/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTreeNodeImpl<T>
implements TreeNode,
Serializable {
    private static final long serialVersionUID = 8841984268370598781L;
    private TreeNode parent;
    private T data;
    private List<TreeNode> children = new ArrayList<TreeNode>();

    public SwingTreeNodeImpl() {
    }

    public SwingTreeNodeImpl(List<TreeNode> children) {
        this.children = children;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public void addChild(TreeNode node) {
        ((SwingTreeNodeImpl)node).setParent(this);
        this.children.add(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration<?> children() {
        return Iterators.asEnumeration(this.children.iterator());
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public List<TreeNode> getChildrenList() {
        return this.children;
    }
}

