/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.behavior;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import org.ajax4jsf.component.behavior.AjaxBehavior;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.JsfBehavior;
import org.richfaces.cdk.annotations.Tag;
import org.richfaces.cdk.annotations.TagType;
import org.richfaces.component.ClientSideMessage;
import org.richfaces.component.behavior.AnonymousFunctionCall;
import org.richfaces.component.behavior.ClientValidatorBehavior;
import org.richfaces.component.behavior.ConverterNotFoundException;
import org.richfaces.component.behavior.MessageUpdateScript;
import org.richfaces.javascript.JavaScriptService;
import org.richfaces.javascript.Message;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.ConverterDescriptor;
import org.richfaces.validator.FacesBeanValidator;
import org.richfaces.validator.FacesConverterService;
import org.richfaces.validator.FacesValidatorService;
import org.richfaces.validator.ValidatorDescriptor;

@JsfBehavior(id="org.richfaces.behavior.ClientValidator", tag={@Tag(name="validator", handler="org.richfaces.view.facelets.html.ClientValidatorHandler", type=TagType.Facelets)}, attributes={"validator-props.xml", "immediate-prop.xml"})
public class ClientValidatorImpl
extends AjaxBehavior
implements ClientValidatorBehavior {
    private static final Set<String> NONE = Collections.emptySet();
    private static final Set<String> THIS = Collections.singleton("@this");
    private static final Class<?>[] EMPTY_GROUPS = new Class[0];
    private static final String VALUE = "value";
    private static final Logger LOG = RichfacesLogger.COMPONENTS.getLogger();
    private Class<?>[] groups;
    private static final Function<? super FacesMessage, Message> MESSAGES_TRANSFORMER = new Function<FacesMessage, Message>(){

        public Message apply(FacesMessage msg) {
            return new Message(msg);
        }
    };

    public String getScript(ClientBehaviorContext behaviorContext) {
        if (behaviorContext.getComponent() instanceof EditableValueHolder) {
            return super.getScript(behaviorContext);
        }
        if (behaviorContext.getComponent() instanceof ActionSource) {
            ClientBehaviorRenderer renderer = this.getRenderer(behaviorContext.getFacesContext(), "org.richfaces.FormValidatorRenderer");
            return renderer.getScript(behaviorContext, (ClientBehavior)this);
        }
        throw new FacesException("Invalid target for client-side validator behavior");
    }

    @Override
    public String getRendererType() {
        return "org.richfaces.ClientValidatorRenderer";
    }

    @Override
    public void broadcast(BehaviorEvent event) throws AbortProcessingException {
        UIComponent component;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (partialViewContext.isAjaxRequest() && (component = event.getComponent()) instanceof EditableValueHolder) {
            String clientId = component.getClientId(facesContext);
            ImmutableList messages = ImmutableList.copyOf((Iterator)Iterators.transform((Iterator)facesContext.getMessages(clientId), MESSAGES_TRANSFORMER));
            JavaScriptService javaScriptService = (JavaScriptService)ServiceTracker.getService(JavaScriptService.class);
            javaScriptService.addPageReadyScript(facesContext, (Object)new MessageUpdateScript(clientId, (List<Message>)messages));
            if (messages.isEmpty()) {
                String onvalid = this.getOnvalid();
                if (onvalid != null && !"".equals(onvalid.trim())) {
                    javaScriptService.addPageReadyScript(facesContext, (Object)new AnonymousFunctionCall(new Object[0]).addToBody(onvalid));
                }
            } else {
                String oninvalid = this.getOninvalid();
                if (oninvalid != null && !"".equals(oninvalid.trim())) {
                    javaScriptService.addPageReadyScript(facesContext, (Object)new AnonymousFunctionCall("messages").addParameterValue(ScriptUtils.toScript((Object)messages)).addToBody(oninvalid));
                }
            }
        }
        super.broadcast(event);
    }

    @Override
    public void setLiteralAttribute(String name, Object value) {
        super.setLiteralAttribute(name, value);
        if (this.compare((Serializable)((Object)Properties.oninvalid), name)) {
            this.setOninvalid((String)value);
        } else if (this.compare((Serializable)((Object)Properties.onvalid), name)) {
            this.setOnvalid((String)value);
        }
    }

    public Set<UIComponent> getMessages(FacesContext context, UIComponent component) {
        HashSet<UIComponent> messages = new HashSet<UIComponent>();
        this.findMessages(component.getParent(), component, messages, false, component.getId());
        return messages;
    }

    protected void findRichMessages(FacesContext context, UIComponent component, String id, Set<UIComponent> messages) {
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child instanceof ClientSideMessage) {
                ClientSideMessage richMessage = (ClientSideMessage)child;
                if (null != richMessage.getFor()) continue;
                richMessage.updateMessages(context, id);
                messages.add(child);
                continue;
            }
            this.findRichMessages(context, child, id, messages);
        }
    }

    protected boolean findMessages(UIComponent parent, UIComponent component, Set<UIComponent> messages, boolean found, Object id) {
        UIComponent newParent;
        Iterator facetsAndChildren = parent.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent child = (UIComponent)facetsAndChildren.next();
            if (child == component) continue;
            if (child instanceof UIMessage || child instanceof UIMessages) {
                UIComponent message = child;
                Object targetId = message.getAttributes().get("for");
                if (null == targetId || !targetId.equals(id)) continue;
                messages.add(message);
                found = true;
                continue;
            }
            found |= this.findMessages(child, null, messages, found, id);
        }
        if (!(found && parent instanceof NamingContainer || component == null || null == (newParent = parent.getParent()))) {
            found = this.findMessages(newParent, parent, messages, found, id);
        }
        return found;
    }

    protected ClientBehaviorRenderer getRenderer(FacesContext context, String rendererType) {
        if (null == context || null == rendererType) {
            throw new NullPointerException();
        }
        ClientBehaviorRenderer renderer = null;
        RenderKit renderKit = context.getRenderKit();
        if (null != renderKit) {
            renderer = renderKit.getClientBehaviorRenderer(rendererType);
            if (null == renderer) {
                throw new FacesException("No ClientBehaviorRenderer found for type " + rendererType);
            }
        } else {
            throw new FacesException("No renderkit available");
        }
        return renderer;
    }

    @Override
    public ConverterDescriptor getConverter(ClientBehaviorContext context) throws ConverterNotFoundException {
        UIComponent component = context.getComponent();
        if (component instanceof EditableValueHolder) {
            ValueExpression valueExpression;
            EditableValueHolder input = (EditableValueHolder)component;
            FacesContext facesContext = context.getFacesContext();
            Converter converter = input.getConverter();
            if (null == converter && null != (valueExpression = component.getValueExpression(VALUE))) {
                Class valueType = valueExpression.getType(facesContext.getELContext());
                converter = this.createConverterByType(facesContext, valueType);
            }
            if (null != converter) {
                FacesConverterService converterService = (FacesConverterService)ServiceTracker.getService((FacesContext)facesContext, FacesConverterService.class);
                String converterMessage = (String)component.getAttributes().get("converterMessage");
                return converterService.getConverterDescription(facesContext, input, converter, converterMessage);
            }
            return null;
        }
        throw new ConverterNotFoundException("Component does not implement EditableValueHolder" + component);
    }

    Converter createConverterByType(FacesContext facesContext, Class<?> valueType) throws ConverterNotFoundException {
        Application application;
        Converter converter = null;
        if (valueType != null && valueType != Object.class && null == (converter = (application = facesContext.getApplication()).createConverter(valueType)) && valueType != String.class) {
            throw new ConverterNotFoundException("No converter registered for type " + valueType.getName());
        }
        return converter;
    }

    @Override
    public Collection<ValidatorDescriptor> getValidators(ClientBehaviorContext context) {
        UIComponent component = context.getComponent();
        if (component instanceof EditableValueHolder) {
            ArrayList validators = Lists.newArrayList();
            EditableValueHolder input = (EditableValueHolder)component;
            Validator[] facesValidators = input.getValidators();
            FacesContext facesContext = context.getFacesContext();
            if (facesValidators.length > 0) {
                String validatorMessage = (String)component.getAttributes().get("validatorMessage");
                boolean beanValidatorsProcessed = false;
                FacesValidatorService facesValidatorService = (FacesValidatorService)ServiceTracker.getService((FacesContext)facesContext, FacesValidatorService.class);
                for (Validator validator : facesValidators) {
                    if (validator instanceof BeanValidator || validator instanceof FacesBeanValidator) {
                        ValueExpression valueExpression = component.getValueExpression(VALUE);
                        if (null == valueExpression || beanValidatorsProcessed) continue;
                        BeanValidatorService beanValidatorService = (BeanValidatorService)ServiceTracker.getService((FacesContext)facesContext, BeanValidatorService.class);
                        validators.addAll(beanValidatorService.getConstrains(facesContext, valueExpression, validatorMessage, (Class[])this.getGroups()));
                        beanValidatorsProcessed = true;
                        continue;
                    }
                    validators.add(facesValidatorService.getValidatorDescription(facesContext, input, validator, validatorMessage));
                }
            }
            return validators;
        }
        throw new FacesException("Component " + component.getClass().getName() + " does not implement EditableValueHolder interface");
    }

    @Override
    public Class<?>[] getGroups() {
        if (this.groups != null) {
            return this.groups;
        }
        ValueExpression expression = this.getValueExpression("groups");
        if (expression != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return (Class[])expression.getValue(ctx.getELContext());
        }
        return EMPTY_GROUPS;
    }

    @Override
    public void setGroups(Class<?> ... groups) {
        this.groups = groups;
        this.clearInitialState();
    }

    @Override
    public String getAjaxScript(ClientBehaviorContext context) {
        return this.getRenderer(context.getFacesContext(), "org.ajax4jsf.behavior.Ajax").getScript(context, (ClientBehavior)this);
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object superState = super.saveState(context);
        Object values = this.initialStateMarked() ? (superState == null ? null : new Object[]{superState}) : new Object[]{superState, this.groups};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            super.restoreState(context, values[0]);
            if (values.length != 1) {
                this.groups = (Class[])values[1];
                this.clearInitialState();
            }
        }
    }

    @Override
    public boolean isImmediateSet() {
        return false;
    }

    @Override
    public boolean isLimitRender() {
        return true;
    }

    @Override
    public boolean isBypassUpdates() {
        return true;
    }

    @Override
    public Collection<String> getExecute() {
        return THIS;
    }

    @Override
    public Collection<String> getRender() {
        return NONE;
    }

    @Override
    @Attribute
    public String getOnvalid() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.onvalid));
    }

    public void setOnvalid(String value) {
        this.getStateHelper().put((Serializable)((Object)Properties.onvalid), (Object)value);
    }

    @Override
    @Attribute
    public String getOninvalid() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.oninvalid));
    }

    public void setOninvalid(String value) {
        this.getStateHelper().put((Serializable)((Object)Properties.oninvalid), (Object)value);
    }

    protected static enum Properties {
        onvalid,
        oninvalid;

    }
}

