/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.util.List;
import javax.faces.application.Application;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.render.Renderer;
import org.richfaces.application.CommonComponentsConfiguration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;
import org.richfaces.component.QueueRegistry;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib")})
@ListenersFor(value={@ListenerFor(systemEventClass=PostAddToViewEvent.class), @ListenerFor(systemEventClass=PreRemoveFromViewEvent.class)})
public abstract class QueueRendererBase
extends Renderer
implements ComponentSystemEventListener {
    protected static final String QUEUE_ID_ATTRIBBUTE = "queueId";
    protected static final String NAME_ATTRIBBUTE = "name";
    protected static final Logger LOGGER = RichfacesLogger.COMPONENTS.getLogger();
    private static final String QUEUE_RESOURCE_COMPONENT_RENDERER_TYPE = "org.richfaces.QueueResourceComponentRenderer";
    private static final String QUEUE_RESOURCE_COMPONENT_TARGET = "head";

    private void addQueueResourceComponent(FacesContext context) {
        List resources = context.getViewRoot().getComponentResources(context, QUEUE_RESOURCE_COMPONENT_TARGET);
        for (UIComponent resource : resources) {
            if (!QUEUE_RESOURCE_COMPONENT_RENDERER_TYPE.equals(resource.getRendererType())) continue;
            return;
        }
        Application application = context.getApplication();
        UIComponent queueResourceComponent = application.createComponent(context, "javax.faces.Output", QUEUE_RESOURCE_COMPONENT_RENDERER_TYPE);
        queueResourceComponent.setId("_org_richfaces_queue");
        context.getViewRoot().addComponentResource(context, queueResourceComponent, QUEUE_RESOURCE_COMPONENT_TARGET);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)context, (Enum)CommonComponentsConfiguration.Items.queueEnabled).booleanValue()) {
            return;
        }
        UIComponent comp = event.getComponent();
        String queueName = this.getQueueName(context, comp);
        QueueRegistry queueRegistry = QueueRegistry.getInstance(context);
        if (event instanceof PostAddToViewEvent) {
            queueRegistry.addQueue(queueName, comp);
            this.addQueueResourceComponent(context);
        } else if (event instanceof PreRemoveFromViewEvent) {
            queueRegistry.removeQueue(queueName);
        }
    }

    protected abstract String getQueueName(FacesContext var1, UIComponent var2);
}

