/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.ajax4jsf.renderkit.RendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.ScrollableDataTableHeaderCellRenderer
 */
public class ScrollableDataTableHeaderCellRenderer extends RendererBase {

	public ScrollableDataTableHeaderCellRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return javax.faces.component.UIComponent.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (javax.faces.component.UIComponent)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, javax.faces.component.UIComponent component, ComponentVariables variables ) throws IOException {
	    writer.startElement("th", component);
			getUtils().writeAttribute(writer, "class", "dr-sdt-hc rich-sdt-header-cell " + convertToString(variables.getVariable("headerColumnClass")) + " " + convertToString(variables.getVariable("headerColumnSortClass")) );
						getUtils().writeAttribute(writer, "columnIndex", variables.getVariable("cell_index") );
						getUtils().writeAttribute(writer, "id", convertToString(variables.getVariable("client_id")) + ":hc_" + convertToString(variables.getVariable("cell_index")) );
						getUtils().writeAttribute(writer, "sortable", component.getAttributes().get("sortable") );
			

			
			if(Boolean.TRUE.equals(component.getAttributes().get("sortable"))) {
				getUtils().writeAttribute(writer, "style", "cursor:pointer" );

			}
		
		

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, javax.faces.component.UIComponent component, ComponentVariables variables) throws IOException {
	  

			
			int offset = ((Integer)variables.getVariable("sepOffset")).intValue() - 3;
			
		
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "dr-sdt-hsep rich-sdt-hsep" );
						getUtils().writeAttribute(writer, "column", variables.getVariable("cell_index") );
						getUtils().writeAttribute(writer, "id", convertToString(variables.getVariable("client_id")) + ":hsep_" + convertToString(variables.getVariable("cell_index")) );
						getUtils().writeAttribute(writer, "style", "left: " + convertToString(variables.getVariable("offset")) + "px;" );
			
writer.endElement("span");
writer.endElement("th");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (javax.faces.component.UIComponent)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
