/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.renderkit;

import java.util.LinkedHashSet;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.component.UIResource;
import org.ajax4jsf.resource.InternetResource;

/**
 * @author shura
 *
 */
public class LoadResourceRendererBase extends RendererBase implements HeaderResourceProducer {
	
	private static final String SCRIPT_COMPONENT_FAMILY="org.ajax4jsf.LoadScript";
	private static final String STYLE_COMPONENT_FAMILY="org.ajax4jsf.LoadStyle";

	/* (non-Javadoc)
	 * @see org.ajax4jsf.renderkit.HeaderResourceProducer#getHeaderScripts(javax.faces.context.FacesContext, javax.faces.component.UIComponent)
	 */
	public LinkedHashSet getHeaderScripts(FacesContext context, UIComponent component) {
		UIResource resource = (UIResource) component;
		if (SCRIPT_COMPONENT_FAMILY.equals(resource.getFamily())) {
			return getResources(context, resource);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.renderkit.HeaderResourceProducer#getHeaderStyles(javax.faces.context.FacesContext, javax.faces.component.UIComponent)
	 */
	public LinkedHashSet getHeaderStyles(FacesContext context, UIComponent component) {
		UIResource resource = (UIResource) component;
		if (STYLE_COMPONENT_FAMILY.equals(resource.getFamily())) {
			return getResources(context, resource);
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.ajax4jsf.renderkit.RendererBase#getComponentClass()
	 */
	protected Class getComponentClass() {
		return UIResource.class;
	}
	
	private LinkedHashSet getResources(FacesContext context, UIResource resource) {
		Object src = resource.getSrc();
		if(null == src){
			throw new FacesException("Source for resource is null for component "+resource.getClientId(context));
		}
		LinkedHashSet set = new LinkedHashSet(1);
		String uri ;
		if(src instanceof InternetResource){
			uri=((InternetResource)src).getUri(context, resource);
		} else {
			// Process as ordinary url, same as for h:graphicsImage.
			uri=context.getApplication().getViewHandler().
            getResourceURL(context, src.toString());
			uri=context.getExternalContext().encodeResourceURL(uri);
		}
		set.add(uri);
		return set;
	}

}
