/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;

import org.ajax4jsf.event.AjaxEvent;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.component.UIPanelMenuItem;
import org.richfaces.renderkit.PanelMenuRendererBase;

public class PanelMenuItemRenderer extends PanelMenuRendererBase {
	protected Class getComponentClass() {
		return UIPanelMenuItem.class;
	}

	protected void doEncodeBegin(ResponseWriter writer, FacesContext context,UIComponent component) throws IOException {
		
	}
	protected void doDecode(FacesContext context, UIComponent component) {
		if(isSubmitted(context, component)) {
			UIPanelMenuItem item = (UIPanelMenuItem)component;
			new ActionEvent(component).queue();
            if ("ajax".equals(getItemMode(component))) {
                new AjaxEvent(component).queue();
            }
		}
	}
	
	protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		
	}
	
	public void insertImage(FacesContext context, UIComponent component, Object data) throws IOException {
		String from = (String)data;
		UIPanelMenu panelMenu = findMenu(component);
		if(panelMenu == null){
			return;
		}
		String align = "";
		UIPanelMenuItem panelMenuItem = (UIPanelMenuItem)component;
		boolean isTopLevel = isTopLevel(panelMenuItem);
		
		if (isTopLevel){
			align = panelMenu.getIconItemTopPosition();
		} else {
			align = panelMenu.getIconItemPosition();
		}
		
		if (align.equalsIgnoreCase(from)){
			image(context,component, from);
		} else {
			String iconType = PANEL_MENU_SPACER_ICON_NAME;
			String imageSrc = getIconByType(iconType, isTopLevel, context, component);
			drawIcon(context.getResponseWriter(), iconType, imageSrc, component, from + "Icon" + component.getClientId(context));
		}
	}
	
	private void image(FacesContext context, UIComponent component, String from) 
			throws IOException{
		
		UIPanelMenu panelMenu = findMenu(component);
		ResponseWriter writer 	= context.getResponseWriter();
		boolean isTopLevel 		= isTopLevel(component);		
		String source 			= null;
		String iconType			= null;	
		UIPanelMenuItem item = (UIPanelMenuItem)component;
		
		String defaultItemIcon = null;
		String customItemIcon = null;
		
		if(isTopLevel){
			if(item.isDisabled()){
				defaultItemIcon = panelMenu.getIconTopDisabledItem();
			} else {
				defaultItemIcon = panelMenu.getIconTopItem();
			}
			if(defaultItemIcon == null || defaultItemIcon.equals("")){
				if(item.isDisabled()){
					defaultItemIcon = panelMenu.getIconDisabledItem();
				} else {
					defaultItemIcon = panelMenu.getIconItem();
				}
			}
		} else {
			//isTopLevel == false
			if(defaultItemIcon == null || defaultItemIcon.equals("")){
				if(item.isDisabled()){
					defaultItemIcon = panelMenu.getIconDisabledItem();
				} else {
					defaultItemIcon = panelMenu.getIconItem();
				}
			}
		}
		
		customItemIcon = item.isDisabled() ? item.getIconDisabled() : item.getIcon();
		
		if(customItemIcon == null || customItemIcon.equals("")){
			iconType = defaultItemIcon;
		} else iconType = customItemIcon;
		
		source = getIconByType(iconType, isTopLevel, context, component);
		drawIcon(writer, iconType, source, component, from + "Icon" + component.getClientId(context));
	}
	
	
	public String getFullStyleClass(FacesContext context, UIComponent component) {
		StringBuffer classBuffer = new StringBuffer("");
		UIPanelMenuItem item = (UIPanelMenuItem)component;
		UIPanelMenu parentMenu = findMenu(item);
		if (!parentMenu.isDisabled() && !item.isDisabled()) {
			if (calculateLevel(item) == 0) {
				classBuffer.append(parentMenu.getTopItemClass()).append(" ");
				classBuffer.append("rich-pmenu-top-item ");
			} else 
				classBuffer.append(parentMenu.getItemClass() + " ");
			classBuffer.append(item.getStyleClass());
		} else
			classBuffer.append(parentMenu.getDisabledItemClass() + " ")
				.append(item.getDisabledClass());
		return classBuffer.toString();
	}
	
	public String getFullStyle(FacesContext context, UIComponent component) {
		StringBuffer styleBuffer = new StringBuffer("");
		UIPanelMenuItem item = (UIPanelMenuItem)component;
		UIPanelMenu parentMenu = findMenu(item);
		if (!item.isDisabled()) {
			if (calculateLevel(item) == 0) 
				styleBuffer.append(parentMenu.getTopItemStyle() + "; ");
			else 
				styleBuffer.append(parentMenu.getItemStyle() + "; ");
			styleBuffer.append(item.getStyle());
		} else
			styleBuffer.append(parentMenu.getDisabledItemStyle() + "; ")
				.append(item.getDisabledStyle());
		return styleBuffer.toString();
	}

	public String getLabelClass(FacesContext context, UIComponent component) {
		StringBuffer resClass = new StringBuffer();
		UIPanelMenuItem item = (UIPanelMenuItem)component;
		UIPanelMenu parentMenu = findMenu(item);
		if(!item.isDisabled() && !parentMenu.isDisabled()){
			if(isTopLevel(component)){
				resClass.append("rich-pmenu-item-label rich-pmenu-top-item-label");
				
			} else resClass.append("rich-pmenu-item-label");
		}
		if(isSelected(context, component)){
			resClass.append(" ").append(UIPanelMenu.DEFAULT_SELECTED_CLASS).append(" ").append(UIPanelMenu.USER_DEFINED_SELECTED_CLASS);
		}
		return resClass.toString();
	}
	
	public String getIconClass(FacesContext context, UIComponent component) {
		UIPanelMenuItem item = (UIPanelMenuItem)component;
		UIPanelMenu parentMenu = findMenu(item);
		if(!item.isDisabled() && !parentMenu.isDisabled()){
			if(isTopLevel(component)){
				return "rich-pmenu-item-icon rich-pmenu-top-item-icon";
			} else return "rich-pmenu-item-icon";
		}
		return "";
	}
	
	public boolean isSelected(FacesContext context, UIComponent component){
		UIPanelMenuItem item = (UIPanelMenuItem)component;
		UIPanelMenu parentMenu = findMenu(item);
		return item.getName().equals(parentMenu.getSelectedName());
	}
}
