/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.internal;

import java.util.HashMap;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import org.ajax4jsf.util.ELUtils;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;
import org.richfaces.model.internal.Expression;
import org.richfaces.model.internal.JavaBeanWrapper;
import org.richfaces.model.internal.NullExpression;
import org.richfaces.model.internal.SimplePropertyExpression;
import org.richfaces.model.internal.ValueBindingExpression;

class ObjectWrapperFactory {
    private Expression[] expressions;
    private FacesContext context;
    private String var;
    private Object varValue;

    public ObjectWrapperFactory(FacesContext context, String var, SortOrder sortOrder) {
        this.context = context;
        Application application = context.getApplication();
        PropertyResolver resolver = application.getPropertyResolver();
        this.var = var;
        SortField[] sortFields = sortOrder.getFields();
        this.expressions = new Expression[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField field = sortFields[i];
            String name = field.getName();
            this.expressions[i] = ELUtils.isValueReference((String)name) ? new ValueBindingExpression(context, name, var) : (name.startsWith("_id") ? new NullExpression(name) : new SimplePropertyExpression(name, resolver));
        }
    }

    void convertList(List list, ObjectConvertor c) {
        int l = list.size();
        for (int i = 0; i < l; ++i) {
            Object o = list.get(i);
            list.set(i, c.convert(o));
        }
    }

    public List unwrapList(List list) {
        this.convertList(list, new ObjectConvertor(){

            public Object convert(Object o) {
                return ObjectWrapperFactory.this.unwrapObject(o);
            }
        });
        if (this.varValue != null) {
            this.context.getExternalContext().getRequestMap().put(this.var, this.varValue);
        } else {
            this.context.getExternalContext().getRequestMap().remove(this.var);
        }
        return list;
    }

    public Object unwrapObject(Object wrapper) {
        return ((JavaBeanWrapper)wrapper).getWrappedObject();
    }

    public List wrapList(List list) {
        this.varValue = this.context.getExternalContext().getRequestMap().get(this.var);
        this.convertList(list, new ObjectConvertor(){

            public Object convert(Object o) {
                return ObjectWrapperFactory.this.wrapObject(o);
            }
        });
        return list;
    }

    public JavaBeanWrapper wrapObject(Object o) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expression = this.expressions[i];
            props.put(expression.getExpressionString(), expression.evaluate(o));
        }
        return new JavaBeanWrapper(o, props);
    }

    static interface ObjectConvertor {
        public Object convert(Object var1);
    }
}

