/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.component;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;

import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/**
 * JSF component class
 *
 */
public abstract class UIModalPanel extends UIInput {
	
	public static final String COMPONENT_TYPE = "org.richfaces.ModalPanel";
	
	private static final String COMPONENT_FAMILY = "org.richfaces.ModalPanel";
	
	private Map visualOptions;
	
	/**
     * Shadow depth.
     */
    private static final int SHADOW_DEPTH = 4;

	public abstract int getWidth();
	public abstract int getHeight();

	public abstract void setWidth(int width);
	public abstract void setHeight(int height);

	public abstract int getMinWidth();
	public abstract int getMinHeight();

	public abstract void setMinWidth(int width);
	public abstract void setMinHeight(int height);

	public abstract boolean isResizeable();
	public abstract boolean isMoveable();
	public abstract boolean isAutosized();

	public abstract void setResizeable(boolean resizeable);
	public abstract void setMoveable(boolean moveable);
	public abstract void setAutosized(boolean autosized);

	public abstract String getLeft();
	public abstract String getTop();

	public abstract void setLeft(String left);
	public abstract void setTop(String top);
	
	public abstract int getZindex();
	public abstract void setZindex(int zindex);
	
	public abstract boolean isShowWhenRendered();
	public abstract void setShowWhenRendered(boolean opened);
	
	public abstract boolean isKeepVisualState();
	public abstract void setKeepVisualState(boolean keepVisualState);
	
	public abstract String getTridentIVEngineSelectBehavior();
	public abstract void setTridentIVEngineSelectBehavior(String tridentIVEngineSelectBehavior);

	public boolean getRendersChildren() {
		return true;
	}
	
	public String getShadowStyle() {
		 String shadow = (String) getAttributes().get("shadowDepth");
	        if (shadow == null) {
	            shadow = Integer.toString(SHADOW_DEPTH);
	        }

	        String shadowStyle = "top: " + shadow + "px; left: " + shadow + "px;";
	        
	        FacesContext context = FacesContext.getCurrentInstance();
	        if (null == context)
	        	return shadowStyle;
	        
	        String opacity = (String) getAttributes().get("shadowOpacity");
	        String filterOpacity;

	        if (null == opacity) {
	            Skin skin = SkinFactory.getInstance().getSkin(context);
	            opacity = (String) skin.getParameter(context, "shadowOpacity");
	        }
	        try {
	            Double op = Double.valueOf(opacity);
	            filterOpacity = Integer.toString(op.intValue() * 10);
	            opacity = Double.toString(op.doubleValue() / 10);
	        } catch (Exception e) {
	            // illegal opacity
	            return ";";
	        }
	        shadowStyle += " opacity:" + opacity
	                + "; filter:alpha(opacity=" + filterOpacity + ");";
	        
	        return shadowStyle;
	}
	
	public Map getVisualOptions() {
		if (null == visualOptions)
			visualOptions = new HashMap();
		return visualOptions;
	}
	public void setVisualOptions(Map visualOptions) {
		this.visualOptions = visualOptions;
	}
}
