/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit;

import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.ajax4jsf.renderkit.RendererBase;

/**
 * @author shura
 *
 */
public abstract class AbstractCellRenderer extends RendererBase {
	
	public String styleClass(FacesContext context , UIComponent component){
		StringBuffer styleClass = new StringBuffer();
		// Construct predefined classes
		Map requestMap = context.getExternalContext().getRequestMap();
		Object parentPredefined = requestMap.get(AbstractRowsRenderer.SKIN_CELL_CLASS_KEY);
		if (null != parentPredefined) {
			styleClass.append(parentPredefined).append(" ");			
		} else {
			styleClass.append("dr-table-cell rich-table-cell ");
		}
		// Append class from parent component.
		Object parent = requestMap.get(AbstractRowsRenderer.CELL_CLASS_KEY);
		if (null != parent) {
			styleClass.append(parent).append(" ");
		}
		Object custom = component.getAttributes().get("styleClass");
		if (null != custom) {
			styleClass.append(custom);
		}
		return styleClass.toString();
	}

}
