/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.html.ToolTipRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.HtmlToolTipRenderer
 */
public class HtmlToolTipRenderer extends ToolTipRenderer {

	public HtmlToolTipRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIToolTip.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIToolTip)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIToolTip component, ComponentVariables variables ) throws IOException {
	    writer.writeComment(convertToString(" h:styles>\n		/org/richfaces/renderkit/html/css/tooltip.xcss\n	</h:styles>\n	<h:scripts>\n		new org.ajax4jsf.framework.resource.PrototypeScript(),\n		new org.ajax4jsf.framework.ajax.AjaxScript(),\n		/org/richfaces/renderkit/html/scripts/utils.js,\n		/org/richfaces/renderkit/html/scripts/tooltip.js\n	</h:scripts"));

java.lang.String clientId = component.getClientId(context);
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "class", "dr-rich-tool-tip rich-tool-tip " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", "position: absolute; display : none;z-index:" + convertToString(component.getAttributes().get("zorder")) + "; " + convertToString(component.getAttributes().get("style")) );
			
getUtils().encodePassThru(context, component);


			if("ajax".equals(component.getMode()) && component.getFacet("defaultContent")!=null) {
		 
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "defaultContent" );
						getUtils().writeAttribute(writer, "style", "display:none" );
			
UIComponent indexChildren_28 = component.getFacet("defaultContent");
if (null != indexChildren_28 && indexChildren_28 .isRendered()) {
	renderChild(context, indexChildren_28);
}

writer.endElement("span");

			}
		 

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIToolTip)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIToolTip component, ComponentVariables variables) throws IOException {
	    
encodeTooltipText(context, component);


	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIToolTip component, ComponentVariables variables) throws IOException {
	  
java.lang.String clientId = component.getClientId(context);
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "script" );
						getUtils().writeAttribute(writer, "style", "display:none" );
			
insertScript(context, component);

writer.endElement("span");
writer.endElement("span");
writer.writeComment(convertToString(" f:call name=\"utils.encodeEndFormIfNessesary\"/"));


	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIToolTip)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
