/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.richfaces.component.Column;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTable;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.renderkit.TableHolder;

public abstract class AbstractTableRenderer
extends AbstractRowsRenderer {
    protected static final String PERSENTAGE_SUPPORT_ERROR_MSG = "columnsWidth property: Percentage values are not supported";

    public void encodeTableStructure(FacesContext context, UIDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = this.getColumnsCount(table);
        writer.startElement("colgroup", (UIComponent)table);
        writer.writeAttribute("span", (Object)String.valueOf(columns), null);
        String columnsWidth = (String)table.getAttributes().get("columnsWidth");
        if (null != columnsWidth) {
            if (columnsWidth.contains("%")) {
                throw new FacesException(PERSENTAGE_SUPPORT_ERROR_MSG);
            }
            String[] widths = columnsWidth.split(",");
            for (int i = 0; i < widths.length; ++i) {
                writer.startElement("col", (UIComponent)table);
                writer.writeAttribute("width", (Object)widths[i], null);
                writer.endElement("col");
            }
        }
        writer.endElement("colgroup");
        this.encodeCaption(context, table);
        this.encodeHeader(context, table, columns);
        this.encodeFooter(context, table, columns);
    }

    public void encodeHeader(FacesContext context, UIDataTable table, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = table.getHeader();
        Iterator headers = this.columnFacets(table, "header");
        if (header != null || headers.hasNext()) {
            writer.startElement("thead", (UIComponent)table);
            String headerClass = (String)table.getAttributes().get("headerClass");
            if (header != null) {
                this.encodeTableHeaderFacet(context, columns, writer, header, "dr-table-header rich-table-header", "dr-table-header-continue rich-table-header-continue", "dr-table-headercell rich-table-headercell", headerClass, "th");
            }
            if (headers.hasNext() && this.findFacet(table, "header")) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "dr-table-subheader rich-table-subheader", null, headerClass);
                this.encodeHeaderFacets(context, writer, headers, "dr-table-subheadercell rich-table-subheadercell", headerClass, "header", "th");
                writer.endElement("tr");
            }
            writer.endElement("thead");
        }
    }

    public boolean findFacet(UIDataTable table, String facetName) {
        Iterator iter = this.columnFacets(table, facetName);
        boolean find = false;
        while (iter.hasNext()) {
            UIComponent comp = (UIComponent)iter.next();
            if (comp.getFacet(facetName) == null) continue;
            find = true;
            break;
        }
        return find;
    }

    protected void encodeHeaderFacets(FacesContext context, ResponseWriter writer, Iterator headers, String skinCellClass, String headerClass, String facetName, String element) throws IOException {
        while (headers.hasNext()) {
            UIComponent column = (UIComponent)headers.next();
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            writer.startElement(element, column);
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            writer.writeAttribute("scope", (Object)"col", null);
            this.getUtils().encodeAttribute(context, column, "colspan");
            UIComponent facet = column.getFacet(facetName);
            if (facet != null) {
                this.renderChild(context, facet);
            }
            writer.endElement(element);
        }
    }

    public void encodeFooter(FacesContext context, UIDataTable table, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFooter();
        Iterator footers = this.columnFacets(table, "footer");
        if (footer != null || footers.hasNext()) {
            writer.startElement("tfoot", (UIComponent)table);
            String footerClass = (String)table.getAttributes().get("footerClass");
            if (footers.hasNext() && this.findFacet(table, "footer")) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "dr-table-subfooter rich-table-subfooter", null, footerClass);
                this.encodeHeaderFacets(context, writer, footers, "dr-table-subfootercell rich-table-subfootercell", footerClass, "footer", "td");
                writer.endElement("tr");
            }
            if (footer != null) {
                this.encodeTableHeaderFacet(context, columns, writer, footer, "dr-table-footer rich-table-footer", "dr-table-footer-continue rich-table-footer-continue", "dr-table-footercell rich-table-footercell", footerClass, "td");
            }
            writer.endElement("tfoot");
        }
    }

    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        UIDataTable table = (UIDataTable)holder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        Iterator iter = table.columns();
        boolean first = true;
        int currentColumn = 0;
        UIComponent column = null;
        while (iter.hasNext()) {
            column = (UIComponent)iter.next();
            if (first && !(column instanceof Row)) {
                this.encodeRowStart(context, this.getFirstRowSkinClass(), holder.getRowClass(), table, writer);
            }
            if (column instanceof Column) {
                boolean breakBefore;
                boolean bl = breakBefore = ((Column)column).isBreakBefore() || column instanceof Row;
                if (breakBefore && !first) {
                    writer.endElement("tr");
                    currentColumn = 0;
                    if (!(column instanceof Row)) {
                        holder.nextRow();
                        this.encodeRowStart(context, holder.getRowClass(), table, writer);
                    }
                }
                this.encodeCellChildren(context, column, first ? this.getFirstRowSkinClass() : null, this.getRowSkinClass(), holder.getRowClass(), this.getCellSkinClass(), holder.getColumnClass(currentColumn));
                if (column instanceof Row && iter.hasNext()) {
                    holder.nextRow();
                    this.encodeRowStart(context, holder.getRowClass(), table, writer);
                    currentColumn = -1;
                }
            } else if (column.isRendered()) {
                writer.startElement("td", (UIComponent)table);
                this.getUtils().encodeId(context, column);
                String columnClass = holder.getColumnClass(currentColumn);
                this.encodeStyleClass(writer, null, this.getCellSkinClass(), null, columnClass);
                this.renderChildren(context, column);
                writer.endElement("td");
            }
            ++currentColumn;
            first = false;
        }
        if (!first && !(column instanceof Row)) {
            writer.endElement("tr");
        }
    }

    protected void encodeRowStart(FacesContext context, String rowClass, UIDataTable table, ResponseWriter writer) throws IOException {
        this.encodeRowStart(context, this.getRowSkinClass(), rowClass, table, writer);
    }

    protected String getRowSkinClass() {
        return "dr-table-row rich-table-row";
    }

    protected String getFirstRowSkinClass() {
        return "dr-table-firstrow rich-table-firstrow";
    }

    protected String getCellSkinClass() {
        return "dr-table-cell rich-table-cell";
    }

    protected void encodeRowStart(FacesContext context, String skinClass, String rowClass, UIDataTable table, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)table);
        this.encodeStyleClass(writer, null, skinClass, null, rowClass);
        this.encodeRowEvents(context, (UIDataAdaptor)table);
    }

    protected Iterator columnFacets(UIDataTable table, final String name) {
        return new FilterIterator(table.columns(), new Predicate(){

            public boolean evaluate(Object input) {
                UIComponent component = (UIComponent)input;
                if (component instanceof Column || component instanceof UIColumn) {
                    return component.isRendered() && component.getFacet(name) != null;
                }
                return false;
            }
        });
    }

    protected int getColumnsCount(UIDataTable table) {
        int count = 0;
        Integer span = (Integer)table.getAttributes().get("columns");
        if (null != span && span != Integer.MIN_VALUE) {
            count = span;
        } else {
            Iterator col = table.columns();
            count = this.calculateRowColumns(col);
        }
        return count;
    }

    protected int calculateRowColumns(Iterator col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent column = (UIComponent)col.next();
            if (!column.isRendered()) continue;
            if (column instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.calculateRowColumns(((Row)column).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (column instanceof Column) {
                Integer colspan;
                Column tableColumn = (Column)column;
                if (tableColumn.isBreakBefore()) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)column.getAttributes().get("colspan")) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(column instanceof UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }
}

