package org.richfaces.model.internal;

import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

/**
 * 
 * Expression evaluated by invoking EL-expression in context of base object
 * 
 * @author Maksim Kaszynski
 *
 */
final class ValueBindingExpression extends Expression {
	private final FacesContext context;
	
	private Map requestMap;
	private String var;
	private ValueBinding binding;

	/**
	 * @param n
	 * @param application
	 * @param requestMap
	 * @param expressionString
	 * @param context
	 * @param var
	 */
	ValueBindingExpression(FacesContext context, String expressionString, String var) {
		super(expressionString);
		this.context = context;
		this.var = var;
		binding = context.getApplication().createValueBinding(expressionString);
		requestMap = context.getExternalContext().getRequestMap();
	}

	public Object evaluate(Object base) {
		requestMap.put(var, base);
		return binding.getValue(context);
	}
}