/**
 * 
 */
package org.richfaces.model.selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Class representing selection on client side.
 * Actually, it's renderer specific
 * @author Maksim Kaszynski
 *
 */
public class ClientSelection implements Serializable{
	
	private static final long serialVersionUID = 5855157282287053681L;

	public static final String FLAG_RESET = "x";
	
	public static final String FLAG_ALL = "a";
	
	private String selectionFlag;
	
	private List ranges = new ArrayList();
	
	public ClientSelection() {
	}

	
	public void addRange(SelectionRange range) {
		ranges.add(range);
	}
	
	public boolean isSelected(int i) {
		boolean result = false;
		Iterator iterator = ranges.iterator();
		while (iterator.hasNext() && !result) {
			result |= ((SelectionRange) iterator.next()).within(i);
		}
		return result;
	}
	
	public List getRanges() {
		return ranges;
	}
	
	public void addIndex(int j) {
		if(this.isSelected(j)) return;
		
		
		
		SelectionRange firstRange = null;
		
		int s = ranges.size();
		
		int insertPosition = 0;
		
		for(int i = 0; i < s && insertPosition >= 0 ; i++) {
			
			firstRange = (SelectionRange) ranges.get(i);
			
			if (firstRange.getStartIndex() == j + 1) {
			
				firstRange.setStartIndex(j);
				insertPosition = -1;
			
			} else if (firstRange.getEndIndex() == j - 1) {
			
				firstRange.setEndIndex(j);
				
				if (i + 1 < s) {
					SelectionRange range2 = (SelectionRange) ranges.get(i + 1);
					
					if (range2.getStartIndex() == j || range2.getStartIndex() == j + 1) {
						
						ranges.remove(i + 1);
						
						firstRange.setEndIndex(range2.getEndIndex());
					}
				}
				
				insertPosition = -1;
			
			} else if (firstRange.getStartIndex() > j) {
				insertPosition = i;
			}
			
		}

		if (insertPosition >= 0) {
			firstRange = new SelectionRange(j,j);
			ranges.add(insertPosition, firstRange);
			
			return;
		}
		

	}

	private boolean reset = false;
	public boolean isReset() {
		return reset;
	}
	
	private boolean selectAll = false;
	public boolean isSelectAll() {
		return selectAll;
	}


	public String getSelectionFlag() {
		return selectionFlag;
	}


	public void setSelectionFlag(String selectionFlag) {
		this.selectionFlag = selectionFlag;
		
		reset = false;
		selectAll = false;

		if (FLAG_ALL.equals(selectionFlag)) {
			selectAll = true;
		} else if (FLAG_RESET.equals(selectionFlag)) {
			reset = true;
		}
	}
}
