/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UIToolBar;
import org.richfaces.component.UIToolBarGroup;
import org.richfaces.renderkit.html.images.DotSeparatorImage;
import org.richfaces.renderkit.html.images.GridSeparatorImage;
import org.richfaces.renderkit.html.images.LineSeparatorImage;
import org.richfaces.renderkit.html.images.SquareSeparatorImage;


public class ToolBarRendererBase extends HeaderResourcesRendererBase {

	
	public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
		UIToolBar toolBar = (UIToolBar) component;
		List children = toolBar.getChildren();
		String contentClass = (String) toolBar.getAttributes().get("contentClass");
		if (null == contentClass) contentClass = "";
		String contentStyle = (String) toolBar.getAttributes().get("contentStyle");
		if(children != null){
			List childrenToTheLeft = new LinkedList();
			List childrenToTheRight = new LinkedList();
			for (Iterator iter = children.iterator(); iter.hasNext();) {
				UIComponent child = (UIComponent) iter.next();
				if(child.isRendered()){
					if (child instanceof UIToolBarGroup) {
						UIToolBarGroup group = (UIToolBarGroup) child;
						String location = group.getLocation();
						if(location != null && location.equals("right")){
							childrenToTheRight.add(child);
						} else {
							childrenToTheLeft.add(child);
						}
					} else {
						childrenToTheLeft.add(child);
					}
				}
			}
			
			ResponseWriter writer = facesContext.getResponseWriter();
			for (Iterator it = childrenToTheLeft.iterator(); it.hasNext();) {				
				UIComponent child = (UIComponent) it.next();
				if (! (child instanceof UIToolBarGroup)) {
					writer.startElement("td", component);					
					writer.writeAttribute("class", "dr-toolbar-int rich-toolbar-item " + contentClass, null);
					getUtils().writeAttribute(writer, "style", contentStyle);
				}				
				renderChild(facesContext, child);
				if (! (child instanceof UIToolBarGroup)) {
					writer.endElement("td");					
				}
				if (it.hasNext() || !childrenToTheRight.isEmpty()) {
					insertSeparatorIfNeed(writer, facesContext, toolBar);
				}
			}				
			
			writer.startElement("td", component);
			writer.writeAttribute("width", "100%", null);
			writer.endElement("td");
			if (!childrenToTheLeft.isEmpty() && !childrenToTheRight.isEmpty()) {				
				insertSeparatorIfNeed(writer, facesContext, toolBar);
			}
			
			for (Iterator it = childrenToTheRight.iterator(); it.hasNext();) {
				UIComponent child = (UIComponent) it.next();					
				renderChild(facesContext, child);
				if (it.hasNext()) {
					insertSeparatorIfNeed(writer, facesContext, toolBar);
				}
			}
		}
	}
	
	protected void insertSeparatorIfNeed(ResponseWriter writer,FacesContext context, UIToolBar toolBar) throws IOException {
		
		String itemSeparator = toolBar.getItemSeparator();
		if (itemSeparator != null && itemSeparator.length()!=0 && ! itemSeparator.equalsIgnoreCase("none")){
			String uri = null;			
			if (itemSeparator.equalsIgnoreCase("square")) {
				uri = getResource(SquareSeparatorImage.class.getName()).getUri(context, null);
			} else if (itemSeparator.equalsIgnoreCase("disc")) {
				uri = getResource(DotSeparatorImage.class.getName()).getUri(context, null);
			} else if (itemSeparator.equalsIgnoreCase("grid")) {
				uri = getResource(GridSeparatorImage.class.getName()).getUri(context, toolBar);				
			} else if (itemSeparator.equalsIgnoreCase("line")) {
				uri = getResource(LineSeparatorImage.class.getName()).getUri(context, toolBar);
			} else throw new FacesException("Unknown type of separator - \""+itemSeparator+"\"");
			writer.startElement("td", toolBar);
			writer.writeAttribute("align", "center", null);
			getUtils().writeAttribute(writer, "class", toolBar.getAttributes().get("separatorClass"));			
			writer.startElement("img", toolBar);			
			getUtils().writeAttribute(writer, "src", uri);
			getUtils().writeAttribute(writer, "alt", "");
			writer.endElement("img");
			writer.endElement("td");			
		}
	}

	protected Class getComponentClass() {
		return UIToolBar.class;
	}

	public boolean getRendersChildren() {
		return true;
	}

}
