/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;

public abstract class UIDatascroller
extends AjaxActionComponent
implements DataScrollerSource,
ActionSource {
    public static final String COMPONENT_TYPE = "org.richfaces.Datascroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.Datascroller";
    public static final String FIRST_FACET_NAME = "first";
    public static final String LAST_FACET_NAME = "last";
    public static final String NEXT_FACET_NAME = "next";
    public static final String PREVIOUS_FACET_NAME = "previous";
    public static final String FAST_FORWARD_FACET_NAME = "fastforward";
    public static final String FAST_REWIND_FACET_NAME = "fastrewind";
    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";
    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";
    public static final String NEXT_DISABLED_FACET_NAME = "next_disabled";
    public static final String PREVIOUS_DISABLED_FACET_NAME = "previous_disabled";
    public static final String FAST_FORWARD_DISABLED_FACET_NAME = "fastforward_disabled";
    public static final String FAST_REWIND_DISABLED_FACET_NAME = "fastrewind_disabled";
    static /* synthetic */ Class class$org$richfaces$event$DataScrollerListener;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public void addScrollerListener(DataScrollerListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[])this.getFacesListeners(class$org$richfaces$event$DataScrollerListener == null ? (class$org$richfaces$event$DataScrollerListener = UIDatascroller.class$("org.richfaces.event.DataScrollerListener")) : class$org$richfaces$event$DataScrollerListener);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent)event;
            this.setPage(dataScrollerEvent.getNewScrolVal());
            FacesContext context = FacesContext.getCurrentInstance();
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getId());
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getFor());
            this.setupReRender(context);
            MethodBinding scrollerListener = this.getScrollerListener();
            if (scrollerListener != null) {
                scrollerListener.invoke(context, new Object[]{event});
            }
        }
    }

    public abstract MethodBinding getScrollerListener();

    public abstract void setScrollerListener(MethodBinding var1);

    public abstract void setFor(String var1);

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract void setFastStep(int var1);

    public abstract boolean isRenderIfSinglePage();

    public abstract void setRenderIfSinglePage(boolean var1);

    public abstract int getMaxPages();

    public abstract void setMaxPages(int var1);

    public abstract String getSelectedStyleClass();

    public abstract void setSelectedStyleClass(String var1);

    public abstract String getSelectedStyle();

    public abstract void setSelectedStyle(String var1);

    public abstract String getEventsQueue();

    public abstract void setEventsQueue(String var1);

    public abstract boolean isAjaxSingle();

    public abstract void setAjaxSingle(boolean var1);

    public abstract int getRequestDelay();

    public abstract void setRequestDelay(int var1);

    public abstract String getTableStyleClass();

    public abstract void setTableStyleClass(String var1);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);

    public abstract String getAlign();

    public abstract void setAlign(String var1);

    public abstract String getBoundaryControls();

    public abstract void setBoundaryControls(String var1);

    public abstract String getFastControls();

    public abstract void setFastControls(String var1);

    public abstract String getStepControls();

    public abstract void setStepControls(String var1);

    public abstract String getInactiveStyleClass();

    public abstract String getInactiveStyle();

    public abstract void setInactiveStyleClass(String var1);

    public abstract void setInactiveStyle(String var1);

    public UIData getDataTable() {
        String forAttribute = this.getFor();
        if (forAttribute == null) {
            UIDatascroller forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (!(forComp instanceof UIData)) continue;
                this.setFor(forComp.getId());
                return (UIData)forComp;
            }
            throw new FacesException("could not find dataTable for  datascroller " + this.getId());
        }
        UIComponent forComp = this.findComponent(forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + (class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = UIDatascroller.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData).getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public int getPageIndex(UIData uiData) {
        int rows = this.getRows(uiData);
        if (0 == rows) {
            throw new FacesException("Missing 'rows' attribute on component '" + uiData.getId() + "'");
        }
        int pageIndex = rows > 0 ? this.getFirstRow(uiData) / rows + 1 : 0;
        if (this.getFirstRow(uiData) % rows > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    public int getPageIndex() {
        UIData uiData = this.getDataTable();
        return this.getPageIndex(uiData);
    }

    public void setPage(String facetName) {
        UIData dataTable = this.getDataTable();
        if (FIRST_FACET_NAME.equals(facetName)) {
            this.setFirstRow(0);
            dataTable.setFirst(0);
        } else if (PREVIOUS_FACET_NAME.equals(facetName)) {
            int previous = dataTable.getFirst() - this.getRows(dataTable);
            if (previous >= 0) {
                this.setFirstRow(previous);
            }
        } else if (NEXT_FACET_NAME.equals(facetName)) {
            int rows = this.getRows(dataTable);
            int next = dataTable.getFirst() + rows;
            if (next < this.getRowCount(dataTable)) {
                this.setFirstRow(next);
            }
        } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
            int rowcount;
            int next;
            int fastStep = this.getFastStep();
            int rows = this.getRows(dataTable);
            if (fastStep <= 0) {
                fastStep = 1;
            }
            if ((next = dataTable.getFirst() + rows * fastStep) >= (rowcount = this.getRowCount(dataTable))) {
                next = rowcount - 1 - (rowcount - 1) % rows;
            }
            this.setFirstRow(next);
        } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
            int previous;
            int fastStep = this.getFastStep();
            if (fastStep <= 0) {
                fastStep = 1;
            }
            if ((previous = dataTable.getFirst() - this.getRows(dataTable) * fastStep) < 0) {
                previous = 0;
            }
            this.setFirstRow(previous);
        } else if (LAST_FACET_NAME.equals(facetName)) {
            int first;
            int rows;
            int rowcount = this.getRowCount(dataTable);
            int delta = rowcount % (rows = this.getRows(dataTable));
            int n = first = delta > 0 && delta < rows ? rowcount - delta : rowcount - rows;
            if (first >= 0) {
                this.setFirstRow(first);
            } else {
                this.setFirstRow(0);
            }
        } else {
            int pageCount;
            int pageindex = Integer.parseInt(facetName);
            if (pageindex > (pageCount = this.getPageCount(dataTable))) {
                pageindex = pageCount;
            } else if (pageindex <= 0) {
                pageindex = 1;
            }
            this.setFirstRow(this.getRows(dataTable) * (pageindex - 1));
        }
    }

    public int getPageCount(UIData data) {
        int pageCount;
        int rows = this.getRows(data);
        if (rows > 0) {
            int rowCount = this.getRowCount(data);
            int n = pageCount = rows <= 0 ? 1 : rowCount / rows;
            if (rowCount % rows > 0) {
                ++pageCount;
            }
            if (pageCount == 0) {
                pageCount = 1;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getPageCount() {
        return this.getPageCount(this.getDataTable());
    }

    public int getRowCount(UIData data) {
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            return rowCount;
        }
        return BinarySearch.search(data);
    }

    public int getRowCount() {
        return this.getRowCount(this.getDataTable());
    }

    public int getRows(UIData data) {
        int row = 0;
        row = data.getRows();
        if (row == 0) {
            row = this.getRowCount(data);
        }
        return row;
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return this.getFacet(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return this.getFacet(NEXT_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return this.getFacet(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return this.getFacet(FAST_REWIND_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return this.getFacet(PREVIOUS_FACET_NAME);
    }

    public int getFirstRow(UIData data) {
        return data.getFirst();
    }

    public void setFirstRow(int rows) {
        this.getDataTable().setFirst(rows);
    }

    public String getFamily() {
        return "org.richfaces.Datascroller";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class BinarySearch {
        BinarySearch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int search(UIData data) {
            int rowIndex = data.getRowIndex();
            try {
                int n;
                int n2 = 1;
                int k = 2;
                while (true) {
                    data.setRowIndex(k - 1);
                    if (!data.isRowAvailable()) break;
                    n2 = k;
                    k *= 2;
                }
                while (n2 < k) {
                    int kk = Math.round((n2 + k) / 2) + 1;
                    data.setRowIndex(kk - 1);
                    if (data.isRowAvailable()) {
                        n2 = kk;
                        continue;
                    }
                    k = kk - 1;
                }
                data.setRowIndex(k - 1);
                if (data.isRowAvailable()) {
                    n = k;
                    return n;
                }
                n = 0;
                return n;
            }
            finally {
                data.setRowIndex(rowIndex);
            }
        }
    }
}

