if (!window.Richfaces) window.Richfaces = {};

Richfaces.PanelBar = Class.create();

Richfaces.PanelBar.prototype = {


	initialize: function(panelId, onclick) {

		this.FF = (RichFaces.navigatorType() == "FF")?true:false;
		this.isIE = ((navigator.userAgent.toLowerCase().indexOf("msie")!=-1) || (navigator.userAgent.toLowerCase().indexOf("explorer")!=-1))?true:false;
		this.panel=$(panelId); //+"_p"

		if (!this.panel) {
			return;
		}
		this.hclient=0;
		this.COUNT=0;
		this.STEP=0;
		this.slides=new Array();
		this.ch=this.panel.clientHeight;

        this.onclick = onclick;
        this._attachBehaviors();

		this.input=$(panelId+"_panelBarInput");

		this.defaultIndex=this.findPanelById($F(panelId+"_panelBarInput"));

		Event.observe(window,'load',this.handleOnLoad.bindAsEventListener(this));

        this.showSlide(this.slides[this.defaultIndex]);

        this.contentHight = -1;
    },

	handleOnLoad: function() {
	    if ( this.timer ){
			clearTimeout(this.timer);
		}
		if (this.panel.clientHeight<=0){
		  this.contentHight = -1;
 		  this.timer = setTimeout(this.handleOnLoad.bind(this), 100);
 		}


		this.showSlide(this.slides[this.defaultIndex]);
	},

	getContentHeight: function() {

        if(this.contentHight) {
        }
        else{
         this.contentHight = -1;
        }

		if(this.contentHight <= -1) {
			var h=0;
			this.hclient=0;
			for(var i=0; i<this.slides.length; i++) {
				h+=this.slides[i].item.offsetHeight;


			}
			this.hclient=h;
			this.contentHight = this.panel.clientHeight-h;
	    }

		return this.contentHight;
	},

	showSlide: function(slide) {
		if (this.current) this.current.hideContent();
		var h=this.getContentHeight();
		if (this.current) this.current.hideHeader();

		slide.content.style.height=(h>0?h:0)+"px";
		if (h<=1 && (this.panel.style.height=="" || this.panel.style.height.indexOf("%")!=-1)) {
			this.panel.style.height="";
			slide.content.style.height="100%";
		}
		slide.showContent();
		this.current=slide;
//		this.input.value=this.current.index;
		this.input.value=this.current.item.id;

	},

	_attachBehaviors: function() {
		var rows=this._getDirectChildrenByTag(this.panel,'DIV');
		for(var i=0; i<rows.length; i++) {
			var subrows=this._getDirectChildrenByTag(rows[i],'DIV');
			this.slides.push(new Richfaces.PanelBar.Slide(this,rows[i],subrows[0],subrows[1],subrows[2],i,this.onclick)); //ndex
		}
	},


	_getDirectChildrenByTag: function( e, tagName ) {

		var kids = new Array();
		var allKids = e.childNodes;
		for( var i = 0 ; i < allKids.length ; i++ ) {
			var item=allKids[i];
			if (item && item.tagName && item.tagName.toUpperCase() == tagName.toUpperCase()){
				kids.push(item);
			}
		}
		return kids;

	},

	findPanelById: function(value) {
		for(var i = 0; i<this.slides.length; i++) {
			if (this.slides[i].item.id==value) return i;
		}
		return 0;
	}


}

Richfaces.PanelBar.Slide = Class.create();
Richfaces.PanelBar.Slide.prototype = {

	initialize: function(slidePanel,item,header,header_act,content,index,onclick){

		this.index=index;
		this.slidePanel=slidePanel;
		this.item=item;
		this.header=header;
		this.header_act=header_act;
		this.content=content;
		this.item.style.overflow="hidden";
//		this.header.style.overflowX="hidden";
//		this.header.style.overflowY="visible";
//		this.header.style.cursor="pointer";
		this.header.onclick=this.headerOnClick.bindAsEventListener(this);
		this.header.onselectstart=this.headerOnSelectStart.bindAsEventListener(this);
		this.header_act.onclick=this.headerOnClick.bindAsEventListener(this);
		this.header_act.onselectstart=this.headerOnSelectStart.bindAsEventListener(this);
		this.content.style.display="none";
		this.content.style.overflow="auto";
		this.content.style.height="0px";
//		this.content.style.paddingRight="0px";
		this.hightFirefoxDelta = 0;

		if (this.slidePanel.isIE){
			if (this.slidePanel.panel.style.width.indexOf("%")!=-1) {
				this.item.style.width="100%";
			} else {
				this.item.style.width=this.slidePanel.panel.style.width;
			}
        }

        if (onclick && onclick != ""){
            this.onclickFunction = new Function("return " + onclick + ";").bindAsEventListener(this);
        }
	},

	showContent: function() {
		this.content.style.display="block";
		this.content.firstChild.style.height="";
		this.header.style.display="none";
		this.header_act.style.display="";

	},

	hideContent: function() {
		this.content.style.display="none";
		this.content.firstChild.style.height="100%";
	},

	hideHeader: function() {
		this.header_act.style.display="none";
		this.header.style.display="";
	},

	headerOnClick: function() {
        if (this.onclickFunction){
            var result = this.onclickFunction();
            if (result != undefined && !result) {
                return;
            }
        }

        if (this.content.style.display=="block") return;
		//this.header.style.display="none";
		//this.header_act.style.display="";
		this.slidePanel.showSlide(this);
		this.slidePanel.panel.style.maxHeight="";
		this.slidePanel.panel.style.minHeight="";
	},

	headerOnSelectStart: function() {
		return false;
	}
}
