/**
 *
 */

package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.model.DataModel;

import org.ajax4jsf.Messages;
import org.ajax4jsf.model.DataVisitor;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.model.ListShuttleDataModel;
import org.richfaces.model.ListShuttleRowKey;

/**
 * JSF component class
 * 
 */
public abstract class UIListShuttle extends UIOrderingBaseComponent {

	public static final String COMPONENT_TYPE = "org.richfaces.ListShuttle";

	public static final String COMPONENT_FAMILY = "org.richfaces.ListShuttle";

	private Collection sourceSelection;
	private boolean sourceSelectionSet;
	
	private Collection targetSelection;
	private boolean targetSelectionSet;

	protected void processDecodes(FacesContext faces, Object argument) {
		if (!this.isRendered())
			return;
		this.decode(faces);

		SubmittedValue submittedValue = UIListShuttle.this.submittedValueHolder;
		if (submittedValue != null) {
			if (submittedValue != null) {
				Object modelSourceValue = getSourceValue();
				Object modelTargetValue = getTargetValue();
				
				Iterator iterator = submittedValue.map.entrySet().iterator();
				while (iterator.hasNext()) {
					Entry entry = (Entry) iterator.next();
					Object value = entry.getValue();
					
					if (!isSuitableValue(modelSourceValue, value) && !isSuitableValue(modelTargetValue, value)) {
						String messageText = Messages.getMessage(
								Messages.INVALID_VALUE, MessageUtil.getLabel(faces, this), value);
						
						FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageText, null);
						faces.addMessage(this.getClientId(faces), message);

						setValid(false);
						break;
					}
				}
			}
		}

		if (isImmediate()) {
			executeValidate(faces);
		}
		
        if (!isValid()) {
            faces.renderResponse();
        }

        this.iterate(faces, decodeVisitor, argument);
	}

	private final class ModelItemState implements ItemState {
		private Collection sourceSelectedItems;
		private Collection targetSelectedItems;
		private Object activeItem;

		public ModelItemState(Collection sourceSelectedItems, Collection targetSelectedItems, Object activeItem) {
			super();
			this.sourceSelectedItems = sourceSelectedItems;
			this.targetSelectedItems = targetSelectedItems;
			this.activeItem = activeItem;
		}

		public boolean isSelected() {
			Object rowData = getRowData();
			return ((sourceSelectedItems != null && sourceSelectedItems.contains(rowData)) || 
			(targetSelectedItems != null && targetSelectedItems.contains(rowData)));
		}

		public boolean isActive() {
			return activeItem != null && activeItem.equals(getRowData());
		}
	}

	protected static final class SubmittedValue implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 5655312942714191981L;
		//ListShuttleRowKey -> ListShuttleRowKey
		private Map map = null;

		private Set sourceSelection;
		private Set targetSelection;
		
		private Object activeItem;
		
		public SubmittedValue(Map map, Set sourceSelection, Set targetSelection, Object activeItem) {
			this.map = map;
		
			this.sourceSelection = sourceSelection;
			this.targetSelection = targetSelection;

			this.activeItem = activeItem;
		}

	}

	private transient Map map;

	private transient SubmittedValue submittedValueHolder = null;

	protected static final class ValueHolder implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 2124352131407581704L;

		private Object sourceValue;
		private boolean sourceValueSet;

		private Object targetValue;
		private boolean targetValueSet;

		private Collection sourceSelection;
		private boolean sourceSelectionSet;
		
		private Collection targetSelection;
		private boolean targetSelectionSet;

		private Map map;
	}

	private Object sourceValue;
	private boolean sourceValueSet;

	private Object targetValue;
	private boolean targetValueSet;

	public Object saveState(FacesContext context) {
		Object[] state = new Object[8];

		state[0] = super.saveState(context);
		state[1] = saveIterationState();

		final HashSet sourceSelectionKeySet = new HashSet();
		final HashSet targetSelectionKeySet = new HashSet();
		final HashSet activeItemSet = new HashSet(1);
		
		Object rowKey = getRowKey();
		try {
			walk(context, new DataVisitor() {

				public void process(FacesContext context, Object rowKey,
						Object argument) throws IOException {

					setRowKey(context, rowKey);
					Object data = getRowData();
					
					if (data != null) {
						if (data.equals(activeItem)) {
							activeItemSet.add(rowKey);
						}
						
						if (sourceSelection != null && sourceSelection.contains(data)) {
							sourceSelectionKeySet.add(rowKey);
						} else if (targetSelection != null && targetSelection.contains(data)){
							targetSelectionKeySet.add(rowKey);
						}
					}
				}
				
			}, null);
		} catch (IOException e) {
			throw new FacesException(e.getLocalizedMessage(), e);
		}

		state[2] = sourceSelectionKeySet;
		state[3] = this.sourceSelectionSet ? Boolean.TRUE : Boolean.FALSE;
		
		state[4] = targetSelectionKeySet;
		state[5] = this.targetSelectionSet ? Boolean.TRUE : Boolean.FALSE;

		state[6] = activeItemSet.isEmpty() ? null : activeItemSet.iterator().next();
		state[7] = this.activeItemSet ? Boolean.TRUE : Boolean.FALSE;

		return state;
	}

	public void restoreState(FacesContext context, Object object) {
		Object[] state = (Object[]) object;

		super.restoreState(context, state[0]);
		restoreIterationState(state[1]);

		this.sourceSelection = (Collection) state[2];
		this.sourceSelectionSet = ((Boolean) state[3]).booleanValue();
		
		this.targetSelection = (Collection) state[4];
		this.targetSelectionSet = ((Boolean) state[5]).booleanValue();
	
		this.activeItem = state[6];
		this.activeItemSet = ((Boolean) state[7]).booleanValue();
	}

	public Object getSourceValue() {
		if (sourceValue != null) {
			return sourceValue;
		}

		ValueBinding vb = getValueBinding("sourceValue");
		if (vb != null) {
			return vb.getValue(FacesContext.getCurrentInstance());
		}

		return null;
	}

	public void setSourceValue(Object sourceValue) {
		setExtendedDataModel(null);
		this.sourceValue = sourceValue;
		this.sourceValueSet = true;
	}

	public Object getTargetValue() {
		if (targetValue != null) {
			return targetValue;
		}

		ValueBinding vb = getValueBinding("targetValue");
		if (vb != null) {
			return vb.getValue(FacesContext.getCurrentInstance());
		}

		return null;
	}

	public void setTargetValue(Object targetValue) {
		setExtendedDataModel(null);
		this.targetValue = targetValue;
		this.targetValueSet = true;
	}

	public void setSubmittedStrings(Map map, Set sourceSelection, Set targetSelection, Object activeItem) {
		this.submittedValueHolder = new SubmittedValue(map, sourceSelection, targetSelection, activeItem);
	}

	protected Object saveIterationSubmittedState() {
		return submittedValueHolder;
	}

	protected void restoreIterationSubmittedState(Object object) {
		this.submittedValueHolder = (SubmittedValue) object;
	}

	protected Object saveIterationState() {
		ValueHolder holder = new ValueHolder();

		holder.sourceValue = sourceValue;
		holder.sourceValueSet = sourceValueSet;

		holder.targetValue = targetValue;
		holder.targetValueSet = targetValueSet;

		holder.sourceSelection = this.sourceSelection;
		holder.sourceSelectionSet = this.sourceSelectionSet;
		
		holder.targetSelection = this.targetSelection;
		holder.targetSelectionSet = this.targetSelectionSet;

		holder.map = map;

		return holder;
	}

	protected void restoreIterationState(Object object) {
		ValueHolder holder = (ValueHolder) object;

		this.sourceValue = holder.sourceValue ;
		this.sourceValueSet = holder.sourceValueSet;

		this.targetValue = holder.targetValue;
		this.targetValueSet = holder.targetValueSet;

		this.sourceSelection = holder.sourceSelection;
		this.sourceSelectionSet = holder.sourceSelectionSet;
		
		this.targetSelection = holder.targetSelection;
		this.targetSelectionSet = holder.targetSelectionSet;

		map = holder.map;
	}

	public org.ajax4jsf.model.ExtendedDataModel createDataModel() {
		Map source = null;
		
		if (submittedValueHolder != null) {
			source = submittedValueHolder.map;
		} else {
			source = this.map;
		}
		
		if (source != null) {
			ListShuttleDataModel dataModel = new ListShuttleDataModel();
			dataModel.setWrappedData(source);
			
			return dataModel;
		}
		
		DataModel sourceDataModel = createDataModel(getSourceValue());
		DataModel targetDataModel = createDataModel(getTargetValue());

		ListShuttleDataModel dataModel = new ListShuttleDataModel();
		dataModel.setWrappedData(new DataModel[]{sourceDataModel, targetDataModel});
		return dataModel;
	}

	public void addValueChangeListener(ValueChangeListener listener) {
		addFacesListener(listener);
	}

	public abstract MethodBinding getValueChangeListener();

	public ValueChangeListener[] getValueChangeListeners() {
		return (ValueChangeListener[]) getFacesListeners(ValueChangeListener.class);
	}

	public void removeValueChangeListener(ValueChangeListener listener) {
		removeFacesListener(listener);
	}

	protected final UpdateModelCommand updateTargetSelectionCommand = new UpdateModelCommand() {

		public void execute(FacesContext context) {
			if (targetSelectionSet) {
				ValueBinding vb = getValueBinding("targetSelection");
				if (vb != null) {
					vb.setValue(context, targetSelection);
					targetSelection = null;
					targetSelectionSet = false;
				}
			}
		}
		
	};
	
	protected final UpdateModelCommand updateSourceSelectionCommand = new UpdateModelCommand() {

		public void execute(FacesContext context) {
			if (sourceSelectionSet) {
				ValueBinding vb = getValueBinding("sourceSelection");
				if (vb != null) {
					vb.setValue(context, sourceSelection);
					sourceSelection = null;
					sourceSelectionSet = false;
				}
			}
		}
		
	};

	private final UpdateModelCommand updateSourceCommand = new UpdateModelCommand() {

		public void execute(FacesContext context) {
			if (sourceValueSet) {
				ValueBinding vb = getValueBinding("sourceValue");
				if (vb != null) {
					vb.setValue(context, sourceValue);
					sourceValue = null;
					sourceValueSet = false;
				}
			}
		}

	};

	private final UpdateModelCommand updateTargetCommand = new UpdateModelCommand() {

		public void execute(FacesContext context) {
			if (targetValueSet) {
				ValueBinding vb = getValueBinding("targetValue");
				if (vb != null) {
					vb.setValue(context, targetValue);
					targetValue = null;
					targetValueSet = false;
				}
			}
		}

	};

	/**
	 * <p>Perform the following algorithm to update the model data
	 * associated with this {@link UIInput}, if any, as appropriate.</p>
	 * <ul>
	 * <li>If the <code>valid</code> property of this component is
	 *     <code>false</code>, take no further action.</li>
	 * <li>If the <code>localValueSet</code> property of this component is
	 *     <code>false</code>, take no further action.</li>
	 * <li>If no {@link ValueBinding} for <code>value</code> exists,
	 *     take no further action.</li>
	 * <li>Call <code>setValue()</code> method of the {@link ValueBinding}
	 *      to update the value that the {@link ValueBinding} points at.</li>
	 * <li>If the <code>setValue()</code> method returns successfully:
	 *     <ul>
	 *     <li>Clear the local value of this {@link UIInput}.</li>
	 *     <li>Set the <code>localValueSet</code> property of this
	 *         {@link UIInput} to false.</li>
	 *     </ul></li>
	 * <li>If the <code>setValue()</code> method call fails:
	 *     <ul>
	 *     <li>Enqueue an error message by calling <code>addMessage()</code>
	 *         on the specified {@link FacesContext} instance.</li>
	 *     <li>Set the <code>valid</code> property of this {@link UIInput}
	 *         to <code>false</code>.</li>
	 *     </ul></li>
	 * </ul>
	 *
	 * @param context {@link FacesContext} for the request we are processing
	 *
	 * @exception NullPointerException if <code>context</code>
	 *  is <code>null</code>
	 */
	public void updateModel(FacesContext context) {

		if (context == null) {
			throw new NullPointerException();
		}

		if (!isValid()) {
			return;
		}

		updateModel(context, updateActiveItemCommand);
		updateModel(context, updateSourceSelectionCommand);
		updateModel(context, updateTargetSelectionCommand);
		updateModel(context, updateSourceCommand);
		updateModel(context, updateTargetCommand);
	}


	// ------------------------------------------------------ Validation Methods


	/**
	 * <p>Perform the following algorithm to validate the local value of
	 * this {@link UIInput}.</p>
	 * <ul>
	 * <li>Retrieve the submitted value with <code>getSubmittedValue()</code>.
	 *   If this returns null, exit without further processing.  (This
	 *   indicates that no value was submitted for this component.)</li>
	 *
	 * <li> Convert the submitted value into a "local value" of the
	 * appropriate data type by calling {@link #getConvertedValue}.</li>
	 *
	 * <li>Validate the property by calling {@link #validateValue}.</li>
	 *
	 * <li>If the <code>valid</code> property of this component is still
	 *     <code>true</code>, retrieve the previous value of the component
	 *     (with <code>getValue()</code>), store the new local value using
	 *     <code>setValue()</code>, and reset the submitted value to 
	 *     null.  If the local value is different from
	 *     the previous value of this component, fire a
	 *     {@link ValueChangeEvent} to be broadcast to all interested
	 *     listeners.</li>
	 * </ul>
	 *
	 * <p>Application components implementing {@link UIInput} that wish to
	 * perform validation with logic embedded in the component should perform
	 * their own correctness checks, and then call the
	 * <code>super.validate()</code> method to perform the standard
	 * processing described above.</p>
	 *
	 * @param context The {@link FacesContext} for the current request
	 *
	 * @exception NullPointerException if <code>context</code>
	 *  is null
	 */
	public void validate(FacesContext context) {

		if (context == null) {
			throw new NullPointerException();
		}

		// Submitted value == null means "the component was not submitted
		// at all";  validation should not continue
		if (submittedValueHolder == null) {
			return;
		}

		Object oldSourceValue = getSourceValue();
		Object newSourceValue = oldSourceValue;

		Object oldTargetValue = getTargetValue();
		Object newTargetValue = oldTargetValue;

		try {
			final ArrayList sourceList = new ArrayList();
			final ArrayList targetList = new ArrayList();

			final ListShuttleDataModel listShuttleDataModel = (ListShuttleDataModel) getExtendedDataModel();
			try {
				listShuttleDataModel.walk(context, new DataVisitor() {

					public void process(FacesContext context, Object rowKey,
							Object argument) throws IOException {

						setRowKey(context, rowKey);
						
						ListShuttleRowKey listShuttleRowKey = (ListShuttleRowKey) rowKey;
						if (listShuttleRowKey.isFacadeSource()) {
							sourceList.add(getRowData());
						} else {
							targetList.add(getRowData());
						}
					}
				}, null, null);
			} catch (IOException e) {
				throw new ConverterException(e.getLocalizedMessage(), e);
			}
			
			newSourceValue = createContainer(sourceList, oldSourceValue.getClass());
			newTargetValue = createContainer(targetList, oldTargetValue.getClass());
		}
		catch (ConverterException ce) {
			Object submittedValue = submittedValueHolder;
			//addConversionErrorMessage(context, ce, submittedValue);
			setValid(false);
		}	

		//validateValue(context, newValue);

		// If our value is valid, store the new value, erase the
		// "submitted" value, and emit a ValueChangeEvent if appropriate
		if (isValid()) {
			setSourceSelection(submittedValueHolder.sourceSelection);
			setTargetSelection(submittedValueHolder.targetSelection);
			setActiveItem(submittedValueHolder.activeItem);

			Object previousSource = getSourceValue();
			Object previousTarget = getTargetValue();

			setSourceValue(newSourceValue);
			setTargetValue(newTargetValue);

			setTranslatedState();

			if (compareValues(previousSource, newSourceValue) || compareValues(previousTarget, newTargetValue)) {
				queueEvent(new ValueChangeEvent(this, 
						new Object[]{previousSource,previousTarget}, 
						new Object[]{newSourceValue, newTargetValue}));
			}

			this.map = this.submittedValueHolder.map;

			this.submittedValueHolder = null;

		}
	}

	protected void resetDataModel() {
		super.resetDataModel();

		this.map = null;

		if (this.submittedValueHolder != null) {
			setTranslatedRenderingState();
		}
	}

	public ItemState getItemState() {
		if (submittedValueHolder != null) {
			return new ModelItemState(submittedValueHolder.sourceSelection, submittedValueHolder.targetSelection, 
					submittedValueHolder.activeItem);
		} else {
			return new ModelItemState(getSourceSelection(), getTargetSelection(), getActiveItem());
		}
	}

	public abstract boolean isOrderControlsVisible();
	public abstract void setOrderControlsVisible(boolean visible);
	
	public abstract boolean isFastOrderControlsVisible();
	public abstract void setFastOrderControlsVisible(boolean visible);

	public abstract boolean isMoveControlsVisible();
	public abstract void setMoveControlsVisible(boolean visible);
	
	public abstract boolean isFastMoveControlsVisible();
	public abstract void setFastMoveControlsVisible(boolean visible);

	public Collection getSourceSelection() {
		if (this.sourceSelection != null) {
			return this.sourceSelection;
		} else {
			ValueBinding vb = getValueBinding("sourceSelection");
			if (vb != null) {
				return (Collection) vb.getValue(FacesContext.getCurrentInstance());
			}
		}
		
		return null;
	}
	
	public void setSourceSelection(Collection collection) {
		this.sourceSelection = collection;
		this.sourceSelectionSet = true;
	}

	public Collection getTargetSelection() {
		if (this.targetSelection != null) {
			return this.targetSelection;
		} else {
			ValueBinding vb = getValueBinding("targetSelection");
			if (vb != null) {
				return (Collection) vb.getValue(FacesContext.getCurrentInstance());
			}
		}
		
		return null;
	}
	
	public void setTargetSelection(Collection collection) {
		this.targetSelection = collection;
		this.targetSelectionSet = true;
	}
	
	public abstract String getSourceCaptionLabel();
	public abstract void setSourceCaptionLabel(String label);
	
	public abstract String getTargetCaptionLabel();
	public abstract void setTargetCaptionLabel(String label);

}
