/**
 * 
 */
package org.richfaces.component;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.validator.Validator;

import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.RepeatState;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.FilterIterator;

/**
 * @author Nick Belaevski
 *         mailto:nbelaevski@exadel.com
 *         created 16.11.2007
 * @since 3.2
 */
public abstract class UIOrderingBaseComponent extends UIDataAdaptor implements EditableValueHolder {

	private Object value;
	private boolean localValueSet;

	protected Object activeItem;
	protected boolean activeItemSet;
	
	private List validators = null;
	private MethodBinding validator;

	public static final Predicate isColumn = new Predicate() {
		public boolean evaluate(Object input) {
			return (input instanceof javax.faces.component.UIColumn || input instanceof Column) &&
					((UIComponent) input).isRendered();
		}
	};

	protected boolean isSuitableValue(Object value, Object restoredObject) {
		if (value instanceof Object[]) {
			Object[] objects = (Object[]) value;
			for (int i = 0; i < objects.length; i++) {
				Object object = objects[i];
			
				if (object != null && object.equals(restoredObject)) {
					return true;
				}
			}

			return false;
		} else {
			if (value != null) {
				return ((Collection) value).contains(restoredObject);
			} else {
				return false;
			}
		}
	}
	
	private static class EditableState implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = -3276243811945890889L;

		private boolean translated = false;

		//setting this flag to true means we should reorder elements
		private boolean translatedRendering = false;
	}

	private static final class ValueHolder implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = 2349104220087787755L;

		private Object value;

		private Object activeItem;
		private boolean activeItemSet;

		private Object state;
	}

	private transient EditableState editableState = new EditableState();
	
	protected abstract void restoreIterationState(Object object);
	protected abstract Object saveIterationState();

	protected abstract void restoreIterationSubmittedState(Object object);
	protected abstract Object saveIterationSubmittedState();
	
	public abstract boolean isOrderControlsVisible();
	public abstract void setOrderControlsVisible(boolean visible);
	
	public abstract boolean isFastOrderControlsVisible();
	public abstract void setFastOrderControlsVisible(boolean visible);

	protected void setTranslatedState() {
		this.editableState.translated = true;
	}

	protected boolean isTranslatedState() {
		return this.editableState.translated;
	}
	
	protected void setTranslatedRenderingState() {
		this.editableState.translatedRendering = true;
	}

	protected boolean isTranslatedRenderingState() {
		return this.editableState.translatedRendering;
	}

	public final Object getSubmittedValue() {
		Object[] state = new Object[2];

		state[0] = saveIterationSubmittedState();
		state[1] = editableState;
		
		return state;
	}
	
	public final void setSubmittedValue(Object object) {
		if (object != null) {
			Object[] state = (Object[]) object;

			restoreIterationSubmittedState(state[0]);
			editableState = (EditableState) state[1];
		} else {
			restoreIterationSubmittedState(null);
		}
	}
	
	public Object saveState(FacesContext faces) {
		Object[] state = new Object[5];

		state[0] = super.saveState(faces);
	
		state[1] = saveAttachedState(faces, validators);
		state[2] = saveAttachedState(faces, validator);

		state[3] = this.value;
		state[4] = localValueSet ? Boolean.TRUE : Boolean.FALSE;

		return state;
	}

	public void restoreState(FacesContext faces, Object object) {
		Object[] state = (Object[]) object;

		super.restoreState(faces, state[0]);

		validators = (List) restoreAttachedState(faces, state[1]);
		validator = (MethodBinding) restoreAttachedState(faces, state[2]);

		value = state[3];
		localValueSet = ((Boolean) state[4]).booleanValue();

	}

	protected DataComponentState createComponentState() {
		return new RepeatState();
	}

	public Iterator columns() {
		return new FilterIterator(getChildren().iterator(), isColumn);
	}

	protected Iterator dataChildren() {
		if (getChildCount() != 0) {
			return columns();
		} else {
			return EmptyIterator.INSTANCE;
		}
	}

	protected Iterator fixedChildren() {
		Map facets = getFacets();
		if (facets != null) {
			return facets.values().iterator();
		} else {
			return EmptyIterator.INSTANCE;
		}
	}

	//validators
	public MethodBinding getValidator() {
		return validator;
	}

	public void setValidator(MethodBinding validatorBinding) {
		this.validator = validatorBinding;
	}

	public Validator[] getValidators() {

		if (validators == null) {
			return new Validator[0];
		} else {
			return (Validator[]) validators.toArray(new Validator[validators.size()]);
		}
	}

	public void addValidator(Validator validator) {
		if (validator == null) {
			throw new NullPointerException();
		}

		if (validators == null) {
			validators = new ArrayList();
		}

		validators.add(validator);
	}

	public void removeValidator(Validator validator) {
		if (validators != null) {
			validators.remove(validator);
		}
	}
	//validators end
	
	//value
	protected Object getLocalValueFieldValue() {
		return value;
	}
	
	public Object getLocalValue() {
		ValueHolder holder = new ValueHolder();
		holder.value = this.value;

		holder.activeItem = this.activeItem;
		holder.activeItemSet = this.activeItemSet;

		holder.state = saveIterationState();
		
		return holder;
	}

	public void setValue(Object value) {
		if (value instanceof ValueHolder) {
			ValueHolder holder = (ValueHolder) value;
			
			setValue(holder.value);
			restoreIterationState(holder.state);
		
			this.activeItem = holder.activeItem;
			this.activeItemSet = holder.activeItemSet;
		} else {
			super.setValue(value);
			this.value = value;
			setLocalValueSet(true);
		}
	}

	public Object getValue() {
		if (this.value != null) {
			return (this.value);
		}
		ValueBinding ve = getValueBinding("value");
		if (ve != null) {
			return (ve.getValue(getFacesContext()));
		} else {
			return (null);
		}
	}
	//value end

	public boolean isLocalValueSet() {
		return localValueSet;
	}

	public void setLocalValueSet(boolean localValueSet) {
		this.localValueSet = localValueSet;
	}

	protected DataModel createDataModel(Object value) {
		DataModel dataModel;
        
        if (value == null) {
            dataModel = new ListDataModel(Collections.EMPTY_LIST);
        } else if (value instanceof List) {
        	dataModel = new ListDataModel((List) value);
        } else if (Object[].class.isAssignableFrom(value.getClass())) {
        	dataModel = new ArrayDataModel((Object[]) value);
        } else {
        	throw new IllegalArgumentException();
        }
        
        return dataModel;
	}


	/**
	 * @exception NullPointerException {@inheritDoc}     
	 */ 
	public void decode(FacesContext context) {

		if (context == null) {
			throw new NullPointerException();
		}

		// Force validity back to "true"
		setValid(true);
		super.decode(context);
	}

	/**
	 * <p>Specialized decode behavior on top of that provided by the
	 * superclass.  In addition to the standard
	 * <code>processDecodes</code> behavior inherited from {@link
	 * UIComponentBase}, calls <code>validate()</code> if the the
	 * <code>immediate</code> property is true; if the component is
	 * invalid afterwards or a <code>RuntimeException</code> is thrown,
	 * calls {@link FacesContext#renderResponse}.  </p>
	 * @exception NullPointerException {@inheritDoc}     
	 */ 
	public void processDecodes(FacesContext context) {

		if (context == null) {
			throw new NullPointerException();
		}

		// Skip processing if our rendered flag is false
		if (!isRendered()) {
			return;
		}

		super.processDecodes(context);

		if (isImmediate()) {
			executeValidate(context);
		}
	}

	/**
	 * Executes validation logic.
	 */
	protected void executeValidate(FacesContext context) {
		try {
			validate(context);
		} catch (RuntimeException e) {
			context.renderResponse();
			throw e;
		}

		if (!isValid()) {
			context.renderResponse();
		}
	}


	public abstract void validate(FacesContext context);
	
	/**
	 * <p>In addition to the standard <code>processValidators</code> behavior
	 * inherited from {@link UIComponentBase}, calls <code>validate()</code>
	 * if the <code>immediate</code> property is false (which is the 
	 * default);  if the component is invalid afterwards, calls
	 * {@link FacesContext#renderResponse}.
	 * If a <code>RuntimeException</code> is thrown during
	 * validation processing, calls {@link FacesContext#renderResponse}
	 * and re-throw the exception.
	 * </p>
	 * @exception NullPointerException {@inheritDoc}    
	 */ 
	public void processValidators(FacesContext context) {

		if (context == null) {
			throw new NullPointerException();
		}

		// Skip processing if our rendered flag is false
		if (!isRendered()) {
			return;
		}

		super.processValidators(context);
		if (!isImmediate()) {
			executeValidate(context);
		}
	}

	/**
	 * <p>In addition to the standard <code>processUpdates</code> behavior
	 * inherited from {@link UIComponentBase}, calls
	 * <code>updateModel()</code>.
	 * If the component is invalid afterwards, calls
	 * {@link FacesContext#renderResponse}.
	 * If a <code>RuntimeException</code> is thrown during
	 * update processing, calls {@link FacesContext#renderResponse}
	 * and re-throw the exception.
	 * </p>
	 * @exception NullPointerException {@inheritDoc}     
	 */ 
	public void processUpdates(FacesContext context) {

		if (context == null) {
			throw new NullPointerException();
		}

		// Skip processing if our rendered flag is false
		if (!isRendered()) {
			return;
		}

		super.processUpdates(context);

		try {
			updateModel(context);
		} catch (RuntimeException e) {
			context.renderResponse();
			throw e;
		}

		if (!isValid()) {
			context.renderResponse();
		}
	}

	public abstract void updateModel(FacesContext context);

	protected interface UpdateModelCommand {
		public void execute(FacesContext context);
	}

	protected interface DataAdder {
		Object getContainer();
		void add(Object object);
	}

	protected final UpdateModelCommand updateValueCommand = new UpdateModelCommand() {

		public void execute(FacesContext context) {
			if (isLocalValueSet()) {
				ValueBinding vb = getValueBinding("value");
				if (vb != null) {
					vb.setValue(context, getLocalValueFieldValue());
					setValue(null);
					setLocalValueSet(false);
				}
			}
		}
		
	};
	
	protected final UpdateModelCommand updateActiveItemCommand = new UpdateModelCommand() {

		public void execute(FacesContext context) {
			if (activeItemSet) {
				ValueBinding vb = getValueBinding("activeItem");
				if (vb != null) {
					vb.setValue(context, activeItem);
					activeItem = null;
					activeItemSet = false;
				}
			}
		}
		
	};

	protected void updateModel(FacesContext context, UpdateModelCommand command) {
		try {
			command.execute(context);
		} catch (EvaluationException e) {
			String messageStr = e.getMessage();
			FacesMessage message = null;
			if (null == messageStr) {
				message =
					MessageFactory.getMessage(context, UIInput.CONVERSION_MESSAGE_ID);
			}
			else {
				message = new FacesMessage(messageStr);
			}
			message.setSeverity(FacesMessage.SEVERITY_ERROR);
			context.addMessage(getClientId(context), message);
			setValid(false);
		}
		catch (FacesException e) {
			FacesMessage message =
				MessageFactory.getMessage(context, UIInput.CONVERSION_MESSAGE_ID);
			message.setSeverity(FacesMessage.SEVERITY_ERROR);
			context.addMessage(getClientId(context), message);
			setValid(false);
		} catch (IllegalArgumentException e) {
			FacesMessage message =
				MessageFactory.getMessage(context, UIInput.CONVERSION_MESSAGE_ID);
			message.setSeverity(FacesMessage.SEVERITY_ERROR);
			context.addMessage(getClientId(context), message);
			setValid(false);
		} catch (Exception e) {
			FacesMessage message =
				MessageFactory.getMessage(context, UIInput.CONVERSION_MESSAGE_ID);
			message.setSeverity(FacesMessage.SEVERITY_ERROR);
			context.addMessage(getClientId(context), message);
			setValid(false);
		}
	}
	
	/**
	 * <p>Return <code>true</code> if the new value is different from the
	 * previous value.</p>
	 *
	 * @param previous old value of this component (if any)
	 * @param value new value of this component (if any)
	 */
	protected boolean compareValues(Object previous, Object value) {

		if (previous == null) {
			return (value != null);
		} else if (value == null) {
			return (true);
		} else {
			if (previous instanceof Object[]) {
				return !Arrays.equals((Object[]) previous, (Object[]) value);
			} else {
				return (!(previous.equals(value)));
			}
		}

	}

	protected void addConversionErrorMessage(FacesContext context, 
			ConverterException ce, Object value) {
		FacesMessage message = ce.getFacesMessage();
		if (message == null) {
			message = MessageFactory.getMessage(context,
					UIInput.CONVERSION_MESSAGE_ID);
			if (message.getDetail() == null) {
				message.setDetail(ce.getMessage());
			}
		}

		message.setSeverity(FacesMessage.SEVERITY_ERROR);
		context.addMessage(getClientId(context), message);
	}
	
	protected boolean isEmpty(Object value) {

		if (value == null) {
			return (true);
		} else if ((value instanceof String) &&
				(((String) value).length() < 1)) {
			return (true);
		} else if (value.getClass().isArray()) {
			if (0 == java.lang.reflect.Array.getLength(value)) {
				return (true);
			}
		}
		else if (value instanceof List) {
			if (0 == ((List) value).size()) {
				return (true);
			}
		}
		return (false);
	}

	public Object getActiveItem() {
		if (this.activeItem != null) {
			return this.activeItem;
		} else {
			ValueBinding vb = getValueBinding("activeItem");
			if (vb != null) {
				return vb.getValue(FacesContext.getCurrentInstance());
			}
		}
		
		return null;
	}
	
	public void setActiveItem(Object activeItem) {
		this.activeItem = activeItem;
		this.activeItemSet = true;
	}
	
	protected Object createContainer(ArrayList data, Class objectClass) {
		if (objectClass.isArray()) {
			return data.toArray((Object[]) Array.newInstance(objectClass.getComponentType(), data.size()));
		} else {
			data.trimToSize();
			return data;
		}
	}

	public abstract ItemState getItemState();
	
	public interface ItemState {
		public boolean isSelected();
		public boolean isActive();
	}

//	protected final class SubmittedItemState implements ItemState {
//
//		private Object activeItem;
//		private Set selectionKeys;
//		
//		public boolean isActive() {
//			return activeItemKeys != null && activeItemKeys.contains(getRowKey());
//		}
//
//		public boolean isSelected() {
//			return selectionKeys != null && selectionKeys.contains(getRowKey());
//		}
//
//		public SubmittedItemState(Set selectionKeys, Set activeItemKeys) {
//			super();
//			this.selectionKeys = selectionKeys;
//			this.activeItemKeys = activeItemKeys;
//		}
//	}
	
	protected Object getAsObject(String string) {
		return string;
	}

	protected String getAsString(Object object) {
		return object.toString();
	}
}
