/**
 * 
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.richfaces.component.UIListShuttle;
import org.richfaces.component.UIOrderingBaseComponent;
import org.richfaces.component.UIOrderingBaseComponent.ItemState;
import org.richfaces.model.ListShuttleRowKey;

/**
 * @author Nick Belaevski
 *
 */
public abstract class ListShuttleRendererBase extends OrderingComponentRendererBase {
	
	protected static final String SELECTION_STATE_VAR_NAME = "selectionState";
	
	public final static String FACET_SOURCE_CAPTION = "sourceCaption";
	
	public final static String FACET_TARGET_CAPTION = "targetCaption";
	
	protected static final OrderingComponentRendererBase.ControlsHelper[] SHUTTLE_HELPERS = ListShuttleControlsHelper.HELPERS;
	
	protected static final OrderingComponentRendererBase.ControlsHelper[] TL_HELPERS = OrderingComponentControlsHelper.HELPERS;
	
	private static final String MESSAGE_BUNDLE_NAME = OrderingListRendererBase.class.getPackage().getName() + "ListShuttle";

	private static class ListShuttleRendererTableHolder extends TableHolder {

		private boolean source;
		
		public ListShuttleRendererTableHolder(UIDataAdaptor table, boolean source) {
			super(table);
		
			this.source = source;
		}
		
		public boolean isSource() {
			return source;
		}
	}
	
	public ListShuttleRendererBase() {
		super(MESSAGE_BUNDLE_NAME);
	}

	public void encodeSLCaption(FacesContext context, UIOrderingBaseComponent shuttle) throws IOException {
		encodeCaption(context, shuttle, FACET_SOURCE_CAPTION, "rich-shuttle-source-caption",
				ListShuttleControlsHelper.ATTRIBUTE_SOURCE_CAPTION_LABEL);
	}

	public void encodeTLCaption(FacesContext context, UIComponent shuttle) throws IOException {
		encodeCaption(context, shuttle, FACET_TARGET_CAPTION, "rich-shuttle-target-caption",
				ListShuttleControlsHelper.ATTRIBUTE_TARGET_CAPTION_LABEL);
	}

	public void encodeSLHeader(FacesContext context, UIOrderingBaseComponent shuttle) throws IOException {
		encodeHeader(context, shuttle, "rich-table-header", "rich-shuttle-header-tab-cell", "sourceHeaderClass");
	}
	
	public void encodeTLHeader(FacesContext context, UIOrderingBaseComponent shuttle) throws IOException {
		encodeHeader(context, shuttle, "rich-table-header", "rich-shuttle-header-tab-cell", "sourceHeaderClass");
	}

	protected String encodeRows(FacesContext context, UIOrderingBaseComponent shuttle, boolean source) throws IOException {
		ResponseWriter writer = context.getResponseWriter();
		StringWriter stringWriter = new StringWriter();
		context.setResponseWriter(writer.cloneWithWriter(stringWriter));
		encodeRows(context, shuttle, new ListShuttleRendererTableHolder(shuttle, source));
		context.getResponseWriter().flush();
		context.setResponseWriter(writer);

		return stringWriter.getBuffer().toString();
	}
	
	public void encodeOneRow(FacesContext context, TableHolder holder)
	throws IOException {
		UIListShuttle table = (UIListShuttle) holder.getTable();
		ListShuttleRendererTableHolder shuttleRendererTableHolder = (ListShuttleRendererTableHolder) holder;
		
		ListShuttleRowKey listShuttleRowKey = (ListShuttleRowKey) table.getRowKey();
		if (listShuttleRowKey != null) {
			if (shuttleRendererTableHolder.isSource() == listShuttleRowKey.isFacadeSource()) {
				
				ResponseWriter writer = context.getResponseWriter();
				String clientId = holder.getTable().getClientId(context);
				writer.startElement(HTML.TR_ELEMENT, table);
				writer.writeAttribute("id",  clientId, null);

				StringBuffer rowClassName = new StringBuffer("ol_normal rich-ordering-list-row");
				StringBuffer cellClassName = new StringBuffer("ol_cell rich-ordering-list-cell");

				ComponentVariables variables = ComponentsVariableResolver.getVariables(this, table);
				SelectionState selectionState = (SelectionState) variables.getVariable(SELECTION_STATE_VAR_NAME);
				ItemState itemState = getItemState(context, table, variables);
				
				boolean active = itemState.isActive();
				if (active) {
					rowClassName.append(" rich-ordering-list-row-active");
					cellClassName.append(" rich-ordering-list-cell-active");
				}
				
				boolean selected = itemState.isSelected();
				selectionState.addState(selected);
				if (selected) {
					rowClassName.append(" rich-ordering-list-row-selected");
					cellClassName.append(" rich-ordering-list-cell-selected");
				}
				
				writer.writeAttribute("class", rowClassName.toString(), null);

				boolean columnRendered = false;

				List children = table.getChildren();
				for (Iterator iterator = children.iterator(); iterator.hasNext();) {
					UIComponent component = (UIComponent) iterator.next();

					if (component instanceof UIColumn && component.isRendered()) {
						UIColumn column = (UIColumn) component;

						writer.startElement(HTML.td_ELEM, table);

						writer.writeAttribute("class", cellClassName.toString(), null);

						writer.startElement(HTML.IMG_ELEMENT, table);
						writer.writeAttribute(HTML.src_ATTRIBUTE, getResource("/org/richfaces/renderkit/html/images/spacer.gif").getUri(context, null), null);
						writer.writeAttribute(HTML.style_ATTRIBUTE, "width:1px;height:1px;", null);
						writer.endElement(HTML.IMG_ELEMENT);
						
						renderChildren(context, column);

						if (!columnRendered) {
							writer.startElement(HTML.INPUT_ELEM, table);
							writer.writeAttribute(HTML.TYPE_ATTR, HTML.INPUT_TYPE_HIDDEN, null);
							writer.writeAttribute(HTML.NAME_ATTRIBUTE, table.getBaseClientId(context), null);

							StringBuffer value = new StringBuffer();
							value.append(table.getRowKey());

							if (selected) {
								value.append('s');
							}
							
							if (active) {
								value.append('a');
							}

							value.append(':');
							value.append(getAsString(context, table, table.getRowData()));
							
							writer.writeAttribute(HTML.value_ATTRIBUTE, value.toString(), null);
							
							writer.writeAttribute(HTML.id_ATTRIBUTE, clientId + "StateInput", null);
							
							writer.endElement(HTML.INPUT_ELEM);
							
							columnRendered = true;
						}

						writer.endElement(HTML.td_ELEM);
					}
				}

				writer.endElement(HTML.TR_ELEMENT);
			}
		}
	}
	
	public void encodeChildren(FacesContext context, UIComponent component)
			throws IOException {
        if (component.isRendered()) {
			ResponseWriter writer = context.getResponseWriter();
			doEncodeChildren(writer, context, component);
		}
	}
	
	public void encodeShuttleControlsFacets(FacesContext context, UIOrderingBaseComponent component, 
			SelectionState sourceSelectionState, SelectionState targetSelectionState) 
		throws IOException {
		String clientId = component.getClientId(context);

		ResponseWriter writer = context.getResponseWriter();
		
		int divider = SHUTTLE_HELPERS.length / 2;
		
		for (int i = 0; i < SHUTTLE_HELPERS.length; i++) {
			SelectionState state = (i < divider ? sourceSelectionState : targetSelectionState);
			
			boolean enabled;
			if (i <= 1 || i >= SHUTTLE_HELPERS.length - 2) {
				enabled = state.isItemExist();
			} else {
				enabled = state.isSelected();
			}
			
			if (i % 2 == 1) {
				enabled = !enabled;
			}
			
			if (SHUTTLE_HELPERS[i].isRendered(context, component)) {
				//proper assumption about helpers ordering
				encodeControlFacet(context, component, SHUTTLE_HELPERS[i], clientId, writer, enabled, 
						"rich-list-shuttle-button", " rich-shuttle-control");
			}
		}
	}
	
	public void encodeTLControlsFacets(FacesContext context, UIOrderingBaseComponent component, SelectionState selectionState) 
		throws IOException {
		String clientId = component.getClientId(context);

		ResponseWriter writer = context.getResponseWriter();
		
		int divider = TL_HELPERS.length / 2;
		
		for (int i = 0; i < TL_HELPERS.length; i++) {
			boolean boundarySelection = i < divider ? selectionState.isFirstSelected() : selectionState.isLastSelected();
			boolean enabled = selectionState.isSelected() && !boundarySelection;
			if (i % 2 == 1) {
				enabled = !enabled;
			}
			
			if (TL_HELPERS[i].isRendered(context, component)) {
				//proper assumption about helpers ordering
				encodeControlFacet(context, component, TL_HELPERS[i], clientId, writer, enabled, 
						"rich-list-shuttle-button", " rich-shuttle-control");
			}
		}
	}
	
	private boolean isEmpty(String s) {
		return s == null || s.length() == 0;
	}
	
	public void doDecode(FacesContext context, UIComponent component) {
		UIListShuttle listShuttle = (UIListShuttle) component;
		
		String clientId = listShuttle.getBaseClientId(context);
        ExternalContext externalContext = context.getExternalContext();
		Map requestParameterMap = externalContext
        								 .getRequestParameterMap();
        
		if (requestParameterMap.containsKey(clientId)) {
			Set sourceSelection = new HashSet();
			Set targetSelection = new HashSet();
			Object activeItem = null;
			String[] strings = (String[]) externalContext.getRequestParameterValuesMap().get(clientId);
        	Map map = new LinkedHashMap();
        	
        	boolean facadeSource = true;
        	
        	for (int i = 0; i < strings.length; i++) {
				String string = strings[i];
				
				if (":".equals(string)) {
					facadeSource = false;
					continue;
				}
				
				int idx = string.indexOf(':');
				Object value = getAsObject(context, listShuttle, string.substring(idx + 1));
				String substring = string.substring(0, idx);
				
				boolean target = false;
				if (substring.charAt(0) == 't') {
					target = true;
				}

				boolean selected = false;
				
				idx = substring.length() - 1;
				
				if (substring.charAt(idx) == 'a') {
					activeItem = value;
					idx--;
				}

				if (substring.charAt(idx) == 's') {
					(facadeSource ? sourceSelection : targetSelection).add(value);
					idx--;
				}


				substring = substring.substring(target ? 1 : 0, idx + 1);
				
				Object key = new ListShuttleRowKey(new Integer(substring), target, facadeSource);
				map.put(key, value);
        	}
        	listShuttle.setSubmittedStrings(map, sourceSelection, targetSelection, activeItem);
        } else {
        	listShuttle.setSubmittedStrings(new HashMap(0), null, null, null);
        }
	}
	
	public String getCaptionDisplay(FacesContext context, UIComponent component) {
		UIListShuttle shuttle = (UIListShuttle)component;
		if ((shuttle.getSourceCaptionLabel() != null && !"".equals(shuttle.getSourceCaptionLabel())) ||
				(shuttle.getTargetCaptionLabel() != null && !"".equals(shuttle.getTargetCaptionLabel())) ||
				(shuttle.getFacet("sourceCaption") != null && shuttle.getFacet("sourceCaption").isRendered()) ||
				(shuttle.getFacet("targetCaption") != null && shuttle.getFacet("targetCaption").isRendered())) {
			
			return "";
		}
		
		return "display: none;";
	}
	
}
