/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.richfaces.renderkit.OrderingComponentRendererBase;
import org.richfaces.component.util.HtmlUtil;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.ListShuttleRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.ListShuttleRenderer
 */
public class ListShuttleRenderer extends ListShuttleRendererBase {

	public ListShuttleRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/listShuttle.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("scripts/extend.js")
						,
				getResource("scripts/ShuttleUtils.js")
						,
				getResource("scripts/SelectItem.js")
						,
				getResource("scripts/LayoutManager.js")
						,
				getResource("scripts/Control.js")
						,
				getResource("scripts/ListBase.js")
						,
				getResource("scripts/OrderingList.js")
						,
				getResource("scripts/ListShuttle.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIListShuttle.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIListShuttle)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIListShuttle component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIListShuttle)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIListShuttle component, ComponentVariables variables) throws IOException {
	    
java.lang.String clientId = component.getClientId(context);

			
				SelectionState sourceSelectionState = new SelectionState();     
			    variables.setVariable(SELECTION_STATE_VAR_NAME, sourceSelectionState);
			    String encodedSourceRows = encodeRows(context, component, true);

			    SelectionState targetSelectionState = new SelectionState();     
			    variables.setVariable(SELECTION_STATE_VAR_NAME, targetSelectionState);
				String encodedTargetRows = encodeRows(context, component, false);
				
				Boolean switchByClick = (Boolean) component.getAttributes().get("switchByClick");
				variables.setVariable("switchByClick", switchByClick);
			
		
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "class", "rich-list-shuttle" );
						getUtils().writeAttribute(writer, "id", clientId );
			
writer.startElement("tr", component);
			getUtils().writeAttribute(writer, "style", getCaptionDisplay(context,component) );
			
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-list-shuttle-caption" );
						getUtils().writeAttribute(writer, "colspan", "2" );
			
encodeSLCaption(context, component);

writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "rich-list-shuttle-caption" );
						getUtils().writeAttribute(writer, "colspan", "2" );
			
encodeTLCaption(context, component);

writer.endElement("td");
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-shuttle-source-items" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "focusKeeper" );
						getUtils().writeAttribute(writer, "name", "focusKeeper" );
						getUtils().writeAttribute(writer, "style", "width: 1px; position: absolute; left: -32767px;" );
						getUtils().writeAttribute(writer, "type", "button" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-shuttle-body" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "table" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-shuttle-list" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "headerBox" );
			

												
								                	String contentContainerStyle = "";
								                	String sourceListWidthValue = (String) component.getAttributes().get("sourceListWidth");
								                	if (sourceListWidthValue != null) {
								                		contentContainerStyle = contentContainerStyle.concat("width:").concat(HtmlUtil.qualifySize(sourceListWidthValue)).concat(";");
								                		variables.setVariable("contentContainerStyle", contentContainerStyle);
							                		}
	                							
	                						
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-shuttle-list-header" );
						getUtils().writeAttribute(writer, "style", variables.getVariable("contentContainerStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-shuttle-internal-header-tab" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "internal_header_tab" );
			
encodeSLHeader(context, component);

writer.endElement("table");
writer.endElement("div");

												
													String listHeightValue = (String) component.getAttributes().get("listsHeight");
								                	if (listHeightValue != null) {
								                		contentContainerStyle = contentContainerStyle.concat("height:").concat(HtmlUtil.qualifySize(listHeightValue)).concat(";");
								                		variables.setVariable("contentContainerStyle", contentContainerStyle);
								                	}
                								
                							
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "ol_list_content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "contentBox" );
						getUtils().writeAttribute(writer, "style", variables.getVariable("contentContainerStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "ol_internal_tab" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "internal_tab" );
			
writer.startElement("tbody", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tbody" );
			

															writer.write(encodedSourceRows);
															encodedSourceRows = null;															
														
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("td");
writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "shuttle_button_layout" );
			

							encodeShuttleControlsFacets(context, component, sourceSelectionState, targetSelectionState);
						
writer.endElement("div");
writer.endElement("td");
writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-shuttle-target-items" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "style", "display: none;" );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", ":" );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlFocusKeeper" );
						getUtils().writeAttribute(writer, "name", "focusKeeper" );
						getUtils().writeAttribute(writer, "style", "width: 1px; position: absolute; left: -32767px;" );
						getUtils().writeAttribute(writer, "type", "button" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-shuttle-body" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlTable" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-shuttle-list" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlHeaderBox" );
			

												
								                	String trContentContainerStyle = "";
								                	String targetListWidthValue = (String) component.getAttributes().get("targetListWidth");
								                	if (targetListWidthValue != null) {
								                		trContentContainerStyle = trContentContainerStyle.concat("width:").concat(HtmlUtil.qualifySize(targetListWidthValue)).concat(";");
								                		variables.setVariable("trContentContainerStyle", trContentContainerStyle);
							                		}
	                							
	                						
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-shuttle-list-header" );
						getUtils().writeAttribute(writer, "style", variables.getVariable("trContentContainerStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "rich-shuttle-internal-header-tab" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlInternal_header_tab" );
			
encodeTLHeader(context, component);

writer.endElement("table");
writer.endElement("div");

												
								                	if (listHeightValue != null) {
								                		trContentContainerStyle = trContentContainerStyle.concat("height:").concat(HtmlUtil.qualifySize(listHeightValue)).concat(";");
								                		variables.setVariable("trContentContainerStyle", trContentContainerStyle);
								                	}
	                							
	                						
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "ol_list_content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlContentBox" );
						getUtils().writeAttribute(writer, "style", variables.getVariable("trContentContainerStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "ol_internal_tab" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlInternal_tab" );
			
writer.startElement("tbody", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "tlTbody" );
			

															writer.write(encodedTargetRows);
															encodedTargetRows = null;															
														
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "ol_center_button_col_valign" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "shuttle_button_layout rich-ordering­controls" );
			

							encodeTLControlsFacets(context, component, targetSelectionState);
						
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");

	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIListShuttle component, ComponentVariables variables) throws IOException {
	  
java.lang.String cId = component.getClientId(context);
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("var clientId = '" + convertToString(cId) + "';\n		Event.onReady(function() {\n			var cotrolsIdPrefix = [['up', 'disup'], ['down', 'disdown'], ['last', 'dislast'], ['first','disfirst']];\n			var listShuttleCotrolsIdPrefix = [['copy', 'discopy'], ['copyAll', 'discopyAll'], ['remove', 'disremove'], ['removeAll','disremoveAll']];\n			var listShuttle = new Richfaces.ListShuttle(new Richfaces.OrderingList('" + convertToString(cId) + "', '" + convertToString(cId) + "tlInternal_tab', '" + convertToString(cId) + "tlInternal_header_tab', '" + convertToString(cId) + "tlFocusKeeper', cotrolsIdPrefix, '" + convertToString(cId) + "sortLabel', function() {" + convertToString(component.getAttributes().get("onorderchanged")) + "}), \n											  			new Richfaces.ListBase('" + convertToString(cId) + "', '" + convertToString(cId) + "internal_tab', '" + convertToString(cId) + "internal_header_tab', '" + convertToString(cId) + "focusKeeper'), \n											  			\"" + convertToString(cId) + "\", listShuttleCotrolsIdPrefix, \"" + convertToString(variables.getVariable("switchByClick")) + "\");\n			var sourceLayoutManager = new LayoutManager('" + convertToString(cId) + "internal_header_tab', '" + convertToString(cId) + "internal_tab');\n			var targetLayoutManager = new LayoutManager('" + convertToString(cId) + "tlInternal_header_tab', '" + convertToString(cId) + "tlInternal_tab');\n			sourceLayoutManager.widthSynchronization();\n			targetLayoutManager.widthSynchronization();\n		});\n		//setTimeout(init, 0);"),null);

writer.endElement("script");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIListShuttle)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
