if(!window.LOG){
	window.LOG = {warn:function(){}};
}

if(typeof Effect == 'undefined')
  throw("calendar.js requires including script.aculo.us' effects.js library");

if (!window.Richfaces) window.Richfaces={};

Richfaces.Calendar={};
Richfaces.Calendar.setElementPosition = function(element, baseElement, jointPoint, direction, offset)
{
	// parameters:
	// baseElement: Dom element or {left:, top:, width:, height:};
	// jointPoint: {x:,y:} or ('top-left','top-right','bottom'-left,'bottom-right')
	// direction:  ('top-left','top-right','bottom'-left,'bottom-right', 'auto')
	// offset: {dx:,dy:}
	
	if (!offset) offset = {dx:0,dy:0};
	
	var elementDim = Richfaces.Calendar.getOffsetDimensions(element);
	var baseElementDim;
	var baseOffset;
	
	if (baseElement.left!=undefined)
	{
		baseElementDim = {width: baseElement.width, height: baseElement.height};
		baseOffset = [baseElement.left, baseElement.top];
		
	} else
	{
		baseElementDim = Richfaces.Calendar.getOffsetDimensions(baseElement);
		baseOffset = Position.cumulativeOffset(baseElement);
	}
	
	var windowRect = Richfaces.Calendar.getWindowViewport();
	
	
	// jointPoint
	var ox=baseOffset[0];
	var oy=baseOffset[1];
	var re = /^(top|bottom)-(left|right)$/;
	var match;
	
	if (typeof jointPoint=='object') {ox = jointPoint.x; oy = jointPoint.y}
	else if ( jointPoint && (match=jointPoint.toLowerCase().match(re))!=null )
	{
		if (match[2]=='right') ox+=baseElementDim.width;
		if (match[1]=='bottom') oy+=baseElementDim.height;
	} else
	{
		// ??? auto 
	}
	
	// direction
	if (direction && (match=direction.toLowerCase().match(re))!=null )
	{
		var d = direction.toLowerCase().split('-');
		if (match[2]=='left') ox-=elementDim.width+offset.dx; else if (match[2]=='right') ox+=offset.dx;
		if (match[1]=='top') oy-=elementDim.height+offset.dy; else if (match[1]=='bottom') oy+=offset.dy; 
	} else
	{
		// auto
		var theBest = {square:0};
		// jointPoint: bottom-right, direction: bottom-left
		var basex = baseOffset[0]-offset.dx;
		var basey = baseOffset[1]+offset.dy;
		var rect = {right: basex + baseElementDim.width, top: basey + baseElementDim.height};
		rect.left = rect.right - elementDim.width;
		rect.bottom = rect.top + elementDim.height;
		ox = rect.left; oy = rect.top;
		var s = Richfaces.Calendar.checkCollision(rect, windowRect);
		if (s!=0)
		{
			if (ox>=0 && oy>=0 && theBest.square<s) theBest = {x:ox, y:oy, square:s};
			// jointPoint: top-right, direction: top-left
			basex = baseOffset[0]-offset.dx;
			basey = baseOffset[1]-offset.dy;
			rect = {right: basex + baseElementDim.width, bottom: basey};
			rect.left = rect.right - elementDim.width;
			rect.top = rect.bottom - elementDim.height;
			ox = rect.left; oy = rect.top;
			s = Richfaces.Calendar.checkCollision(rect, windowRect);
			if (s!=0)
			{
				if (ox>=0 && oy>=0 && theBest.square<s) theBest = {x:ox, y:oy, square:s};
				// jointPoint: bottom-left, direction: bottom-right
				basex = baseOffset[0]+offset.dx;
				basey = baseOffset[1]+offset.dy;
				rect = {left: basex, top: basey + baseElementDim.height};
				rect.right = rect.left + elementDim.width;
				rect.bottom = rect.top + elementDim.height;
				ox = rect.left; oy = rect.top;
				s = Richfaces.Calendar.checkCollision(rect, windowRect);
				if (s!=0)
				{
					if (ox>=0 && oy>=0 && theBest.square<s) theBest = {x:ox, y:oy, square:s};
					// jointPoint: top-left, direction: top-right
					basex = baseOffset[0]+offset.dx;
					basey = baseOffset[1]-offset.dy;
					rect = {left: basex, bottom: basey};
					rect.right = rect.left + elementDim.width;
					rect.top = rect.bottom - elementDim.height;
					ox = rect.left; oy = rect.top;
					s = Richfaces.Calendar.checkCollision(rect, windowRect);
					if (s!=0)
					{
						// the best way selection
						if (ox<0 || oy<0 || theBest.square>s) {ox=theBest.x; oy=theBest.y}
					}
				}
			}
			
		}
	}
	
	var els = element.style;
	var originalVisibility = els.visibility;
	var originalPosition = els.position;
	var originalDisplay = els.display;
	els.visibility = 'hidden';
	els.position = 'absolute';
	els.display = '';
	
	if (element.offsetParent && element.offsetParent!=document.body)
	{
		var parentOffset=Position.cumulativeOffset(element.offsetParent);
		ox -= parentOffset[0];
		oy -= parentOffset[1];
	}

	els.display = originalDisplay;
	els.position = originalPosition;
	els.visibility = originalVisibility;
	
	element.style.left = (ox + windowRect.left) + 'px';
	element.style.top = (oy + windowRect.top) + 'px';
};

Richfaces.Calendar.getOffsetDimensions = function(element) {
	// from prototype 1.5.0 // Pavel Yascenko
    element = $(element);
    var display = $(element).getStyle('display');
    if (display != 'none' && display != null) // Safari bug
      return {width: element.offsetWidth, height: element.offsetHeight};

    // All *Width and *Height properties give 0 on elements with display none,
    // so enable the element temporarily
    var els = element.style;
    var originalVisibility = els.visibility;
    var originalPosition = els.position;
    var originalDisplay = els.display;
    els.visibility = 'hidden';
    els.position = 'absolute';
    els.display = 'block';
    var originalWidth = element.offsetWidth; // was element.clientWidth // Pavel Yascenko
    var originalHeight = element.offsetHeight; // was element.clientHeight // Pavel Yascenko
    els.display = originalDisplay;
    els.position = originalPosition;
    els.visibility = originalVisibility;
    return {width: originalWidth, height: originalHeight};
};
 
Richfaces.Calendar.checkCollision = function(elementRect, windowRect, windowOffset)
{
	if (elementRect.left >= windowRect.left &&
		elementRect.top >= windowRect.top &&
		elementRect.right <= windowRect.right &&  
		elementRect.bottom <= windowRect.bottom)
		return 0;
	
	var rect = {left:   (elementRect.left>windowRect.left ? elementRect.left : windowRect.left),
				top:    (elementRect.top>windowRect.top ? elementRect.top : windowRect.top),
				right:  (elementRect.right<windowRect.right ? elementRect.right : windowRect.right),
				bottom: (elementRect.bottom<windowRect.bottom ? elementRect.bottom : windowRect.bottom)};
	return (rect.right-rect.left)* (rect.bottom-rect.top);
};


Richfaces.Calendar.getWindowDimensions = function() {
    var w =  self.innerWidth
                || document.documentElement.clientWidth
                || document.body.clientWidth
                || 0;
    var h =  self.innerHeight
                || document.documentElement.clientHeight
                || document.body.clientHeight
                || 0;
	return {width:w, height: h};
};

Richfaces.Calendar.getWindowScrollOffset = function() {
    var dx =  window.pageXOffset
                || document.documentElement.scrollLeft
                || document.body.scrollLeft
                || 0;
    var dy =  window.pageYOffset
                || document.documentElement.scrollTop
                || document.body.scrollTop
                || 0;
	return {left:dx, top: dy};
};

Richfaces.Calendar.getWindowViewport = function() {
	var windowDim = Richfaces.Calendar.getWindowDimensions();
	var windowOffset = Richfaces.Calendar.getWindowScrollOffset();
	return {left:windowOffset.left, top:windowOffset.top, right: windowDim.width+windowOffset.left, bottom: windowDim.height+windowOffset.top};
};

Richfaces.Calendar.joinArray = function(array, begin, end, separator)
{
	var value = '';
	if (array.length!=0) value = begin+array.pop()+end;
	while (array.length)
		value = begin+array.pop()+end+separator+value;
	return value;
};

Richfaces.Calendar.getMonthByLabel = function (monthLabel, monthNames)
{
	var i=0;
	while (i<monthNames.length) if (monthNames[i]==monthLabel) return i; else i++;
};

Object.extend(Event, {
	findElementByAttr : function(event, tagName, attribute, value, flag) {
    	var element = Event.findElement(event, tagName);
    	while (!element[attribute] || (flag ? element[attribute].indexOf(value)!=0 : element[attribute]!=value) )
    	{
	      	element = element.parentNode;
	    }
    	return element;
	}
});

Object.extend(Element, {
	replaceClassName : function (element, whichClassName, toClassName) {
		if (!(element = $(element))) return;
	    var e = Element.classNames(element);
	    e.remove(whichClassName);
	    e.add(toClassName);
	    return element;
	}
});

/* Year:
 *	y,yy - 00-99
 *	yyy+ - 1999
 * Month:
 *	M - 1-12
 *	MM - 01-12
 *	MMM - short (Jul)
 *	MMMM+ - long (July)
 * Date:
 *	d - 1-31
 *	dd+ - 01-31 */
Richfaces.Calendar.getDefaultMonthNames = function(shortNames)
{
	return (shortNames
			? ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']
			: ['January','February','March','April','May','June','July','August','September','October','November','December']);
};

Richfaces.Calendar.parseDate = function(dateString, pattern, monthNames, monthNamesShort)
{
	if (!monthNames) monthNames = Richfaces.Calendar.getDefaultMonthNames();
	if (!monthNamesShort) monthNamesShort = Richfaces.Calendar.getDefaultMonthNames(true);
	
	var counter=1;
	var y,m,d;
	var a,h,min;
	var shortLabel=false;
	
	pattern = pattern.replace(/([.*+?^<>=!:${}()|[\]\/\\])/g, '\\$1');
	pattern = pattern.replace(/(y+|M+|d+|a|H{1,2}|h{1,2}|m{2})/g,
		function($1) {
			switch ($1) {
	            case 'y'  :
	            case 'yy' : y=counter; counter++; return '(\\d{2})';
	            case 'MM' : m=counter; counter++; return '(\\d{2})';
	            case 'M'  : m=counter; counter++; return '(\\d{1,2})';
	            case 'd'  : d=counter; counter++; return '(\\d{1,2})';
	            case 'MMM': m=counter; counter++; shortLabel=true; return '('+monthNamesShort.join('|')+')';
	            case 'a'  : a=counter; counter++; return '(AM|am|PM|pm)?';
	            case 'HH' :
	            case 'hh' : h=counter; counter++; return '(\\d{2})?';
	            case 'H'  :
	            case 'h'  : h=counter; counter++; return '(\\d{1,2})?';
	            case 'mm' : min=counter; counter++; return '(\\d{2})?';
			}
	        // y+,M+,d+
			var ch = $1.charAt(0);
			if (ch=='y') {y=counter; counter++; return '(\\d{4})'};
			if (ch=='M') {m=counter; counter++; return '('+monthNames.join('|')+')'};
			if (ch=='d') {d=counter; counter++; return '(\\d{2})'};
		}
	);
		
	var re = new RegExp(pattern,'i');
	var match = dateString.match(re);
	if (match!=null)
	{
		var yy = parseInt(match[y],10); if (isNaN(yy)) return null; else if (yy<70) yy+=2000; else if (yy<100) yy+=1900;
		var mm = parseInt(match[m],10); if (isNaN(mm)) mm = Richfaces.Calendar.getMonthByLabel(match[m], shortLabel ? monthNamesShort : monthNames); else if (--mm<0 || mm>11) return null;
		var dd = parseInt(match[d],10); if (isNaN(dd) || dd<1 || dd>daysInMonth(yy, mm)) return null;

		// time parsing
		if (min!=undefined && h!=undefined)
		{			
			var hh,mmin,aa;
			mmin = parseInt(match[min],10); if (isNaN(mmin) || mmin<0 || mmin>59) return null;
			hh = parseInt(match[h],10); if (isNaN(hh)) return null;
			if (a!=undefined)
			{
				aa = match[a].toLowerCase();
				if ((aa!='am' && aa!='pm') || hh<1 || hh>12) return null;
				if (aa=='pm')
				{
					if (hh!=12) hh+=12;
				} else if (hh==12) hh = 0;
			}
			else if (hh<0 || hh>23) return null;

			return new Date(yy, mm, dd, hh, mmin, 0);
		}
		
		return new Date(yy, mm, dd);
	}
	return null;
};

Richfaces.Calendar.formatDate = function(date, pattern, monthNames, monthNamesShort) {
	if (!monthNames) monthNames = Richfaces.Calendar.getDefaultMonthNames();
	if (!monthNamesShort) monthNamesShort = Richfaces.Calendar.getDefaultMonthNames(true);
	var mm; var dd; var hh;
    var result = pattern.replace(/(^|[^\\yMdHhm])(y+|M+|d+|a|H{1,2}|h{1,2}|m{2})/g,
        function($1,$2,$3) {
			switch ($3) {
	            case 'y':
	            case 'yy':  return $2+date.getYear().toString().slice(-2);
	            case 'M':   return $2+(date.getMonth()+1);
	            case 'MM':  return $2+((mm = date.getMonth()+1)<10 ? '0'+mm : mm);
	            case 'MMM': return $2+monthNamesShort[date.getMonth()];
		        case 'd':   return $2+date.getDate();
	            case 'a'  : return $2+(date.getHours()<12 ? 'AM' : 'PM');
	            case 'HH' : return $2+((hh = date.getHours())<10 ? '0'+hh : hh);
	            case 'H'  : return $2+date.getHours();
	            case 'hh' : return $2+((hh = date.getHours())==0 ? '12' : (hh<10 ? '0'+hh : (hh>12 ? hh-12 : hh)));
	            case 'h'  : return $2+((hh = date.getHours())==0 ? '12' : (hh>12 ? hh-12 : hh));
	            case 'mm' : return $2+((min = date.getMinutes())<10 ? '0'+min : min);
			}
	        // y+,M+,d+
			var ch = $3.charAt(0);
			if (ch=='y') return $2+date.getFullYear();
			if (ch=='M') return $2+monthNames[date.getMonth()];
			if (ch=='d') return $2+((dd = date.getDate())<10 ? '0'+dd : dd);
		}
	);
	return Richfaces.Calendar.unescape(result);
};

Richfaces.Calendar.escape = function (str)
{
	return str.replace(/([yMdaHhm])/g,"\\$1");
};
	
Richfaces.Calendar.unescape = function (str)
{
	return str.replace(/\\([yMdaHhm])/g,"$1");
};	



function isLeapYear(year) {
	return new Date(year, 1, 29).getDate()==29;
}

function daysInMonth(year,month) {
	return 32 - new Date(year, month, 32).getDate();
}

function daysInMonthByDate(date) {
	return 32 - new Date(date.getFullYear(), date.getMonth(), 32).getDate();
}

function getDay(date, firstWeekDay ) {
	var value = date.getDay() - firstWeekDay;
	if (value < 0) value = 7 + value;
	return value;
}

function getFirstWeek(year, mdifw, fdow) {
	var date = new Date(year,0,1);
	var firstday = getDay(date, fdow);
	
	var weeknumber = (7-firstday<mdifw) ? 0 : 1;
	
	return {date:date, firstDay:firstday, weekNumber:weeknumber, mdifw:mdifw, fdow:fdow};
}

function getLastWeekOfPrevYear(o) {
	var year = o.date.getFullYear()-1;
	var days = (isLeapYear(year) ? 366 : 365);
	var obj = getFirstWeek(year, o.mdifw, o.fdow);
	days = (days - 7 + o.firstDay);
	var weeks = Math.floor(days/7)+1;
	  
	return  weeks+obj.weekNumber;
}

function weekNumber(year, month, mdifw, fdow) {
	
	var o = getFirstWeek(year, mdifw, fdow);
	
	if (month==0) 
	{
		if (o.weekNumber==1) return 1;
		return getLastWeekOfPrevYear(o);
	}
	var	oneweek =  604800000;
	var d = new Date(year, month,1);
		d.setDate( 1+o.firstDay + (getDay(d,fdow)==0?1:0));
		
	weeknumber = o.weekNumber + Math.floor((d.getTime() - o.date.getTime()) / oneweek);
	
	return weeknumber;
}

Calendar = Class.create();
Object.extend(Calendar.prototype, {
    initialize: function(id,parameters) {

		// dayListTableId, weekNumberBarId, weekDayBarId - 3 tables ids',

		// dayListMarkup - day cell markup
		//		context: {day, date, weekNumber, weekDayNumber, isWeekend, isCurrentMonth,  elementId, component}
		// weekNumberMarkup - week number cell markup
		//		context: {weekNumber, elementId, component}
		// weekDayMarkup - week day cell markup
		//		context: {weekDayLabel, weekDayLabelShort, weekDayNumber, isWeekend, elementId, component}

		// headerMarkup
		// footerMarkup
		// optionalHeaderMarkup - user defined header (optional)
		// optionalFooterMarkup - user defined footer (optional)
		
		// currentDate - date to show month (day not used) (mm/yyyy) 
		// selectedDate - selected date (mm/dd/yyyy)
		// weekDayLabels - collection of week day labels keyed by week day numbers
		// weekDayLabelsShort - collection of week day short labels keyed by week day numbers
		// minDaysInFirstWeek - locale-specific constant defining number of days in the first week
		// firstWeekDay - (0..6) locale-specific constant defining number of the first week day
		// showWeekDaysBar - show WeekDays Bar [default value is true]
		// showWeeksBar - show Weeks numbers bar [default value is true]
		// showApplyButton
		
		// POPUP description
		// direction - [top-left, top-right, bottom-left, bottom-right, auto]
		// jointPoint - [top-left, top-right, bottom-left, bottom-right]
		// popup - true
		// id+PopupButton, id+InputDate,  
				
		// boundaryDatesMode - boundary dates onclick action:
		// 						"inactive" or undefined - no action (default)
		//						"scroll" - change current month
		//						"select" - change current month and select date
		//
		// todayControlMode - today control onclick action:
		//						"scroll"
		//						"select"
		//						"hidden"
		
		// isDayEnabled - end-developer JS function
		// dayStyleClass - end-developer JS function that provide style class for day's cells.
		
		// dayCellClass - add div to day cell with class 'rich-calendar-cell-div' and add this class to TD if defined  
		// style - table style
		// className - table class
		
		
		this.id = id;
		this.params = parameters;

		this.showApplyButton = (!this.params.popup) ? false : this.params.showApplyButton;

		if (this.params.showWeekDaysBar==undefined) this.params.showWeekDaysBar = true;
		if (this.params.showWeeksBar==undefined) this.params.showWeeksBar = true;

		if (!this.params.datePattern) this.params.datePattern = "MMM d, y";
		
		// time
		this.setTimeProperties();
		
		// markups initialization
		if (!this.params.dayListMarkup)
		{
			this.params.dayListMarkup = CalendarView.dayList;
			this.customDayListMarkup = false;
		}
		else
		{
			this.customDayListMarkup = true;
		}
		if (!this.params.weekNumberMarkup) this.params.weekNumberMarkup = CalendarView.weekNumber;
		if (!this.params.weekDayMarkup) this.params.weekDayMarkup = CalendarView.weekDay;
		if (!this.params.headerMarkup) this.params.headerMarkup = CalendarView.header;
		if (!this.params.footerMarkup) this.params.footerMarkup = CalendarView.footer;
		
		// popup offset
		this.popupOffset = {dx: (isNaN(this.params.horizontalOffset) ? 0 : parseInt(this.params.horizontalOffset,10)), dy: (isNaN(this.params.verticalOffset) ? 0 : parseInt(this.params.verticalOffset,10))};
		
		this.currentDate = this.params.currentDate ? this.params.currentDate : (this.params.selectedDate ? this.params.selectedDate : new Date());
		this.currentDate.setDate(1);
		this.selectedDate = this.params.selectedDate;
		
		if (typeof this.params.boundaryDatesMode=="string") this.params.boundaryDatesMode = this.params.boundaryDatesMode.toLowerCase();
		if (typeof this.params.todayControlMode=="string") this.todayControlMode = this.params.todayControlMode.toLowerCase();
		
		//
		if (typeof this.params.isDayEnabled != "function") this.params.isDayEnabled = function (context) {return true;};
		if (typeof this.params.dayStyleClass != "function") this.params.dayStyleClass = function (context) {return "";};
				
		this.todayDate = new Date();
		
		this.firstWeekendDayNumber = 6-this.params.firstWeekDay;
		this.secondWeekendDayNumber = (this.params.firstWeekDay>0 ? 7-this.params.firstWeekDay : 0);
		
		this.calendarContext = new CalendarContext(this);
		
		this.DATE_ELEMENT_ID = this.params.dayListTableId+'Cell';
		this.WEEKNUMBER_ELEMENT_ID = this.params.weekNumberBarId+'Cell';
		this.WEEKDAY_ELEMENT_ID = this.params.weekDayBarId+'Cell';
		this.POPUP_ID = this.id+'Popup';
		this.POPUP_BUTTON_ID = this.id+'PopupButton';
		this.INPUT_DATE_ID = this.id+'InputDate';
		this.IFRAME_ID = this.id+'IFrame';
		this.TIME_EDITOR_ID = this.id+'TimeEditor';
		this.TIME_EDITOR_SHADOW_ID = this.id+'TimeEditorShadow';

		this.TIME_EDITOR_LAYOUT_ID = this.id+'TimeEditorLayout';
		this.TIME_EDITOR_LAYOUT_SHADOW_ID = this.id+'TimeEditorLayoutShadow';
		
		//this.popupIntervalId=null;
		
		this.firstDateIndex = 0;
		
		this.daysData = {startDate:null, days:[]};
		this.days = [];
		this.todayCellId = null;
		this.todayCellColor = "";

		this.selectedDateCellId = null;
		this.selectedDateCellColor = "";
		
		var popupStyles = "";
		this.isVisible = true;
		if (this.params.popup==true)
		{
			// popup mode initialisation
			popupStyles = "display:none; position:absolute;"
			this.isVisible = false;
		}

		var htmlTextHeader = (!this.params.popup ? '<input id="'+this.INPUT_DATE_ID+'" name="'+this.INPUT_DATE_ID+'" type="hidden" style="display:none" value="'+this.getSelectedDateString(this.params.datePattern)+'"/>\n' : '') +
							 '<input id="'+this.id+'InputCurrentDate" name="'+this.id+'InputCurrentDate" type="hidden" style="display:none" value="'+Richfaces.Calendar.formatDate(this.getCurrentDate(),"MM/yyyy")+'"/>\n' +
							 (this.params.popup && Richfaces.browser.isIE6 ? '<iframe src="javascript:\'\'" frameborder="0" scrolling="no" id="' + this.IFRAME_ID + '" style="display:none; position: absolute; width: 1px; height: 1px; background-color:white;">'+'</iframe>\n' : '' )+
							 '<table id="'+this.id+'" border="0" cellpadding="0" cellspacing="0" class="rich-calendar-exterior rich-calendar-popup'+(this.params.className ? ' '+this.params.className : '')+'" style="'+popupStyles+this.params.style+'"><tbody>\n';
		var colspan = (this.params.showWeeksBar ? "8" : "7");
		var htmlHeaderOptional = (this.params.optionalHeaderMarkup) ? '<tr><td class="rich-calendar-header-optional" colspan="'+colspan+'" id="'+this.id+'HeaderOptional"></td></tr>' : '';
		var htmlFooterOptional = (this.params.optionalFooterMarkup) ? '<tr><td class="rich-calendar-footer-optional" colspan="'+colspan+'" id="'+this.id+'FooterOptional"></td></tr>' : '';
		var htmlControlsHeader = '<tr><td class="rich-calendar-header" colspan="'+colspan+'" id="'+this.id+'Header"></td></tr>';
		var htmlControlsFooter = '<tr><td class="rich-calendar-footer" colspan="'+colspan+'" id="'+this.id+'Footer"></td></tr>';
		var htmlTextFooter = '</tbody></table>\n'
		var htmlTextIFrame = '';

		// days bar creation
		var styleClass;
		var bottomStyleClass;
		var htmlTextWeekDayBar='';
		var context;
		if (this.params.showWeekDaysBar)
		{ 
			var htmlTextWeekDayBar = '<tr id="'+this.params.weekDayBarId+'">';
			if (this.params.showWeeksBar) htmlTextWeekDayBar+='<td class="rich-calendar-days"><br/></td>';
			var weekDayCounter = this.params.firstWeekDay;
			for (var i=0;i<7;i++)
			{
				context = {weekDayLabel: this.params.weekDayLabels[weekDayCounter], weekDayLabelShort: this.params.weekDayLabelsShort[weekDayCounter], weekDayNumber:weekDayCounter, isWeekend:this.isWeekend(i), elementId:this.WEEKDAY_ELEMENT_ID+i, component:this}; 
				var weekDayHtml = this.evaluateMarkup(this.params.weekDayMarkup, context );
				if (weekDayCounter==6) weekDayCounter=0; else weekDayCounter++;

				styleClass = "rich-calendar-days";
				if (context.isWeekend)
				{
					styleClass += " rich-calendar-weekends";
				}
				if (i==6) styleClass += " rich-right-cell";
				htmlTextWeekDayBar+='<td class="'+styleClass+'" id="'+context.elementId+'">'+weekDayHtml+'</td>';
			}
			htmlTextWeekDayBar+='</tr>\n';
		}

		// week & weekNumber creation
		var htmlTextWeek='';
		var p=0;

		for (k=1;k<7;k++)
		{
			bottomStyleClass = (k==6 ? "rich-bottom-cell " : "");			
			htmlTextWeek+='<tr id="'+this.params.weekNumberBarId+k+'">';
			if (this.params.showWeeksBar)
			{
				context = {weekNumber: k, elementId:this.WEEKNUMBER_ELEMENT_ID+k, component:this}; 
				var weekNumberHtml = this.evaluateMarkup(this.params.weekNumberMarkup, context );
				htmlTextWeek+='<td class="rich-calendar-week '+bottomStyleClass+'" id="'+context.elementId+'">'+weekNumberHtml+'</td>';
			}
			
			// day cells creation 
			for (var i=0;i<7;i++)
			{
				styleClass = bottomStyleClass+(!this.params.dayCellClass ? "rich-calendar-cell-size" : (!this.customDayListMarkup ? this.params.dayCellClass : ""))+" rich-calendar-cell";
				if (i==this.firstWeekendDayNumber || i==this.secondWeekendDayNumber) styleClass+=" rich-calendar-holly";
				if (i==6) styleClass+=" rich-right-cell";
				
				htmlTextWeek+='<td class="'+styleClass+'" id="'+this.DATE_ELEMENT_ID+p+'">'+(this.customDayListMarkup ? '<div class="rich-calendar-cell-div'+(this.params.dayCellClass ? ' '+this.params.dayCellClass : '')+'"></div>' : '')+'</td>';
				p++;
			}
			htmlTextWeek+='</tr>';
		}
		
		//obj.innerHTML = htmlTextIFrame+htmlTextHeader+htmlHeaderOptional+htmlControlsHeader+htmlTextWeekDayBar+htmlTextWeek+htmlControlsFooter+htmlFooterOptional+htmlTextFooter;
		var span=$(this.POPUP_ID);
		new Insertion.After(span,htmlTextIFrame+htmlTextHeader+htmlHeaderOptional+htmlControlsHeader+htmlTextWeekDayBar+htmlTextWeek+htmlControlsFooter+htmlFooterOptional+htmlTextFooter);
		// set content
		var obj=$(id);
		obj.component = this;
		obj.richfacesComponent="richfaces:calendar";
		
		if(this.params.submitFunction)	this.submitFunction = this.params.submitFunction.bind(this);
		this.prepareEvents();
		
		// add onclick event handlers to input field and popup button
		if (this.params.popup && !this.params.disabled)
		{
			var handler = new Function ('event', "$('"+this.id+"').component.doSwitch();").bindAsEventListener(); 
			Event.observe(this.POPUP_BUTTON_ID, "click", handler, false);
			if (!this.params.enableManualInput) 
			{
				Event.observe(this.INPUT_DATE_ID, "click", handler, false);				
			}
		}
		
	},

	updateTimeEditor: function()
	{
		var th=$(this.id+'TimeHours');
		var ts=$(this.id+'TimeSign');
		var tm=$(this.id+'TimeMinutes');
				
		var h = this.selectedDate.getHours();
		var m = this.selectedDate.getMinutes();
		if (this.timeType==2)
		{
			var a = (h<12 ? 'AM' : 'PM');
			ts.value = a;
			h = (h==0 ? '12' : (h>12 ? h-12 : h));
		}
		th.value = (this.timeHoursDigits==2 && h<10 ? '0'+h : h);
		tm.value = (m<10 ? '0'+m : m);
	},

	createTimeEditor: function(element)
	{
		var element = $(this.id);
		var htmlBegin = '<div id="'+this.TIME_EDITOR_SHADOW_ID+'" class="rich-calendar-time-shadow" style="position:absolute; display:none;"></div><table border="0" cellpadding="0" cellspacing="0" id="'+this.TIME_EDITOR_ID+'" style="position:absolute; display:none;"><tbody><tr><td class="rich-calendar-time-layout-container" align="center"><div style="position:relative; width:100%">';
		var htmlEndn = '</div></td></tr></tbody></table>';
		new Insertion.After(element, htmlBegin+this.evaluateMarkup(CalendarView.timeEditor, this.calendarContext));
		var te_shadow = $(this.TIME_EDITOR_SHADOW_ID);
		var te = $(this.TIME_EDITOR_ID);
		te.style.zIndex = te_shadow.style.zIndex = element.getStyle('z-index');

		var th=$(this.id+'TimeHours');
		var ts;
		var tm=$(this.id+'TimeMinutes');
		if (this.timeType==1)
		{
			sbjQuery(th).SpinButton({digits:this.timeHoursDigits,min:0,max:23});
		}
		else
		{
			sbjQuery(th).SpinButton({digits:this.timeHoursDigits,min:1,max:12});
			ts=$(this.id+'TimeSign');				
			sbjQuery(ts).SpinButton({});
		}
		sbjQuery(tm).SpinButton({digits:2,min:0,max:59});
		
		this.isTimeEditorCreated = true;
	},
	
	createSpinnerTable: function(id) {
		return '<table cellspacing="0" cellpadding="0" border="0"><tbody><tr>'+
					'<td class="rich-calendar-spinner-input-container">'+
						'<input id="' + id + '" class="rich-calendar-spinner-input" type="text" />'+
					'</td>'+	
					'<td class="rich-calendar-spinner-buttons">'+
						'<table border="0" cellspacing="0" cellpadding="0"><tbody>'+
							'<tr><td>'+
								'<div id="'+id+'BtnUp" class="rich-calendar-spinner-up"'+
									'onmousedown="this.className=\'rich-calendar-spinner-up rich-calendar-spinner-pressed\'" '+
									'onmouseup="this.className=\'rich-calendar-spinner-up\'"'+ 
									'onmouseout="this.className=\'rich-calendar-spinner-up\'" />'+
							'</td></tr>'+
							'<tr><td>'+
								'<div id="'+id+'BtnDown" class="rich-calendar-spinner-down"'+
									'onmousedown="this.className=\'rich-calendar-spinner-down rich-calendar-spinner-pressed\'" '+
									'onmouseup="this.className=\'rich-calendar-spinner-down\'"'+
									'onmouseout="this.className=\'rich-calendar-spinner-down\'" />'+
							'</td></tr>'+
						'</tbody></table>'+
					'</td>'+
				'</tr></tbody></table>';
	},
	
	setTimeProperties: function() {
		this.timeType = 0;

		var dateTimePattern = this.params.datePattern;
		var pattern = [];
		var re = /(^|[^\\yMdHhm])(y+|M+|d+|a|H{1,2}|h{1,2}|m{2})/g;
		var r;
		while (r = re.exec(dateTimePattern))
  			pattern.push({str:r[0],marker:r[2],pref:r[1],idx:r.index});
  		
  		var datePattern = "";
  		var timePattern = "";
  		
		var digits,h,hh,m,a;
		var id = this.id;
		
		var getString = function (p) {
			return (p.length==0 ? obj.marker : dateTimePattern.substring(pattern[i-1].str.length+pattern[i-1].idx, obj.idx+obj.str.length));
		};
		
  		for (var i=0;i<pattern.length;i++)
  		{
  			var obj = pattern[i];
  			var ch = obj.marker.charAt(0);
  			if (ch=='y'||ch=='M'||ch=='d') datePattern+=getString(datePattern);
  			else if (ch=='a')
  			{
  				a=true;
  				timePattern+=getString(timePattern);
  			}
  			else if (ch=='H')
  			{
  				h=true;
  				digits=obj.marker.length;
  				timePattern+=getString(timePattern);
  			}
  			else if (ch=='h')
  			{
  				hh=true;
  				digits=obj.marker.length;
  				timePattern+=getString(timePattern);
  			}
  			else if (ch=='m')
  			{
  				m=true;
  				timePattern+=getString(timePattern);
  			}
  			
  			
  		}
  		this.datePattern = datePattern;
  		this.timePattern = timePattern;

  		var calendar = this;
  		
		this.timePatternHtml = timePattern.replace(/(^|[^\\Hhm])(H{1,2}|h{1,2}|m{2}|a)/g,
			function($1,$2,$3) {
				switch ($3) {
		            case 'a'  : return ($2 ? '<td>'+$2+'</td>' : '')+'<td>'+calendar.createSpinnerTable(id+'TimeSign')+'</td>';//'<input class="rich-calendar-time-input" id="'+id+'TimeSign"/>';
		            case 'H'  :
		            case 'HH' :
		            case 'h'  :
		            case 'hh' : return ($2 ? '<td>'+$2+'</td>' : '')+'<td>'+calendar.createSpinnerTable(id+'TimeHours')+'</td>';//'<input class="rich-calendar-time-input" id="'+id+'TimeHours"/>';
		            case 'mm' : return ($2 ? '<td>'+$2+'</td>' : '')+'<td>'+calendar.createSpinnerTable(id+'TimeMinutes')+'</td>';//'<input class="rich-calendar-time-input" id="'+id+'TimeMinutes"/>';
				}
			}
		);
		
		this.timePatternHtml = '<table><tbody><tr>'+this.timePatternHtml+'</tr></tbody></table>';
  		
		if (m && h)
		{
			this.timeType = 1;
		}
		else if (m && hh && a) 
		{
			this.timeType = 2;
		}
		this.timeHoursDigits = digits;
	},
	
	doCollapse: function() {
		if (!this.params.popup || !this.isVisible) return;
		
		if (this.isTimeEditorCreated) this.hideTimeEditor();
		
		/*this.stopTimer();
		this.stopPopupEvents($(this.id));
		this.stopPopupEvents($(this.POPUP_ID));*/
		
		var element = $(this.id);
		
		if (this.invokeEvent("collapse", element))
		{
			Event.stopObserving(window.document, "click", this.eventOnCollapse, false);
			
			var iframe=null;
			if (Richfaces.browser.isIE6) iframe = $(this.IFRAME_ID);
			if (iframe) Element.hide(iframe);
			
			Element.hide(element);
			this.isVisible = false;

			/*if (this.floatedToBody && this.parent)
			{
				if (iframe)
				{
					document.body.removeChild(iframe);
					this.parent.appendChild(iframe);
				}
				document.body.removeChild(element);
				this.parent.appendChild(element);
				this.floatedToBody = false;
				this.parent = null;
			}*/

		}
	},
	
	doExpand: function(e) {
		if (e) this.skipEventOnCollapse = true;
		if (!this.params.popup || this.isVisible) return;
		
		var element = $(this.id);

		if (this.invokeEvent("expand", element))
		{

			var iframe=null;
			if (Richfaces.browser.isIE6) iframe = $(this.IFRAME_ID);

	        /*if (!this.floatedToBody) {
				this.parent = element.parentNode;
				if (iframe) document.body.insertBefore(this.parent.removeChild(iframe), null);
				document.body.insertBefore(this.parent.removeChild(element), null);
				this.floatedToBody = true;
			}*/

			var base = $(this.POPUP_ID)
			var baseInput = base.firstChild;
			var baseButton = baseInput.nextSibling;
			
			if (baseInput && baseInput.value!=undefined)
			{
				this.selectDate(baseInput.value);
			}
			
			/*this.setPopupEvents(e);
			this.setPopupEvents(base);*/
			
			//rect calculation
			
			var offsetBase = Position.cumulativeOffset(baseButton);
			
			if (this.params.showInput)
			{
				var offsetBase1 = Position.cumulativeOffset(baseInput);
			
				offsetBase = [offsetBase[0]<offsetBase1[0] ? offsetBase[0] : offsetBase1[0],
							  offsetBase[1]<offsetBase1[1] ? offsetBase[1] : offsetBase1[1]];
				var offsetDimInput = Richfaces.Calendar.getOffsetDimensions(baseInput);
			}
			
			var offsetDimBase = Richfaces.Calendar.getOffsetDimensions(base);
			var offsetDimButton = Richfaces.Calendar.getOffsetDimensions(baseButton);
			var offsetTemp = Position.realOffset(baseButton);
			var o = {left: offsetBase[0]-offsetTemp[0],
					 top: offsetBase[1]-offsetTemp[1],
					 width: offsetDimBase.width,
					 height: (offsetDimInput && offsetDimInput.height>offsetDimButton.height ? offsetDimInput.height : offsetDimButton.height)};
					 
			Richfaces.Calendar.setElementPosition(element, o, this.params.jointPoint, this.params.direction, this.popupOffset);
	
			if (iframe)
			{
				iframe.style.left = element.style.left;
				iframe.style.top = element.style.top;
				var edim = Richfaces.Calendar.getOffsetDimensions(element);
				iframe.style.width = edim.width+'px';
				iframe.style.height = edim.height+'px';
				Element.show(iframe);
			}
			
			Element.show(element);
			
			this.isVisible = true;

			Event.observe(window.document, "click", this.eventOnCollapse, false);
		}
	},
	
	doSwitch: function(e) {
		this.isVisible ? this.doCollapse() : this.doExpand(e);
	},
	
	eventOnCollapse: function (e) {
		if (this.skipEventOnCollapse)
		{
			this.skipEventOnCollapse = false;
			return true;
		}

		if (Event.element(e).id == this.POPUP_BUTTON_ID || (!this.params.enableManualInput && Event.element(e).id == this.INPUT_DATE_ID) ) return true;
		
		Position.prepare();
		if (Position.withinIncludingScrolloffsets($(this.id), Event.pointerX(e), Event.pointerY(e))) return true;
		this.doCollapse();
		
		return true;
	},
	
	getCurrentDate: function() {
		return this.currentDate;
	},	
	getSelectedDate: function() {
		if (!this.selectedDate) return null; else return this.selectedDate;
	},
	getSelectedDateString: function(pattern) {
		if (!this.selectedDate) return "";
		if (!pattern) pattern = this.params.datePattern;
		return Richfaces.Calendar.formatDate(this.selectedDate, pattern, this.params.monthLabels, this.params.monthLabelsShort);
	},

	getPrevYear: function() {
		var value = this.currentDate.getFullYear()-1;
		if (value<0) value = 0;
		return value;
	},
	getPrevMonth: function(asMonthLabel) {
		var value = this.currentDate.getMonth()-1;
		if (value < 0 ) value = 11;
		if (asMonthLabel)
		{
			return this.params.monthLabels[value];
		} else return value;
	},
	getCurrentYear: function() {
		return this.currentDate.getFullYear();
	},
	getCurrentMonth: function(asMonthLabel) {
		var value = this.currentDate.getMonth();
		if (asMonthLabel)
		{
			return this.params.monthLabels[value];
		} else return value;
	},
	getNextYear: function() {
		return this.currentDate.getFullYear()+1;
	},
	getNextMonth: function(asMonthLabel) {
		var value = this.currentDate.getMonth()+1;
		if (value > 11 ) value = 0;
		if (asMonthLabel)
		{
			return this.params.monthLabels[value];
		} else return value;
	},
	
	isWeekend: function(weekday) {
		return (weekday == this.firstWeekendDayNumber || weekday == this.secondWeekendDayNumber);
	},
	
	prepareEvents: function() {
		this.eventCellOnClick = this.eventCellOnClick.bindAsEventListener(this);
		this.eventCellOnMouseOver = this.eventCellOnMouseOver.bindAsEventListener(this);
		this.eventCellOnMouseOut = this.eventCellOnMouseOut.bindAsEventListener(this);
		this.eventOnCollapse = this.eventOnCollapse.bindAsEventListener(this);
		//this.eventOnMouseOver = this.eventOnMouseOver.bindAsEventListener(this);
		//this.eventOnMouseOut = this.eventOnMouseOut.bindAsEventListener(this);
	},
	
/*	setPopupEvents: function(obj) {
		Event.observe(obj, "mouseover", this.eventOnMouseOver, false);
		Event.observe(obj, "mouseout", this.eventOnMouseOut, false);
	},

	stopPopupEvents: function(obj) {
		Event.stopObserving(obj, "mouseover", this.eventOnMouseOver, false);
		Event.stopObserving(obj, "mouseout", this.eventOnMouseOut, false);
	},
	* 	
	stopTimer: function()
	{
		if (this.popupIntervalId!=null) 
		{
			clearTimeout(this.popupIntervalId);
			this.popupIntervalId=null;
		}		
	},
	
	eventOnMouseOver: function(e) {
		this.stopTimer();
	},
	
	eventOnMouseOut: function(e) {
		if (this.popupIntervalId==null) this.popupIntervalId = setTimeout('$("'+this.id+'").component.doCollapse()',400);
	},*/
	
	setCellEvents: function(obj) {
		Event.observe(obj, "click", this.eventCellOnClick, false);
		Event.observe(obj, "mouseover", this.eventCellOnMouseOver, false);
		Event.observe(obj, "mouseout", this.eventCellOnMouseOut, false);
	},
	stopCellEvents: function(obj) {
		Event.stopObserving(obj, "click", this.eventCellOnClick, false);
		Event.stopObserving(obj, "mouseover", this.eventCellOnMouseOver, false);
		Event.stopObserving(obj, "mouseout", this.eventCellOnMouseOut, false);
	},
	
	invokeEvent: function(eventName, element, event, date) {
		var eventFunction = this.params['on'+eventName];
		var result;

		if (eventFunction)
		{
			var eventObj;

			if (event)
			{
				eventObj = event;
			}
			else if( document.createEventObject ) 
			{
				eventObj = document.createEventObject();
			}
			else if( document.createEvent )
			{
				eventObj = document.createEvent('Events');
				eventObj.initEvent( eventName, true, false );
			}
			
			eventObj.rich = {component:this};
			eventObj.rich.date = date;

			try
			{
				result = eventFunction.call(element, eventObj);
			}
			catch (e) { LOG.warn("Exception: "+e.Message + "\n[on"+eventName + "]"); }

		}
		
		if (result!=false) result = true;
		
		return result;
	},
	
	eventCellOnClick: function (e) {
		var obj = Event.findElementByAttr(e, "TD", "id", this.DATE_ELEMENT_ID, true);
		if (obj)
		{
			var daydata = this.days[parseInt(obj.id.substr(this.DATE_ELEMENT_ID.length),10)];
			if (daydata.enabled && daydata._month==0)
			{
				var date=new Date(this.currentDate);
				date.setDate(daydata.day);
				
				if (this.selectDate(date,true) && !this.showApplyButton)
				{
					this.doCollapse();
				}
				
			} else {
				if (this.params.boundaryDatesMode == "scroll") 
					if (daydata._month==-1) this.prevMonth(); else this.nextMonth();
				else if (this.params.boundaryDatesMode == "select") 
				{
					//var date = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth()+daydata._month, daydata.day);
					if (this.selectDate(daydata.date) && !this.showApplyButton)
					{
					 	this.doCollapse();
					}
				}
			}
		}
	},

	eventCellOnMouseOver: function (e) {
		var obj = Event.findElementByAttr(e, "TD", "id", this.DATE_ELEMENT_ID, true);
		if (obj)
		{
			var daydata = this.days[parseInt(obj.id.substr(this.DATE_ELEMENT_ID.length),10)];
			//var date = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth()+daydata._month, daydata.day);
			if (this.invokeEvent("datemouseover", obj, e, daydata.date) && daydata.enabled)
			{
				if (daydata._month==0) Element.addClassName(obj,'rich-calendar-hover');
			}
		}
	},
	
	eventCellOnMouseOut: function (e) {
		var obj = Event.findElementByAttr(e, "TD", "id", this.DATE_ELEMENT_ID, true);
		if (obj)
		{
			var daydata = this.days[parseInt(obj.id.substr(this.DATE_ELEMENT_ID.length),10)];
			//var date = new Date(this.currentDate.getFullYear(), this.currentDate.getMonth()+daydata._month, daydata.day);
			if (this.invokeEvent("datemouseout", obj, e, daydata.date) && daydata.enabled)
			{
				if (daydata._month==0) Element.removeClassName(obj,'rich-calendar-hover');
			}
		}
	},

	load:function(daysData, isAjaxMode)	{
		//	startDate,
		//	daysData:array[]
		//	{
		//			day
		//			enabled boolean
		//			text1: 'Meeting...',
		//			text2: 'Meeting...'
		//			tooltip 
		//			hasTooltip 
		//			styleClass
		//	}
		
		if (!$(this.id).component) return;
		
		if (daysData) {
			this.daysData = this.indexData(daysData, isAjaxMode);
		} else {
			this.daysData = null;
		}
		
		this.render();
		
		if (typeof this.afterLoad=='function') 
		{
			this.afterLoad();
			this.afterLoad=null;
		}
	},
	
	indexData:function(daysData, isAjaxMode) {
		var dateYear = daysData.startDate.getFullYear();
		var dateMonth = daysData.startDate.getMonth();
		
		daysData.index = [];
		daysData.index[dateYear+'-'+dateMonth] = 0;
		if (isAjaxMode)
		{
			this.currentDate = daysData.startDate;
			this.currentDate.setDate(1);
			return daysData;
		}
		var idx = daysInMonthByDate(daysData.startDate)-daysData.startDate.getDate()+1;
		
		while (daysData.days[idx])
		{
			if (dateMonth==11) {dateYear++; dateMonth=0;} else dateMonth++;
			daysData.index[dateYear+'-'+dateMonth] = idx;
			idx+= (32 - new Date(dateYear, dateMonth, 32).getDate());
		}
		return daysData;
	},
	
	getCellBackgroundColor: function(element)
	{
		var result;
		if (Richfaces.browser.isSafari && this.params.popup && !this.isVisible)
		{
			// Safari 2.0 fix 
			// if [display:none] Element.getStyle() function returns null;
			var els = $(this.id).style;
			var originalVisibility = els.visibility;
			var originalDisplay = els.display;
			els.visibility = 'hidden';
			els.display = '';
			result = Element.getStyle(element, 'background-color').parseColor();
			els.display = originalDisplay;
			els.visibility = originalVisibility;
		} else 
		{					
			result = Element.getStyle(element, 'background-color').parseColor();
		}
		
		return result;
	},
	
	clearEffect: function (element_id, effect, className)
	{
		if (effect) 
		{
			effect.cancel();
			effect=null;
		}
		if (element_id)
		{
			var e = $(element_id);
			e.style['backgroundColor'] = '';
			if (className) Element.removeClassName(e, className);
		}
		return null;
	},
	
	render:function() {
		
		this.todayDate = new Date();		
		
		var currentYear = this.getCurrentYear();
		var currentMonth = this.getCurrentMonth();
		
		var todayflag = (currentYear == this.todayDate.getFullYear() && currentMonth == this.todayDate.getMonth());
		var todaydate =  this.todayDate.getDate();
		
		var selectedflag = this.selectedDate && (currentYear == this.selectedDate.getFullYear() && currentMonth == this.selectedDate.getMonth())
		var selecteddate = this.selectedDate && this.selectedDate.getDate();

		var wd = getDay(this.currentDate, this.params.firstWeekDay);
		var currentMonthDays = daysInMonthByDate(this.currentDate);
		var previousMonthDays = daysInMonth(currentYear, currentMonth-1);
		
		var p=0;
		var month=-1;
		this.days = [];
		var dayCounter = previousMonthDays  - wd + 1;
		
		// previuos month days
		if (wd>0) while (dayCounter<=previousMonthDays)
		{
			this.days.push({day:dayCounter, isWeekend: this.isWeekend(p), _month:month}); dayCounter++; p++;
		}
			
		dayCounter = 1;
		month=0;
		
		this.firstDateIndex = p;

		// current month days
		if (this.daysData && this.daysData.index[currentYear+'-'+currentMonth]!=undefined)
		{
			var idx = this.daysData.index[currentYear+'-'+currentMonth];
			if (this.daysData.startDate.getFullYear()==currentYear && this.daysData.startDate.getMonth()==currentMonth)
			{
				var firstDay = firstDay=(this.daysData.days[idx].day ? this.daysData.days[idx].day : this.daysData.startDate.getDate());
				while (dayCounter<firstDay)
				{
					this.days.push({day:dayCounter, isWeekend:this.isWeekend(p%7), _month:month});
				
					dayCounter++;
					p++;
				}
			}
			
			var len = this.daysData.days.length;
			var obj;
			var flag;
			while (idx<len && dayCounter<=currentMonthDays)
			{
				flag = this.isWeekend(p%7);
				obj = this.daysData.days[idx];
				obj.day = dayCounter;
				obj.isWeekend = flag;
				obj._month = month;
				this.days.push(obj);
				idx++;
				dayCounter++;
				p++;
			}
		}
		while (p<42)
		{
			if (dayCounter>currentMonthDays) {dayCounter=1; month=1;}
			this.days.push({day:dayCounter, isWeekend: this.isWeekend(p%7), _month:month});
			dayCounter++;
			p++;
		}
		
		// render
		this.renderHF();
		this.renderHeaderOptional();
		this.renderFooterOptional();
		
		//days render
		p=0;
		var element;
		var dataobj;
		var wn;
		if (this.params.showWeeksBar) wn = weekNumber(currentYear, currentMonth, this.params.minDaysInFirstWeek, this.params.firstWeekDay); /// fix it
		this.selectedDayElement=null;
		var weekflag=true;

		var e;
		
		var boundaryDatesModeFlag = (this.params.boundaryDatesMode == "scroll" || this.params.boundaryDatesMode == "select");
		
		this.todayCellId = this.clearEffect(this.todayCellId, this.highlightEffect, "rich-calendar-today");
		this.selectedDateCellId = this.clearEffect(this.selectedDateCellId, this.highlightEffect2, "rich-calendar-select");
		
		//var _d=new Date();
		
		for (var k=1;k<7;k++)
		{
			//
			dataobj = this.days[p];
			
			var obj = $(this.params.weekNumberBarId+k);
			element = obj.firstChild;
			var weeknumber; 

			// week number update			
			if (this.params.showWeeksBar)
			{
				if (weekflag && currentMonth==11 &&
				   (k==5||k==6) &&
				   (dataobj._month==1 || (currentMonthDays-dataobj.day+1)<this.params.minDaysInFirstWeek) )
				{
					wn=1;
					weekflag=false;
				}
				weeknumber = wn;
			    element.innerHTML = this.evaluateMarkup(this.params.weekNumberMarkup, {weekNumber: wn++, elementId:element.id, component:this} );
			    if (k==1&&wn>52) wn=1;
			    element = element.nextSibling;
			}
			
			var weekdaycounter = this.params.firstWeekDay;
			var contentElement = null;

			while (element)
			{
				// TODO fix start/stop event's calls
				this.stopCellEvents(element);
				
				dataobj.elementId=element.id;
				dataobj.date=new Date(currentYear, currentMonth+dataobj._month, dataobj.day);
				dataobj.weekNumber = weeknumber;
				dataobj.component = this;
				dataobj.isCurrentMonth = (dataobj._month==0);
				dataobj.weekDayNumber = weekdaycounter;

				// call user function to get day state
				if (dataobj.enabled != false) dataobj.enabled = this.params.isDayEnabled(dataobj);
				// call user function to custom class style
				if (!dataobj.styleClass) dataobj.customStyleClass = this.params.dayStyleClass(dataobj);
				else
				{
					var styleclass = this.params.dayStyleClass(dataobj);
					dataobj.customStyleClass = dataobj.styleClass
					if (styleclass) dataobj.customStyleClass += " " + styleclass;
				}

				contentElement = (this.customDayListMarkup ? element.firstChild : element);
				contentElement.innerHTML = this.evaluateMarkup(this.params.dayListMarkup, dataobj );

				if (weekdaycounter==6) weekdaycounter=0; else weekdaycounter++;
				
				// class styles
				e = Element.classNames(element);
				// remove custom style class
				if (element.rich && element.rich.customStyleClass) 
				{
					element.rich.customStyleClass.split(' ').each(function(name){e.remove(name);});
					element.rich.customStyleClass = null;
				}
				
				if (dataobj._month!=0) 
				{
					e.add('rich-calendar-boundary-dates');
					if (boundaryDatesModeFlag)
						e.add('rich-calendar-btn');
					else
						e.remove('rich-calendar-btn');}
				else 
				{
					e.remove('rich-calendar-boundary-dates');
					if (dataobj.enabled) e.add('rich-calendar-btn'); else e.remove('rich-calendar-btn');

					// add custom style class
					if (dataobj.customStyleClass) 
					{
						e.add(dataobj.customStyleClass);
						element.rich = {customStyleClass: dataobj.customStyleClass};
					}
				}
				
				// TODO make some optimization with rich-calendar-today class
				if (todayflag && dataobj._month==0 && dataobj.day==todaydate) 
				{
					this.todayCellId = element.id;
					this.todayCellColor = this.getCellBackgroundColor(element);
					e.add("rich-calendar-today");
				}
				
				if (selectedflag && dataobj._month==0 && dataobj.day==selecteddate)
				{
					this.selectedDateCellId = element.id;
					this.selectedDateCellColor = this.getCellBackgroundColor(element);
					e.add("rich-calendar-select");
				}
				
				this.setCellEvents(element);
				p++;

				dataobj = this.days[p];
				element=element.nextSibling;
			}
		}
		
		//alert(new Date().getTime()-_d.getTime());
		
		// hack for IE 6.0 //fix 1072 // TODO check this bug again 
		/*if (Richfaces.browser.isIE6)
		{
			var element = $(this.id);
			if (element)
			{
				element.style.width = "0px";
				element.style.height = "0px";
			}
		}*/
		
	},

	renderHF: function()
	{
		this.renderMarkup(this.params.headerMarkup, this.id+"Header", this.calendarContext);
		this.renderMarkup(this.params.footerMarkup, this.id+"Footer", this.calendarContext);
	},

	renderHeaderOptional: function()
	{
		this.renderMarkup(this.params.optionalHeaderMarkup, this.id+"HeaderOptional", this.calendarContext);
	},	

	renderFooterOptional: function()
	{
		this.renderMarkup(this.params.optionalFooterMarkup, this.id+"FooterOptional", this.calendarContext);
	},
	
	renderMarkup: function (markup, elementId, context)
	{
		if (!markup) return;

		var e = $(elementId);
		if (!e) return; 
	
		e.innerHTML = markup.invoke('getContent', context).join('');
	},
	
	evaluateMarkup: function(markup, context)
	{
		if (!markup) return "";
		return markup.invoke('getContent', context).join('');
	},
	
	onUpdate: function()
	{
		var formattedDate = Richfaces.Calendar.formatDate(this.getCurrentDate(),"MM/yyyy");
		$(this.id+'InputCurrentDate').value=formattedDate;
		
		if (this.submitFunction)
			this.submitFunction(formattedDate);
		else
			this.render();
	},
	
	nextMonth: function() {
		this.changeCurrentDate(0,1);
	},
	
	prevMonth: function() {
		this.changeCurrentDate(0,-1);
	},
	
	nextYear: function() {
		this.changeCurrentDate(1,0);
	},
	
	prevYear: function() {
		this.changeCurrentDate(-1,0);
	},
	
	changeCurrentDate: function(yearOffset, monthOffset) {
		var date = new Date(this.currentDate.getFullYear()+yearOffset, this.currentDate.getMonth()+monthOffset,1);
		if (this.invokeEvent("currentdateselect", $(this.id), null, date))
		{
			this.currentDate = date;
			this.onUpdate();
		}
	},
	
	today: function(noUpdate, noHighlight) {

		var now = new Date();

		var nowyear = now.getFullYear();
		var nowmonth = now.getMonth();
		var nowdate = now.getDate();
		var updateflag = false;
		
		if (nowdate!=this.todayDate.getDate()) {updateflag=true; this.todayDate = now;}
		
		if (nowyear != this.currentDate.getFullYear() || nowmonth != this.currentDate.getMonth() )
		{
			updateflag = true;
			this.currentDate = new Date(nowyear, nowmonth, 1);
		}

		if (this.todayControlMode=='select')
		{
			noHighlight=true;
		}
		
		if (updateflag)
		{
			if (noUpdate) this.render(); else this.onUpdate();
		}
		else
		{
			// highlight today
			
			if (this.isVisible && this.todayCellId && !noHighlight)
			{
				this.clearEffect(this.todayCellId, this.highlightEffect);
				if (this.todayCellColor!="transparent")
				{
					this.highlightEffect = new Effect.Highlight($(this.todayCellId), {startcolor: this.todayCellColor, duration:0.3, transition: Effect.Transitions.sinoidal,
					afterFinish: this.onHighlightFinish});
				}
			}
		}

		// todayControl select mode
		if (this.todayControlMode=='select')
			if (updateflag && !noUpdate && this.submitFunction)
			{
				this.afterLoad = this.selectToday;
			}
			else this.selectToday();
		
	},

	selectToday: function()
	{
		if (this.todayCellId)
		{
			var daydata = this.days[parseInt($(this.todayCellId).id.substr(this.DATE_ELEMENT_ID.length),10)];
			if (daydata.enabled && this.selectDate(new Date(),true) && !this.showApplyButton)
			{
				this.doCollapse();
			}
		}		
	},
	
	onHighlightFinish: function (object)
	{
		object.element.style['backgroundColor'] = '';
	},
	
	selectDate: function(date, noUpdate, eventData) {
		
		if (!eventData)
		{
			eventData = {event: null, element: null};
		}
		
		var oldSelectedDate = this.selectedDate;
		var newSelectedDate;
		var isDateParsed = false;
		if (date)
		{
			if (typeof date=='string') 
			{
				date = Richfaces.Calendar.parseDate(date,this.params.datePattern, this.params.monthLabels, this.params.monthLabelsShort);
				if (date) isDateParsed = true;
			}
			newSelectedDate = date;
		}
		else
		{
			newSelectedDate = null;
		}

		// fire user event
		var flag = true;
		var isDateChanged = false;
		if ( (oldSelectedDate - newSelectedDate) && (oldSelectedDate!=null || newSelectedDate!=null) )
		{
			isDateChanged = true 	
			flag = this.invokeEvent("dateselect", eventData.element, eventData.event, date)
		}	
		
		if (flag)
		{		   
			var field = $(this.INPUT_DATE_ID);
			this.selectedDate = newSelectedDate;
			if (this.selectedDate!=null)
			{
				if (this.timeType && !isDateParsed)
					if (oldSelectedDate!=null)
					{
						this.selectedDate.setHours(oldSelectedDate.getHours());
						this.selectedDate.setMinutes(oldSelectedDate.getMinutes());
					}
					else
					{
						this.selectedDate.setHours(12);
					}
					
				if (!this.showApplyButton) field.value=this.getSelectedDateString(this.params.datePattern);
				
				var d = new Date(this.selectedDate);
				if (d.getMonth()==this.currentDate.getMonth() && d.getFullYear()==this.currentDate.getFullYear())
				{
					if (!oldSelectedDate || oldSelectedDate.getDate()!=d.getDate())
					{
						// find cell and change style class
						var e = $(this.DATE_ELEMENT_ID+(this.firstDateIndex + this.selectedDate.getDate()-1));
						
						this.clearEffect(this.selectedDateCellId, this.highlightEffect2, "rich-calendar-select");
						this.selectedDateCellId = e.id;
						this.selectedDateCellColor = this.getCellBackgroundColor(e);
						Element.addClassName(e, "rich-calendar-select");
	
						this.renderHF();
					}
					else if (this.timeType!=0) this.renderHF();
				}
				else
				{
					// change currentDate and call this.onUpdate();
					d.setDate(1);
					this.currentDate = d;
					if (noUpdate) this.render(); else this.onUpdate();
				}
			}
			else
			{
				this.selectedDate = null;
				field.value = ""; 

				this.clearEffect(this.selectedDateCellId, this.highlightEffect2, "rich-calendar-select");
				
				if (this.selectedDateCellId)
				{
					this.selectedDateCellId = null;
					this.renderHF();					
				}
				
				var date = new Date();
				if (this.currentDate.getMonth()==date.getMonth() && this.currentDate.getFullYear()==date.getFullYear())
				{
					this.renderHF();
				}
				
				var todayControlMode = this.todayControlMode;
				this.todayControlMode = '';
				this.today(noUpdate, true);
				this.todayControlMode = todayControlMode;
			}
			
			// call user event
			if (isDateChanged)
			{
				this.invokeEvent("dateselected", eventData.element, eventData.event, this.selectedDate);
			}
		}
		
		return flag;			
	},
	
	resetSelectedDate: function()
	{
		if (!this.selectedDate) return;
		if (this.invokeEvent("dateselect", null, null, null))
		{
			this.selectedDate = null;
			
			this.selectedDateCellId = this.clearEffect(this.selectedDateCellId, this.highlightEffect2, "rich-calendar-select");
			 
			this.renderHF();
			if (!this.showApplyButton)
			{
				$(this.INPUT_DATE_ID).value = "";
				this.doCollapse();
				this.invokeEvent("dateselected", null, null, null);
			}
		}
	},
	
	showSelectedDate: function()
	{
		if (!this.selectedDate) return;
		if (this.currentDate.getMonth()!=this.selectedDate.getMonth() || this.currentDate.getFullYear()!=this.selectedDate.getFullYear())
		{
			this.currentDate = new Date(this.selectedDate);
			this.currentDate.setDate(1);
			this.onUpdate();
		}
		else
		{
			// highlight Selected Date
			if (this.isVisible && this.selectedDateCellId)
			{
				this.clearEffect(this.selectedDateCellId, this.highlightEffect2);
				if (this.selectedDateCellColor!="transparent")
				{
					this.highlightEffect2 = new Effect.Highlight($(this.selectedDateCellId), {startcolor: this.selectedDateCellColor, duration:0.3, transition: Effect.Transitions.sinoidal,
					afterFinish: this.onHighlightFinish});
				}
			}			
		}
	},
	
	close: function(updateDate)
	{
		if (updateDate)
		{
			var field = $(this.INPUT_DATE_ID);
			field.value=this.getSelectedDateString(this.params.datePattern);
		}		
		this.doCollapse();
	},
	
	showTimeEditor: function()
	{
		if (this.timeType==0) return;
		if (!this.isTimeEditorCreated) this.createTimeEditor();
		
		var element = $(this.id);
		
		var te = $(this.TIME_EDITOR_ID);
		var te_shadow = $(this.TIME_EDITOR_SHADOW_ID);
		
		/*var dim = Richfaces.Calendar.getOffsetDimensions(element);
		te.style.width = te_shadow.style.width = dim.width + 'px';
		te.style.height = te_shadow.style.height = dim.height + 'px';
		te.style.left = te_shadow.style.left = element.style.left;
		te.style.top = te_shadow.style.top = element.style.top;*/
		
		Element.clonePosition(te, element);
		Element.clonePosition(te_shadow, element);

		this.updateTimeEditor();
		
		te.show();
		te_shadow.show();
		Element.clonePosition(this.TIME_EDITOR_LAYOUT_SHADOW_ID, this.TIME_EDITOR_LAYOUT_ID, {offsetLeft: 3, offsetTop: 3});
	},
	
	hideTimeEditor: function(updateTime)
	{
		$(this.TIME_EDITOR_ID).hide();
		$(this.TIME_EDITOR_SHADOW_ID).hide();

		if (updateTime && this.selectedDate)
		{
			var m = parseInt($(this.id+'TimeMinutes').value,10);
			this.selectedDate.setMinutes(m);
			var h=parseInt($(this.id+'TimeHours').value,10);
			if (this.timeType==2)
			{
				if ($(this.id+'TimeSign').value.toLowerCase()=="am")
				{
					if (h==12) h = 0;					
				}
				else
				{
					if (h!=12) h+=12;
				}
			}
			this.selectedDate.setHours(h);
			this.renderHF();
		}
		
		if (this.params.popup && !this.showApplyButton && updateTime) this.close(true);
	}

});

CalendarView = {};
CalendarView.getControl = function(text, attributes, functionName, paramsStr) {
	var attr = Object.extend({
			onclick: (functionName ? "Richfaces.getComponent('calendar',this)."+functionName+"("+(paramsStr ? paramsStr : "")+");" : "")+"return true;",
			className: "rich-calendar-btn"
		}, attributes);
	
	return new E('div',attr,[new T(text)]);
};

CalendarView.getSelectedDateControl = function(calendar) {
	
	if (!calendar.selectedDate || calendar.showApplyButton) return "";
	
	var text = Richfaces.Calendar.formatDate(calendar.selectedDate,(calendar.timeType ? calendar.datePattern : calendar.params.datePattern), calendar.params.monthLabels, calendar.params.monthLabelsShort);
	
	var markup = new E('div', {'class': 'rich-calendar-tool-btn', 'onclick': "Richfaces.getComponent('calendar',this).showSelectedDate(); return true;"}, [new ET(text)]);

	return markup;
};

CalendarView.getTimeControl = function(calendar) {
	
	if (!calendar.selectedDate || !calendar.timeType) return "";
	
	var text = Richfaces.Calendar.formatDate(calendar.selectedDate, calendar.timePattern, calendar.params.monthLabels, calendar.params.monthLabelsShort);
	
	var markup = new E('div', {'class': 'rich-calendar-tool-btn rich-calendar-tool-btn-hover rich-calendar-tool-btn-press', 'onclick': "Richfaces.getComponent('calendar',this).showTimeEditor();return true;",
						'onmouseover': "Element.removeClassName(this, 'rich-calendar-tool-btn-press');",
						'onmouseout' : "Element.addClassName(this, 'rich-calendar-tool-btn-press');"}, [new ET(text)]);

	return markup;
};

CalendarView.toolButtonAttributes = {className: "rich-calendar-tool-btn", onmouseover:"this.className='rich-calendar-tool-btn rich-calendar-tool-btn-hover'", onmouseout:"this.className='rich-calendar-tool-btn'", onmousedown:"this.className='rich-calendar-tool-btn rich-calendar-tool-btn-hover rich-calendar-tool-btn-press'", onmouseup:"this.className='rich-calendar-tool-btn rich-calendar-tool-btn-hover'"};
CalendarView.nextYearControl = CalendarView.getControl(">>", CalendarView.toolButtonAttributes, "nextYear");
CalendarView.previousYearControl = CalendarView.getControl("<<", CalendarView.toolButtonAttributes, "prevYear");
CalendarView.nextMonthControl = CalendarView.getControl(">", CalendarView.toolButtonAttributes, "nextMonth");
CalendarView.previousMonthControl = CalendarView.getControl("<", CalendarView.toolButtonAttributes, "prevMonth");
CalendarView.currentMonthControl = function (context) { return Richfaces.Calendar.formatDate(context.calendar.getCurrentDate(), "MMMM, yyyy", context.monthLabels, context.monthLabelsShort);}; 
CalendarView.todayControl = function (context) { return (context.calendar.todayControlMode!='hidden' ? CalendarView.getControl("Today", CalendarView.toolButtonAttributes, "today") : "");};
CalendarView.selectedDateControl = function (context) { return CalendarView.getSelectedDateControl(context.calendar);};
CalendarView.timeControl = function (context) { return CalendarView.getTimeControl(context.calendar);};
CalendarView.closeControl = CalendarView.getControl("x", CalendarView.toolButtonAttributes, "close", "false");
CalendarView.applyControl = function (context) { return (context.calendar.showApplyButton ? CalendarView.getControl("Apply", CalendarView.toolButtonAttributes, "close", "true") : "");};
CalendarView.cleanControl = function (context) { return (context.calendar.selectedDate ? CalendarView.getControl("Clean", CalendarView.toolButtonAttributes, "resetSelectedDate") : "");};
CalendarView.timeEditorFields = function (context) { return context.calendar.timePatternHtml;};

CalendarView.header = [
	new E('table',{'border': '0', 'cellpadding': '0', 'cellspacing': '0', 'width': '100%'},
		[
			new E('tbody',{},
			[
				new E('tr',{},
				[
					new E('td',{'class': 'rich-calendar-tool'},
					[
						new ET(function (context) { return Richfaces.evalMacro("previousYearControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-tool'},
					[
						new ET(function (context) { return Richfaces.evalMacro("previousMonthControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-month'},
					[
						new ET(function (context) { return Richfaces.evalMacro("currentMonthControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-tool'},
					[
						new ET(function (context) { return Richfaces.evalMacro("nextMonthControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-tool'},
					[
						new ET(function (context) { return Richfaces.evalMacro("nextYearControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-tool rich-calendar-tool-close'},
					[
						new ET(function (context) { return Richfaces.evalMacro("closeControl", context)})
					])
				])
			])
		]
	)];
	
CalendarView.footer = [
	new E('table',{'border': '0', 'cellpadding': '0', 'cellspacing': '0', 'width': '100%'},
		[
			new E('tbody',{},
			[
				new E('tr',{},
				[
					new E('td',{'class': 'rich-calendar-toolfooter', 'style':function(context){return (this.isEmpty ? 'display:none;' : '');}},
					[
						new ET(function (context) { return Richfaces.evalMacro("selectedDateControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-toolfooter', 'style':function(context){return (this.isEmpty ? 'display:none;' : '');}},
					[
						new ET(function (context) { return Richfaces.evalMacro("cleanControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-toolfooter', 'style':function(context){return (this.isEmpty ? 'display:none;' : '');}},
					[
						new ET(function (context) { return Richfaces.evalMacro("timeControl", context)})
					]),
					new E('td',{'width': '100%'}, []),
					new E('td',{'class': 'rich-calendar-toolfooter', 'style':function(context){return (this.isEmpty ? 'display:none;' : '')+(!context.calendar.showApplyButton ? 'background-image:none;' : '');}},
					[
						new ET(function (context) { return Richfaces.evalMacro("todayControl", context)})
					]),
					new E('td',{'class': 'rich-calendar-toolfooter', 'style':function(context){return (this.isEmpty ? 'display:none;' : '')+'background-image:none;';}},
					[
						new ET(function (context) { return Richfaces.evalMacro("applyControl", context)})
					])
				])
			])
		]
	)];
	
CalendarView.timeEditor = [

        new E('div',{'id': function(context){return context.calendar.TIME_EDITOR_LAYOUT_SHADOW_ID}, 'class': 'rich-calendar-time-layout-shadow'},null),

        new E('table',{'id': function(context){return context.calendar.TIME_EDITOR_LAYOUT_ID}, 'border': '0', 'cellpadding': '0', 'cellspacing': '0', 'class': 'rich-calendar-time-layout'},
		[
			new E('tbody',{},
			[
				new E('tr',{},
				[
					new E('td',{'class': 'rich-calendar-time-layout-fields', 'colspan': '2', 'align': 'center'},
					[
						new ET(function (context) { return Richfaces.evalMacro("timeEditorFields", context)})
					])
				]),
				new E('tr',{},
				[
					new E('td',{'class': 'rich-calendar-time-layout-ok'},
					[
						new E('div',{'class': 'rich-calendar-time-btn', 'style': 'float:right;', 'onmousedown': "Element.addClassName(this, 'rich-calendar-time-btn-press');", 'onmouseout': "Element.removeClassName(this, 'rich-calendar-time-btn-press');", 'onmouseup': "Element.removeClassName(this, 'rich-calendar-time-btn-press');", 'onclick': function(context){return "$('"+context.calendar.id+"').component.hideTimeEditor(true)";}},
						[
							new T('Ok')
						])
					])
					,
					new E('td',{'class': 'rich-calendar-time-layout-cancel'},
					[
						new E('div',{'class': 'rich-calendar-time-btn', 'style': 'float:left;', 'onmousedown': "Element.addClassName(this, 'rich-calendar-time-btn-press');", 'onmouseout': "Element.removeClassName(this, 'rich-calendar-time-btn-press');", 'onmouseup': "Element.removeClassName(this, 'rich-calendar-time-btn-press');", 'onclick': function(context){return "$('"+context.calendar.id+"').component.hideTimeEditor(false)";}},
						[
							new T('Cancel')
						])
					])
				])
			])
		]
	)];

CalendarView.dayList = [new ET(function (context) { return context.day})];
CalendarView.weekNumber = [new ET(function (context) { return context.weekNumber})];
CalendarView.weekDay = [new ET(function (context) { return context.weekDayLabelShort})];

CalendarContext = Class.create();
Object.extend(CalendarContext.prototype, {
    initialize: function(calendar) {
    	this.calendar=calendar;
		this.monthLabels=calendar.params.monthLabels;
		this.monthLabelsShort=calendar.params.monthLabelsShort;
		this.weekDayLabels=calendar.params.weekDayLabels;
		this.weekDayLabelsShort=calendar.params.weekDayLabelsShort;
    },

	nextYearControl: CalendarView.nextYearControl,
	previousYearControl: CalendarView.previousYearControl,
	nextMonthControl: CalendarView.nextMonthControl,
	previousMonthControl: CalendarView.previousMonthControl,
	currentMonthControl: CalendarView.currentMonthControl,
	selectedDateControl: CalendarView.selectedDateControl,
	cleanControl: CalendarView.cleanControl,
	timeControl: CalendarView.timeControl,
	todayControl: CalendarView.todayControl,
	closeControl: CalendarView.closeControl,
	applyControl: CalendarView.applyControl,
	timeEditorFields: CalendarView.timeEditorFields
});