/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.model.DataModel;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.SequenceDataModel;
import org.richfaces.component.MessageFactory;
import org.richfaces.component.UIOrderingBaseComponent;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.model.OrderingListDataModel;

public abstract class UIOrderingList
extends UIOrderingBaseComponent {
    private transient Map dataMap;
    private transient SubmittedValue submittedValueHolder = null;
    private Collection selection;
    private boolean selectionSet;
    protected final UIOrderingBaseComponent.UpdateModelCommand updateSelectionCommand = new UIOrderingBaseComponent.UpdateModelCommand(){

        public void execute(FacesContext context) {
            ValueBinding vb;
            if (UIOrderingList.this.selectionSet && (vb = UIOrderingList.this.getValueBinding("selection")) != null) {
                vb.setValue(context, (Object)UIOrderingList.this.selection);
                UIOrderingList.this.selection = null;
                UIOrderingList.this.selectionSet = false;
            }
        }
    };
    static /* synthetic */ Class class$javax$faces$event$ValueChangeListener;

    protected void processDecodes(FacesContext faces, Object argument) {
        if (!this.isRendered()) {
            return;
        }
        this.decode(faces);
        SubmittedValue submittedValue = this.submittedValueHolder;
        if (submittedValue != null) {
            Object modelValue = this.getValue();
            Iterator iterator = submittedValue.dataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object value = entry.getValue();
                if (this.isSuitableValue(modelValue, value)) continue;
                String messageText = Messages.getMessage((String)"INVALID_VALUE", (Object)MessageUtil.getLabel((FacesContext)faces, (UIComponent)this), value);
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, messageText, null);
                faces.addMessage(this.getClientId(faces), message);
                this.setValid(false);
                break;
            }
        }
        if (this.isImmediate()) {
            this.executeValidate(faces);
        }
        if (!this.isValid()) {
            faces.renderResponse();
        }
        this.iterate(faces, this.decodeVisitor, argument);
    }

    protected ExtendedDataModel createDataModel() {
        Map modelMap = null;
        modelMap = this.submittedValueHolder != null ? this.submittedValueHolder.dataMap : this.dataMap;
        if (modelMap != null) {
            OrderingListDataModel dataModel = new OrderingListDataModel();
            dataModel.setWrappedData(modelMap);
            return dataModel;
        }
        DataModel dataModel = this.createDataModel(this.getValue());
        return new SequenceDataModel(dataModel);
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public abstract MethodBinding getValueChangeListener();

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(class$javax$faces$event$ValueChangeListener == null ? (class$javax$faces$event$ValueChangeListener = UIOrderingList.class$("javax.faces.event.ValueChangeListener")) : class$javax$faces$event$ValueChangeListener);
    }

    public abstract boolean isImmediate();

    public abstract boolean isRequired();

    public abstract boolean isValid();

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void setSubmittedString(Map submittedString, Set selection, Object activeItem) {
        this.submittedValueHolder = new SubmittedValue(submittedString, selection, activeItem);
    }

    protected Object saveIterationSubmittedState() {
        return this.submittedValueHolder;
    }

    protected void restoreIterationSubmittedState(Object object) {
        this.submittedValueHolder = (SubmittedValue)object;
    }

    protected Object saveIterationState() {
        ValueHolder valueHolder = new ValueHolder();
        valueHolder.map = this.dataMap;
        valueHolder.selection = this.selection;
        valueHolder.selectionSet = this.selectionSet;
        return valueHolder;
    }

    protected void restoreIterationState(Object object) {
        ValueHolder valueHolder = (ValueHolder)object;
        this.dataMap = valueHolder.map;
        this.selection = valueHolder.selection;
        this.selectionSet = valueHolder.selectionSet;
    }

    public abstract void setImmediate(boolean var1);

    public abstract void setRequired(boolean var1);

    public abstract void setValid(boolean var1);

    public abstract void setValueChangeListener(MethodBinding var1);

    public abstract Converter getConverter();

    public abstract void setConverter(Converter var1);

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding method;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (method = this.getValueChangeListener()) != null) {
            FacesContext context = this.getFacesContext();
            method.invoke(context, new Object[]{event});
        }
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid()) {
            return;
        }
        this.updateModel(context, this.updateValueCommand);
        this.updateModel(context, this.updateSelectionCommand);
        this.updateModel(context, this.updateActiveItemCommand);
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.submittedValueHolder == null) {
            return;
        }
        Object previousValue = this.getValue();
        Object newValue = null;
        try {
            if (previousValue == null) {
                previousValue = Collections.EMPTY_LIST;
            }
            OrderingListDataModel dataModel = (OrderingListDataModel)this.getExtendedDataModel();
            try {
                final ArrayList list = new ArrayList(dataModel.getRowCount());
                this.walk(context, new DataVisitor(){

                    public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                        UIOrderingList.this.setRowKey(context, rowKey);
                        list.add(UIOrderingList.this.getRowData());
                    }
                }, null);
                newValue = this.createContainer(list, previousValue.getClass());
            }
            catch (IOException e) {
                throw new ConverterException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (ConverterException ce) {
            SubmittedValue submittedValue = this.submittedValueHolder;
            this.addConversionErrorMessage(context, ce, submittedValue);
            this.setValid(false);
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            this.setSelection(this.submittedValueHolder.selection);
            this.setActiveItem(this.submittedValueHolder.activeItem);
            this.setValue(newValue);
            this.setTranslatedState();
            if (this.compareValues(previousValue, newValue)) {
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, previousValue, newValue));
            }
            this.dataMap = this.submittedValueHolder.dataMap;
            this.submittedValueHolder = null;
        }
    }

    protected void resetDataModel() {
        super.resetDataModel();
        this.dataMap = null;
        if (this.submittedValueHolder != null) {
            this.setTranslatedRenderingState();
        }
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && this.isEmpty(newValue)) {
            FacesMessage message = MessageFactory.getMessage(context, "javax.faces.component.UIInput.REQUIRED");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && !this.isEmpty(newValue)) {
            FacesMessage message;
            Validator[] validators = this.getValidators();
            for (int i = 0; i < validators.length; ++i) {
                Validator validator = validators[i];
                try {
                    validator.validate(context, (UIComponent)this, newValue);
                    continue;
                }
                catch (ValidatorException ve) {
                    this.setValid(false);
                    message = ve.getFacesMessage();
                    if (message == null) continue;
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), message);
                }
            }
            MethodBinding validator = this.getValidator();
            if (validator != null) {
                try {
                    validator.invoke(context, new Object[]{context, this, newValue});
                }
                catch (EvaluationException ee) {
                    if (ee.getCause() instanceof ValidatorException) {
                        ValidatorException ve = (ValidatorException)ee.getCause();
                        this.setValid(false);
                        message = ve.getFacesMessage();
                        if (message != null) {
                            message.setSeverity(FacesMessage.SEVERITY_ERROR);
                            context.addMessage(this.getClientId(context), message);
                        }
                    }
                    throw ee;
                }
            }
        }
    }

    public UIOrderingBaseComponent.ItemState getItemState() {
        if (this.submittedValueHolder != null) {
            return new ModelItemState(this.submittedValueHolder.selection, this.submittedValueHolder.activeItem);
        }
        return new ModelItemState(this.getSelection(), this.getActiveItem());
    }

    public abstract String getControlsType();

    public abstract void setControlsType(String var1);

    public Collection getSelection() {
        if (this.selection != null) {
            return this.selection;
        }
        ValueBinding vb = this.getValueBinding("selection");
        if (vb != null) {
            return (Collection)vb.getValue(FacesContext.getCurrentInstance());
        }
        return null;
    }

    public void setSelection(Collection collection) {
        this.selection = collection;
        this.selectionSet = true;
    }

    public Object saveState(FacesContext faces) {
        Object[] state = new Object[5];
        state[0] = super.saveState(faces);
        Object rowKey = this.getRowKey();
        final HashSet selectionKeySet = new HashSet();
        final HashSet activeItemSet = new HashSet(1);
        try {
            this.walk(faces, new DataVisitor(){

                public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                    UIOrderingList.this.setRowKey(context, rowKey);
                    Object data = UIOrderingList.this.getRowData();
                    if (data != null) {
                        if (data.equals(UIOrderingList.this.activeItem)) {
                            activeItemSet.add(rowKey);
                        }
                        if (UIOrderingList.this.selection != null && UIOrderingList.this.selection.contains(data)) {
                            selectionKeySet.add(rowKey);
                        }
                    }
                }
            }, null);
        }
        catch (IOException e) {
            throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
        }
        state[1] = selectionKeySet;
        state[2] = this.selectionSet ? Boolean.TRUE : Boolean.FALSE;
        state[3] = activeItemSet.isEmpty() ? null : activeItemSet.iterator().next();
        state[4] = this.activeItemSet ? Boolean.TRUE : Boolean.FALSE;
        return state;
    }

    public void restoreState(FacesContext faces, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(faces, state[0]);
        this.selection = (Collection)state[1];
        this.selectionSet = (Boolean)state[2];
        this.activeItem = state[3];
        this.activeItemSet = (Boolean)state[4];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static final class ValueHolder
    implements Serializable {
        private static final long serialVersionUID = -4216115242421460529L;
        private Collection selection;
        private boolean selectionSet;
        private Map map;

        protected ValueHolder() {
        }
    }

    private final class ModelItemState
    implements UIOrderingBaseComponent.ItemState {
        private Collection selectedItems;
        private Object activeItem;

        public ModelItemState(Collection selectedItems, Object activeItem) {
            this.selectedItems = selectedItems;
            this.activeItem = activeItem;
        }

        public boolean isSelected() {
            return this.selectedItems != null && this.selectedItems.contains(UIOrderingList.this.getRowData());
        }

        public boolean isActive() {
            return this.activeItem != null && this.activeItem.equals(UIOrderingList.this.getRowData());
        }
    }

    protected static final class SubmittedValue
    implements Serializable {
        private static final long serialVersionUID = 5860506816451180551L;
        private Map dataMap;
        private Collection selection;
        private Object activeItem;

        public SubmittedValue(Map dataMap, Set selection, Object activeItem) {
            this.dataMap = dataMap;
            this.selection = selection;
            this.activeItem = activeItem;
        }
    }
}

