if(!window.Richfaces) var Richfaces = function(){};


Richfaces.SelectItems = {
	CLASSES : {
		ROW : {
			ACTIVE   : "rich-ordering-list-row-active",
			SELECTED : "rich-ordering-list-row-selected",
			ACTIVE_SELECTED : "rich-ordering-list-row-selected rich-ordering-list-row-active",
			DISABLED : "rich-ordering-list-row-disabled",
			NORMAL   : "rich-ordering-list-row"
		},
		CELL : {
			ACTIVE   : "rich-ordering-list-cell-active",
			SELECTED : "rich-ordering-list-cell-selected",
			ACTIVE_SELECTED : "rich-ordering-list-cell-selected rich-ordering-list-cell-active",
			DISABLED : "rich-ordering-list-cell-disabled",
			NORMAL   : "rich-ordering-list-cell"
		}
	},

	doActive : function(row) {
		var newRowStyle = Richfaces.SelectItems.CLASSES.ROW.ACTIVE;
		var newCellStyle = Richfaces.SelectItems.CLASSES.CELL.ACTIVE;
		if (Element.hasClassName(row, Richfaces.SelectItems.CLASSES.ROW.SELECTED)) {
			newRowStyle = Richfaces.SelectItems.CLASSES.ROW.ACTIVE_SELECTED;
			newCellStyle = Richfaces.SelectItems.CLASSES.CELL.ACTIVE_SELECTED;
		}
		Richfaces.SelectItems.doChange(row, newRowStyle, newCellStyle);
	},
	
	doSelect : function(row) {
		Richfaces.SelectItems
				 .doChange(row, 
						   Richfaces.SelectItems.CLASSES.ROW.SELECTED, 
						   Richfaces.SelectItems.CLASSES.CELL.SELECTED);
	},
	
	doNormal : function(row) {
		Richfaces.SelectItems
				 .doChange(row, 
						   Richfaces.SelectItems.CLASSES.ROW.NORMAL, 
						   Richfaces.SelectItems.CLASSES.CELL.NORMAL);
	},
	
	isSelected : function(row) {
		return Richfaces.SelectItems.compareStates(row, Richfaces.SelectItems.CLASSES.ROW.SELECTED);
	},
	
	isActive : function(row) {
		return Richfaces.SelectItems.compareStates(row, Richfaces.SelectItems.CLASSES.ROW.ACTIVE);
	},
	
	doChange : function(row, classNameRow, classNameCell) {
		Richfaces.SelectItems.doChangeNode(row, classNameRow);
		var cells = row.cells;
		for (var i = 0; i < cells.length; i++) {
			var cell = cells[i];
			if (i == (cells.length - 1)) {
				//TODO nick - testing
				//Element.setStyle(cell, {'border': '0px'});
			}
			Richfaces.SelectItems.doChangeNode(cell, classNameCell);
		}
	},
	
	doChangeNode : function(node, className) {
		node.className = className;
	},
	
	compareStates : function(row, className) {
		if (row.className.indexOf(className) != -1) {
			return true;
		}
		return false;
	}
}

Richfaces.SelectItem = Class.create();
Richfaces.SelectItem.prototype = {
	initialize : function(label, id, selected, node) {
		this._label = label;
		this._node = node; 
		this._node.item = this;
		this._id = id;
		this._selected = selected;
		
		//TODO 2 optimize
		this.input = $(node.id + "StateInput");
	}
}
