if(!window.Richfaces) window.Richfaces = {};

Richfaces.ListShuttle = Class.create();

Richfaces.ListShuttle.Source = Class.create(Richfaces.ListBase);

Richfaces.ListShuttle.Source.prototype.CLASSES = {
	ROW : {
		ACTIVE   : "rich-shuttle-source-row-active",
		SELECTED : "rich-shuttle-source-row-selected",
		ACTIVE_SELECTED : "rich-shuttle-source-row-selected rich-shuttle-source-row-active",
		DISABLED : "rich-shuttle-source-row-disabled",
		NORMAL   : "rich-shuttle-source-row"
	},
	CELL : {
		ACTIVE   : "rich-shuttle-source-cell-active",
		SELECTED : "rich-shuttle-source-cell-selected",
		ACTIVE_SELECTED : "rich-shuttle-source-cell-selected rich-shuttle-source-cell-active",
		DISABLED : "rich-shuttle-source-cell-disabled",
		NORMAL   : "rich-shuttle-source-cell",
		BEGIN:	" rich-shuttle-source-cell-begin",
		END:	" rich-shuttle-source-cell-end"
	}
};

Richfaces.ListShuttle.Target = Class.create(Richfaces.OrderingList);

Richfaces.ListShuttle.Target.prototype.CLASSES = {
	ROW : {
		ACTIVE   : "rich-shuttle-target-row-active",
		SELECTED : "rich-shuttle-target-row-selected",
		ACTIVE_SELECTED : "rich-shuttle-target-row-selected rich-shuttle-target-row-active",
		DISABLED : "rich-shuttle-target-row-disabled",
		NORMAL   : "rich-shuttle-target-row"
	},
	CELL : {
		ACTIVE   : "rich-shuttle-target-cell-active",
		SELECTED : "rich-shuttle-target-cell-selected",
		ACTIVE_SELECTED : "rich-shuttle-target-cell-selected rich-shuttle-target-cell-active",
		DISABLED : "rich-shuttle-target-cell-disabled",
		NORMAL   : "rich-shuttle-target-cell",
		BEGIN:	" rich-shuttle-target-cell-begin",
		END:	" rich-shuttle-target-cell-end"
	}
};

Richfaces.ListShuttle.prototype = {
	initialize: function(targetList, sourceList, clientId, controlIds, switchByClick, sourceLayoutManager, targetLayoutManager) {
		sourceList._onclickHandler = sourceList.onclickHandler;
		sourceList.onclickHandler = function(e) { this.onclickHandler(e, sourceList); }.bindAsEventListener(this);
		targetList._onclickHandler = targetList.onclickHandler;
		targetList.onclickHandler = function(e) { this.onclickHandler(e, targetList); }.bindAsEventListener(this);
	
		this.targetList = targetList;
		this.sourceList = sourceList;
		
		this.targetLayoutManager = targetLayoutManager;
		this.sourceLayoutManager = sourceLayoutManager;
		
		this.targetList.shuttleTable.observe("dblclick", function(e) {this.moveItemByClick(window.event||e, this.targetList, this.sourceList)}.bindAsEventListener(this));
		this.sourceList.shuttleTable.observe("dblclick", function(e) {this.moveItemByClick(window.event||e, this.sourceList, this.targetList)}.bindAsEventListener(this));
		
		if (switchByClick == "true") {
			this.targetList.shuttleTable.observe("click", function(e) {this.moveItemByClick(window.event||e, this.targetList, this.sourceList)}.bindAsEventListener(this));
			this.sourceList.shuttleTable.observe("click", function(e) {this.moveItemByClick(window.event||e, this.sourceList, this.targetList)}.bindAsEventListener(this));
		}
		
		this.controlList = new Array();
		this.initControlList(clientId, controlIds);
	},
	
	initControlList : function(clientId, ids) {
		for (var i = 0; i < ids.length; i++) {
			var id = ids[i];
			var node = $(clientId + id[0]);
			var disNode = $(clientId + id[1]);
			if (node && disNode) { 
				node.observe("click", Richfaces.ListShuttle.HANDLERS[id[0]].bindAsEventListener(this));	
				this.controlList[i] = new Control(node, disNode, false, false, id[0]);
			}
		}
		//this.controlListManager();
	},
	
	controlListManager : function() {
		//this.controlsProcessing();
		this.controlsProcessing(["copy", "copyAll", "removeAll" ,"remove"], "enable");
		if (this.sourceList.shuttleItems.length < 1) 
			this.controlsProcessing(["copy", "copyAll"], "disable");
		if (this.sourceList.selectedItems.length < 1) 
			this.controlsProcessing(["copy"] , "disable");
		if (this.targetList.shuttleItems.length < 1) 
			this.controlsProcessing(["removeAll" ,"remove"], "disable");
		if (this.targetList.selectedItems.length < 1) {
			this.controlsProcessing(["remove"], "disable");
		} 	
	},
	
	onclickHandler : function(event, component) {
		component._onclickHandler(event);
		this.controlListManager();
		Event.stop(event);
	},
	
	controlsProcessing : function(disabledControls , action) {
		for (var i = 0; i < this.controlList.length; i++) {
			control = this.controlList[i];
			if (control != null) {
				if (disabledControls != null && disabledControls.indexOf(control.action) != -1) {
					if (action == "disable") {
						control.doDisable();
					} else {
						control.doEnable();
					}
				}
			}
		}
	},
	
	moveItems : function(sourceComponent, targetComponent, items) {
		if (items.length > 0) {
			var length = items.length;
			for (var i = 0; items.length > 0;) {
				var item = items[i];
				this.moveItem(sourceComponent, targetComponent, item);
			} 
			this.controlListManager();
			this.targetList.controlListManager();
			this.saveState();
			
			this.targetLayoutManager.widthSynchronization();
			this.sourceLayoutManager.widthSynchronization();
		}
	},
	
	moveItem : function(sourceComponent, targetComponent, item) {
		if (!(item instanceof Richfaces.SelectItem)) {
			item = sourceComponent.getSelectItemByNode(item);
		}
		this.addItem(targetComponent, item);
		this.removeItem(sourceComponent, item);
	},
	
	removeItem : function(component, item) {
		var items = component.shuttleItems;
		component.selectedItems.remove(item._node);
		items.remove(item);
		if (item == component.activeItem) {
			component.activeItem == null;
		}
	},
	
	addItem : function(component, item) {
		//var newItem = Object.clone(item);
		Richfaces.SelectItems.doNormal(item._node, component.CLASSES);
		component.shuttleTbody.insertBefore(item._node, null);
		component.shuttleItems.push(item);
	},
	
	saveState : function() {
		this.targetList.saveState();
		this.sourceList.saveState();
	},
	
	moveItemByClick : function(event, sourceComponent, targetComponent, layoutManager) {
		var item = this.sourceList.getEventTargetRow(event);
		this.moveItem(sourceComponent, targetComponent, item);
		
		this.controlListManager();
		this.targetList.controlListManager();
		this.saveState();
		
		this.targetLayoutManager.widthSynchronization();
		this.sourceLayoutManager.widthSynchronization();
	}
	
}

Richfaces.ListShuttle.HANDLERS = {
	copy:      function (e) { this.moveItems(this.sourceList, this.targetList, this.sourceList.selectedItems); return false; },
	copyAll:   function (e) { this.moveItems(this.sourceList, this.targetList, this.sourceList.shuttleItems); return false; },
	remove:    function (e) { this.moveItems(this.targetList, this.sourceList, this.targetList.selectedItems); return false; },
	removeAll: function (e) { this.moveItems(this.targetList, this.sourceList, this.targetList.shuttleItems); return false; }
};