if(!window.Richfaces) var Richfaces = function(){};


Richfaces.SelectItems = {
	
	doActive : function(row, classes) {
		var newRowStyle = classes.ROW.ACTIVE;
		var newCellStyle = classes.CELL.ACTIVE;
		if (Element.hasClassName(row, classes.ROW.SELECTED)) {
			newRowStyle = classes.ROW.ACTIVE_SELECTED;
			newCellStyle = classes.CELL.ACTIVE_SELECTED;
		}
		Richfaces.SelectItems.doChange(row, newRowStyle, newCellStyle,
			classes.CELL.BEGIN, classes.CELL.END);
	},
	
	doSelect : function(row, classes) {
		Richfaces.SelectItems
				 .doChange(row, 
						   classes.ROW.SELECTED, 
						   classes.CELL.SELECTED);
	},
	
	doNormal : function(row, classes) {
		Richfaces.SelectItems
				 .doChange(row, 
						   classes.ROW.NORMAL, 
						   classes.CELL.NORMAL);
	},
	
	isSelected : function(row, classes) {
		return Richfaces.SelectItems.compareStates(row, classes.ROW.SELECTED);
	},
	
	isActive : function(row, classes) {
		return Richfaces.SelectItems.compareStates(row, classes.ROW.ACTIVE);
	},
	
	doChange : function(row, classNameRow, classNameCell, classNameCellBegin, classNameCellEnd) {
		Richfaces.SelectItems.doChangeNode(row, classNameRow);
		var cells = row.cells;
		for (var i = 0; i < cells.length; i++) {
			var cell = cells[i];
			var clazz = classNameCell;
			if (classNameCellEnd && (cells.length - 1) == i) {
				clazz += " " + classNameCellEnd;
			}
			if (classNameCellBegin && 0 == i){
				clazz += " " + classNameCellBegin;
			}
			Richfaces.SelectItems.doChangeNode(cell, clazz);
		}
	},
	
	doChangeNode : function(node, className) {
		node.className = className;
	},
	
	compareStates : function(row, className) {
		if (row.className.indexOf(className) != -1) {
			return true;
		}
		return false;
	}
}

Richfaces.SelectItem = Class.create();
Richfaces.SelectItem.prototype = {
	initialize : function(label, id, selected, node) {
		this._label = label;
		this._node = node; 
		this._node.item = this;
		this._id = id;
		this._selected = selected;
		
		//TODO 2 optimize
		this.input = $(node.id + "StateInput");
	}
}
