/**
 * License Agreement.
 *
 *  JBoss RichFaces 3.0 - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.model.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;

import org.ajax4jsf.util.ELUtils;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;
/**
 * 
 * class responsible for packaging objects with their properties evaluated using EL.
 * 
 * @author Maksim Kaszynski
 *
 */
class ObjectWrapperFactory {

	interface ObjectConvertor {
		public Object convert(Object o);
	}
	
	private Expression [] expressions;
	private FacesContext context;
	private String var;
	private Object varValue;
	
	public ObjectWrapperFactory(FacesContext context, final String var, SortOrder sortOrder) {
		
		this.context = context;
		
		Application application = context.getApplication();
		PropertyResolver resolver = application.getPropertyResolver();

		this.var = var;
		
		SortField[] sortFields = sortOrder.getFields();
		
		expressions = new Expression[sortFields.length];
		                             
		for (int i = 0; i < sortFields.length; i++) {
			final SortField field = sortFields[i];
			final String name = field.getName();
			
			if (ELUtils.isValueReference(name)) {
				
				expressions[i] = new ValueBindingExpression(context, name, var);
				
			} else if (name.startsWith(UIViewRoot.UNIQUE_ID_PREFIX)) {
				
				expressions[i] = new NullExpression(name);
				
			} else {
				
				expressions[i] = new SimplePropertyExpression(name, resolver);
			}
		}
		
		
		
	}
	
	void convertList(List list, ObjectConvertor c) {
		int l = list.size();

		for (int i = 0; i < l; i++) {
			Object o = list.get(i);
			list.set(i, c.convert(o));
		}
	}
	
	public List unwrapList(List list) {
		
		convertList(list, new ObjectConvertor() {
			public Object convert(Object o) {
				return unwrapObject(o);
			}
		});
		
		if (varValue != null){
			context.getExternalContext().getRequestMap().put(var, varValue);
		} else {
			context.getExternalContext().getRequestMap().remove(var);
		}
		
		return list;
	}
	
	public Object unwrapObject(Object wrapper) {
		return ((JavaBeanWrapper) wrapper).getWrappedObject();
	}
	
	public List wrapList(List list) {
		
		varValue = context.getExternalContext().getRequestMap().get(var);
		
		convertList(list, new ObjectConvertor() {
			public Object convert(Object o) {
				return wrapObject(o);
			}
		});
		
		return list;
	}
	
	public JavaBeanWrapper wrapObject(Object o) {
		Map props = new HashMap();
		for (int i = 0; i < expressions.length; i++) {
			Expression expression = expressions[i];
			
			props.put(expression.getExpressionString(), expression.evaluate(o));
		}
		
		return new JavaBeanWrapper(o, props);
		
	}
	
}