/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.component;

import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;


/** JSF component class */
//xxxx nick -> alex - extend UIComponentBase and
//create event listener & event classes to define PageSwitchEvent
//public abstract class UIDatascroller extends UIComponentBase implements DataScrollerSource{
public abstract class UIDatascroller extends AjaxActionComponent
        implements DataScrollerSource, ActionSource {

    public static final String COMPONENT_TYPE = "org.richfaces.Datascroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.Datascroller";

    public static final String FIRST_FACET_NAME = "first";

    public static final String LAST_FACET_NAME = "last";

    public static final String NEXT_FACET_NAME = "next";

    public static final String PREVIOUS_FACET_NAME = "previous";

    public static final String FAST_FORWARD_FACET_NAME = "fastforward";

    public static final String FAST_REWIND_FACET_NAME = "fastrewind";


    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";

    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";

    public static final String NEXT_DISABLED_FACET_NAME = "next_disabled";

    public static final String PREVIOUS_DISABLED_FACET_NAME
            = "previous_disabled";

    public static final String FAST_FORWARD_DISABLED_FACET_NAME
            = "fastforward_disabled";

    public static final String FAST_REWIND_DISABLED_FACET_NAME
            = "fastrewind_disabled";

    public void addScrollerListener(DataScrollerListener listener) {
        addFacesListener(listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[]) getFacesListeners(
                DataScrollerListener.class);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        removeFacesListener(listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent) event;
            setPage(dataScrollerEvent.getNewScrolVal());

            FacesContext context = FacesContext.getCurrentInstance();
            AjaxRendererUtils.addRegionByName(context, this, this.getId());
            AjaxRendererUtils.addRegionByName(context, this, this.getFor());

            setupReRender(context);
            
            MethodBinding scrollerListener = getScrollerListener();
            if (scrollerListener != null) {
                scrollerListener.invoke(context, new Object[]{event});
            }
        }
    }

    public abstract MethodBinding getScrollerListener();

    public abstract void setScrollerListener(MethodBinding scrollerListener);

    public abstract void setFor(String f);

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract void setFastStep(int FastStep);

    public abstract boolean isRenderIfSinglePage();

    public abstract void setRenderIfSinglePage(boolean renderIfSinglePage);

    public abstract int getMaxPages();

    public abstract void setMaxPages(int maxPages);

    public abstract String getSelectedStyleClass();

    public abstract void setSelectedStyleClass(String selectedStyleClass);

    public abstract String getSelectedStyle();

    public abstract void setSelectedStyle(String selectedStyle);

    public abstract String getEventsQueue();

    public abstract void setEventsQueue(String eventsQueue);

    public abstract boolean isAjaxSingle();

    public abstract void setAjaxSingle(boolean ajaxSingle);

    public abstract int getRequestDelay();

    public abstract void setRequestDelay(int requestDelay);

    public abstract String getTableStyleClass();

    public abstract void setTableStyleClass(String tableStyleClass);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String styleClass);

    public abstract void setStyle(String styleClass);

    public abstract String getAlign();

    public abstract void setAlign(String align);

    public abstract String getBoundaryControls();

    public abstract void setBoundaryControls(String boundaryControls);

    public abstract String getFastControls();

    public abstract void setFastControls(String fastControls);

    public abstract String getStepControls();

    public abstract void setStepControls(String stepControls);

    public abstract String getInactiveStyleClass();

    public abstract String getInactiveStyle();

    public abstract void setInactiveStyleClass(String inactiveStyleClass);

    public abstract void setInactiveStyle(String inactiveStyle);
    /**
     * Finds the dataTable which id is mapped to the "for" property
     *
     * @return the dataTable component
     */
    public UIData getDataTable() {
        String forAttribute = getFor();
        UIComponent forComp;
        if (forAttribute == null) {
            forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (forComp instanceof UIData) {
                    setFor(forComp.getId());
                    return (UIData) forComp;
                }
            }
            throw new FacesException(
                    "could not find dataTable for  datascroller " + this.getId());
        } else {
            forComp = RendererUtils.getInstance().findComponentFor(this, forAttribute);
        }
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '"
                                               + forAttribute + "'");
        } else if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException(
                    "component with id '" + forAttribute
                    + "' must be of type " + UIData.class.getName()
                    + ", not type "
                    + forComp.getClass().getName());
        }
        return (UIData) forComp;
    }

    public int getPageIndex(UIData uiData) {
        //xxxx nick -> alex - suppose this.getRows() would be better here
        int rows = getRows(uiData);
        if (0 == rows) {
            throw new FacesException("Missing 'rows' attribute on component '"
                                     + uiData.getId() + "'");
        }

        int pageIndex;
        if (rows > 0) {
            //xxxx nick -> alex - suppose this.getFirst() would be better here
            pageIndex = getFirstRow(uiData) / rows + 1;
        } else {
            //TODO nick -> nick - is it valid if under 0?
            pageIndex = 0;
        }
        if (getFirstRow(uiData) % rows > 0) {
            pageIndex++;
        }
        return pageIndex;
    }

    /**
     * Gets the index of the current page
     *
     * @return the page index
     */
    public int getPageIndex() {
        UIData uiData = getDataTable();
        return getPageIndex(uiData);
    }

    /**
     * Sets the page number according to the parameter recived from the
     * commandLink
     *
     * @param facetName - can be "first:, "last", "next",  "previous",
     * "fastforward", "fastrewind"
     */
    public void setPage(String facetName) {

        UIData dataTable = getDataTable();

        // check if facet is selected
        if (FIRST_FACET_NAME.equals(facetName)) {
            setFirstRow(0);
            dataTable.setFirst(0);
        } else if (PREVIOUS_FACET_NAME.equals(facetName)) {
            int previous = dataTable.getFirst() - getRows(dataTable);
            if (previous >= 0) {
                setFirstRow(previous);
            }
        } else if (NEXT_FACET_NAME.equals(facetName)) {
            int rows = getRows(dataTable);
            int next = dataTable.getFirst() + rows;
            if (next < getRowCount(dataTable)) {
                setFirstRow(next);
            }
            //if (rows>0){
            //	 if (((next+rows)/rows)>getMaxPages()){
            //		next=getMaxPages()*rows-rows;;
            //	 }
            //}
        } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
            int fastStep = getFastStep();
            int rows = getRows(dataTable);
            if (fastStep <= 0) {
                fastStep = 1;
            }
            int next = dataTable.getFirst() + rows * fastStep;
            int rowcount = getRowCount(dataTable);
            if (next >= rowcount) {
                next = (rowcount - 1) - ((rowcount - 1) % rows);
            }
            //if (rows>0){
            // if (((next+rows)/rows)>getMaxPages()){
            //	next=getMaxPages()*rows-rows;;
            //}
            //}
            setFirstRow(next);
        } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
            int fastStep = getFastStep();
            if (fastStep <= 0) {
                fastStep = 1;
            }
            int previous = dataTable.getFirst() - getRows(dataTable) * fastStep;
            if (previous < 0) {
                previous = 0;
            }
            setFirstRow(previous);
        } else if (LAST_FACET_NAME.equals(facetName)) {
            int rowcount = getRowCount(dataTable);
            int rows = getRows(dataTable);
            int delta = rowcount % rows;
            int first = delta > 0 && delta < rows ? rowcount - delta : rowcount
                                                                       - rows;
            if (first >= 0) {
                //if (rows>0){
                //if (((first+rows)/rows)>getMaxPages()){
                //	first=getMaxPages()*rows-rows;
                //}
                //}
                setFirstRow(first);
            } else {
                setFirstRow(0);
            }
        }
        // the paginator is selected
        else {
            int pageindex = Integer.parseInt(facetName);
            int pageCount = getPageCount(dataTable);
            if (pageindex > pageCount) {
                pageindex = pageCount;
            } else if (pageindex <= 0) {
                pageindex = 1;
            }
            setFirstRow(getRows(dataTable) * (pageindex - 1));
        }

    }

    public int getPageCount(UIData data) {
        int rows = getRows(data);
        int pageCount;
        if (rows > 0) {
            int rowCount = getRowCount(data);
            pageCount = rows <= 0 ? 1 : rowCount / rows;
            if (rowCount % rows > 0) {
                pageCount++;
            }
            if (pageCount == 0) {
                pageCount = 1;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    /** @return the page count of the uidata */
    public int getPageCount() {
        return getPageCount(getDataTable());
    }

    public int getRowCount(UIData data) {
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            return rowCount;
        }

        return BinarySearch.search(data);
    }

    /** @return int */
    public int getRowCount() {
        //xxx nick -> alex - scrollable models can return -1 here
        //let's implement "dychotomic" discovery
        // setPage(1)... if isPageAvailable() setPage(2) then 4, 8, etc.
        // setPage() { setRowIndex(pageIdx * rows); }
        // isPageAvailable() { return isRowAvailable() }
        //return getUIData().getRowCount();
        return getRowCount(getDataTable());
    }

    public int getRows(UIData data) {
        int row = 0;
        row = data.getRows();
        if (row == 0) {
            row = getRowCount(data);
        }

        return row;
    }

    // facet getter methods
    public UIComponent getFirst() {
        return getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return getFacet(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return getFacet(NEXT_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return getFacet(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return getFacet(FAST_REWIND_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return getFacet(PREVIOUS_FACET_NAME);
    }

    public int getFirstRow(UIData data) {
        return data.getFirst();
    }

    public void setFirstRow(int rows) {
        getDataTable().setFirst(rows);
        //setControls();
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    static class BinarySearch {

        public static int search(UIData data) {
            int rowIndex = data.getRowIndex();
            try {
                int n = 1;
                int k = 2;
                for (; ;) {
                    data.setRowIndex(k - 1);
                    if (data.isRowAvailable()) {
                        n = k;
                        k = k * 2;
                    } else {
                        break;
                    }
                }

                while (n < k) {
                    int kk = Math.round((n + k) / 2) + 1;
                    data.setRowIndex(kk - 1);
                    if (data.isRowAvailable()) {
                        n = kk;
                    } else {
                        k = kk - 1;
                    }
                }

                data.setRowIndex(k - 1);
                if (data.isRowAvailable()) {
                    return k;
                } else {
                    return 0;
                }
            } finally {
                data.setRowIndex(rowIndex);
            }
        }
    }
}
