/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.ValueChangeEvent;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.CurrentDateChangeEvent;
import org.richfaces.event.CurrentDateChangeListener;
import org.richfaces.model.CalendarDataModel;
import org.richfaces.model.CalendarDataModelItem;
import org.richfaces.renderkit.CalendarRendererBase;

public abstract class UICalendar
extends UIInput
implements AjaxComponent {
    public static final String COMPONENT_TYPE = "org.richfaces.Calendar";
    private static final String COMPONENT_FAMILY = "org.richfaces.Calendar";
    public static final String AJAX_MODE = "ajax";
    public static final String CLIENT_MODE = "client";
    private static final Log log = LogFactory.getLog((Class)(class$org$richfaces$component$UICalendar == null ? (class$org$richfaces$component$UICalendar = UICalendar.class$("org.richfaces.component.UICalendar")) : class$org$richfaces$component$UICalendar));
    static /* synthetic */ Class class$org$richfaces$component$UICalendar;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$org$richfaces$event$CurrentDateChangeListener;

    public abstract Object getLocale();

    public abstract void setLocale(Object var1);

    public abstract TimeZone getTimeZone();

    public abstract void setTimeZone(TimeZone var1);

    public abstract Object getPreloadDateRangeBegin();

    public abstract void setPreloadDateRangeBegin(Object var1);

    public abstract Object getPreloadDateRangeEnd();

    public abstract void setPreloadDateRangeEnd(Object var1);

    public abstract Object getCurrentDate();

    public abstract void setCurrentDate(Object var1);

    public abstract CalendarDataModel getDataModel();

    public abstract void setDataModel(CalendarDataModel var1);

    public abstract String getDatePattern();

    public abstract void setDatePattern(String var1);

    public abstract Object getMonthLabels();

    public abstract void setMonthLabels(Object var1);

    public abstract Object getMonthLabelsShort();

    public abstract void setMonthLabelsShort(Object var1);

    public abstract Object getWeekDayLabels();

    public abstract void setWeekDayLabels(Object var1);

    public abstract Object getWeekDayLabelsShort();

    public abstract void setWeekDayLabelsShort(Object var1);

    public abstract String getJointPoint();

    public abstract void setJointPoint(String var1);

    public abstract String getDirection();

    public abstract void setDirection(String var1);

    public abstract boolean isPopup();

    public abstract void setPopup(boolean var1);

    public abstract boolean isDisabled();

    public abstract void setDisabled(boolean var1);

    public abstract String getButtonLabel();

    public abstract void setButtonLabel(String var1);

    public abstract String getToolTipMode();

    public abstract void setToolTipMode(String var1);

    public abstract String getBoundaryDatesMode();

    public abstract void setBoundaryDatesMode(String var1);

    public abstract MethodBinding getCurrentDateChangeListener();

    public abstract void setCurrentDateChangeListener(MethodBinding var1);

    public abstract String getMode();

    public abstract void setMode(String var1);

    public abstract int getVerticalOffset();

    public abstract void setVerticalOffset(int var1);

    public abstract int getHorizontalOffset();

    public abstract void setHorizontalOffset(int var1);

    public abstract String getDayStyleClass();

    public abstract void setDayStyleClass(String var1);

    public abstract String getIsDayEnabled();

    public abstract void setIsDayEnabled(String var1);

    public abstract String getCellHeight();

    public abstract void setCellHeight(String var1);

    public abstract String getCellWidth();

    public abstract void setCellWidth(String var1);

    public abstract boolean isShowWeekDaysBar();

    public abstract void setShowWeekDaysBar(boolean var1);

    public abstract boolean isShowWeeksBar();

    public abstract void setShowWeeksBar(boolean var1);

    public abstract boolean isShowHeader();

    public abstract void setShowHeader(boolean var1);

    public abstract boolean isShowFooter();

    public abstract void setShowFooter(boolean var1);

    public abstract String getTodayControlMode();

    public abstract void setTodayControlMode(String var1);

    public abstract boolean isShowApplyButton();

    public abstract void setShowApplyButton(boolean var1);

    public Calendar getCalendar() {
        return Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
    }

    public Date getConvertedValue(FacesContext context, String currentDateString) throws ConverterException {
        DateTimeConverter datetime = new DateTimeConverter();
        datetime.setPattern("m/y");
        Date newCurrentDate = (Date)datetime.getAsObject(context, (UIComponent)this, currentDateString);
        return newCurrentDate;
    }

    protected void validateValue(FacesContext context, Object newValue) {
        this.setSubmittedValue(newValue);
        super.validateValue(context, newValue);
    }

    public void updateCurrentDate(FacesContext context, Object currentDate) {
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            ValueBinding vb = this.getValueBinding("currentDate");
            if (vb != null) {
                if (vb.getType(context).equals(class$java$lang$String == null ? (class$java$lang$String = UICalendar.class$("java.lang.String")) : class$java$lang$String)) {
                    DateTimeConverter convert = new DateTimeConverter();
                    convert.setLocale(this.getAsLocale(this.getLocale()));
                    convert.setPattern(this.getDatePattern());
                    vb.setValue(context, (Object)convert.getAsString(context, (UIComponent)this, currentDate));
                    return;
                }
                if (vb.getType(context).equals(class$java$util$Calendar == null ? (class$java$util$Calendar = UICalendar.class$("java.util.Calendar")) : class$java$util$Calendar)) {
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)currentDate);
                    vb.setValue(context, (Object)c);
                    return;
                }
                vb.setValue(context, currentDate);
                return;
            }
            this.setCurrentDate(currentDate);
        }
        catch (Exception e) {
            this.setValid(false);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" updateCurrentDate method throws exception: " + e.toString()), (Throwable)e);
            }
            e.printStackTrace();
            String messageString = e.toString();
            FacesMessage message = new FacesMessage(messageString);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
        }
    }

    public Date getCurrentDateOrDefault() {
        Date date = this.getAsDate(this.getCurrentDate());
        if (date != null) {
            return date;
        }
        Date value = this.getAsDate(this.getValue());
        if (value != null) {
            return value;
        }
        return Calendar.getInstance(this.getTimeZone()).getTime();
    }

    public Date getAsDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date instanceof String) {
            DateTimeConverter converter = new DateTimeConverter();
            converter.setPattern(this.getDatePattern());
            converter.setLocale(this.getAsLocale(this.getLocale()));
            converter.setTimeZone(this.getTimeZone());
            FacesContext context = FacesContext.getCurrentInstance();
            return (Date)converter.getAsObject(context, (UIComponent)this, (String)date);
        }
        if (date instanceof Calendar) {
            return ((Calendar)date).getTime();
        }
        throw new FacesException("Wrong attibute type");
    }

    public Object getTooltip(Date date) {
        CalendarDataModel calendarDM = this.getDataModel();
        if (calendarDM != null) {
            return calendarDM.getToolTip(date);
        }
        return null;
    }

    protected Date getDefaultPreloadBegin(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    protected Date getDefaultPreloadEnd(Date date) {
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    protected Locale getDefaultLocale() {
        Locale locale;
        UIViewRoot viewRoot;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (viewRoot = facesContext.getViewRoot()) != null && (locale = viewRoot.getLocale()) != null) {
            return locale;
        }
        return Locale.US;
    }

    protected TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    public Date convertCurrentDate(String currentDateString) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, 1);
        int idx = currentDateString.indexOf(47);
        if (idx != -1) {
            calendar.set(2, Integer.parseInt(currentDateString.substring(0, idx)) - 1);
            calendar.set(1, Integer.parseInt(currentDateString.substring(idx + 1)));
            return calendar.getTime();
        }
        return null;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof AjaxEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
            ajaxContext.addRegionsFromComponent((UIComponent)this);
            if (this.getPreload() != null) {
                ajaxContext.setResponseData(this.getPreload());
            }
        } else if (event instanceof CurrentDateChangeEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            CurrentDateChangeEvent dateChangeEvent = (CurrentDateChangeEvent)event;
            String currentDateString = dateChangeEvent.getCurrentDateString();
            if (currentDateString != null) {
                try {
                    Date currentDate = this.convertCurrentDate(currentDateString);
                    CurrentDateChangeEvent newDateChangeEvent = new CurrentDateChangeEvent((UIComponent)this, currentDate);
                    newDateChangeEvent.queue();
                    MethodBinding binding = this.getCurrentDateChangeListener();
                    if (binding != null) {
                        binding.invoke(facesContext, new Object[]{event});
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" currentDate convertion fails with following exception: " + e.toString()), (Throwable)e);
                    }
                    this.setValid(false);
                    String messageString = e.toString();
                    e.printStackTrace();
                    FacesMessage message = new FacesMessage(messageString);
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    facesContext.addMessage(this.getClientId(facesContext), message);
                    facesContext.renderResponse();
                }
            } else {
                Date currentDate2;
                Date currentDate1 = dateChangeEvent.getCurrentDate();
                if (!currentDate1.equals(currentDate2 = this.getAsDate(this.getCurrentDate()))) {
                    this.updateCurrentDate(facesContext, currentDate1);
                    ValueChangeEvent changeEvent = new ValueChangeEvent((UIComponent)this, (Object)currentDate2, (Object)currentDate1);
                    changeEvent.queue();
                }
            }
        } else {
            super.broadcast(event);
        }
    }

    public Object getPreload() {
        CalendarDataModel calendarDataModel;
        Date[] preloadDateRange = this.getPreloadDateRange();
        if (preloadDateRange != null && preloadDateRange.length != 0 && (calendarDataModel = this.getDataModel()) != null) {
            CalendarDataModelItem[] calendarDataModelItems = calendarDataModel.getData(preloadDateRange);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("startDate", CalendarRendererBase.formatDate(preloadDateRange[0]));
            args.put("days", calendarDataModelItems);
            return args;
        }
        return null;
    }

    public Date[] getPreloadDateRange() {
        Date dateRangeBegin = this.getAsDate(this.getPreloadDateRangeBegin());
        Date dateRangeEnd = this.getAsDate(this.getPreloadDateRangeEnd());
        if (dateRangeBegin == null && dateRangeEnd == null) {
            return null;
        }
        if (dateRangeBegin.after(dateRangeEnd)) {
            FacesMessage message = new FacesMessage("preloadDateRangeBegin is greater than preloadDateRangeEnd");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            FacesContext context = FacesContext.getCurrentInstance();
            context.addMessage(this.getClientId(context), message);
            throw new IllegalArgumentException();
        }
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance(this.getTimeZone(), this.getAsLocale(this.getLocale()));
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar.setTime(dateRangeBegin);
        calendar2.setTime(dateRangeEnd);
        do {
            dates.add(calendar.getTime());
            calendar.add(5, 1);
        } while (!calendar.after(calendar2));
        return dates.toArray(new Date[dates.size()]);
    }

    public void addCurrentDateChangeListener(CurrentDateChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public CurrentDateChangeListener[] getCurrentDateChangeListeners() {
        return (CurrentDateChangeListener[])this.getFacesListeners(class$org$richfaces$event$CurrentDateChangeListener == null ? (class$org$richfaces$event$CurrentDateChangeListener = UICalendar.class$("org.richfaces.event.CurrentDateChangeListener")) : class$org$richfaces$event$CurrentDateChangeListener);
    }

    public void removeCurrentDateChangeListener(CurrentDateChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public Locale parseLocale(String localeStr) {
        int length = localeStr.length();
        if (null == localeStr || length < 2) {
            return Locale.getDefault();
        }
        int index1 = localeStr.indexOf("_");
        String language = null;
        if (index1 == -1) {
            return new Locale(localeStr);
        }
        language = localeStr.substring(0, index1);
        int index2 = localeStr.indexOf("_", index1 + 1);
        String country = null;
        if (index2 != -1) {
            country = localeStr.substring(index1 + 1, index2);
            String variant = localeStr.substring(index2 + 1);
            return new Locale(language, country, variant);
        }
        country = localeStr.substring(index1 + 1);
        return new Locale(language, country);
    }

    public Locale getAsLocale(Object locale) {
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return this.parseLocale((String)locale);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        Converter converter = application.createConverter(locale.getClass());
        if (null != converter) {
            return this.parseLocale(converter.getAsString(context, (UIComponent)this, locale));
        }
        throw new FacesException("Wrong locale attibute type or there is no converter for custom attibute type");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String getFocus();

    public abstract /* synthetic */ void setFocus(String var1);

    public abstract /* synthetic */ void setTimeout(int var1);

    public abstract /* synthetic */ int getTimeout();

    public abstract /* synthetic */ void setRequestDelay(int var1);

    public abstract /* synthetic */ int getRequestDelay();

    public abstract /* synthetic */ void setEventsQueue(String var1);

    public abstract /* synthetic */ boolean isIgnoreDupResponses();

    public abstract /* synthetic */ void setIgnoreDupResponses(boolean var1);

    public abstract /* synthetic */ String getEventsQueue();

    public abstract /* synthetic */ void setBypassUpdates(boolean var1);

    public abstract /* synthetic */ boolean isBypassUpdates();

    public abstract /* synthetic */ boolean isAjaxSingle();

    public abstract /* synthetic */ void setAjaxSingle(boolean var1);

    public abstract /* synthetic */ boolean isLimitToList();

    public abstract /* synthetic */ void setLimitToList(boolean var1);

    public abstract /* synthetic */ Object getData();

    public abstract /* synthetic */ void setData(Object var1);

    public abstract /* synthetic */ void setOnbeforedomupdate(String var1);

    public abstract /* synthetic */ String getOnbeforedomupdate();

    public abstract /* synthetic */ String getOncomplete();

    public abstract /* synthetic */ void setOncomplete(String var1);

    public abstract /* synthetic */ String getStatus();

    public abstract /* synthetic */ void setStatus(String var1);

    public abstract /* synthetic */ Object getReRender();

    public abstract /* synthetic */ void setReRender(Object var1);
}

