/**
 * 
 */
package org.richfaces.renderkit.html;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/**
 * @author Anton Belevich
 *
 */
public abstract class ExtendedColumnVisitor implements ColumnVisitor {

	/* (non-Javadoc)
	 * @see org.richfaces.renderkit.html.ColumnVisitor#visit(javax.faces.context.FacesContext, org.richfaces.component.UIScrollableGridColumn, javax.faces.context.ResponseWriter, org.richfaces.renderkit.html.ScrollableDataTableRendererState)
	 */
	public int visit(FacesContext context, UIComponent column,
			ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException {
		
		if(state.isFrozenColumn()){
			int i = state.getFrozenColumnCount();
			state.setFrozenColumnCount(i-1);
			if(state.isFrozenPart()){
				renderContent(context, column, writer,state);
			}
		}else if(!state.isFrozenPart() && !state.isFrozenColumn()){
			renderContent(context, column, writer,state);
		}
			
		return 1;
	};
	
	 abstract public void renderContent(FacesContext context, UIComponent column,ResponseWriter writer, ScrollableDataTableRendererState state) throws IOException;
}
