package org.ajax4jsf.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.UIAjaxRegion;

public class HtmlAjaxRegion extends UIAjaxRegion{

public final static  String COMPONENT_FAMILY = "org.ajax4jsf.AjaxRegion";

public final static  String COMPONENT_TYPE = "org.ajax4jsf.AjaxRegion";

/*
* Flag to disable rendering in AJAX responses content
				outside of active region. If this attribute set to
				"true" , no one of the components outside of region will
				be included to AJAX response. If set to "false", search
				for components to include in response will be performed
				on all tree. Default "false"
*/
private  boolean _renderRegionOnly = false;

private  boolean _renderRegionOnlySet = false;


public HtmlAjaxRegion(){
setRendererType("org.ajax4jsf.components.AjaxRegionRenderer");
}

public boolean isRenderRegionOnly(){
	if (this._renderRegionOnlySet) {
	    return (this._renderRegionOnly);
	}
	ValueExpression ve = getValueExpression("renderRegionOnly");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._renderRegionOnly);
	    }
	    
	    return value;
	} else {
	    return (this._renderRegionOnly);
	}

}

public void setRenderRegionOnly(boolean _renderRegionOnly){
this._renderRegionOnly = _renderRegionOnly;
this._renderRegionOnlySet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[3];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_renderRegionOnly);
state[2] = Boolean.valueOf(_renderRegionOnlySet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_renderRegionOnly = ((Boolean)states[1]).booleanValue();
		_renderRegionOnlySet = ((Boolean)states[2]).booleanValue();
	
}

}
