package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIDataFltrSlider;

public class HtmlDataFilterSlider extends UIDataFltrSlider{

public final static  String COMPONENT_FAMILY = "org.richfaces.DataFilterSlider";

public final static  String COMPONENT_TYPE = "org.richfaces.DataFilterSlider";

/*
* MethodBinding pointing at the application action to be invoked,
            if this UIComponent is activated by you, during the Apply
            Request Values or Invoke Application phase of the request
            processing lifecycle, depending on the value of the immediate
            property
*/
private  MethodBinding _action = null;

/*
* MethodBinding pointing at method accepting  an ActionEvent with return type void
*/
private  MethodBinding _actionListener = null;

/*
* if "true", submits ONLY one field/link, instead of all form controls
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* An error message to use in client side validation events
*/
private  String _clientErrorMessage = null;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* A slider end point
*/
private  Integer _endRange = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* The styleClass for input that displays the value : 'manualInput' must
                be true
*/
private  String _fieldStyleClass = null;

/*
* A getter of an object member required to compare a slider value to. This is a
                value that is used in results filtering
*/
private  String _filterBy = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* The component using UIData (datatable id)
*/
private  String _for = null;

/*
* This is a string which is used in a value attribute of the datatable. It is used for resetting
                the datatable back to the original list provided by a backing bean
*/
private  String _forValRef = null;

/*
* The handleStyleClass for a handle
*/
private  String _handleStyleClass = null;

/*
* Current handle value
*/
private  Integer _handleValue = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* True means, that the default ActionListener should be executed
            immediately (i.e. during Apply Request Values phase of the
            request processing lifecycle), rather than waiting until the
            Invoke Application phase
*/
private  boolean _immediate = false;

private  boolean _immediateSet = false;

/*
* Amount to which a handle on each slide/move should be incremented
*/
private  Integer _increment = null;

/*
* If "true", updates on client side ONLY elements from this 'reRender' property. If "false" (default) updates all rendered by ajax region components
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* False value for this attribute makes text field "read-only" and "hidden".
                Hence, the value can be changed only from a handle
*/
private  boolean _manualInput = true;

private  boolean _manualInputSet = false;

/*
* If the slider value changes must submit a form,  onSlideSubmit can be true
*/
private  boolean _onSlideSubmit = true;

private  boolean _onSlideSubmitSet = false;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* Event occur on chage
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; event fires whenever an JavaScript error occurs
*/
private  String _onerror = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* Event occur on sliding
*/
private  String _onslide = null;

/*
* The rangeStyleClass for the background div showing a full range
*/
private  String _rangeStyleClass = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* MethodBinding representing an action listener method that will be notified after changing of slider control position
*/
private  MethodBinding _sliderListener = null;

/*
* A slider begin point
*/
private  Integer _startRange = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* Specifies if the component will store a UIData object (your table rows) in session
*/
private  boolean _storeResults = false;

private  boolean _storeResultsSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* The styleClass for the container div surrounding the component
*/
private  String _styleClass = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* The trackStyleClass for a background div
*/
private  String _trackStyleClass = null;

/*
* It shows or hides a trailer following a handle
*/
private  boolean _trailer = false;

private  boolean _trailerSet = false;

/*
* The trailerStyleClass for a div following a handle
*/
private  String _trailerStyleClass = null;

/*
* The current value for this component
*/
private  Object _value = null;

/*
* Width of the slider control
*/
private  String _width = null;


public HtmlDataFilterSlider(){
setRendererType("org.richfaces.DataFilterSliderRenderer");
}

public MethodBinding getAction(){
	if (this._action != null) {
		return this._action;
	}
	ValueExpression ve = getValueExpression("action");
	if (ve != null) {
	    MethodBinding value = null;
	    
	    try {
			value = (MethodBinding) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAction(MethodBinding _action){
this._action = _action;
}

public MethodBinding getActionListener(){
return _actionListener;
}

public void setActionListener(MethodBinding _actionListener){
this._actionListener = _actionListener;
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public String getClientErrorMessage(){
	if (this._clientErrorMessage != null) {
		return this._clientErrorMessage;
	}
	ValueExpression ve = getValueExpression("clientErrorMessage");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClientErrorMessage(String _clientErrorMessage){
this._clientErrorMessage = _clientErrorMessage;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public Integer getEndRange(){
	if (this._endRange != null) {
		return this._endRange;
	}
	ValueExpression ve = getValueExpression("endRange");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEndRange(Integer _endRange){
this._endRange = _endRange;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFieldStyleClass(){
	if (this._fieldStyleClass != null) {
		return this._fieldStyleClass;
	}
	ValueExpression ve = getValueExpression("fieldStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFieldStyleClass(String _fieldStyleClass){
this._fieldStyleClass = _fieldStyleClass;
}

public String getFilterBy(){
	if (this._filterBy != null) {
		return this._filterBy;
	}
	ValueExpression ve = getValueExpression("filterBy");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFilterBy(String _filterBy){
this._filterBy = _filterBy;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getFor(){
	if (this._for != null) {
		return this._for;
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFor(String _for){
this._for = _for;
}

public String getForValRef(){
	if (this._forValRef != null) {
		return this._forValRef;
	}
	ValueExpression ve = getValueExpression("forValRef");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setForValRef(String _forValRef){
this._forValRef = _forValRef;
}

public String getHandleStyleClass(){
	if (this._handleStyleClass != null) {
		return this._handleStyleClass;
	}
	ValueExpression ve = getValueExpression("handleStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHandleStyleClass(String _handleStyleClass){
this._handleStyleClass = _handleStyleClass;
}

public Integer getHandleValue(){
	if (this._handleValue != null) {
		return this._handleValue;
	}
	ValueExpression ve = getValueExpression("handleValue");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHandleValue(Integer _handleValue){
this._handleValue = _handleValue;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public boolean isImmediate(){
	if (this._immediateSet) {
	    return (this._immediate);
	}
	ValueExpression ve = getValueExpression("immediate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediate);
	    }
	    
	    return value;
	} else {
	    return (this._immediate);
	}

}

public void setImmediate(boolean _immediate){
this._immediate = _immediate;
this._immediateSet = true;
}

public Integer getIncrement(){
	if (this._increment != null) {
		return this._increment;
	}
	ValueExpression ve = getValueExpression("increment");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setIncrement(Integer _increment){
this._increment = _increment;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public boolean isManualInput(){
	if (this._manualInputSet) {
	    return (this._manualInput);
	}
	ValueExpression ve = getValueExpression("manualInput");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._manualInput);
	    }
	    
	    return value;
	} else {
	    return (this._manualInput);
	}

}

public void setManualInput(boolean _manualInput){
this._manualInput = _manualInput;
this._manualInputSet = true;
}

public boolean isOnSlideSubmit(){
	if (this._onSlideSubmitSet) {
	    return (this._onSlideSubmit);
	}
	ValueExpression ve = getValueExpression("onSlideSubmit");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._onSlideSubmit);
	    }
	    
	    return value;
	} else {
	    return (this._onSlideSubmit);
	}

}

public void setOnSlideSubmit(boolean _onSlideSubmit){
this._onSlideSubmit = _onSlideSubmit;
this._onSlideSubmitSet = true;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnslide(){
	if (this._onslide != null) {
		return this._onslide;
	}
	ValueExpression ve = getValueExpression("onslide");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnslide(String _onslide){
this._onslide = _onslide;
}

public String getRangeStyleClass(){
	if (this._rangeStyleClass != null) {
		return this._rangeStyleClass;
	}
	ValueExpression ve = getValueExpression("rangeStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRangeStyleClass(String _rangeStyleClass){
this._rangeStyleClass = _rangeStyleClass;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public MethodBinding getSliderListener(){
return _sliderListener;
}

public void setSliderListener(MethodBinding _sliderListener){
this._sliderListener = _sliderListener;
}

public Integer getStartRange(){
	if (this._startRange != null) {
		return this._startRange;
	}
	ValueExpression ve = getValueExpression("startRange");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStartRange(Integer _startRange){
this._startRange = _startRange;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public boolean isStoreResults(){
	if (this._storeResultsSet) {
	    return (this._storeResults);
	}
	ValueExpression ve = getValueExpression("storeResults");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._storeResults);
	    }
	    
	    return value;
	} else {
	    return (this._storeResults);
	}

}

public void setStoreResults(boolean _storeResults){
this._storeResults = _storeResults;
this._storeResultsSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getTrackStyleClass(){
	if (this._trackStyleClass != null) {
		return this._trackStyleClass;
	}
	ValueExpression ve = getValueExpression("trackStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTrackStyleClass(String _trackStyleClass){
this._trackStyleClass = _trackStyleClass;
}

public boolean isTrailer(){
	if (this._trailerSet) {
	    return (this._trailer);
	}
	ValueExpression ve = getValueExpression("trailer");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._trailer);
	    }
	    
	    return value;
	} else {
	    return (this._trailer);
	}

}

public void setTrailer(boolean _trailer){
this._trailer = _trailer;
this._trailerSet = true;
}

public String getTrailerStyleClass(){
	if (this._trailerStyleClass != null) {
		return this._trailerStyleClass;
	}
	ValueExpression ve = getValueExpression("trailerStyleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTrailerStyleClass(String _trailerStyleClass){
this._trailerStyleClass = _trailerStyleClass;
}

public Object getValue(){
	if (this._value != null) {
		return this._value;
	}
	ValueExpression ve = getValueExpression("value");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setValue(Object _value){
this._value = _value;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200px";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[63];
state[0] = super.saveState(context);
state[1] = saveAttachedState(context, _action);
state[2] = saveAttachedState(context, _actionListener);
state[3] = Boolean.valueOf(_ajaxSingle);
state[4] = Boolean.valueOf(_ajaxSingleSet);
state[5] = Boolean.valueOf(_bypassUpdates);
state[6] = Boolean.valueOf(_bypassUpdatesSet);
state[7] = _clientErrorMessage;
state[8] = saveAttachedState(context, _data);
state[9] = _endRange;
state[10] = _eventsQueue;
state[11] = _fieldStyleClass;
state[12] = _filterBy;
state[13] = _focus;
state[14] = _for;
state[15] = _forValRef;
state[16] = _handleStyleClass;
state[17] = _handleValue;
state[18] = Boolean.valueOf(_ignoreDupResponses);
state[19] = Boolean.valueOf(_ignoreDupResponsesSet);
state[20] = Boolean.valueOf(_immediate);
state[21] = Boolean.valueOf(_immediateSet);
state[22] = _increment;
state[23] = Boolean.valueOf(_limitToList);
state[24] = Boolean.valueOf(_limitToListSet);
state[25] = Boolean.valueOf(_manualInput);
state[26] = Boolean.valueOf(_manualInputSet);
state[27] = Boolean.valueOf(_onSlideSubmit);
state[28] = Boolean.valueOf(_onSlideSubmitSet);
state[29] = _onbeforedomupdate;
state[30] = _onchange;
state[31] = _onclick;
state[32] = _oncomplete;
state[33] = _ondblclick;
state[34] = _onerror;
state[35] = _onkeydown;
state[36] = _onkeypress;
state[37] = _onkeyup;
state[38] = _onmousedown;
state[39] = _onmousemove;
state[40] = _onmouseout;
state[41] = _onmouseover;
state[42] = _onmouseup;
state[43] = _onslide;
state[44] = _rangeStyleClass;
state[45] = saveAttachedState(context, _reRender);
state[46] = Integer.valueOf(_requestDelay);
state[47] = Boolean.valueOf(_requestDelaySet);
state[48] = saveAttachedState(context, _sliderListener);
state[49] = _startRange;
state[50] = _status;
state[51] = Boolean.valueOf(_storeResults);
state[52] = Boolean.valueOf(_storeResultsSet);
state[53] = _style;
state[54] = _styleClass;
state[55] = Integer.valueOf(_timeout);
state[56] = Boolean.valueOf(_timeoutSet);
state[57] = _trackStyleClass;
state[58] = Boolean.valueOf(_trailer);
state[59] = Boolean.valueOf(_trailerSet);
state[60] = _trailerStyleClass;
state[61] = saveAttachedState(context, _value);
state[62] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_action = (MethodBinding)restoreAttachedState(context, states[1]);
		_actionListener = (MethodBinding)restoreAttachedState(context, states[2]);
		_ajaxSingle = ((Boolean)states[3]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[4]).booleanValue();
		_bypassUpdates = ((Boolean)states[5]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[6]).booleanValue();
		_clientErrorMessage = (String)states[7];;
		_data = (Object)restoreAttachedState(context, states[8]);
		_endRange = (Integer)states[9];;
		_eventsQueue = (String)states[10];;
		_fieldStyleClass = (String)states[11];;
		_filterBy = (String)states[12];;
		_focus = (String)states[13];;
		_for = (String)states[14];;
		_forValRef = (String)states[15];;
		_handleStyleClass = (String)states[16];;
		_handleValue = (Integer)states[17];;
		_ignoreDupResponses = ((Boolean)states[18]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[19]).booleanValue();
		_immediate = ((Boolean)states[20]).booleanValue();
		_immediateSet = ((Boolean)states[21]).booleanValue();
		_increment = (Integer)states[22];;
		_limitToList = ((Boolean)states[23]).booleanValue();
		_limitToListSet = ((Boolean)states[24]).booleanValue();
		_manualInput = ((Boolean)states[25]).booleanValue();
		_manualInputSet = ((Boolean)states[26]).booleanValue();
		_onSlideSubmit = ((Boolean)states[27]).booleanValue();
		_onSlideSubmitSet = ((Boolean)states[28]).booleanValue();
		_onbeforedomupdate = (String)states[29];;
		_onchange = (String)states[30];;
		_onclick = (String)states[31];;
		_oncomplete = (String)states[32];;
		_ondblclick = (String)states[33];;
		_onerror = (String)states[34];;
		_onkeydown = (String)states[35];;
		_onkeypress = (String)states[36];;
		_onkeyup = (String)states[37];;
		_onmousedown = (String)states[38];;
		_onmousemove = (String)states[39];;
		_onmouseout = (String)states[40];;
		_onmouseover = (String)states[41];;
		_onmouseup = (String)states[42];;
		_onslide = (String)states[43];;
		_rangeStyleClass = (String)states[44];;
		_reRender = (Object)restoreAttachedState(context, states[45]);
		_requestDelay = ((Integer)states[46]).intValue();
		_requestDelaySet = ((Boolean)states[47]).booleanValue();
		_sliderListener = (MethodBinding)restoreAttachedState(context, states[48]);
		_startRange = (Integer)states[49];;
		_status = (String)states[50];;
		_storeResults = ((Boolean)states[51]).booleanValue();
		_storeResultsSet = ((Boolean)states[52]).booleanValue();
		_style = (String)states[53];;
		_styleClass = (String)states[54];;
		_timeout = ((Integer)states[55]).intValue();
		_timeoutSet = ((Boolean)states[56]).booleanValue();
		_trackStyleClass = (String)states[57];;
		_trailer = ((Boolean)states[58]).booleanValue();
		_trailerSet = ((Boolean)states[59]).booleanValue();
		_trailerStyleClass = (String)states[60];;
		_value = (Object)restoreAttachedState(context, states[61]);
		_width = (String)states[62];;
	
}

}
