package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.org.jboss.seam.ui.component.UIFileUpload;

public class HtmlFileUpload extends UIFileUpload{

public final static  String COMPONENT_FAMILY = "org.richfaces.component.FileUpload";

public final static  String COMPONENT_TYPE = "org.richfaces.component.FileUpload";

/*
* Files types allowed to upload
*/
private  String _acceptedTypes = null;

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* CSS style for add button
*/
private  String _addButtonClass = null;

/*
* CSS style for add button disabled
*/
private  String _addButtonClassDisabled = null;

/*
* left|center|right|justify [CI]
            Deprecated. This attribute specifies the horizontal alignment of its element with respect to the surrounding context. Possible values:
            
            * left: text lines are rendered flush left.
            * center: text lines are centered.
            * right: text lines are rendered flush right.
            * justify: text lines are justified to both margins.
            
            The default depends on the base text direction. For left to right text, the default is align=left, while for right to left text, the default is align=right
*/
private  String _align = null;

/*
* For a user agents that cannot display images, forms, or applets, this attribute specifies alternate text. The language of the alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* If this attribute is true files will be immediatelly removed from list after upload completed
*/
private  boolean _autoclear = false;

private  boolean _autoclearSet = false;

/*
* CSS style for cancel button
*/
private  String _cancelButtonClass = null;

/*
* CSS style for cancel button disabled
*/
private  String _cancelButtonClassDisabled = null;

/*
* CSS style for clean button
*/
private  String _cleanButtonClass = null;

/*
* CSS style for clean button disabled
*/
private  String _cleanButtonClassDisabled = null;

/*
* the property to receive the contentType
*/
private  String _contentType = null;

/*
* Disabled attribute
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* CSS style upload file entry
*/
private  String _fileEntryClass = null;

/*
* CSS style upload file entry disabled
*/
private  String _fileEntryClassDisabled = null;

/*
* CSS style for upload enrty control
*/
private  String _fileEntryControlClass = null;

/*
* CSS style for upload enrty control disabled
*/
private  String _fileEntryControlClassDisabled = null;

/*
* this value binding receives the filename (optional).
*/
private  String _fileName = null;

/*
* this value binding receives the file size (optional).
*/
private  Integer _fileSize = null;

/*
* MethodExpression representing an action listener method
				that will be notified after file uploaded.
*/
private  MethodExpression _fileUploadListener = null;

/*
* Defines height of file list
*/
private  String _listHeight = null;

/*
* Defines width of file list
*/
private  String _listWidth = null;

/*
* Defines max files count allowed for upload (optional).
*/
private  Integer _maxFilesQuantity = null;

/*
* When the type attribute has the value "text" or "password", this attribute specifies the maximum number of characters you may enter. This number may exceed the specified size, in which case the user agent should offer a scrolling mechanism. The default value for this attribute is an unlimited number
*/
private  int _maxlength = Integer.MIN_VALUE;

private  boolean _maxlengthSet = false;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* null
*/
private  String _onerror = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; The onselect event occurs when you select some text in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* null
*/
private  String _onupload = null;

/*
* null
*/
private  String _onuploadcanceled = null;

/*
* null
*/
private  String _onuploadcomplete = null;

/*
* Defines bean name where progress info should be stored (optional).
*/
private  String _progressInfo = null;

/*
* This attribute tells the user agent the initial width of the control. The width is given in pixels except when type attribute has the value "text" or "password". In that case, its value refers to the (integer) number of characters
*/
private  int _size = Integer.MIN_VALUE;

private  boolean _sizeSet = false;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* CSS style for upload button
*/
private  String _uploadButtonClass = null;

/*
* CSS style for upload button disabled
*/
private  String _uploadButtonClassDisabled = null;

/*
* Collection of files uploaded
*/
private  Object _uploadData = null;

/*
* CSS style for upload list
*/
private  String _uploadListClass = null;

/*
* CSS style for upload list disabled
*/
private  String _uploadListClassDisabled = null;


public HtmlFileUpload(){
setRendererType("org.richfaces.renderkit.html.FileUploadRenderer");
}

public String getAcceptedTypes(){
	if (this._acceptedTypes != null) {
		return this._acceptedTypes;
	}
	ValueExpression ve = getValueExpression("acceptedTypes");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAcceptedTypes(String _acceptedTypes){
this._acceptedTypes = _acceptedTypes;
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAddButtonClass(){
	if (this._addButtonClass != null) {
		return this._addButtonClass;
	}
	ValueExpression ve = getValueExpression("addButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddButtonClass(String _addButtonClass){
this._addButtonClass = _addButtonClass;
}

public String getAddButtonClassDisabled(){
	if (this._addButtonClassDisabled != null) {
		return this._addButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("addButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddButtonClassDisabled(String _addButtonClassDisabled){
this._addButtonClassDisabled = _addButtonClassDisabled;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public boolean isAutoclear(){
	if (this._autoclearSet) {
	    return (this._autoclear);
	}
	ValueExpression ve = getValueExpression("autoclear");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._autoclear);
	    }
	    
	    return value;
	} else {
	    return (this._autoclear);
	}

}

public void setAutoclear(boolean _autoclear){
this._autoclear = _autoclear;
this._autoclearSet = true;
}

public String getCancelButtonClass(){
	if (this._cancelButtonClass != null) {
		return this._cancelButtonClass;
	}
	ValueExpression ve = getValueExpression("cancelButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelButtonClass(String _cancelButtonClass){
this._cancelButtonClass = _cancelButtonClass;
}

public String getCancelButtonClassDisabled(){
	if (this._cancelButtonClassDisabled != null) {
		return this._cancelButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("cancelButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelButtonClassDisabled(String _cancelButtonClassDisabled){
this._cancelButtonClassDisabled = _cancelButtonClassDisabled;
}

public String getCleanButtonClass(){
	if (this._cleanButtonClass != null) {
		return this._cleanButtonClass;
	}
	ValueExpression ve = getValueExpression("cleanButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCleanButtonClass(String _cleanButtonClass){
this._cleanButtonClass = _cleanButtonClass;
}

public String getCleanButtonClassDisabled(){
	if (this._cleanButtonClassDisabled != null) {
		return this._cleanButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("cleanButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCleanButtonClassDisabled(String _cleanButtonClassDisabled){
this._cleanButtonClassDisabled = _cleanButtonClassDisabled;
}

public String getContentType(){
	if (this._contentType != null) {
		return this._contentType;
	}
	ValueExpression ve = getValueExpression("contentType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentType(String _contentType){
this._contentType = _contentType;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getFileEntryClass(){
	if (this._fileEntryClass != null) {
		return this._fileEntryClass;
	}
	ValueExpression ve = getValueExpression("fileEntryClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryClass(String _fileEntryClass){
this._fileEntryClass = _fileEntryClass;
}

public String getFileEntryClassDisabled(){
	if (this._fileEntryClassDisabled != null) {
		return this._fileEntryClassDisabled;
	}
	ValueExpression ve = getValueExpression("fileEntryClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryClassDisabled(String _fileEntryClassDisabled){
this._fileEntryClassDisabled = _fileEntryClassDisabled;
}

public String getFileEntryControlClass(){
	if (this._fileEntryControlClass != null) {
		return this._fileEntryControlClass;
	}
	ValueExpression ve = getValueExpression("fileEntryControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryControlClass(String _fileEntryControlClass){
this._fileEntryControlClass = _fileEntryControlClass;
}

public String getFileEntryControlClassDisabled(){
	if (this._fileEntryControlClassDisabled != null) {
		return this._fileEntryControlClassDisabled;
	}
	ValueExpression ve = getValueExpression("fileEntryControlClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryControlClassDisabled(String _fileEntryControlClassDisabled){
this._fileEntryControlClassDisabled = _fileEntryControlClassDisabled;
}

public String getFileName(){
	if (this._fileName != null) {
		return this._fileName;
	}
	ValueExpression ve = getValueExpression("fileName");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileName(String _fileName){
this._fileName = _fileName;
}

public Integer getFileSize(){
	if (this._fileSize != null) {
		return this._fileSize;
	}
	ValueExpression ve = getValueExpression("fileSize");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileSize(Integer _fileSize){
this._fileSize = _fileSize;
}

public MethodExpression getFileUploadListener(){
return _fileUploadListener;
}

public void setFileUploadListener(MethodExpression _fileUploadListener){
this._fileUploadListener = _fileUploadListener;
}

public String getListHeight(){
	if (this._listHeight != null) {
		return this._listHeight;
	}
	ValueExpression ve = getValueExpression("listHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "210px";
	

}

public void setListHeight(String _listHeight){
this._listHeight = _listHeight;
}

public String getListWidth(){
	if (this._listWidth != null) {
		return this._listWidth;
	}
	ValueExpression ve = getValueExpression("listWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "400px";
	

}

public void setListWidth(String _listWidth){
this._listWidth = _listWidth;
}

public Integer getMaxFilesQuantity(){
	if (this._maxFilesQuantity != null) {
		return this._maxFilesQuantity;
	}
	ValueExpression ve = getValueExpression("maxFilesQuantity");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return 1;
	

}

public void setMaxFilesQuantity(Integer _maxFilesQuantity){
this._maxFilesQuantity = _maxFilesQuantity;
}

public int getMaxlength(){
	if (this._maxlengthSet) {
	    return (this._maxlength);
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._maxlength);
	    }
	    
	    return value;
	} else {
	    return (this._maxlength);
	}

}

public void setMaxlength(int _maxlength){
this._maxlength = _maxlength;
this._maxlengthSet = true;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnupload(){
	if (this._onupload != null) {
		return this._onupload;
	}
	ValueExpression ve = getValueExpression("onupload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnupload(String _onupload){
this._onupload = _onupload;
}

public String getOnuploadcanceled(){
	if (this._onuploadcanceled != null) {
		return this._onuploadcanceled;
	}
	ValueExpression ve = getValueExpression("onuploadcanceled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnuploadcanceled(String _onuploadcanceled){
this._onuploadcanceled = _onuploadcanceled;
}

public String getOnuploadcomplete(){
	if (this._onuploadcomplete != null) {
		return this._onuploadcomplete;
	}
	ValueExpression ve = getValueExpression("onuploadcomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnuploadcomplete(String _onuploadcomplete){
this._onuploadcomplete = _onuploadcomplete;
}

public String getProgressInfo(){
	if (this._progressInfo != null) {
		return this._progressInfo;
	}
	ValueExpression ve = getValueExpression("progressInfo");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProgressInfo(String _progressInfo){
this._progressInfo = _progressInfo;
}

public int getSize(){
	if (this._sizeSet) {
	    return (this._size);
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._size);
	    }
	    
	    return value;
	} else {
	    return (this._size);
	}

}

public void setSize(int _size){
this._size = _size;
this._sizeSet = true;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getUploadButtonClass(){
	if (this._uploadButtonClass != null) {
		return this._uploadButtonClass;
	}
	ValueExpression ve = getValueExpression("uploadButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadButtonClass(String _uploadButtonClass){
this._uploadButtonClass = _uploadButtonClass;
}

public String getUploadButtonClassDisabled(){
	if (this._uploadButtonClassDisabled != null) {
		return this._uploadButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("uploadButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadButtonClassDisabled(String _uploadButtonClassDisabled){
this._uploadButtonClassDisabled = _uploadButtonClassDisabled;
}

public Object getUploadData(){
	if (this._uploadData != null) {
		return this._uploadData;
	}
	ValueExpression ve = getValueExpression("uploadData");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadData(Object _uploadData){
this._uploadData = _uploadData;
}

public String getUploadListClass(){
	if (this._uploadListClass != null) {
		return this._uploadListClass;
	}
	ValueExpression ve = getValueExpression("uploadListClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadListClass(String _uploadListClass){
this._uploadListClass = _uploadListClass;
}

public String getUploadListClassDisabled(){
	if (this._uploadListClassDisabled != null) {
		return this._uploadListClassDisabled;
	}
	ValueExpression ve = getValueExpression("uploadListClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadListClassDisabled(String _uploadListClassDisabled){
this._uploadListClassDisabled = _uploadListClassDisabled;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[57];
state[0] = super.saveState(context);
state[1] = _acceptedTypes;
state[2] = _accesskey;
state[3] = _addButtonClass;
state[4] = _addButtonClassDisabled;
state[5] = _align;
state[6] = _alt;
state[7] = Boolean.valueOf(_autoclear);
state[8] = Boolean.valueOf(_autoclearSet);
state[9] = _cancelButtonClass;
state[10] = _cancelButtonClassDisabled;
state[11] = _cleanButtonClass;
state[12] = _cleanButtonClassDisabled;
state[13] = _contentType;
state[14] = Boolean.valueOf(_disabled);
state[15] = Boolean.valueOf(_disabledSet);
state[16] = _fileEntryClass;
state[17] = _fileEntryClassDisabled;
state[18] = _fileEntryControlClass;
state[19] = _fileEntryControlClassDisabled;
state[20] = _fileName;
state[21] = _fileSize;
state[22] = saveAttachedState(context, _fileUploadListener);
state[23] = _listHeight;
state[24] = _listWidth;
state[25] = _maxFilesQuantity;
state[26] = Integer.valueOf(_maxlength);
state[27] = Boolean.valueOf(_maxlengthSet);
state[28] = _onblur;
state[29] = _onchange;
state[30] = _onclick;
state[31] = _ondblclick;
state[32] = _onerror;
state[33] = _onfocus;
state[34] = _onkeydown;
state[35] = _onkeypress;
state[36] = _onkeyup;
state[37] = _onmousedown;
state[38] = _onmousemove;
state[39] = _onmouseout;
state[40] = _onmouseover;
state[41] = _onmouseup;
state[42] = _onselect;
state[43] = _onupload;
state[44] = _onuploadcanceled;
state[45] = _onuploadcomplete;
state[46] = _progressInfo;
state[47] = Integer.valueOf(_size);
state[48] = Boolean.valueOf(_sizeSet);
state[49] = _style;
state[50] = _styleClass;
state[51] = _tabindex;
state[52] = _uploadButtonClass;
state[53] = _uploadButtonClassDisabled;
state[54] = saveAttachedState(context, _uploadData);
state[55] = _uploadListClass;
state[56] = _uploadListClassDisabled;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptedTypes = (String)states[1];;
		_accesskey = (String)states[2];;
		_addButtonClass = (String)states[3];;
		_addButtonClassDisabled = (String)states[4];;
		_align = (String)states[5];;
		_alt = (String)states[6];;
		_autoclear = ((Boolean)states[7]).booleanValue();
		_autoclearSet = ((Boolean)states[8]).booleanValue();
		_cancelButtonClass = (String)states[9];;
		_cancelButtonClassDisabled = (String)states[10];;
		_cleanButtonClass = (String)states[11];;
		_cleanButtonClassDisabled = (String)states[12];;
		_contentType = (String)states[13];;
		_disabled = ((Boolean)states[14]).booleanValue();
		_disabledSet = ((Boolean)states[15]).booleanValue();
		_fileEntryClass = (String)states[16];;
		_fileEntryClassDisabled = (String)states[17];;
		_fileEntryControlClass = (String)states[18];;
		_fileEntryControlClassDisabled = (String)states[19];;
		_fileName = (String)states[20];;
		_fileSize = (Integer)states[21];;
		_fileUploadListener = (MethodExpression)restoreAttachedState(context, states[22]);
		_listHeight = (String)states[23];;
		_listWidth = (String)states[24];;
		_maxFilesQuantity = (Integer)states[25];;
		_maxlength = ((Integer)states[26]).intValue();
		_maxlengthSet = ((Boolean)states[27]).booleanValue();
		_onblur = (String)states[28];;
		_onchange = (String)states[29];;
		_onclick = (String)states[30];;
		_ondblclick = (String)states[31];;
		_onerror = (String)states[32];;
		_onfocus = (String)states[33];;
		_onkeydown = (String)states[34];;
		_onkeypress = (String)states[35];;
		_onkeyup = (String)states[36];;
		_onmousedown = (String)states[37];;
		_onmousemove = (String)states[38];;
		_onmouseout = (String)states[39];;
		_onmouseover = (String)states[40];;
		_onmouseup = (String)states[41];;
		_onselect = (String)states[42];;
		_onupload = (String)states[43];;
		_onuploadcanceled = (String)states[44];;
		_onuploadcomplete = (String)states[45];;
		_progressInfo = (String)states[46];;
		_size = ((Integer)states[47]).intValue();
		_sizeSet = ((Boolean)states[48]).booleanValue();
		_style = (String)states[49];;
		_styleClass = (String)states[50];;
		_tabindex = (String)states[51];;
		_uploadButtonClass = (String)states[52];;
		_uploadButtonClassDisabled = (String)states[53];;
		_uploadData = (Object)restoreAttachedState(context, states[54]);
		_uploadListClass = (String)states[55];;
		_uploadListClassDisabled = (String)states[56];;
	
}

}
