package org.richfaces.org.jboss.seam.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * A filter for decoding multipart requests, for
 * use with the file upload control.
 * 
 * @author Shane Bryzak
 *
 */
//@Scope(APPLICATION)
//@Name("org.jboss.seam.web.multipartFilter")
//@Install(precedence = BUILT_IN)
//@BypassInterceptors
//@Filter(within={"org.jboss.seam.web.ajax4jsfFilter", "org.jboss.seam.web.exceptionFilter"})
public class MultipartFilter implements Filter
{
   public static final String MULTIPART = "multipart/";
   
   /** Session bean name where multipart requests map will be stored */
   public static final String REQUESTS_SESSIONS_BEAN_NAME = "_richfaces_upload_sessions";
   
   /** Session bean name where progress bar's percent map will be stored  */
   public static final String PERCENT_BEAN_NAME = "_richfaces_upload_percents"; 
   
   /**
    * Flag indicating whether a temporary file should be used to cache the uploaded file
    */
   private boolean createTempFiles = false;
   
   /**
    * The maximum size of a file upload request.  0 means no limit.
    */
   private int maxRequestSize = 0; 
     
   public boolean getCreateTempFiles()
   {
      return createTempFiles;
   }
   
   public void setCreateTempFiles(boolean createTempFiles)
   {
      this.createTempFiles = createTempFiles;
   }
   
   public int getMaxRequestSize()
   {
      return maxRequestSize;
   }
   
   public void setMaxRequestSize(int maxFileSize)
   {
      this.maxRequestSize = maxFileSize;
   }   
   
   @SuppressWarnings("unchecked")
public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		if (!(response instanceof HttpServletResponse)) {
			chain.doFilter(request, response);
			return;
		}

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		String uid = httpRequest.getParameter("uid");
		//String componentId = httpRequest.getParameter("clientId");
		if (isMultipartRequest(httpRequest)) {
			MultipartRequest multipartRequest = new MultipartRequest(
					httpRequest, createTempFiles, maxRequestSize, uid);

			Map<String, MultipartRequest> sessionsMap = null;
			Map<String, Object> percentMap = null;
			try {
			    if (!isFileSizeRestricted(request, maxRequestSize)) {
				HttpSession session = httpRequest.getSession();
				synchronized (session) {
					sessionsMap = (Map<String, MultipartRequest>) session
							.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
					percentMap = (Map<String, Object>) session.getAttribute(PERCENT_BEAN_NAME);		
					if (sessionsMap == null) {
						sessionsMap = Collections.synchronizedMap(new HashMap<String, MultipartRequest>());
						session.setAttribute(
										REQUESTS_SESSIONS_BEAN_NAME, sessionsMap);
					}
					if (percentMap == null) {
						percentMap = new HashMap<String, Object>();
						session.setAttribute(PERCENT_BEAN_NAME, percentMap);
					}
				}
				
				percentMap.put(uid, 0);  // associate percent value with file entry uid
				sessionsMap.put(uid, multipartRequest); 

				if (multipartRequest.parseRequest()) {
					chain.doFilter(multipartRequest, response);
				} else {
				    	printResponse(response, "<html id=\"_richfaces_file_upload_stopped\"></html>");
				}
			    }else {
				printResponse(response, "<html id=\"_richfaces_file_upload_size_restricted\"></html>");
			    }
			} finally {
				if (sessionsMap != null) {
					sessionsMap.remove(uid);
					percentMap.remove(uid);
				}
			}
		} else {
			if ("stop".equals(httpRequest.getParameter("action"))) {
				HttpSession session = httpRequest.getSession();
				Map<String, MultipartRequest> sessions = (Map<String, MultipartRequest>) session
					.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);

				if (sessions != null) {
					MultipartRequest multipartRequest = sessions.get(uid);
					if (multipartRequest != null) {
						multipartRequest.stop();
						HttpServletResponse httpResponse = (HttpServletResponse) response;
						httpResponse.setStatus(HttpServletResponse.SC_NO_CONTENT);
						httpResponse.getOutputStream().close();
					}
				}
			} else {
				chain.doFilter(request, response);
			}
		}
	}
   
   private boolean isFileSizeRestricted (ServletRequest request, int maxSize) {
       if (request.getContentLength() > maxSize) {
	   return true;
       }
       return false;
   }
   
   private void printResponse (ServletResponse response, String message) throws IOException{
        HttpServletResponse httpResponse = (HttpServletResponse) response;
	httpResponse.setStatus(HttpServletResponse.SC_OK);
	httpResponse.setContentType("text/html");
	PrintWriter writer = httpResponse.getWriter();
	writer.write(message);
	writer.close();
   }
   
   private boolean isMultipartRequest(HttpServletRequest request)
   {
      if (!"post".equals(request.getMethod().toLowerCase()))
      {
         return false;
      }
      
      String contentType = request.getContentType();
      if (contentType == null)
      {
         return false;
      }
      
      if (contentType.toLowerCase().startsWith(MULTIPART))
      {
         return true;
      }
      
      return false;     
   }

public void destroy() {
	
}

public void init(FilterConfig filterConfig) throws ServletException {
	String param = filterConfig.getInitParameter("createTempFiles");
	if (param != null) {
	    this.createTempFiles = Boolean.parseBoolean(param);
	}
	param = filterConfig.getInitParameter("maxRequestSize");
	if (param != null) {
	    this.maxRequestSize = Integer.parseInt(param);
	}

	
}
}
