/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UIToolBarGroup;
import org.richfaces.renderkit.html.images.DotSeparatorImage;
import org.richfaces.renderkit.html.images.GridSeparatorImage;
import org.richfaces.renderkit.html.images.LineSeparatorImage;
import org.richfaces.renderkit.html.images.SquareSeparatorImage;

public class ToolBarGroupRenderer extends RendererBase {
	
	protected Class getComponentClass() {
		return UIToolBarGroup.class;
	}

	public boolean getRendersChildren() {
		return true;
	}
	
	public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
		UIToolBarGroup toolBarGroup = (UIToolBarGroup) component;
		ResponseWriter writer = facesContext.getResponseWriter();
		String style = (String) toolBarGroup.getAttributes().get("style");
		String styleClass = (String) toolBarGroup.getAttributes().get("styleClass");
		if (null == styleClass) styleClass = "";
		String contentClass = (String) toolBarGroup.getToolBar().getAttributes().get("contentClass");
		if (null == contentClass) contentClass = "";
		String contentStyle = (String) toolBarGroup.getToolBar().getAttributes().get("contentStyle");
		
		if (component.getChildCount() > 0) {
			List children = component.getChildren();
			for (Iterator iter = children.iterator(); iter.hasNext();) {
				UIComponent child = (UIComponent) iter.next();
				if(!child.isRendered()){
					iter.remove();
				}
			}
			for (Iterator it = children.iterator(); it.hasNext();) {
				UIComponent child = (UIComponent) it.next();
					writer.startElement("td", component);
					writer.writeAttribute("class", "dr-toolbar-int rich-toolbar-item " + contentClass +" "+styleClass, null);
					getUtils().writeAttribute(writer, "style", contentStyle);
					getUtils().writeAttribute(writer, "style", style);
					getUtils().encodePassThruWithExclusions(facesContext, component, "style,class");
					renderChild(facesContext, child);
					writer.endElement("td");
					if (it.hasNext()) {
						insertSeparatorIfNeed(writer, facesContext, toolBarGroup);
					}
				
			}
		}		
	}
	
	protected void insertSeparatorIfNeed(ResponseWriter writer,FacesContext context, UIToolBarGroup toolBarGroup) throws IOException {				
				String itemSeparator = toolBarGroup.getItemSeparator();
				if (itemSeparator != null && itemSeparator.length()!=0 && ! itemSeparator.equalsIgnoreCase("none")){								
					String uri = null;
					if (itemSeparator.equalsIgnoreCase("square")) {
						uri = getResource(SquareSeparatorImage.class.getName()).getUri(context, null);
					} else if (itemSeparator.equalsIgnoreCase("disc")) {
						uri = getResource(DotSeparatorImage.class.getName()).getUri(context, null);
					} else if (itemSeparator.equalsIgnoreCase("grid")) {
						uri = getResource(GridSeparatorImage.class.getName()).getUri(context, toolBarGroup);
					} else if (itemSeparator.equalsIgnoreCase("line")) {
						uri = getResource(LineSeparatorImage.class.getName()).getUri(context, toolBarGroup);
					} else throw new FacesException("Unknown type of separator - \""+itemSeparator+"\"");
					writer.startElement("td", toolBarGroup);
					getUtils().writeAttribute(writer, "class", toolBarGroup.getAttributes().get("separatorClass"));
					writer.writeAttribute("align", "center", null);					
					writer.startElement("img", toolBarGroup);					
					getUtils().writeAttribute(writer, "src", uri);
					getUtils().writeAttribute(writer, "alt", "");
					writer.endElement("img");		
					writer.endElement("td");
				}
			}
	
}
