/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.org.jboss.seam.ui.component;

import java.io.InputStream;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.richfaces.event.FileUploadListener;
import org.richfaces.event.UploadEvent;
import org.richfaces.org.jboss.seam.ui.renderkit.FileUploadRendererBase;
import org.richfaces.org.jboss.seam.web.MultipartRequest;

public abstract class UIFileUpload
extends UIInput {
    public static final String COMPONENT_TYPE = "org.richfaces.component.FileUpload";
    public static final String COMPONENT_FAMILY = "org.richfaces.component.FileUpload";
    private String localContentType;
    private String localFileName;
    private Integer localFileSize;
    private InputStream localInputStream;

    private void setupProgressBarValueExpression(FacesContext context, String uid) {
        FileUploadRendererBase renderer = (FileUploadRendererBase)this.getRenderer(context);
        UIComponent progressBar = renderer.getProgressBar(context, (UIComponent)this);
        String exprStr = "#{_richfaces_upload_percents['" + uid + "']}";
        ValueExpression ex = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), exprStr, Integer.class);
        progressBar.setValueExpression("value", ex);
    }

    public String getLocalContentType() {
        return this.localContentType;
    }

    public void setLocalContentType(String localContentType) {
        this.localContentType = localContentType;
    }

    public String getLocalFileName() {
        return this.localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public Integer getLocalFileSize() {
        return this.localFileSize;
    }

    public void setLocalFileSize(Integer localFileSize) {
        this.localFileSize = localFileSize;
    }

    public InputStream getLocalInputStream() {
        return this.localInputStream;
    }

    public void setLocalInputStream(InputStream localInputStream) {
        this.localInputStream = localInputStream;
    }

    public abstract void setAcceptedTypes(String var1);

    public abstract String getAcceptedTypes();

    public abstract Integer getMaxFilesQuantity();

    public abstract void setMaxFilesQuantity(Integer var1);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);

    public abstract MethodExpression getFileUploadListener();

    public abstract void setFileUploadListener(MethodExpression var1);

    public void addFileUploadListener(FileUploadListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public FileUploadListener[] getFileUploadListeners() {
        return (FileUploadListener[])this.getFacesListeners(FileUploadListener.class);
    }

    public void removeFileUploadListener(FileUploadListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void reset() {
        this.localContentType = null;
        this.localContentType = null;
        this.localFileName = null;
        this.localFileSize = null;
        this.localInputStream = null;
    }

    public void broadcast(FacesEvent e) {
        super.broadcast(e);
        if (e instanceof UploadEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            MethodExpression binding = this.getFileUploadListener();
            if (binding != null) {
                binding.invoke(facesContext.getELContext(), new Object[]{e});
            }
        } else {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
            if ("progress".equals(request.getParameter("action")) && request.getParameterMap().containsKey(this.getClientId(facesContext))) {
                MultipartRequest multipartRequest;
                AjaxContext ajaxContext = AjaxContextImpl.getCurrentInstance((FacesContext)facesContext);
                String uid = request.getParameter("uid");
                Map sessionMap = externalContext.getSessionMap();
                Map sessions = (Map)sessionMap.get("_richfaces_upload_sessions");
                if (sessions != null && (multipartRequest = (MultipartRequest)((Object)sessions.get(uid))) != null) {
                    this.setupProgressBarValueExpression(facesContext, uid);
                    ajaxContext.setResponseData((Object)multipartRequest.getSize());
                }
            }
        }
    }
}

