/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.resource.CountingOutputWriter;
import org.richfaces.component.UIProgressBar;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

public class AbstractProgressBarRenderer
extends TemplateEncoderRendererBase {
    private static final String AJAX_POLL_FUNCTION = "A4J.AJAX.Poll";

    protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        new AjaxEvent(uiComponent).queue();
        uiComponent.queueEvent((FacesEvent)new ActionEvent(uiComponent));
    }

    public void renderForcedState(String state, FacesContext context, UIComponent component) throws IOException {
        if ("initialState".equals(state)) {
            this.encodeInitialState(context, component, true);
        } else if ("progressState".equals(state)) {
            this.encodeProgressState(context, component, true);
        } else if ("completeState".equals(state)) {
            this.encodeCompletedState(context, component, true);
        }
        component.getAttributes().remove("forcePercent");
    }

    public String getForcedState(FacesContext context, UIComponent component) {
        String forcedState = null;
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        Map params = request.getParameterMap();
        if (params.containsKey("forcePercent")) {
            String[] str = (String[])params.get("forcePercent");
            forcedState = str[0];
        }
        return forcedState;
    }

    public StringBuffer getMarkup(FacesContext context, UIComponent component) {
        StringBuffer result = null;
        CountingOutputWriter customWriter = new CountingOutputWriter();
        try {
            if (this.hasChildren(component)) {
                ResponseWriter writer = context.getResponseWriter();
                String defaultRenderKitId = context.getApplication().getDefaultRenderKitId();
                if (null == defaultRenderKitId) {
                    defaultRenderKitId = "HTML_BASIC";
                }
                RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderKitFactory.getRenderKit(context, defaultRenderKitId);
                ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)customWriter, null, "UTF-8");
                context.setResponseWriter(responseWriter);
                this.writeScriptBody(context, component, true);
                result = customWriter.getContent();
                if (writer != null) {
                    context.setResponseWriter(writer);
                }
            } else {
                this.writeScriptBody((Writer)customWriter, (String)component.getAttributes().get("label"));
                result = customWriter.getContent();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result;
    }

    public void encodePollScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIProgressBar progressBar = (UIProgressBar)component;
        String clientId = component.getClientId(context);
        StringBuffer pollScript = new StringBuffer("\n");
        StringBuffer script = new StringBuffer("\n");
        if (this.isAjaxMode(component) && progressBar.isEnabled()) {
            JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context, (String)AJAX_POLL_FUNCTION);
            function.addParameter((Object)new JSReference("$('" + clientId + "').component.options"));
            function.appendScript(script);
            pollScript.append(script);
        } else {
            pollScript.append(this.getStopPollScript(clientId));
        }
        pollScript.append(";\n");
        writer.writeText((Object)pollScript.toString(), null);
    }

    public void encodeRenderStateScript(FacesContext context, UIComponent component, String state) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer script = new StringBuffer("\n");
        script.append("$('" + component.getClientId(context) + "').component.renderState('").append(state).append("');");
        writer.write(script.toString());
    }

    public void encodeLabelScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer script = new StringBuffer("\n");
        script.append("$('" + component.getClientId(context) + "').component.renderLabel(").append(this.getMarkup(context, component)).append(",null);\n");
        writer.append((CharSequence)script.toString());
    }

    public void encodeInitialScript(FacesContext context, UIComponent component, String state) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIProgressBar progressBar = (UIProgressBar)component;
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        StringBuffer script = new StringBuffer();
        String clientId = component.getClientId(context);
        String containerId = ((UIComponent)AjaxRendererUtils.findAjaxContainer((FacesContext)context, (UIComponent)component)).getClientId(context);
        String formId = AjaxRendererUtils.getNestingForm((UIComponent)component).getClientId(context);
        String mode = (String)component.getAttributes().get("mode");
        Number minValue = this.getNumber(component.getAttributes().get("minValue"));
        Number maxValue = this.getNumber(component.getAttributes().get("maxValue"));
        Number value = (Number)variables.getVariable("value");
        StringBuffer markup = this.getMarkup(context, component);
        script.append("new ProgressBar('").append(clientId).append("','").append(containerId).append("','").append(formId).append("','").append(mode).append("',").append(minValue).append(",").append(maxValue).append(",");
        script.append(this.getContext(component));
        script.append(",");
        script.append(markup != null ? new JSLiteral(markup.toString()) : JSReference.NULL);
        script.append(",");
        script.append(ScriptUtils.toScript((Object)this.buildAjaxOptions(clientId, progressBar, context)));
        String progressVar = (String)component.getAttributes().get("progressVar");
        if (progressVar != null) {
            script.append(",'");
            script.append(progressVar);
            script.append("','");
        } else {
            script.append(",null,'");
        }
        script.append(state);
        script.append("',");
        script.append(value.toString());
        script.append(")\n;");
        writer.write(script.toString());
    }

    private Map buildAjaxOptions(String clientId, UIProgressBar progressBar, FacesContext context) {
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)progressBar);
        Integer interval = new Integer(progressBar.getInterval());
        options.put("pollId", clientId);
        options.put("pollinterval", interval);
        if (progressBar.getAttributes().containsKey("ignoreDupResponses")) {
            options.put("ignoreDupResponses", progressBar.getAttributes().get("ignoreDupResponses"));
        }
        Map parameters = (Map)options.get("parameters");
        parameters.put("percent", "percent");
        parameters.put(clientId, clientId);
        return options;
    }

    private boolean isAjaxMode(UIComponent component) {
        String mode = (String)component.getAttributes().get("mode");
        return "ajax".equalsIgnoreCase(mode);
    }

    public void encodeClientMode(FacesContext context, UIComponent component, Number value, Number min, Number max) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        String state = value.doubleValue() <= min.doubleValue() ? "initialState" : (value.doubleValue() >= max.doubleValue() ? "completeState" : "progressState");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, null);
        this.encodeInitialState(context, component, false);
        this.encodeProgressState(context, component, false);
        this.encodeCompletedState(context, component, false);
        this.startScript(writer, component);
        this.encodeInitialScript(context, component, state);
        this.encodeLabelScript(context, component);
        this.encodeRenderStateScript(context, component, state);
        this.endScript(writer, component);
        writer.endElement("div");
    }

    public void encodeInitialState(FacesContext context, UIComponent component, boolean isAjaxMode) throws IOException {
        String clientId = component.getClientId(context);
        String initialClass = (String)component.getAttributes().get("initialClass");
        String style = (String)component.getAttributes().get("style");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", (Object)initialClass);
        this.getUtils().writeAttribute(writer, "style", (Object)(style + (!isAjaxMode ? "display: none" : "")));
        writer.writeAttribute("id", (Object)(isAjaxMode ? clientId : clientId + ":initialState"), null);
        UIComponent initial = component.getFacet("initial");
        if (initial != null) {
            this.renderChild(context, initial);
        }
        if (isAjaxMode) {
            this.startScript(writer, component);
            this.encodeInitialScript(context, component, "initialState");
            this.encodePollScript(context, component);
            this.endScript(writer, component);
        }
        writer.endElement("div");
    }

    public void encodeProgressState(FacesContext context, UIComponent component, boolean isAjaxMode) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        String clientId = component.getClientId(context);
        String styleClass = (String)variables.getVariable("styleClass");
        boolean isSimple = this.isSimpleMarkup(component);
        String shellClass = !isSimple ? "rich-progress-bar-shell-dig " : "rich-progress-bar-shell ";
        writer.startElement("div", component);
        this.getUtils().writeAttribute(writer, "class", (Object)("rich-progress-bar-block rich-progress-bar-width " + shellClass + (styleClass != null ? styleClass : "")));
        this.getUtils().writeAttribute(writer, "id", (Object)(isAjaxMode ? clientId : clientId + ":progressState"));
        this.getUtils().writeAttribute(writer, "style", (Object)(variables.getVariable("style") + (!isAjaxMode ? "display: none" : "")));
        this.encodeProgressBar(context, component, isSimple);
        if (isAjaxMode) {
            this.startScript(writer, component);
            this.encodeInitialScript(context, component, "progressState");
            this.encodeLabelScript(context, component);
            this.encodePollScript(context, component);
            this.endScript(writer, component);
        }
        writer.endElement("div");
    }

    public void encodeProgressBar(FacesContext context, UIComponent component, boolean isSimple) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        ComponentVariables variables = ComponentsVariableResolver.getVariables((RendererBase)this, (UIComponent)component);
        Number value = (Number)variables.getVariable("percent");
        String width = String.valueOf(value.intValue());
        String style = (String)component.getAttributes().get("style");
        String completeClass = (String)component.getAttributes().get("completeClass");
        String remainClass = (String)component.getAttributes().get("remainClass");
        if (!isSimple) {
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", (Object)("rich-progress-bar-width rich-progress-bar-remained rich-progress-bar-padding " + remainClass));
            this.getUtils().writeAttribute(writer, "id", (Object)(clientId + ":remain"));
            this.getUtils().writeAttribute(writer, "style", (Object)style);
            writer.endElement("div");
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", (Object)"rich-progress-bar-uploaded-dig");
            this.getUtils().writeAttribute(writer, "id", (Object)(clientId + ":upload"));
            this.getUtils().writeAttribute(writer, "style", (Object)((style != null ? style + ";" : "") + " width: " + width + "%;"));
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", (Object)("rich-progress-bar_height_dig rich-progress-bar-width rich-progress-bar-completed rich-progress-bar-padding " + completeClass));
            this.getUtils().writeAttribute(writer, "id", (Object)(clientId + ":complete"));
            this.getUtils().writeAttribute(writer, "style", (Object)style);
            writer.endElement("div");
            writer.endElement("div");
        } else {
            writer.startElement("div", component);
            this.getUtils().writeAttribute(writer, "class", (Object)("rich-progress-bar-height rich-progress-bar-uploaded " + completeClass));
            this.getUtils().writeAttribute(writer, "id", (Object)(clientId + ":upload"));
            this.getUtils().writeAttribute(writer, "style", (Object)((style != null ? style + ";" : "") + " width: " + width + "%;"));
            writer.endElement("div");
        }
    }

    public String getParameters(UIComponent component) {
        String parameters = (String)component.getAttributes().get("parameters");
        return parameters;
    }

    private void startScript(ResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("style", (Object)"display: none;", null);
        writer.startElement("script", component);
    }

    private void endScript(ResponseWriter writer, UIComponent component) throws IOException {
        writer.endElement("script");
        writer.endElement("span");
    }

    private JSLiteral getContext(UIComponent component) {
        StringBuffer buffer = new StringBuffer();
        String parameters = this.getParameters(component);
        JSLiteral literal = null;
        if (parameters != null) {
            buffer.append("{").append(parameters).append("}");
            literal = new JSLiteral(buffer.toString());
        } else {
            literal = new JSLiteral("null");
        }
        return literal;
    }

    private boolean hasChildren(UIComponent component) {
        return component.getChildCount() != 0;
    }

    public boolean isSimpleMarkup(UIComponent component) {
        if (this.hasChildren(component)) {
            return false;
        }
        return component.getAttributes().get("label") == null;
    }

    public void encodeCompletedState(FacesContext context, UIComponent component, boolean isAjaxMode) throws IOException {
        Object rerenderAfterComplete;
        Set ajaxRegions;
        if (isAjaxMode && (ajaxRegions = AjaxRendererUtils.asSet(rerenderAfterComplete = component.getAttributes().get("reRenderAfterComplete"))) != null) {
            Iterator iter = ajaxRegions.iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
                ajaxContext.addComponentToAjaxRender(component, id);
            }
        }
        String clientId = component.getClientId(context);
        String finishClass = (String)component.getAttributes().get("finishClass");
        String style = (String)component.getAttributes().get("style");
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(isAjaxMode ? clientId : clientId + ":completeState"), null);
        this.getUtils().writeAttribute(writer, "class", (Object)finishClass);
        this.getUtils().writeAttribute(writer, "style", (Object)(style + (!isAjaxMode ? "display: none" : "")));
        UIComponent completed = component.getFacet("complete");
        if (completed != null) {
            this.renderChild(context, completed);
        }
        if (isAjaxMode) {
            this.startScript(writer, component);
            this.encodeInitialScript(context, component, "completeState");
            writer.write(this.getStopPollScript(clientId).toString());
            this.endScript(writer, component);
        }
        writer.endElement("div");
    }

    public Number getNumber(Object v) {
        Number result = new Integer(0);
        if (v != null) {
            try {
                if (v instanceof String) {
                    result = Double.parseDouble((String)v);
                } else {
                    Number n = (Number)v;
                    if (n instanceof BigDecimal || n instanceof Double || n instanceof Float) {
                        result = Float.valueOf(n.floatValue());
                    } else if (n instanceof Integer || n instanceof Long) {
                        result = n.intValue();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Number calculatePercent(Number value, Number minValue, Number maxValue) {
        if (minValue.doubleValue() < value.doubleValue() && value.doubleValue() < maxValue.doubleValue()) {
            return (value.doubleValue() - minValue.doubleValue()) * 100.0 / (maxValue.doubleValue() - minValue.doubleValue());
        }
        return value;
    }

    private StringBuffer getStopPollScript(String clientId) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("A4J.AJAX.StopPoll('").append(clientId).append("');\n");
        return buffer;
    }

    protected Class getComponentClass() {
        return UIProgressBar.class;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }
}

