/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UIToolBar;
import org.richfaces.component.UIToolBarGroup;
import org.richfaces.renderkit.html.images.DotSeparatorImage;
import org.richfaces.renderkit.html.images.GridSeparatorImage;
import org.richfaces.renderkit.html.images.LineSeparatorImage;
import org.richfaces.renderkit.html.images.SquareSeparatorImage;

public class ToolBarRendererBase
extends HeaderResourcesRendererBase {
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        UIToolBar toolBar = (UIToolBar)component;
        List children = toolBar.getChildren();
        String contentClass = (String)toolBar.getAttributes().get("contentClass");
        if (null == contentClass) {
            contentClass = "";
        }
        String contentStyle = (String)toolBar.getAttributes().get("contentStyle");
        if (children != null) {
            UIComponent child;
            LinkedList<UIComponent> childrenToTheLeft = new LinkedList<UIComponent>();
            LinkedList<UIComponent> childrenToTheRight = new LinkedList<UIComponent>();
            for (UIComponent child2 : children) {
                if (!child2.isRendered()) continue;
                if (child2 instanceof UIToolBarGroup) {
                    UIToolBarGroup group = (UIToolBarGroup)child2;
                    String location = group.getLocation();
                    if (location != null && location.equals("right")) {
                        childrenToTheRight.add(child2);
                        continue;
                    }
                    childrenToTheLeft.add(child2);
                    continue;
                }
                childrenToTheLeft.add(child2);
            }
            ResponseWriter writer = facesContext.getResponseWriter();
            Iterator it = childrenToTheLeft.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                if (!(child instanceof UIToolBarGroup)) {
                    writer.startElement("td", component);
                    writer.writeAttribute("class", (Object)("dr-toolbar-int rich-toolbar-item " + contentClass), null);
                    this.getUtils().writeAttribute(writer, "style", (Object)contentStyle);
                }
                this.renderChild(facesContext, child);
                if (!(child instanceof UIToolBarGroup)) {
                    writer.endElement("td");
                }
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(writer, facesContext, toolBar);
            }
            writer.startElement("td", component);
            writer.writeAttribute("width", (Object)"100%", null);
            writer.endElement("td");
            it = childrenToTheRight.iterator();
            while (it.hasNext()) {
                child = (UIComponent)it.next();
                this.renderChild(facesContext, child);
                if (!it.hasNext()) continue;
                this.insertSeparatorIfNeed(writer, facesContext, toolBar);
            }
        }
    }

    protected void insertSeparatorIfNeed(ResponseWriter writer, FacesContext context, UIToolBar toolBar) throws IOException {
        String itemSeparator = toolBar.getItemSeparator();
        if (itemSeparator != null && itemSeparator.length() != 0 && !itemSeparator.equalsIgnoreCase("none")) {
            String uri = null;
            if (itemSeparator.equalsIgnoreCase("square")) {
                uri = this.getResource(SquareSeparatorImage.class.getName()).getUri(context, null);
            } else if (itemSeparator.equalsIgnoreCase("disc")) {
                uri = this.getResource(DotSeparatorImage.class.getName()).getUri(context, null);
            } else if (itemSeparator.equalsIgnoreCase("grid")) {
                uri = this.getResource(GridSeparatorImage.class.getName()).getUri(context, (Object)toolBar);
            } else if (itemSeparator.equalsIgnoreCase("line")) {
                uri = this.getResource(LineSeparatorImage.class.getName()).getUri(context, (Object)toolBar);
            } else {
                throw new FacesException("Unknown type of separator - \"" + itemSeparator + "\"");
            }
            writer.startElement("td", (UIComponent)toolBar);
            writer.writeAttribute("align", (Object)"center", null);
            this.getUtils().writeAttribute(writer, "class", toolBar.getAttributes().get("separatorClass"));
            writer.startElement("img", (UIComponent)toolBar);
            this.getUtils().writeAttribute(writer, "src", (Object)uri);
            this.getUtils().writeAttribute(writer, "alt", (Object)"");
            writer.endElement("img");
            writer.endElement("td");
        }
    }

    protected Class getComponentClass() {
        return UIToolBar.class;
    }

    public boolean getRendersChildren() {
        return true;
    }
}

