package org.richfaces.component;

import java.io.InputStream;
import java.util.Map;

import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpServletRequest;

import org.ajax4jsf.Filter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.request.MultipartRequest;
import org.richfaces.event.FileUploadListener;
import org.richfaces.event.UploadEvent;
import org.richfaces.renderkit.FileUploadRendererBase;



/**
 * JSF component class
 * 
 */
public abstract class UIFileUpload extends UIInput {

    /**
     * <p>
     * The standard component type for this component.
     * </p>
     */
    public static final String COMPONENT_TYPE = "org.richfaces.component.FileUpload";

    /**
     * <p>
     * The standard component family for this component.
     * </p>
     */
    public static final String COMPONENT_FAMILY = "org.richfaces.component.FileUpload";

    private String localContentType;

    private String localFileName;

    private Integer localFileSize;

    private InputStream localInputStream;
    
    private void setupProgressBarValueExpression(FacesContext context, String uid) {
	    FileUploadRendererBase renderer = (FileUploadRendererBase)this.getRenderer(context);
	    UIComponent progressBar = renderer.getProgressBar(context, this);
	    String exprStr = "#{" + Filter.PERCENT_BEAN_NAME + "['"+uid+"']}";
		ValueExpression ex = context.getApplication().getExpressionFactory()
			.createValueExpression(context.getELContext(), exprStr,
				Integer.class);
		progressBar.setValueExpression("value", ex);
	}


 
    public String getLocalContentType() {
        return localContentType;
    }

    public void setLocalContentType(String localContentType) {
        this.localContentType = localContentType;
    }

    public String getLocalFileName() {
        return localFileName;
    }

    public void setLocalFileName(String localFileName) {
        this.localFileName = localFileName;
    }

    public Integer getLocalFileSize() {
        return localFileSize;
    }

    public void setLocalFileSize(Integer localFileSize) {
        this.localFileSize = localFileSize;
    }

    public InputStream getLocalInputStream() {
        return localInputStream;
    }

    public void setLocalInputStream(InputStream localInputStream) {
        this.localInputStream = localInputStream;
    }

    public abstract void setAcceptedTypes(String acceptedTypes);

    public abstract String getAcceptedTypes();

    public abstract Integer getMaxFilesQuantity();

    public abstract void setMaxFilesQuantity(Integer maxFilesQuantity);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String styleClass);

    public abstract void setStyle(String style);

    public abstract MethodExpression getFileUploadListener();

    public abstract void setFileUploadListener(MethodExpression scrollerListener);

    public void addFileUploadListener(FileUploadListener listener) {
        addFacesListener(listener);
    }

    public FileUploadListener[] getFileUploadListeners() {
        return (FileUploadListener[]) getFacesListeners(FileUploadListener.class);
    }

    public void removeFileUploadListener(FileUploadListener listener) {
        removeFacesListener(listener);
    }
    
    public void reset () {
	this.localContentType = null;
	this.localContentType = null;
	this.localFileName = null;
	this.localFileSize = null;
	this.localInputStream = null;
    }

    public void broadcast(FacesEvent e) {

        super.broadcast(e);

        if (e instanceof UploadEvent) {
            // XXX BTW, why doesn't UploadEvent accept any listeners?

            FacesContext facesContext = FacesContext.getCurrentInstance();
            MethodExpression binding = getFileUploadListener();
            if (binding != null) {
                binding.invoke(facesContext.getELContext(), new Object[] { e });
            }

        } else {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            HttpServletRequest request = (HttpServletRequest) externalContext.getRequest();
            if ("progress".equals(request.getParameter("action"))
		    && request.getParameterMap().containsKey(
			    this.getClientId(facesContext))) {
                AjaxContext ajaxContext = AjaxContextImpl.getCurrentInstance(facesContext);
                String uid = request.getParameter(Filter.UPLOAD_FILES_ID);

                Map<String, Object> sessionMap = externalContext.getSessionMap();

                Map<String, MultipartRequest> sessions = (Map<String, MultipartRequest>) sessionMap
                        .get(Filter.REQUESTS_SESSIONS_BEAN_NAME);
                if (sessions != null) {
                    MultipartRequest multipartRequest = sessions.get(uid);
                    if (multipartRequest != null) {
                	setupProgressBarValueExpression(facesContext, uid);
                        ajaxContext.setResponseData(multipartRequest.getSize());
                    }
                }
            }
        }

    }
}
