package org.richfaces.component;

import java.io.IOException;
import java.util.Set;

import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;

import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.richfaces.renderkit.html.ToolTipRenderer;

public abstract class UIToolTip extends UIComponentBase implements org.ajax4jsf.component.AjaxChildrenEncoder{

	public static final String COMPONENT_TYPE = "org.richfaces.component.ToolTip";
	public static final String CONTENT_FACET_NAME = "defaultContent";

	public abstract String getValue();

	public abstract void setValue(String value);

	public abstract String getLayout();

	public abstract void setLayout(String layout);
	
	public abstract String getEvent();

	public abstract void setEvent(String event);

	public abstract String getMode();

	public abstract void setMode(String mode);
	
	public abstract boolean isDisabled();

	public abstract void setDisabled(boolean disabled);

	public abstract String getDirection();

	public abstract void setDirection(String direction);

	public abstract boolean isFollowMouse();

	public abstract void setFollowMouse(boolean followMouse);

	public abstract int getHorizontalOffset();

	public abstract void setHorizontalOffset(int horizontalOffset);

	public abstract int getVerticalOffset();

	public abstract void setVerticalOffset(int verticalOffset);

	public abstract String getStyle();

	public abstract void setStyle(String style);

	public abstract String getStyleClass();

	public abstract void setStyleClass(String styleClass);

	public abstract String getOncomplete();

	public abstract void setOncomplete(String oncomplete);

	public abstract String getOnshow();

	public abstract void setOnshow(String onshow);

	public abstract String getOnhide();

	public abstract void setOnhide(String onhide);

	public abstract String getOnclick();

	public abstract void setOnclick(String onclick);

	public abstract String getOndblclick();

	public abstract void setOndblclick(String ondblclick);

	public abstract String getOnmouseout();

	public abstract void setOnmouseout(String onmouseout);

	public abstract String getOnmousemove();

	public abstract void setOnmousemove(String onmousemove);

	public abstract String getOnmouseover();

	public abstract void setOnmouseover(String onmouseover);
	
	public abstract int getShowDelay();

	public abstract void setShowDelay(int delay);
	
	public abstract int getHideDelay();

	public abstract void setHideDelay(int delay);

	public abstract int getZorder();

	public abstract void setZorder(int delay);
	
	public abstract String getFor();
	
	public abstract void setFor(String _for);
	
	public abstract String getShowEvent();
	
	public abstract void setShowEvent(String showEvent);
	
	public abstract String getHideEvent();
	
	public abstract void setHideEvent(String hideEvent);
	
	
	public String getUsedElementType(){
		return getLayout().equals("block") ? "div" : "span";
	}
	
	public void broadcast(FacesEvent event) throws AbortProcessingException {

		super.broadcast(event);

		if (event instanceof AjaxEvent) {
			FacesContext facesContext = FacesContext.getCurrentInstance();
			AjaxContext ajaxContext = AjaxContext.getCurrentInstance(facesContext);
			ajaxContext.getAjaxAreasToRender().add(this.getClientId(facesContext) + "content");
			ajaxContext.addRegionsFromComponent(this);
		}
	}
	
	public void encodeAjaxChild(FacesContext context, String path, Set ids,
			Set renderedAreas) throws IOException {
		
		if(ids.contains(this.getClientId(context) + "content")){
			AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
			ToolTipRenderer r = (ToolTipRenderer)getRenderer(context);
			r.encodeTooltipText(context, this);
			ajaxContext.getAjaxRenderedAreas().add(this.getClientId(context) + "content");
		} else {
			// todo
//			AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
//			ajaxContext.e
			
		}
			
	}
	
}
