if (!window.RichFaces) window.RichFaces = {};
var Suggestion = {};
Suggestion.Base = function() {
};
Suggestion.Base.prototype = {
    baseInitialize: function(element, update, options) {
        this.isOpera = (RichFaces.navigatorType() == RichFaces.OPERA?true:false);
        this.element = $(element);
        this.update = $(update);
        this.hasFocus = false;
        this.changed = false;
        this.active = false;
        this.index = 0;
        this.prevIndex = -1;
        this.entryCount = 0;
        this.keyEvent = false;
        this.oldValue = this.element.value;
        this.skipHover = false;

		options.selection = update + "_selection";

        var needIframe = (RichFaces.navigatorType() == RichFaces.MSIE);

        if (needIframe) {
            options.iframeId = update + "_iframe";
        }

        if (this.setOptions)
            this.setOptions(options);
        else
            this.options = options || {};

        this.options.param = this.options.param || this.element.name;
        this.options.selectedClasses = (this.options.selectedClass
                || "dr-sb-int-sel rich-sb-int-sel").split(' ');
        this.options.selectValueClass = this.options.selectValueClass
                || " ";
        this.options.tokens = $A(options.tokens) || [];
        this.options.frequency = this.options.frequency || 0.4;
        this.options.minChars = parseInt(this.options.minChars) || 1;
        this.options.onShow = this.options.onShow ||
                              function(element, update, options) {
                                  if (!update.style.position
                                          || update.style.position
                                          == 'absolute') {
                                      update.style.position = 'absolute';
                                      RichFaces.Position.smartClone(element, update, options);
                                  }
                                  if (!window.opera) {
	                                  Effect.Appear(update, {duration:0.15});
	                                  if (options.iframeId) {
	                                      Effect.Appear($(options.iframeId), {duration:0.15, to: 0.01});
	                                  }
                                  } else {
                                  	  // workaround for RF-205
	                                  Effect.Appear(update, {duration:0.15, to: 0.999999});
                                  }
                              };
        this.options.onHide = this.options.onHide ||
                              function(element, update, options) {
                                  if (options.iframeId) {
                                      new Effect.Fade($(options.iframeId), {duration:0.15});
                                  }
                                  new Effect.Fade(update, {duration:0.15});
                              };

        this.options.width = this.options.width || "auto";

        if (typeof(this.options.tokens) == 'string')
            this.options.tokens = new Array(this.options.tokens);
        for (var i = 0; i < this.options.tokens.length; i++) {
            var token = this.options.tokens[i];
            if (token.charAt[0] == "'" && token.charAt[token.length - 1] == "'")
                this.options.tokens[i] = token.substring(1, -1);
        }

        this.observerHandle = null;

        this.element.setAttribute('autocomplete', 'off');

        Element.hide(this.update);
		
		
        this.onBlurListener = this.onBlur.bindAsEventListener(this);
        Event.observe(this.element, "blur", this.onBlurListener);

        this.onKeyDownListener = this.onKeyDown.bindAsEventListener(this);
        Event.observe(this.element, "keydown", this.onKeyDownListener);

        if (this.isOpera) {
            this.onKeyUpListener = this.onKeyUp.bindAsEventListener(this);
            Event.observe(this.element, "keyup", this.onKeyUpListener);
            this.upDown = 0;
        }

		this.onScrollListener = this.onScroll.bindAsEventListener(this);

		if (options.popupClass)
			Element.addClassName(document.getElementsByClassName("dr-sb-ext-decor-3",
											this.update)[0], options.popupClass);

		this.onNothingLabelClick = this.hideNLabel.bindAsEventListener(this);
    },

    onBoxKeyPress: function(event) {
        if (this.upDown == 1) {
            this.keyEvent = true;
            this.markPrevious();
            this.render();
        } else if (this.upDown == 2) {
            this.keyEvent = true;
            this.markNext();
            this.render();
        } else if (this.upDown == 3) {
            this.keyEvent = true;
            this.markPreviousPage();
            this.render();
        } else if (this.upDown == 4) {
            this.keyEvent = true;
            this.markNextPage();
            this.render();
        }
    },

    cancelSubmit: function(event) {
        Event.stop(event);
    },

    disableSubmit: function() {
        if (this.isOpera) {
            var el = this.element;
            while (el.parentNode && (!el.tagName || (el.tagName.toUpperCase()
                    != 'FORM')))
                el = el.parentNode;
            if (el.tagName && (el.tagName.toUpperCase() == 'FORM')) {
                this.parentForm = el;
                this.onSubmitListener
                        = this.cancelSubmit.bindAsEventListener(this);
                Event.observe(el, "submit", this.onSubmitListener);
            }
        }
        
    },

    enableSubmit: function() {
        if (this.isOpera) {
            if (this.parentForm) {
                Event.stopObserving(this.parentForm, "submit", this.onSubmitListener);
            }
        }
    },

    onKeyUp: function(event) {
        if (this.upDown > 0) {
            this.element.onkeypress = this.prevOnKeyPress;
        }
        this.upDown = 0;
    },
 
    show: function() {
		if (RichFaces.SAFARI == RichFaces.navigatorType()) {
			this.wasScroll = false;
			this.wasBlur = false;
			if (!this.overflow)
				this.overflow = document.getElementsByClassName("dr-sb-overflow", this.update)[0];
	       	Event.observe(this.overflow, "scroll", this.onScrollListener);
		}
        if (Element.getStyle(this.update, 'display')
                == 'none') this.options.onShow(this.element, this.update, this.options);
        this.disableSubmit();
    },

    hide: function() {
		if (RichFaces.SAFARI == RichFaces.navigatorType()) {
			if (this.wasScroll) {
				this.wasScroll = false;
				return;
			}
			Event.stopObserving(this.overflow, "scroll", this.onScrollListener)
		}
        this.stopIndicator();
        if (Element.getStyle(this.update, 'display')
                != 'none') this.options.onHide(this.element, this.update, this.options);
        this.enableSubmit();
		this.hasFocus = false;
        this.active = false;
    },

    hideNLabel: function(event) {
	var nothingLabel = $(this.update.id + "NothingLabel");
    	if (nothingLabel) {
	    	Element.hide(nothingLabel);
	    	Event.stopObserving(nothingLabel, "click", this.onNothingLabelClick);
	    	Event.stopObserving(this.element, "blur", this.onNothingLabelClick);
	    	this.hide();
    	}
    },

    startIndicator: function() {
        if (this.options.indicator) Element.show(this.options.indicator);
    },

    stopIndicator: function() {
        if (this.options.indicator) Element.hide(this.options.indicator);
    },

    isUnloaded: function() {
        if (this.element.parentNode && this.update.parentNode) {
            return false;
        }
        LOG.info("Element unloaded from DOM");
        if (this.element) {
            Event.stopObserving(this.element, "blur", this.onBlurListener);
            Event.stopObserving(this.element, "keydown", this.onKeyDownListener);
        }
        return true;
    },

    onKeyDown: function(event) {
        if (this.isUnloaded()) return;
        if (!this.initialized) {
            if (this.options.iframeId) {
                var iFrame = $(this.options.iframeId);
                var iTemp = iFrame.cloneNode(true);
                iFrame.parentNode.removeChild(iFrame);
                document.body.insertBefore(iTemp, document.body.firstChild);
            }
            var temp = this.update.cloneNode(true);
            this.update.parentNode.removeChild(this.update);
            this.update = temp;
            document.body.insertBefore(this.update, document.body.firstChild);
            this.initialized = true;
        }
        this.wasBlur = false;
        if (this.active) {
            this.wasScroll = false;
            switch (event.keyCode) {
                case Event.KEY_TAB:
                case Event.KEY_RETURN:
                    this.selectEntry(event);
                    Event.stop(event);
                case Event.KEY_ESC:
                    this.hide();
                    this.active = false;
                    Event.stop(event);
                    if (this.isOpera) {
                        this.element.focus();
                    }
                    return;
                case Event.KEY_LEFT:
                case Event.KEY_RIGHT:
                    return;
                case Event.KEY_UP:
                    this.keyEvent = true;
                    this.markPrevious();
                    this.render();
                    if (navigator.appVersion.indexOf('AppleWebKit')
                            > 0) Event.stop(event);
                    if (this.isOpera) {
                        this.upDown = 1;
                        this.prevOnKeyPress = this.element.onkeypress;
                        this.element.onkeypress
                                = this.onBoxKeyPress.bindAsEventListener(this);
                    }
                    return;
                case Event.KEY_DOWN:
                    this.keyEvent = true;
                    this.markNext();
                    this.render();
                    if (navigator.appVersion.indexOf('AppleWebKit')
                            > 0) Event.stop(event);
                    if (this.isOpera) {
                        this.upDown = 2;
                        this.prevOnKeyPress = this.element.onkeypress;
                        this.element.onkeypress
                                = this.onBoxKeyPress.bindAsEventListener(this);
                    }
                    return;
                case 33:
                    this.keyEvent = true;
                    this.markPreviousPage();
                    this.render();
                    if (navigator.appVersion.indexOf('AppleWebKit')
                            > 0) Event.stop(event);
                    if (this.isOpera) {
                        this.upDown = 3;
                        this.prevOnKeyPress = this.element.onkeypress;
                        this.element.onkeypress
                                = this.onBoxKeyPress.bindAsEventListener(this);
                    }
                    return;
                case 34:
                    this.keyEvent = true;
                    this.markNextPage();
                    this.render();
                    if (navigator.appVersion.indexOf('AppleWebKit')
                            > 0) Event.stop(event);
                    if (this.isOpera) {
                        this.upDown = 4;
                        this.prevOnKeyPress = this.element.onkeypress;
                        this.element.onkeypress
                                = this.onBoxKeyPress.bindAsEventListener(this);
                    }
                    return;
            }
        } else if (event.keyCode == Event.KEY_TAB
                || event.keyCode  == Event.KEY_RETURN
                || event.keyCode  == Event.KEY_ESC) {
                return;
        }

        this.changed = true;
        this.hasFocus = true;

        if (this.observerHandle) {
            LOG.debug("clear existing observer");
            window.clearTimeout(this.observerHandle)
        }
        ;
        LOG.debug("set timeout for request suggestion");
        // Clone event. after call in timeout handdler, original event is unaccesible.
        var domEvt = {};
        try {
            domEvt.target = event.target;
            domEvt.srcElement = event.srcElement;
            domEvt.type = event.type;
            domEvt.altKey = event.altKey;
            domEvt.button = event.button;
            domEvt.clientX = event.clientX;
            domEvt.clientY = event.clientY;
            domEvt.ctrlKey = event.ctrlKey;
            domEvt.keyCode = event.keyCode;
            domEvt.modifiers = event.modifiers;
            domEvt.pageX = event.pageX;
            domEvt.pageY = event.pageY;
            domEvt.screenX = event.screenX;
            domEvt.screenY = event.screenY;
            domEvt.shiftKey = event.shiftKey;
            domEvt.which = event.which;
        } catch(e) {
            LOG.warn("Exception on clone event");
        }
        this.observerHandle =
        window.setTimeout(this.onObserverEvent.bind(this, domEvt), this.options.frequency
                * 1000);
    },

    onHover: function(event) {
        var element = Event.findElement(event, 'TR');
    	if (!this.skipHover) {
	        if (this.index != element.autocompleteIndex) {
	            this.index = element.autocompleteIndex;
	            this.render();
	        }
	        if (event.type == 'mousemove') {
	        	Event.stopObserving(element, "mousemove", this.onHover);
	        }
    	} else {
    		this.skipHover = false;
	        Event.observe(element, "mousemove", this.onHover.bindAsEventListener(this));
    	}
        Event.stop(event);
    },

    onClick: function(event) {
		this.wasScroll = false;
		this.wasBlur = false;
        var element = Event.findElement(event, 'TR');
        this.index = element.autocompleteIndex;
        this.selectEntry(event);
        this.hide();
    },

    onMouseOut: function(event) {
        var element = Event.findElement(event, 'TR');
       	Event.stopObserving(element, "mousemove", this.onHover);
    },

    onBlur: function(event) {
        if (this.isUnloaded()) return;
		this.wasBlur = true;
        if (!this.active) return;
        var offsets = RichFaces.Position.calcOffsets(this.update);
        
        if (RichFaces.navigatorType() != RichFaces.MSIE) {
            offsets["x"] = 0;
            offsets["y"] = 0;
        }
        
        var x = event.clientX + 
        	document.body.scrollLeft + 
        	document.documentElement.scrollLeft;
        	
        var y = event.clientY + 
        	document.body.scrollTop+ 
        	document.documentElement.scrollTop;
        
        if (x > offsets["x"] && x < (this.update.clientWidth + offsets["x"])) {
            if (y > (offsets["y"] - this.update.clientHeight) && y < offsets["y"]) {
                this.element.focus();
                return;
            }
        }
        // needed to make click events working
        setTimeout(this.hide.bind(this), 250);
    },

	onScroll: function(event) {
		if (RichFaces.SAFARI == RichFaces.navigatorType() && this.wasBlur ) {
			if(this.element) {
				this.element.focus();
				this.wasScroll = true;
				this.wasBlur = false;
			}
		}
	},

	calcEntryPosition: function(entry, scroll) {
        var item = entry;
        var realOffset = 0;
        while (item && (item != scroll)) {
        	// Avoid bug in Safari. Details: http://jacob.peargrove.com/blog/2006/technical/table-row-offsettop-bug-in-safari/
			if (RichFaces.SAFARI == RichFaces.navigatorType() && "TR" == item.tagName.toUpperCase()) {
				realOffset += document.getElementsByClassName("dr-sb-cell-padding", item)[0].offsetTop;
			}
			else
            	realOffset += item.offsetTop;
            if (item.parentNode == scroll) break;
            item = item.offsetParent;
        }

		var entryOffsetHeight;
		if (RichFaces.SAFARI == RichFaces.navigatorType()) {
			var tdElement = document.getElementsByClassName("dr-sb-cell-padding", item)[0];
			entryOffsetHeight = tdElement.offsetTop + tdElement.offsetHeight;
		} else
			entryOffsetHeight = entry.offsetHeight;
		return {realOffset:realOffset, entryOffsetHeight:entryOffsetHeight};
	},

	countVisibleEntries: function() {
		var entry = this.getEntry(this.index);
        var scroll = document.getElementsByClassName("_suggestion_size_", this.update)[0]
                || this.update;

		var entryPosition = this.calcEntryPosition(entry,scroll);

		var countAll = Math.round(scroll.clientHeight/entryPosition.entryOffsetHeight);
		var current = Math.round((entryPosition.realOffset-scroll.scrollTop)/entryPosition.entryOffsetHeight);
		return {current:current,all:countAll};
	},

    render: function() {
        if (this.entryCount > 0) {
            LOG.debug('render for index ' + this.index + " and old index "
                    + this.prevIndex);
            if (this.prevIndex != this.index) {
                var entry = this.getEntry(this.index);
                for (var i = 0; i < this.options.selectedClasses.length; i++)
	                Element.addClassName(entry, this.options.selectedClasses[i]);

                var cells = document.getElementsByClassName("dr-sb-cell-padding" , entry);
                for (var i = 0; i < cells.length; i++) {
                	Element.addClassName(cells[i], this.options.selectValueClass);
                }

                // Calc scroll position :
                if (this.keyEvent) {
	                var scroll = document.getElementsByClassName("_suggestion_size_", this.update)[0]
	                        || this.update;

					var entryPosition = this.calcEntryPosition(entry,scroll);

					var oldScrollTop = scroll.scrollTop;
                    if (entryPosition.realOffset > scroll.scrollTop + scroll.clientHeight - entryPosition.entryOffsetHeight) {
                    	scroll.scrollTop = entryPosition.realOffset - scroll.clientHeight + entryPosition.entryOffsetHeight;
                    } else if (entryPosition.realOffset < scroll.scrollTop) {
                    	scroll.scrollTop = entryPosition.realOffset;
                    }
                    if (oldScrollTop != scroll.scrollTop) {
                    	this.skipHover = true;
                    }
                    this.keyEvent = false;
                }
                // remove hightliit from inactive entry
                if (this.prevIndex >= 0) {
                    var prevEntry = this.getEntry(this.prevIndex);
                    if (prevEntry) {
                    	var prevCells = document.getElementsByClassName("dr-sb-cell-padding" , prevEntry);
		                for (var i = 0; i < prevCells.length; i++) {
		                	Element.removeClassName(prevCells[i], this.options.selectValueClass);
                		}
                		for (var i = 0; i < this.options.selectedClasses.length; i++)
	                        Element.removeClassName(prevEntry, this.options.selectedClasses[i]);
                    }
                }
            }

            this.prevIndex = this.index;
            if (this.hasFocus && !this.wasBlur) {
                this.show();
                this.active = true;
            }
        } else {
		var nothingLabel = $(this.update.id + "NothingLabel");
		if (!nothingLabel || 'none' == nothingLabel.style.display) {
			this.active = false;
			this.hide();
		}
        }
    },

    markPrevious: function() {
        if (this.index > 0) this.index--;
        //else this.index = this.entryCount - 1;
    },

    markNext: function() {
        if (this.index < this.entryCount - 1) this.index++;
        //else this.index = 0;
    },

    markPreviousPage: function() {
    	var pos = this.countVisibleEntries();
        if (this.index > 0) {
        	if (pos.current>0) this.index = this.index - Math.min(pos.current,pos.all);
        		else this.index = this.index - pos.all;
        	if (this.index < 0) this.index = 0;
        }
    },

    markNextPage: function() {
    	var pos = this.countVisibleEntries();
        if (this.index < this.entryCount - 1) {
        	if ((pos.current < pos.all - 1) && pos.current>=0) this.index = this.index + (pos.all - pos.current - 1);
        		else this.index = this.index + pos.all;
        	if (this.index > this.entryCount - 1) this.index = this.entryCount - 1;
        }
    },

    getEntry: function(index) {
        if (this.options.entryClass) {
            return document.getElementsByClassName(this.options.entryClass, this.update)[index];
        } else {
            return this.update.firstChild.firstChild.childNodes[index];
        }
    },

    getCurrentEntry: function() {
        return this.getEntry(this.index);
    },

    selectEntry: function(event) {
        this.active = false;
		
		var input = $(this.options.selection);
		input.value = this.index;
		var value="";
		if ( this.fetchValues && (value=this.fetchValues[this.index]) )
		{
			$(this.content+"_hiddenFetchValue").value = value;
		}
        
        this.updateElement(this.getCurrentEntry());
        if (this.options.onselect) {
            this.options.onselect(this, event);
        }
        if (this.update.onselect) {
            this.update.onselect(this, event);
        }
		input.value = "";
    },

    updateElement: function(selectedElement) {
        if (this.options.updateElement) {
            this.options.updateElement(selectedElement);
            return;
        }
        var value = '';
        if (this.options.select) {
            var nodes = document.getElementsByClassName(this.options.select, selectedElement)
                    || [];
            if (nodes.length > 0) value
                    = Element.collectTextNodes(nodes[0], this.options.select);
        } else
            value = Element.collectTextNodesIgnoreClass(selectedElement, 'informal');

        var lastTokenPos = this.findLastToken();
        if (lastTokenPos != -1) {
            var newValue = this.element.value.substr(0, lastTokenPos + 1);
            var whitespace = this.element.value.substr(lastTokenPos
                    + 1).match(/^\s+/);
            if (whitespace)
                newValue += whitespace[0];
            this.element.value = newValue + value;
        } else {
            this.element.value = value;
        }
        this.oldValue = this.element.value;
        this.element.focus();

        if (this.options.afterUpdateElement)
            this.options.afterUpdateElement(this.element, selectedElement);
    },

    updateChoices: function(choices) {
        if (!this.changed && this.hasFocus) {
            if (choices) {
                this.update.firstChild.replaceChild(choices, this.update.firstChild.firstChild);
            }
            // TODO - get entry elements by tag name or class
            var entryes = [];
            if (this.options.entryClass) {
                entryes = document.getElementsByClassName(this.options.entryClass, this.update)
                        || [];
            } else if (this.update.firstChild
                    && this.update.firstChild.firstChild
                    && this.update.firstChild.firstChild.childNodes) {
                Element.cleanWhitespace(this.update);
                Element.cleanWhitespace(this.update.firstChild);
                Element.cleanWhitespace(this.update.firstChild.firstChild);
                entryes = this.update.firstChild.firstChild.childNodes;
            }
            this.entryCount = entryes.length;
            for (var i = 0; i < this.entryCount; i++) {
                var entry = entryes[i];
                //          var entry = this.getEntry(i);
                entry.autocompleteIndex = i;
                this.addObservers(entry);
                //                if (this.options.cellpadding)
                //                entry.lastChild.style.padding=this.options.cellpadding;
            }

            this.stopIndicator();
            var scroll = document.getElementsByClassName("_suggestion_size_", this.update)[0]
                    || this.update;
            scroll.scrollTop = -1;
            scroll.scrollLeft = -1;
            this.index = 0;
            this.prevIndex = -1;

		var nothingLabel = $(this.update.id + "NothingLabel");
		if (nothingLabel) {
			if (this.entryCount < 1) {
				Element.show(nothingLabel);
				Event.observe(nothingLabel, "click", this.onNothingLabelClick);
				Event.observe(this.element, "blur", this.onNothingLabelClick);
				this.show();
			}
		}

            this.render();
        }
    },

    addObservers: function(element) {
        Event.observe(element, "mouseover", this.onHover.bindAsEventListener(this));
        Event.observe(element, "click", this.onClick.bindAsEventListener(this));
        Event.observe(element, "mouseout", this.onMouseOut.bindAsEventListener(this));
    },

    onObserverEvent: function(event) {
        LOG.debug("Observer event occurs");
        this.changed = false;
        var oldValue = this.element.value;
        if (this.getToken().length >= this.options.minChars) {
            LOG.debug("Call data for update choices");
			if ((event.keyCode == Event.KEY_DOWN || this.oldValue != oldValue) && oldValue.length > 0) {
	            this.startIndicator();
    	        this.getUpdatedChoices(event);
        	}
        } else {
            this.active = false;
            this.hide();
        }
    	this.oldValue = oldValue;
        this.observerHandle = null;
    },

    getToken: function() {
        var tokenPos = this.findLastToken();
        if (tokenPos != -1)
            var ret = this.element.value.substr(tokenPos
                    + 1).replace(/^\s+/, '').replace(/\s+$/, '');
        else
            var ret = this.element.value;

        return /\n/.test(ret) ? '' : ret;
    },

    findLastToken: function() {
        var lastTokenPos = -1;

        for (var i = 0; i < this.options.tokens.length; i++) {
            var thisTokenPos = this.element.value.lastIndexOf(this.options.tokens[i]);
            if (thisTokenPos > lastTokenPos)
                lastTokenPos = thisTokenPos;
        }
        return lastTokenPos;
    }
}


RichFaces.Suggestion = Class.create();
Object.extend(Object.extend(RichFaces.Suggestion.prototype, Suggestion.Base.prototype), {
    initialize: function(containerId, actionUrl, element, content, onsubmit, options) {
        var update = options.popup || 'ac1update';
        if (!$(update)) this.create(element, update, content, options);
        this.baseInitialize(element, update, options);
        this.options.asynchronous = true;
        this.options.onajaxcomplete = options.oncomplete;
        this.options.oncomplete = this.onComplete.bind(this);
        this.options.defaultParams = this.options.parameters || null;
        this.content = content;
        this.containerId = containerId;
        this.actionUrl = actionUrl;

        if (onsubmit && onsubmit != 'null'){
			this.onsubmitFunction = new Function(onsubmit+';return true;').bind(this.element);
		}

        return this;
    },

    getUpdatedChoices: function(event) {
        this.options.parameters[this.options.param] = this.getToken();

        if (this.onsubmitFunction && ! this.onsubmitFunction()) {
			return;
		}

        A4J.AJAX.Submit(this.containerId, this.actionUrl, event, this.options);
    },

    onComplete: function(request, event, data) {
        LOG.debug("AJAX response  complete - updateChoices");
        // Calculate height of choices window
        if (!this.update.style.position || this.update.style.position
                == 'absolute') {
            this.update.style.position = 'absolute';
            RichFaces.Position.smartClone(this.element, this.update, this.options);
        }
        this.updateChoices();
        this.fetchValues = data;
        LOG.debug("Choices updated");
        if (this.options.onajaxcomplete) {
            this.options.onajaxcomplete(request, event);
        }
    },

    create: function(element, suggestion, content, options) {
        if (!$(element)) return;
        var style = "display:none;" + ( options.popupStyle
                || "border:1px solid black;position:absolute; background-color:white;");
        var styleClass = options.popupClass ? ' class="' + options.popupClass
                + '" ':'';
        new Insertion.Top($(element).ownerDocument.body,
                '<div id="' + suggestion + '"' + styleClass + ' style="' + style
                        + '">' +
                '<table id="' + content + '" cellspacing="0" cellpadding="0">' +
                '<tbody></tbody>' +
                '</table>' +
                '</div>'
                );
    }

});

RichFaces.Position = {
    source: null,
    target: null,
    smartClone: function(source, target, options) {
        this.options = Object.extend({
            width: "auto"
        }, options || {});

        this.source = $(source);
        this.target = $(target);

        var targetStyle = {};
        /*
        http://jira.exadel.com/browse/RFA-236

        var pos = RichFaces.SmartPosition.getPosition(this.source, this.target, options);

        if (RichFaces.navigatorType() == "MSIE") {
            var offsets = this.calcOffsets(this.source);
            Element.setStyle(this.target, Object.extend({"left": offsets["x"] + "px", "top": offsets["y"] + "px"}, targetStyle));
        } else {
            Element.setStyle(this.target, Object.extend({"left": pos[0] + "px", "top": pos[1] + "px"}, targetStyle));
        }
        */
        var offsets = this.calcOffsets(this.source);
        Element.setStyle(this.target, Object.extend({"left": offsets["x"]
                + "px", "top": offsets["y"] + "px"}, targetStyle));

        if (options.iframeId) {
            var iframe = $(options.iframeId);
            Position.clone(this.target, iframe);
            Element.setStyle(this.target, {zIndex: 201});

            Element.setStyle(iframe, {zIndex: 200});
            iframe.style.position = "absolute";
            iframe.style.top = this.target.style.top;
            iframe.style.left = this.target.style.left;
            iframe.style.width = this.target.style.width;
            iframe.style.height = this.target.style.height;
        }
    },

    calcOffsets : function(element) {
        var ret = new Object(), height = 0;
        var left = element.offsetLeft;
        var top = element.offsetTop;
        var parent = element.offsetParent;
        while (parent)
        {
            left += parent.offsetLeft;
            top += parent.offsetTop;
            parent = parent.offsetParent;
        }

        ret["x"] = left;
        ret["y"] = top + element.offsetHeight;

        return ret;
    },

    _removePx : function(str) {
        str += "";
        if (str.indexOf("px") != -1) {
            return str.substr(0, str.indexOf("px"));
        }
        return str;
    },

    calcHeight: function() {
        return this.options.height == "auto" ? "" :this.options.height;
    },

    calcTop: function(targetHeight) {
        var sourceOffset = Position.cumulativeOffset(this.source);
        var sourceTop = sourceOffset[1];
        var sourceHeight = this.source.offsetHeight;
        var body = this.getBody();
        //		if (sourceTop + sourceHeight + targetHeight <= body.clientHeight) {
        return sourceTop + sourceHeight - 1;
    },

    calcWidth: function() {
        if (this.options.width == "auto") {
            return "";
        } else {
            if (this.options.width.indexOf("%") >= 0) {
                // Count persents to pixels
                var percent = parseInt(this.options.width.substring(0, this.options.width.indexOf("%")));
                var sizeInPixels = parseInt(this.source.offsetWidth) * percent
                        / 100;
                this.options.width = sizeInPixels + "px";
            }

            return this.options.width;
        }
        //		return this.source.offsetWidth;
    },

    calcLeft: function(targetWidth) {
        //		Position.prepare();
        var sourceOffset = Position.cumulativeOffset(this.source);
        var sourceLeft = sourceOffset[0];
        var sourceWidth = this.source.offsetWidth;
        var body = this.getBody();
        var width = parseInt(sourceLeft) + parseInt(sourceWidth)
                + parseInt(targetWidth);
        if (width <= parseInt(body.clientWidth)) {
            return sourceLeft;
        } else {
            return width;
        }
    },

    getBody: function() {
        return this.source.ownerDocument.body;
    }
}
