/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.ajax4jsf.component.AjaxActionComponent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;

public abstract class UIDatascroller
extends AjaxActionComponent
implements DataScrollerSource,
ActionSource {
    private Integer firstRow;
    public static final String COMPONENT_TYPE = "org.richfaces.Datascroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.Datascroller";
    public static final String FIRST_FACET_NAME = "first";
    public static final String LAST_FACET_NAME = "last";
    public static final String NEXT_FACET_NAME = "next";
    public static final String PREVIOUS_FACET_NAME = "previous";
    public static final String FAST_FORWARD_FACET_NAME = "fastforward";
    public static final String FAST_REWIND_FACET_NAME = "fastrewind";
    public static final String FIRST_DISABLED_FACET_NAME = "first_disabled";
    public static final String LAST_DISABLED_FACET_NAME = "last_disabled";
    public static final String NEXT_DISABLED_FACET_NAME = "next_disabled";
    public static final String PREVIOUS_DISABLED_FACET_NAME = "previous_disabled";
    public static final String FAST_FORWARD_DISABLED_FACET_NAME = "fastforward_disabled";
    public static final String FAST_REWIND_DISABLED_FACET_NAME = "fastrewind_disabled";

    public void addScrollerListener(DataScrollerListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[])this.getFacesListeners(DataScrollerListener.class);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataScrollerEvent) {
            DataScrollerEvent dataScrollerEvent = (DataScrollerEvent)event;
            this.setPage(dataScrollerEvent.getNewScrolVal(), true);
            FacesContext context = FacesContext.getCurrentInstance();
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getId());
            AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)this, (String)this.getFor());
            this.setupReRender(context);
            MethodExpression scrollerListener = this.getScrollerListener();
            if (scrollerListener != null) {
                scrollerListener.invoke(context.getELContext(), new Object[]{event});
            }
        }
    }

    public abstract MethodExpression getScrollerListener();

    public abstract void setScrollerListener(MethodExpression var1);

    public abstract void setFor(String var1);

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract void setFastStep(int var1);

    public abstract boolean isRenderIfSinglePage();

    public abstract void setRenderIfSinglePage(boolean var1);

    public abstract int getMaxPages();

    public abstract void setMaxPages(int var1);

    public abstract String getSelectedStyleClass();

    public abstract void setSelectedStyleClass(String var1);

    public abstract String getSelectedStyle();

    public abstract void setSelectedStyle(String var1);

    public abstract String getEventsQueue();

    public abstract void setEventsQueue(String var1);

    public abstract boolean isAjaxSingle();

    public abstract void setAjaxSingle(boolean var1);

    public abstract int getRequestDelay();

    public abstract void setRequestDelay(int var1);

    public abstract String getTableStyleClass();

    public abstract void setTableStyleClass(String var1);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);

    public abstract String getAlign();

    public abstract void setAlign(String var1);

    public abstract String getBoundaryControls();

    public abstract void setBoundaryControls(String var1);

    public abstract String getFastControls();

    public abstract void setFastControls(String var1);

    public abstract String getStepControls();

    public abstract void setStepControls(String var1);

    public abstract String getInactiveStyleClass();

    public abstract String getInactiveStyle();

    public abstract void setInactiveStyleClass(String var1);

    public abstract void setInactiveStyle(String var1);

    public UIData getDataTable() {
        String forAttribute = this.getFor();
        if (forAttribute == null) {
            UIDatascroller forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (!(forComp instanceof UIData)) continue;
                this.setFor(forComp.getId());
                return (UIData)forComp;
            }
            throw new FacesException("could not find dataTable for  datascroller " + this.getId());
        }
        UIComponent forComp = RendererUtils.getInstance().findComponentFor((UIComponent)this, forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public int getPageIndex(UIData uiData) {
        int rows = this.getRows(uiData);
        if (0 == rows) {
            throw new FacesException("Missing 'rows' attribute on component '" + uiData.getId() + "'");
        }
        int firstRow = this.getFirstRow();
        int pageIndex = rows > 0 ? firstRow / rows + 1 : 0;
        if (firstRow % rows > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    public int getPageIndex() {
        UIData uiData = this.getDataTable();
        return this.getPageIndex(uiData);
    }

    private void setFirstRowValue(int row) {
        FacesContext context = this.getFacesContext();
        ValueExpression ve = this.getValueExpression("firstRow");
        if (ve != null) {
            try {
                ve.setValue(context.getELContext(), (Object)row);
                this.firstRow = null;
            }
            catch (ELException e) {
                Throwable result;
                String messageStr = e.getMessage();
                for (result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                FacesMessage message = null == messageStr ? MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                context.getExternalContext().log(message.getSummary(), result);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
            catch (IllegalArgumentException e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                context.getExternalContext().log(message.getSummary(), (Throwable)e);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
            catch (Exception e) {
                FacesMessage message = MessageUtil.getMessage((FacesContext)context, (String)"javax.faces.component.UIInput.UPDATE", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)context, (UIComponent)this)});
                context.getExternalContext().log(message.getSummary(), (Throwable)e);
                context.addMessage(this.getClientId(context), message);
                context.renderResponse();
            }
        } else {
            this.setFirstRow(row);
        }
    }

    private int getFirstRowForLastPage(int rowCount, int rows) {
        int newFirst;
        int delta = rowCount % rows;
        int n = newFirst = delta > 0 && delta < rows ? rowCount - delta : rowCount - rows;
        if (newFirst >= 0) {
            return newFirst;
        }
        return 0;
    }

    public void setPage(String facetName) {
        this.setPage(facetName, false);
    }

    public void setPage(String facetName, boolean updateModel) {
        if (FIRST_FACET_NAME.equals(facetName)) {
            this.setFirstRowValue(0);
        } else {
            UIData dataTable = this.getDataTable();
            int first = this.getFirstRow();
            int rows = this.getRows(dataTable);
            int rowCount = this.getRowCount(dataTable);
            if (PREVIOUS_FACET_NAME.equals(facetName)) {
                int previous = first - rows;
                if (previous >= 0) {
                    this.setFirstRowValue(previous);
                }
            } else if (NEXT_FACET_NAME.equals(facetName)) {
                int next = first + rows;
                if (next < rowCount) {
                    this.setFirstRowValue(next);
                }
            } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
                int next;
                int fastStep = this.getFastStep();
                if (fastStep <= 0) {
                    fastStep = 1;
                }
                if ((next = first + rows * fastStep) >= rowCount) {
                    next = rowCount - 1 - (rowCount - 1) % rows;
                }
                this.setFirstRowValue(next);
            } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
                int previous;
                int fastStep = this.getFastStep();
                if (fastStep <= 0) {
                    fastStep = 1;
                }
                if ((previous = first - rows * fastStep) < 0) {
                    previous = 0;
                }
                this.setFirstRowValue(previous);
            } else if (LAST_FACET_NAME.equals(facetName)) {
                this.setFirstRow(this.getFirstRowForLastPage(rowCount, rows));
            } else {
                int pageCount;
                int pageindex = Integer.parseInt(facetName);
                if (pageindex > (pageCount = this.getPageCount(rowCount, rows))) {
                    pageindex = pageCount;
                } else if (pageindex <= 0) {
                    pageindex = 1;
                }
                this.setFirstRowValue(rows * (pageindex - 1));
            }
        }
    }

    public int getPageCount(int rowCount, int rows) {
        int pageCount;
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : rowCount / rows;
            if (rowCount % rows > 0) {
                ++pageCount;
            }
            if (pageCount == 0) {
                pageCount = 1;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getPageCount(UIData data) {
        return this.getPageCount(this.getRowCount(data), this.getRows(data));
    }

    public int getPageCount() {
        return this.getPageCount(this.getDataTable());
    }

    public int getRowCount(UIData data) {
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            return rowCount;
        }
        return BinarySearch.search(data);
    }

    public int getRowCount() {
        return this.getRowCount(this.getDataTable());
    }

    public int getRows(UIData data) {
        int row = 0;
        row = data.getRows();
        if (row == 0) {
            row = this.getRowCount(data);
        }
        return row;
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return this.getFacet(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return this.getFacet(NEXT_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return this.getFacet(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return this.getFacet(FAST_REWIND_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return this.getFacet(PREVIOUS_FACET_NAME);
    }

    public void updateFirstRow() {
        UIData dataTable = this.getDataTable();
        int rowCount = this.getRowCount(dataTable);
        int firstRow = this.getFirstRow();
        if (firstRow < 0) {
            this.setFirstRow(0);
        } else if (firstRow >= rowCount) {
            this.setFirstRow(this.getFirstRowForLastPage(rowCount, this.getRows(dataTable)));
        }
    }

    public int getFirstRow() {
        if (this.firstRow != null) {
            return this.firstRow;
        }
        ValueExpression ve = this.getValueExpression("firstRow");
        if (ve != null) {
            try {
                Integer firstRowObject = (Integer)ve.getValue(this.getFacesContext().getELContext());
                if (firstRowObject != null) {
                    return firstRowObject;
                }
                return 0;
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return 0;
    }

    public void setFirstRow(int row) {
        this.firstRow = row;
    }

    public String getFamily() {
        return "org.richfaces.Datascroller";
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.firstRow};
    }

    public void restoreState(FacesContext context, Object object) {
        Object[] state = (Object[])object;
        super.restoreState(context, state[0]);
        this.firstRow = (Integer)state[1];
    }

    static class BinarySearch {
        BinarySearch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int search(UIData data) {
            int rowIndex = data.getRowIndex();
            try {
                int n;
                int n2 = 1;
                int k = 2;
                while (true) {
                    data.setRowIndex(k - 1);
                    if (!data.isRowAvailable()) break;
                    n2 = k;
                    k *= 2;
                }
                while (n2 < k) {
                    int kk = Math.round((n2 + k) / 2) + 1;
                    data.setRowIndex(kk - 1);
                    if (data.isRowAvailable()) {
                        n2 = kk;
                        continue;
                    }
                    k = kk - 1;
                }
                data.setRowIndex(k - 1);
                if (data.isRowAvailable()) {
                    n = k;
                    return n;
                }
                n = 0;
                return n;
            }
            finally {
                data.setRowIndex(rowIndex);
            }
        }
    }
}

