/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.exception.FileUploadException;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.request.MultipartRequest;
import org.ajax4jsf.resource.CountingOutputWriter;
import org.richfaces.component.UIFileUpload;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUploadRendererBase
extends TemplateEncoderRendererBase {
    private static final String _FILES_UPLOADED_ATTRIBUTE_NAME = "uploadData";
    private static final String _MULTIPART_REQUEST_CLASS_NAME = MultipartRequest.class.getName();

    protected void doDecode(FacesContext context, UIComponent component) {
        UIFileUpload fileUpload = (UIFileUpload)component;
        ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
        String clientId = component.getClientId(context);
        new AjaxEvent(component).queue();
        Class<?> requestClazz = request.getClass();
        if (_MULTIPART_REQUEST_CLASS_NAME.equals(requestClazz.getName()) || "org.jboss.seam.web.MultipartRequest".equals(requestClazz.getName())) {
            HttpSession session = (HttpSession)context.getExternalContext().getSession(false);
            String uid = request.getParameter("_richfaces_upload_uid");
            Map map = (Map)session.getAttribute("_richfaces_upload_sessions");
            MultipartRequest multipartRequest = (MultipartRequest)map.get(uid);
            clientId = clientId + ":file";
            String fileName = multipartRequest.getFileName(clientId);
            Object file = multipartRequest.getFile(clientId);
            fileUpload.setLocalFileName(fileName);
            this.onUploadComplete(context, file, fileUpload);
        }
    }

    private boolean checkFileCount(UIFileUpload fileUpload, Collection filesUploaded) {
        Integer max = fileUpload.getMaxFilesQuantity();
        if (filesUploaded != null && filesUploaded.size() >= max) {
            fileUpload.reset();
            return false;
        }
        return true;
    }

    private void storeData(FacesContext context, UIFileUpload fileUpload, Object file) {
        ValueExpression data = fileUpload.getValueExpression(_FILES_UPLOADED_ATTRIBUTE_NAME);
        if (data != null && data.getValue(context.getELContext()) instanceof Collection) {
            Collection collection = (Collection)data.getValue(context.getELContext());
            if (this.checkFileCount(fileUpload, collection)) {
                UploadItem item = new UploadItem(fileUpload.getLocalFileName(), file);
                new UploadEvent((UIComponent)fileUpload, item).queue();
                collection.add(item);
            } else {
                throw new FileUploadException("Files count overflow");
            }
        }
    }

    private void onUploadComplete(FacesContext context, Object file, UIFileUpload fileUpload) {
        this.storeData(context, fileUpload, file);
        try {
            AjaxContext ajaxContext = AjaxContextImpl.getCurrentInstance((FacesContext)context);
            ajaxContext.setAjaxRequest(true);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIFileUpload.class;
    }

    private String getActionScript(FacesContext context, UIComponent component, String action, Object oncomplete) throws IOException {
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        String clientId = component.getClientId(context);
        Map options = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        Map parameters = (Map)options.get("parameters");
        parameters.put("action", action);
        parameters.put("_richfaces_upload_uid", new JSReference("uid"));
        parameters.put(clientId, clientId);
        if (oncomplete != null) {
            options.put("onbeforedomupdate", oncomplete);
        }
        ajaxFunction.addParameter((Object)options);
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"uid"});
        function.addParameter((Object)"event");
        function.addToBody((Object)ajaxFunction.toScript());
        return function.toScript();
    }

    public Object getAcceptedTypes(FacesContext context, UIComponent component) {
        String acceptedTypes = (String)component.getAttributes().get("acceptedTypes");
        if (acceptedTypes != null) {
            HashMap<String, Boolean> accepted = new HashMap<String, Boolean>();
            String[] types = acceptedTypes.split("[,;|]");
            if (types != null) {
                for (String type : types) {
                    accepted.put(type.toLowerCase(), true);
                }
                return ScriptUtils.toScript(accepted);
            }
        }
        return JSReference.NULL;
    }

    public String getStopScript(FacesContext context, UIComponent component) throws IOException {
        return this.getActionScript(context, component, "stop", null);
    }

    public String getFileSizeScript(FacesContext context, UIComponent component) throws IOException {
        JSFunctionDefinition oncomplete = new JSFunctionDefinition(new Object[0]);
        oncomplete.addParameter((Object)"request");
        oncomplete.addParameter((Object)"event");
        oncomplete.addParameter((Object)"data");
        StringBuffer body = new StringBuffer("$('");
        body.append(component.getClientId(context));
        body.append("').component.getFileSize(data);");
        oncomplete.addToBody((Object)body);
        return this.getActionScript(context, component, "progress", oncomplete);
    }

    public Object getLabelMarkup(FacesContext context, UIComponent component) throws IOException {
        CountingOutputWriter customWriter = new CountingOutputWriter();
        StringBuffer result = null;
        UIComponent label = component.getFacet("label");
        try {
            if (label != null) {
                ResponseWriter writer = context.getResponseWriter();
                String defaultRenderKitId = context.getApplication().getDefaultRenderKitId();
                if (null == defaultRenderKitId) {
                    defaultRenderKitId = "HTML_BASIC";
                }
                RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
                RenderKit renderKit = renderKitFactory.getRenderKit(context, defaultRenderKitId);
                ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)customWriter, null, "UTF-8");
                context.setResponseWriter(responseWriter);
                this.writeScriptBody(context, label, false);
                if (writer != null) {
                    context.setResponseWriter(writer);
                }
                result = customWriter.getContent();
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result != null ? new JSLiteral(result.toString()) : JSReference.NULL;
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        JSFunctionDefinition eventHandler = RendererUtils.getInstance().getAsEventHandler(context, component, attributeName, "");
        if (eventHandler != null) {
            return eventHandler.toString();
        }
        return JSReference.NULL.toScript();
    }

    public String getProgressBarId(FacesContext context, UIComponent component) throws IOException {
        return this.getProgressBar(context, component).getClientId(context);
    }

    public void renderProgress(FacesContext context, UIComponent component) throws IOException {
        UIComponent progressBar = this.getProgressBar(context, component);
        this.renderChild(context, progressBar);
    }

    private UIComponent createProgressBar(FacesContext context, UIComponent fileUpload) {
        UIComponent progressBar = fileUpload.getFacet("progress");
        if (null == progressBar) {
            progressBar = context.getApplication().createComponent("org.richfaces.ProgressBar");
        }
        fileUpload.getFacets().put("progress", progressBar);
        return progressBar;
    }

    public UIComponent getProgressBar(FacesContext context, UIComponent component) {
        UIComponent progressBar = component.getFacet("progress");
        if (null == progressBar) {
            progressBar = this.createProgressBar(context, component);
        }
        progressBar.getAttributes().put("minValue", -1);
        progressBar.getAttributes().put("enabled", false);
        progressBar.setTransient(false);
        return progressBar;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }
}

