/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.style.CSSFormat;
import org.richfaces.component.UISeparator;
import org.richfaces.renderkit.html.images.BevelSeparatorImage;
import org.richfaces.renderkit.html.images.SimpleSeparatorImage;

public class SeparatorRendererBase
extends RendererBase {
    private static final String[] SUPPORTED_TYPES = new String[]{"beveled", "dashed", "dotted", "double", "solid"};

    private String getCSSDimension(UIComponent component, String attributeName, String defaultValue) {
        String height;
        Object hO = component.getAttributes().get(attributeName);
        if (hO == null) {
            height = defaultValue;
        } else if (hO instanceof String) {
            height = (String)hO;
            if (height.trim().length() == 0) {
                height = defaultValue;
            }
        } else {
            height = hO.toString();
        }
        if (height.trim().length() == 0) {
            return height;
        }
        return this.getUtils().encodePctOrPx(height);
    }

    protected Class getComponentClass() {
        return UISeparator.class;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected boolean isSupportedLineType(String lineType) {
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (!lineType.equalsIgnoreCase(SUPPORTED_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    public String backgroundImage(FacesContext context, UIComponent component) throws IOException {
        String height;
        UISeparator separator = (UISeparator)component;
        String lineType = separator.getLineType();
        if (!this.isSupportedLineType(lineType)) {
            lineType = "beveled";
        }
        if ((height = this.getHeight(context, component)).trim().endsWith("%")) {
            throw new FacesException("It is not allowed to set height of separator in percent (component " + component.getId() + ")!");
        }
        int h = HtmlDimensions.decode((String)height).intValue();
        if (lineType == null || lineType.trim().length() == 0) {
            lineType = "beveled";
        }
        if (lineType.equalsIgnoreCase("beveled") && h < 3) {
            lineType = "solid";
        }
        String uri = null;
        uri = lineType.equalsIgnoreCase("beveled") ? this.getResource(BevelSeparatorImage.class.getName()).getUri(context, (Object)component) : this.getResource(SimpleSeparatorImage.class.getName()).getUri(context, (Object)component);
        if (uri != null) {
            uri = CSSFormat.url((String)uri);
        }
        return uri;
    }

    public String getHeight(FacesContext context, UIComponent component) {
        return this.getCSSDimension(component, "height", "6px");
    }

    public String getWidth(FacesContext context, UIComponent component) {
        return this.getCSSDimension(component, "width", "");
    }
}

