if (!window.DW) {
	window.DW = {};
}

if (!window.Richfaces) {
	window.Richfaces = {};
}

sizeA = 4;
sizeB = 40;

function discardElement(element) {
    var garbageBin = document.getElementById('IELeakGarbageBin');
    if (!garbageBin) {
        garbageBin = document.createElement('DIV');
        garbageBin.id = 'IELeakGarbageBin';
        garbageBin.style.display = 'none';
        document.body.appendChild(garbageBin);
    }

	window.RichFaces.Memory.clean(element);
    // move the element to the garbage bin
    garbageBin.appendChild(element);
    garbageBin.innerHTML = '';
}

Selection = {};
Selection.eventHandler=function(event){Event.stop(event);};
Selection.eventHandler = Selection.eventHandler.bindAsEventListener(Selection);
Selection.disableSelection = function (element)
{
	if (typeof element.onselectstart!="undefined") //IE
	{
		Event.observe(element, 'selectstart', this.eventHandler);
	}
	else if (typeof element.style.MozUserSelect!="undefined") //Firefox
	{
		element.style.MozUserSelect="none";
	}
	else //All other (ie: Opera)
	{
		Event.observe(element, 'mousedown', this.eventHandler);
	}
}

Selection.enableSelection = function (element)
{
	if (typeof element.onselectstart!="undefined") //IE
	{
		Event.stopObserving(element, 'selectstart', this.eventHandler);
	}
	else if (typeof element.style.MozUserSelect!="undefined") //Firefox
	{
		element.style.MozUserSelect="";
	}
	else //All other (ie: Opera)
	{
		Event.stopObserving(element, 'mousedown', this.eventHandler);
	}
}

ModalPanel = Class.create();

{
	var ieVersion = RichFaces.getIEVersion();
	if (ieVersion && ieVersion < 7) {
		ModalPanel.disableSelects = true;
	}
}

ModalPanel.panels = new Array();

ModalPanel.Context = Class.create();
ModalPanel.Context.prototype = {
	initialize: function(modalPanel) {
		this.cdiv = modalPanel.contentDiv;
		this.isPositionFixed = Richfaces.getComputedStyle(this.cdiv, "position") == "fixed";
	},

	left: function(offset) {
		return offset;
	},

	top: function(offset) {
		return offset;
	},

	width: function() {
		return $(this.cdiv).offsetWidth;
	},

	height: function() {
		return $(this.cdiv).offsetHeight;
	}
}

	function getSizeElement() {
		var element;
		if (RichFaces.navigatorType() != RichFaces.OPERA && document.compatMode=='CSS1Compat') {
			element = document.documentElement;
		} else {
			element = document.body;
		}

		return element;
	}


ModalPanel.prototype = {
	initialize: function(id, options) {
		this["rich:destructor"] = "destroy";
	
		this.markerId = $(id);

		this.id = $(id + "Container");

		this.options = options;

		this.baseZIndex = this.options.zindex ? this.options.zindex : 100;

		this.minWidth = Math.max(this.options.minWidth, 2*sizeA + 2);
		this.minHeight = Math.max(this.options.minHeight, 2*sizeA + 2);

		this.div = id + "Div";
		this.cursorDiv = id + "CursorDiv";
		this.cdiv = id + "CDiv";
		this.contentDiv = id + "ContentDiv";
		this.shadowDiv = id + "ShadowDiv";

		this.context = new ModalPanel.Context(this);

		this.borders = new Array();

		if (this.options.resizeable) {
			this.borders.push(new ModalPanel.Border(id + "ResizerNWU", this, "NW-resize", ModalPanel.Sizer.NWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerN", this, "N-resize", ModalPanel.Sizer.N));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEU", this, "NE-resize", ModalPanel.Sizer.NEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerNEL", this, "NE-resize", ModalPanel.Sizer.NEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerE", this, "E-resize", ModalPanel.Sizer.E));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEU", this, "SE-resize", ModalPanel.Sizer.SEU));
			this.borders.push(new ModalPanel.Border(id + "ResizerSEL", this, "SE-resize", ModalPanel.Sizer.SEL));
			this.borders.push(new ModalPanel.Border(id + "ResizerS", this, "S-resize", ModalPanel.Sizer.S));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWL", this, "SW-resize", ModalPanel.Sizer.SWL));
			this.borders.push(new ModalPanel.Border(id + "ResizerSWU", this, "SW-resize", ModalPanel.Sizer.SWU));
			this.borders.push(new ModalPanel.Border(id + "ResizerW", this, "W-resize", ModalPanel.Sizer.W));
			this.borders.push(new ModalPanel.Border(id + "ResizerNWL", this, "NW-resize", ModalPanel.Sizer.NWL));
		}

		if (this.options.moveable && $(id + "Header")) {
			this.header = new ModalPanel.Border(id + "Header", this, "move", ModalPanel.Header);
		}

		this.markerId.component = this;
		
		var eDiv = $(this.div);
		if (eDiv.style.setExpression)
			if (ModalPanel.disableSelects /* IE 6 */ || Richfaces.getComputedStyle(eDiv, "position") != "fixed" /* IE again, not in strict mode*/)

		{
			eDiv.style.position = "absolute";
			
			var eCursorDiv = $(this.cursorDiv);
			eCursorDiv.style.position = "absolute";

			//that is to apply filter
			eDiv.style.width = "1px";
			eDiv.style.height = "1px";
			eCursorDiv.style.width = "1px";
			eCursorDiv.style.height = "1px";

			var eCdiv = $(this.cdiv);
			eCdiv.style.position = "absolute";

			eCdiv.mpUseExpr = true;
		}

		if (this.options.onhide && this.options.onhide != ""){
			this.eventOnHide = new Function("event",this.options.onhide);
		}
		
		ModalPanel.panels.push(this);

		this.eventFirstOnfocus = this.firstOnfocus.bindAsEventListener(this);
		this.eventLastOnfocus = this.lastOnfocus.bindAsEventListener(this);

		this.firstHref = id + "FirstHref";
		this.lastHref = id + "LastHref";
		
		this.selectBehavior = options.selectBehavior;
	},

	destroy: function() {
		ModalPanel.panels = ModalPanel.panels.without(this);
		
        this.traverseSelects(true);
        
        this.parent = null;
        this.firstOutside = null;
        this.lastOutside = null;
        if (this.header) {
        	this.header.destroy();
			this.header=null;        	
        }

		for (var k = 0; k < this.borders.length; k++ ) {
			this.borders[k].destroy();
		}
		this.borders = null;

		setTimeout(function() {
			if (this.floatedToBody) {
				var element = this.id;
				var parent = element.parentNode;
				if (parent) {
					parent.removeChild(element);
					discardElement(element);
				}
			}
		}.bind(this), 0);
		
        this.markerId.component = null;
        this.markerId = null;
	},

	initIframe : function() {
        if (this.contentWindow) {
			Element.setStyle(this.contentWindow.document.body, { "margin" : "0px 0px 0px 0px" });
		} else {
			//TODO opera etc.

		}

		if("transparent" == Element.getStyle(document.body, "background-color")) {
			this.style.filter = "alpha(opacity=0)";
			this.style.opacity = "0";
		}

		//this.style.opacity = "0.5";
		//this.style.filter='progid:DXImageTransform.Microsoft.Alpha(style=0,opacity=50)';
		//var iframeBodyStyle = this.contentWindow.document.body.style;
		//iframeBodyStyle.backgroundColor = "#d0d0d0";
		//iframeBodyStyle.filter = "alpha(opacity=50)";
		//iframeBodyStyle.opacity = "0.5";
		//iframeBodyStyle.zIndex = "99";
	},

	traverseSelects: function(enable) {
		if (!ModalPanel.disableSelects) {
			return ;
		}

		var children = document.body.childNodes;
		for (var k = 0; k < children.length; k++) {
			var child = children[k];
			if (child != this.id && child.getElementsByTagName) {

				var selects = child.getElementsByTagName("SELECT");

				for (var i = 0; i < selects.length; i++) {
					var elt = selects[i];
					
					if (this.selectBehavior && "hide" == this.selectBehavior) {
						if (enable) {
							if (elt._mdwCount) {
								elt._mdwCount -= 1;
	
								if (elt._mdwCount == 0) {
									if (elt._mdwHidden) {
										Element.setStyle(elt, { "visibility" : elt._mdwHidden });
										elt._mdwHidden = undefined;
									} else {
										Element.setStyle(elt, { "visibility" : "" });
									}
	
									elt._mdwCount = undefined;
								}
							}
						} else {
							if (elt._mdwCount) {
								elt._mdwCount += 1;
							} else {
								if (elt.style.visibility && "" != elt.style.visibility) {
									elt._mdwHidden = elt.style.visibility;
								}
								Element.setStyle(elt, { "visibility" : "hidden" });
	
								elt._mdwCount = 1;
							}
						}
					} else {
						if (enable) {
							if (elt._mdwCount) {
								elt._mdwCount -= 1;
	
								if (elt._mdwCount == 0) {
									if (elt._mdwDisabled) {
										elt._mdwDisabled = undefined;
									} else {
										elt.disabled = false;
									}
	
									elt._mdwCount = undefined;
								}
							}
						} else {
							if (elt._mdwCount) {
								elt._mdwCount += 1;
							} else {
								if (elt.disabled) {
									elt._mdwDisabled = true;
								} else {
									elt.disabled = true;
								}
	
								elt._mdwCount = 1;
							}
						}
					}
				}
			}
		}
	},

	setLeft: function(pos) {
		var eCdiv = $(this.cdiv);
		if (eCdiv.mpUseExpr) {
			eCdiv.mpLeft = pos;
		} else {
			eCdiv.style.left = pos + "px";
		}
	},

	setTop: function(pos) {
		var eCdiv = $(this.cdiv);
		if (eCdiv.mpUseExpr) {
			eCdiv.mpTop = pos;
		} else {
			eCdiv.style.top = pos + "px";
		}
	},

	firstOnfocus: function(event) {
		var e = $(this.firstHref)
		if (e) {
			e.focus();
		}
	},

	lastOnfocus: function(event) {
		var e = $(this.lastHref);
		if (e) {
			e.focus();
		}
	},

	processAllFocusElements: function(root, callback) {
		if (root.focus && 
			// Many not visible elements have focus method, we is had to avoid processing them.
			/^a|input|select|button|textarea$/i.test(root.tagName) &&
			!root.disabled && !/^hidden$/.test(root.type) &&
			!/^none$/.test(root.style.display)) {

			callback.call(this, root);
		} else {
			if (root != this.id) {
				var child = root.firstChild;
				while (child) {
					this.processAllFocusElements(child, callback);
					child = child.nextSibling;
				}
			}
		}
	},

	processTabindexes:	function(input) {
		if (!this.firstOutside)
			this.firstOutside = input;
		this.lastOutside = input;
		if (input.tabIndex) {
			input.prevTabIndex = input.tabIndex;
		}
		input.tabIndex = undefined;
		if (input.accesskey) {
			input.prevAccesskey = input.accesskey;
		}
		input.accesskey = undefined;
	},

	restoreTabindexes:	function(input) {
		if (input.prevTabIndex)
			input.tabIndex = input.prevTabIndex;
		if (input.prevAccesskey)
			input.accesskey = input.prevAccesskey;
	},

	preventFocus:	function() {
		this.processAllFocusElements(document, this.processTabindexes);
		
		if (this.firstOutside) {
			Event.observe(this.firstOutside, "focus", this.eventFirstOnfocus); 
		}
		if (this.lastOutside && this.lastOutside != this.firstOutside) {
			Event.observe(this.lastOutside, "focus", this.eventLastOnfocus); 
		}
	},

	restoreFocus: function() {
		this.processAllFocusElements(document, this.restoreTabindexes);
		
		if (this.firstOutside) {
			Event.stopObserving(this.firstOutside, "focus", this.eventFirstOnfocus);
			this.firstOutside = null;
		}
		if (this.lastOutside) {
			Event.stopObserving(this.lastOutside, "focus", this.eventLastOnfocus);
			this.lastOutside = null;
		}
	},

	_show: function(event, opts, synchronous) {
		var element = this.id;
		if(this.invokeEvent("show",event,null,element)){
			this.preventFocus();
			
	        if (!this.floatedToBody) {
				this.parent = element.parentNode;
				document.body.insertBefore(this.parent.removeChild(element), null);
				this.floatedToBody = true;
			}
	
			var eCdiv = $(this.cdiv);
			var forms = eCdiv.getElementsByTagName("form");
	
			if (this.options.keepVisualState && forms) {
				this.formOnsubmit = this.setStateInput.bindAsEventListener(this); 
				for (var i = 0; i < forms.length; i++) {
					Event.observe(forms[i], "submit", this.formOnsubmit); 
				}
			}
	
			var eIframe;
			if (ModalPanel.disableSelects && !this.iframe) {
	                        this.iframe = this.id.id + "IFrame";
				new Insertion.Top(eCdiv,
                         	"<iframe src=\"javascript:''\" frameborder=\"0\" scrolling=\"no\" id=\"" + this.iframe + "\" " +								
				"style=\"position: absolute; width: 1px; height: 1px; background-color: white; overflow-y: hidden; z-index: 1;\">" +
				"</iframe>");
	
				eIframe = $(this.iframe); 
	
				//alert("IFrame:" + eIframe + "created!");
	
				//eIframe.onload = this.initIframe.bind(eIframe);
				Event.observe(eIframe, 'load', this.initIframe.bindAsEventListener(eIframe));
			}
	
			var options = {};
			this.userOptions = {};
	
			if (!eCdiv.mpSet) {
				Object.extend(options, this.options);
			}
	
			if (opts) {
				Object.extend(options, opts);
				Object.extend(this.userOptions, opts);
			}
			
			var eContentDiv = $(this.contentDiv);
	
			if (this.options.autosized) {
				eContentDiv.style.overflow = "";
				options.width = -1;
				options.height = -1;
				
			} else {
				if (options.width && options.width == -1) 
					options.width = 300;
				if (options.height && options.height == -1) 
					options.height = 200;
			}
				
			var eContentDiv = $(this.contentDiv);
			if (options.width && options.width != -1) {
				if (this.minWidth > options.width) {
					options.width = this.minWidth;
				}
	
				eContentDiv.style.width = options.width + (/px/.test(options.width) ? '' : 'px');
			}
	
			if (options.height && options.height != -1) {
				if (this.minHeight > options.height) {
					options.height = this.minHeight;
				}
	
				eContentDiv.style.height = options.height + (/px/.test(options.height) ? '' : 'px');
			}
			
			eCdiv.mpSet = true;
	
			//Element.setStyle(this.dialogWindow.document.body, { "margin" : "0px 0px 0px 0px" });
			//if("transparent" == Element.getStyle(document.body, "background-color")) {
			//	eIframe.allowTransparency = true;
			//}
	
	
			this.traverseSelects();
	
			//this.shape.init(eCdiv, this.options);
	
			var eDiv = $(this.div);
			if (eDiv.style.position == "absolute")
			{
				var we = "getSizeElement().clientWidth + \"px\"";
				var he = "getSizeElement().clientHeight + \"px\"";
				eDiv.style.setExpression("width", we);
				eDiv.style.setExpression("height", he);
	
				var eCursorDiv = $(this.cursorDiv);
				eCursorDiv.style.setExpression("width", we);
				eCursorDiv.style.setExpression("height", he);
	
				var le = "-Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + \"px\"";
				var te = "-Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + \"px\"";
	
				eDiv.style.setExpression("left", le);
				eDiv.style.setExpression("top", te);
	
				eCursorDiv.style.setExpression("left", le);
				eCursorDiv.style.setExpression("top", te);
	
	
				var leftExpr = "(this.mpLeft || 0) + -Position.cumulativeOffset(this.parentNode)[0] + getSizeElement().scrollLeft + \"px\"";
				var topExpr = "(this.mpTop || 0) + -Position.cumulativeOffset(this.parentNode)[1] + getSizeElement().scrollTop + \"px\"";
	
				eCdiv.style.setExpression("left", leftExpr);
				eCdiv.style.setExpression("top", topExpr);
	
	
				/* That's how we output debug info - DOM inspector rulez */
				/*
				document.body.setExpression("_clientLeft", "getSizeElement().clientLeft");
				document.body.setExpression("_clientTop", "getSizeElement().clientTop");
				document.body.setExpression("_scrollLeft", "getSizeElement().scrollLeft");
				document.body.setExpression("_scrollTop", "getSizeElement().scrollTop");
				*/
				/* */
			}
	
			element.style.visibility = "hidden";
	
			Element.show(element);
			this.correctShadowSizeEx();
			
			if (options.left) {
				var _left;
				if (options.left != "auto") {
					_left = parseInt(options.left, 10);
				} else {
					var cw = getSizeElement().clientWidth;
					if (RichFaces.navigatorType() == RichFaces.OPERA)
					{
					 	_left = (cw - eContentDiv.getWidth()) / 2;
					}
					else {
					 	var _width = eContentDiv.clientWidth;
						_left = (cw - _width) / 2;
					 }
	
				}
	
				this.setLeft(_left);
			}
	
			if (options.top) {
				var _top;
				if (options.top != "auto") {
					_top = parseInt(options.top, 10);
				} else {
					var cw = getSizeElement().clientHeight;
					if (RichFaces.navigatorType() == RichFaces.OPERA)
					{
					 	_top = (cw - eContentDiv.getHeight()) / 2;
					}
					else {
						var _height = eContentDiv.clientHeight;
						_top = (cw - _height) / 2;
					}
				}
	
				this.setTop(_top);
			}
	
			if (this.options.autosized) {
				this.observerSize =
			        window.setInterval(this.correctShadowSize.bindAsEventListener(this), 500);
			}
	
			this.doResizeOrMove(ModalPanel.Sizer.Diff.EMPTY);
	
			for (var k = 0; k < this.borders.length; k++ ) {
				this.borders[k].doPosition();
			}
	
			if (this.header) {
				this.header.doPosition();
			}
	
            Element.hide(eCdiv);
            element.style.visibility = "";

            var showFunction = function() {
            	Element.show(eCdiv);

            	this.lastOnfocus();
	
            	var event = {};
            	event.parameters = opts || {};
            	this.shown = true;
            }

            if (synchronous) {
            	showFunction.call(this);
            } else {
            	setTimeout(showFunction.bind(this), 0);
            }
		}	
	},

	syncShow: function(event, opts) {
		this._show(event, opts, true);
	},

	show: function(event, opts) {
		this._show(event, opts, false);
	},	
	
	startDrag: function(border) {
		//for (var k = 0; k < this.borders.length; k++ ) {
		//	this.borders[k].hide();
		//}
		Selection.disableSelection(document.body);
	},

	endDrag: function(border) {
		for (var k = 0; k < this.borders.length; k++ ) {
			//this.borders[k].show();
			this.borders[k].doPosition();
		}
		Selection.enableSelection(document.body);
	},

	hide: function(event, opts) {
		this.restoreFocus();

        this.traverseSelects(true);

		var eDiv = $(this.div);
		var eCdiv = $(this.cdiv);

		if (eDiv.style.removeExpression) {
			eDiv.style.removeExpression("width");
			eDiv.style.removeExpression("height");

			eDiv.style.removeExpression("left");
			eDiv.style.removeExpression("top");

			var eCursorDiv = $(this.cursorDiv);
			eCursorDiv.style.removeExpression("width");
			eCursorDiv.style.removeExpression("height");

			eCursorDiv.style.removeExpression("left");
			eCursorDiv.style.removeExpression("top");

			eCdiv.style.removeExpression("left");
			eCdiv.style.removeExpression("top");
		}

		var element = $(this.id);
		Element.hide(element);

		if (this.floatedToBody && this.parent) {
			
			document.body.removeChild(element);
			this.parent.appendChild(element);
			this.floatedToBody = false;
		}
		
		var event = {};
		event.parameters = opts || {};
		if (this.eventOnHide) this.eventOnHide(event);
		
		var forms = eCdiv.getElementsByTagName("form");
		if (this.options.keepVisualState && forms) {
			for (var i = 0; i < forms.length; i++) {
				Event.stopObserving(forms[i], "submit", this.formOnsubmit);
			}
		}

		this.shown = false;
		
		if (this.options.autosized) {
			window.clearInterval(this.observerSize);
		}
	},

	_getStyle: function(elt, name) {
		return parseInt(elt.style[name].replace("px", ""), 10);
	},
	
	doResizeOrMove: function(diff) {
		var vetoes = {};
		var cssHash = {};
		var cssHashWH = {};

		var vetoeChange = false;
		var newSize;
		
		var eContentDiv = $(this.contentDiv);
		
		newSize = this._getStyle(eContentDiv, "width");//Richfaces.getComputedStyleSize(eContentDiv, "width");

		var oldSize = newSize;
		newSize += diff.deltaWidth || 0;

		if (newSize >= this.minWidth || this.options.autosized) {
			if (diff.deltaWidth) {
				cssHashWH.width = newSize + 'px';
			}
		} else {
			if (diff.deltaWidth) {
				cssHashWH.width = this.minWidth + 'px';

				vetoes.vx = oldSize - this.minWidth;
			}

			vetoes.x = true;
		}

		if (vetoes.vx && diff.deltaX) {
			diff.deltaX = -vetoes.vx;
		}
		
		var eCdiv = $(this.cdiv); 

		if (diff.deltaX && (vetoes.vx || !vetoes.x)) {
			if (vetoes.vx) {
				diff.deltaX = vetoes.vx;
			}
			var newPos;
			
			newPos = this._getStyle(eCdiv, "left");//Richfaces.getComputedStyleSize(eCdiv, "left");
			newPos += diff.deltaX;
			cssHash.left = newPos + 'px';
		}

		newSize = this._getStyle(eContentDiv, "height")//;Richfaces.getComputedStyleSize(eContentDiv, "height");

		var oldSize = newSize;
		newSize += diff.deltaHeight || 0;

		if (newSize >= this.minHeight || this.options.autosized) {
			if (diff.deltaHeight) {
				cssHashWH.height = newSize + 'px';
			}
		} else {
			if (diff.deltaHeight) {
				cssHashWH.height = this.minHeight + 'px';

				vetoes.vy = oldSize - this.minHeight;
			}

			vetoes.y = true;
		}

		if (vetoes.vy && diff.deltaY) {
			diff.deltaY = -vetoes.vy;
		}

		if (diff.deltaY && (vetoes.vy || !vetoes.y)) {
			if (vetoes.vy) {
				diff.deltaY = vetoes.vy;
			}

			var newPos;
			if (eCdiv.mpUseExpr) {
				newPos = eCdiv.mpTop || 0;
				newPos += diff.deltaY;

				eCdiv.mpTop = newPos;
				cssHash.top = newPos + 'px';
			} else {
				newPos = this._getStyle(eCdiv, "top");//Richfaces.getComputedStyleSize(eCdiv, "top");
				newPos += diff.deltaY;
				cssHash.top = newPos + 'px';
			}
		}

		Element.setStyle(eCdiv, cssHash);

		Element.setStyle(eContentDiv, cssHashWH);
		this.correctShadowSizeEx();
		
		Object.extend(this.userOptions, cssHash);
		Object.extend(this.userOptions, cssHashWH);

		var w = this.context.width();
		var h = this.context.height();

		this.context.reduced = null;

		if (w <= 2*sizeB) {
			this.context.reduced = {};
			this.context.reduced.w = w;
		}

		if (h <= 2*sizeB) {
			if (!this.context.reduced) {
				this.context.reduced = {};
			}

			this.context.reduced.h = h;
		}

		if (this.header) {
			this.header.doPosition();
		}

		return vetoes;
	},

	setStateInput: function(e) {
		var target = Event.element(e);
		if (e && target) {
			// Concret input but not entire form is a target element for onsubmit in FF
			while (target && !/^form$/i.test(target.tagName)) {
				target = target.parentNode;
			}
			
			var input = document.createElement("input");
			input.type = "hidden";
			input.id = this.id.id + "OpenedState";
			input.name = this.id.id + "OpenedState";
			input.value = this.shown ? "true" : "false";
			target.appendChild(input);

			var keys = $H(this.userOptions).keys();
			if (keys) {
				for (var i = 0; i < keys.length; i++) {
					input = document.createElement("input");
					input.type = "hidden";
					input.id = this.id.id + "StateOption_" + keys[i];
					input.name = this.id.id + "StateOption_" + keys[i];
					input.value = this.userOptions[keys[i]];
					target.appendChild(input);

				}
			}
			
			return true;
		}
	},
	
	correctShadowSize: function(event) {
		this.correctShadowSizeEx();
	},
	
	correctShadowSizeEx: function() {
		var eShadowDiv = $(this.shadowDiv);
		var eContentDiv = $(this.contentDiv);
		if (!eShadowDiv || !eContentDiv) {
			return;
		}
		var eIframe = $(this.iframe);
		
		var dx = 0;
		var dy = 0;
		if (!Richfaces.browser.isIE)
		{
			dx = eShadowDiv.offsetWidth-eShadowDiv.clientWidth;
			dy = eShadowDiv.offsetHeight-eShadowDiv.clientHeight;
		}
		var w = eContentDiv.offsetWidth;
		var h = eContentDiv.offsetHeight;
		eShadowDiv.style.width = (w-dx)+"px";
		eShadowDiv.style.height = (h-dy)+"px";
		
		if (eIframe) {
			eIframe.style.width = w+"px";
			eIframe.style.height = h+"px";
		}
	},
	
	invokeEvent: function(eventName, event, value, element) {
	
		var eventFunction = this.options['on'+eventName];
		var result;

		if (eventFunction)
		{
			var eventObj;

			if (event)
			{
				eventObj = event;
			}
			else if( document.createEventObject ) 
			{
				eventObj = document.createEventObject();
			}
			else if( document.createEvent )
			{
				eventObj = document.createEvent('Events');
				eventObj.initEvent( eventName, true, false );
			}
			
			eventObj.rich = {component:this};
			eventObj.rich.value = value;

			try
			{
				result = eventFunction.call(element, eventObj);
			}
			catch (e) { LOG.warn("Exception: "+e.Message + "\n[on"+eventName + "]"); }

		}
		
		if (result!=false) result = true;
		
		return result;
	}	
}

Richfaces.findModalPanel = function (id) {
	if (id) {
		var prefId = (id.charAt(0) == ':' ? id : ':' + id);

		for (var i = 0; i < ModalPanel.panels.length; i++ ) {
			var pnl = ModalPanel.panels[i];
			if (pnl && pnl.markerId) {
				var pnlId = pnl.markerId.id;

				if (pnlId) {
					//try to match ids
					if (pnlId.length >= prefId.length) {
						var substr = pnlId.substring(pnlId.length - prefId.length, pnlId.length);
						if (substr == prefId) {
							return pnl.markerId;
						}
					}
				}
			}
		}
	}
}

Richfaces._showModalPanel = function (id, opts, event, sync) {
	
	var invoke = 
		(RichFaces.MSIE == RichFaces.navigatorType()) ?
		function(f) {
				if (document.readyState != "complete") {
					var args = arguments;
					var dis = this;
				window.setTimeout(
					function() {
						args.callee.apply(dis,args );
					}, 50);
			} else {
				f();
			}
		} : 
		function(f) {
			f();
		}; 
	
	var panel = $(id);
	if (!panel) {
		panel = Richfaces.findModalPanel(id);
	}
	invoke(function() {
		if (sync) {
			panel.component.syncShow(event, opts);
		} else {
			panel.component.show(event, opts);
		}
	});
	
	
};

Richfaces.showModalPanel = function (id, opts, event) {
	Richfaces._showModalPanel(id, opts, event, false);
};

Richfaces.syncShowModalPanel = function (id, opts, event) {
	Richfaces._showModalPanel(id, opts, event, true);
};


Richfaces.hideModalPanel = function (id, opts, event) {
	var panel = $(id);
	if (!panel) {
		panel = Richfaces.findModalPanel(id);
	}
	panel.component.hide(event, opts);
};
