package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIDragIndicator;

public class HtmlDragIndicator extends UIDragIndicator{

final public static  String COMPONENT_FAMILY = "org.richfaces.DragIndicator";

final public static  String COMPONENT_TYPE = "org.richfaces.DragIndicator";

/*
* Corresponds to the HTML class attribute and added to an indicator when a drop is accepted
*/
private  String _acceptClass = null;

/*
* Corresponds to the HTML class attribute and added to an indicator when a drop is rejected
*/
private  String _rejectClass = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;


public HtmlDragIndicator(){
setRendererType("org.richfaces.DragIndicatorRenderer");
}

public String getAcceptClass(){
	if (this._acceptClass != null) {
		return this._acceptClass;
	}
	ValueExpression ve = getValueExpression("acceptClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAcceptClass(String _acceptClass){
this._acceptClass = _acceptClass;
}

public String getRejectClass(){
	if (this._rejectClass != null) {
		return this._rejectClass;
	}
	ValueExpression ve = getValueExpression("rejectClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRejectClass(String _rejectClass){
this._rejectClass = _rejectClass;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[5];
state[0] = super.saveState(context);
state[1] = _acceptClass;
state[2] = _rejectClass;
state[3] = _style;
state[4] = _styleClass;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptClass = (String)states[1];;
		_rejectClass = (String)states[2];;
		_style = (String)states[3];;
		_styleClass = (String)states[4];;
	
}

}
