package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIListShuttle;

public class HtmlListShuttle extends UIListShuttle{

final public static  String COMPONENT_FAMILY = "org.richfaces.ListShuttle";

final public static  String COMPONENT_TYPE = "org.richfaces.ListShuttle";

/*
* CSS class for bottom control
*/
private  String _bottomControlClass = null;

/*
* Defines a label for a bottom control
*/
private  String _bottomControlLabel = null;

/*
* Comma-separated list of CSS classes for columns
*/
private  String _columnClasses = null;

/*
* Defines type of a control: button or none.
*/
private  String _controlsType = null;

/*
* Id of Converter to be used or reference to a Converter
*/
private  Converter _converter = null;

/*
* CSS class for copy all control
*/
private  String _copyAllControlClass = null;

/*
* Defines a label for a copyAll control
*/
private  String _copyAllControlLabel = null;

/*
* CSS class for copy control
*/
private  String _copyControlClass = null;

/*
* Defines a label for a copy control
*/
private  String _copyControlLabel = null;

/*
* CSS class for a disabled control
*/
private  String _disabledControlClass = null;

/*
* CSS class for down control
*/
private  String _downControlClass = null;

/*
* Defines a label for a down control
*/
private  String _downControlLabel = null;

/*
* If "false", 'Copy All' and 'Remove All' controls aren't displayed
*/
private  boolean _fastMoveControlsVisible = true;

private  boolean _fastMoveControlsVisibleSet = false;

/*
* If "false", 'Top' and 'Bottom' controls aren't displayed.
*/
private  boolean _fastOrderControlsVisible = true;

private  boolean _fastOrderControlsVisibleSet = false;

/*
* A flag indicating that this component value must be converted
            and validated immediately (that is, during Apply Request Values
            phase), rather than waiting until a Process Validations phase
*/
private  boolean _immediate = false;

private  boolean _immediateSet = false;

/*
* CSS class for a list
*/
private  String _listClass = null;

/*
* Defines height of the list
*/
private  String _listsHeight = null;

/*
* Customizes vertically a position of move/copy controls relatively to lists
*/
private  String _moveControlsVerticalAlign = null;

/*
* If "false", 'Copy' and 'Remove' controls aren't displayed
*/
private  boolean _moveControlsVisible = true;

private  boolean _moveControlsVisibleSet = false;

/*
* A JavaScript event handler; a button "Bottom" is clicked
*/
private  String _onbottomclick = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* A JavaScript event handler; a button "Copy All" is clicked
*/
private  String _oncopyallclick = null;

/*
* HTML: a script expression; a button "Copy" is clicked
*/
private  String _oncopyclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* A JavaScript event handler; a button "Down" is clicked
*/
private  String _ondownclick = null;

/*
* A JavaScript event handler called on a list change operation
*/
private  String _onlistchanged = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; called after ordering action
*/
private  String _onorderchanged = null;

/*
* A JavaScript event handler; a button "Remove All" is clicked
*/
private  String _onremoveallclick = null;

/*
* A JavaScript event handler; a button "Remove" is clicked
*/
private  String _onremoveclick = null;

/*
* A JavaScript event handler; a button "Top" is clicked
*/
private  String _ontopclick = null;

/*
* HTML: a script expression; a button "Up" is clicked
*/
private  String _onupclick = null;

/*
* Customizes vertically a position of order controls relatively to lists
*/
private  String _orderControlsVerticalAlign = null;

/*
* If "false", 'Up' and 'Down' controls aren't displayed.
*/
private  boolean _orderControlsVisible = true;

private  boolean _orderControlsVisibleSet = false;

/*
* CSS class for remove all control
*/
private  String _removeAllControlClass = null;

/*
* Defines a label for a removeAll control
*/
private  String _removeAllControlLabel = null;

/*
* CSS class for remove control
*/
private  String _removeControlClass = null;

/*
* Defines a label for a remove control
*/
private  String _removeControlLabel = null;

/*
* If "true", this component is checked for non-empty input
*/
private  boolean _required = false;

private  boolean _requiredSet = false;

/*
* CSS class for a row
*/
private  String _rowClasses = null;

/*
* Shows a label for a button
*/
private  boolean _showButtonLabels = true;

private  boolean _showButtonLabelsSet = false;

/*
* Defines source list caption representation text
*/
private  String _sourceCaptionLabel = null;

/*
* Defines width of a source list
*/
private  String _sourceListWidth = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* If "true", dragging between lists realized by click
*/
private  boolean _switchByClick = false;

private  boolean _switchByClickSet = false;

/*
* Defines target list caption representation text
*/
private  String _targetCaptionLabel = null;

/*
* Defines width of a target list
*/
private  String _targetListWidth = null;

/*
* CSS class for top control
*/
private  String _topControlClass = null;

/*
* Defines a label for a "Top" control
*/
private  String _topControlLabel = null;

/*
* CSS class for up control
*/
private  String _upControlClass = null;

/*
* Defines a label for an "Up" control
*/
private  String _upControlLabel = null;

/*
* valid
*/
private  boolean _valid = false;

private  boolean _validSet = false;

/*
* Listener for value changes
*/
private  MethodBinding _valueChangeListener = null;


public HtmlListShuttle(){
setRendererType("org.richfaces.ListShuttleRenderer");
}

public String getBottomControlClass(){
	if (this._bottomControlClass != null) {
		return this._bottomControlClass;
	}
	ValueExpression ve = getValueExpression("bottomControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setBottomControlClass(String _bottomControlClass){
this._bottomControlClass = _bottomControlClass;
}

public String getBottomControlLabel(){
	if (this._bottomControlLabel != null) {
		return this._bottomControlLabel;
	}
	ValueExpression ve = getValueExpression("bottomControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBottomControlLabel(String _bottomControlLabel){
this._bottomControlLabel = _bottomControlLabel;
}

public String getColumnClasses(){
	if (this._columnClasses != null) {
		return this._columnClasses;
	}
	ValueExpression ve = getValueExpression("columnClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setColumnClasses(String _columnClasses){
this._columnClasses = _columnClasses;
}

public String getControlsType(){
	if (this._controlsType != null) {
		return this._controlsType;
	}
	ValueExpression ve = getValueExpression("controlsType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "button";
	

}

public void setControlsType(String _controlsType){
this._controlsType = _controlsType;
}

public Converter getConverter(){
	if (this._converter != null) {
		return this._converter;
	}
	ValueExpression ve = getValueExpression("converter");
	if (ve != null) {
	    Converter value = null;
	    
	    try {
			value = (Converter) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConverter(Converter _converter){
this._converter = _converter;
}

public String getCopyAllControlClass(){
	if (this._copyAllControlClass != null) {
		return this._copyAllControlClass;
	}
	ValueExpression ve = getValueExpression("copyAllControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCopyAllControlClass(String _copyAllControlClass){
this._copyAllControlClass = _copyAllControlClass;
}

public String getCopyAllControlLabel(){
	if (this._copyAllControlLabel != null) {
		return this._copyAllControlLabel;
	}
	ValueExpression ve = getValueExpression("copyAllControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCopyAllControlLabel(String _copyAllControlLabel){
this._copyAllControlLabel = _copyAllControlLabel;
}

public String getCopyControlClass(){
	if (this._copyControlClass != null) {
		return this._copyControlClass;
	}
	ValueExpression ve = getValueExpression("copyControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setCopyControlClass(String _copyControlClass){
this._copyControlClass = _copyControlClass;
}

public String getCopyControlLabel(){
	if (this._copyControlLabel != null) {
		return this._copyControlLabel;
	}
	ValueExpression ve = getValueExpression("copyControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCopyControlLabel(String _copyControlLabel){
this._copyControlLabel = _copyControlLabel;
}

public String getDisabledControlClass(){
	if (this._disabledControlClass != null) {
		return this._disabledControlClass;
	}
	ValueExpression ve = getValueExpression("disabledControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDisabledControlClass(String _disabledControlClass){
this._disabledControlClass = _disabledControlClass;
}

public String getDownControlClass(){
	if (this._downControlClass != null) {
		return this._downControlClass;
	}
	ValueExpression ve = getValueExpression("downControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setDownControlClass(String _downControlClass){
this._downControlClass = _downControlClass;
}

public String getDownControlLabel(){
	if (this._downControlLabel != null) {
		return this._downControlLabel;
	}
	ValueExpression ve = getValueExpression("downControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDownControlLabel(String _downControlLabel){
this._downControlLabel = _downControlLabel;
}

public boolean isFastMoveControlsVisible(){
	if (this._fastMoveControlsVisibleSet) {
	    return (this._fastMoveControlsVisible);
	}
	ValueExpression ve = getValueExpression("fastMoveControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._fastMoveControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._fastMoveControlsVisible);
	}

}

public void setFastMoveControlsVisible(boolean _fastMoveControlsVisible){
this._fastMoveControlsVisible = _fastMoveControlsVisible;
this._fastMoveControlsVisibleSet = true;
}

public boolean isFastOrderControlsVisible(){
	if (this._fastOrderControlsVisibleSet) {
	    return (this._fastOrderControlsVisible);
	}
	ValueExpression ve = getValueExpression("fastOrderControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._fastOrderControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._fastOrderControlsVisible);
	}

}

public void setFastOrderControlsVisible(boolean _fastOrderControlsVisible){
this._fastOrderControlsVisible = _fastOrderControlsVisible;
this._fastOrderControlsVisibleSet = true;
}

public boolean isImmediate(){
	if (this._immediateSet) {
	    return (this._immediate);
	}
	ValueExpression ve = getValueExpression("immediate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediate);
	    }
	    
	    return value;
	} else {
	    return (this._immediate);
	}

}

public void setImmediate(boolean _immediate){
this._immediate = _immediate;
this._immediateSet = true;
}

public String getListClass(){
	if (this._listClass != null) {
		return this._listClass;
	}
	ValueExpression ve = getValueExpression("listClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setListClass(String _listClass){
this._listClass = _listClass;
}

public String getListsHeight(){
	if (this._listsHeight != null) {
		return this._listsHeight;
	}
	ValueExpression ve = getValueExpression("listsHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setListsHeight(String _listsHeight){
this._listsHeight = _listsHeight;
}

public String getMoveControlsVerticalAlign(){
	if (this._moveControlsVerticalAlign != null) {
		return this._moveControlsVerticalAlign;
	}
	ValueExpression ve = getValueExpression("moveControlsVerticalAlign");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "middle";
	

}

public void setMoveControlsVerticalAlign(String _moveControlsVerticalAlign){
this._moveControlsVerticalAlign = _moveControlsVerticalAlign;
}

public boolean isMoveControlsVisible(){
	if (this._moveControlsVisibleSet) {
	    return (this._moveControlsVisible);
	}
	ValueExpression ve = getValueExpression("moveControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._moveControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._moveControlsVisible);
	}

}

public void setMoveControlsVisible(boolean _moveControlsVisible){
this._moveControlsVisible = _moveControlsVisible;
this._moveControlsVisibleSet = true;
}

public String getOnbottomclick(){
	if (this._onbottomclick != null) {
		return this._onbottomclick;
	}
	ValueExpression ve = getValueExpression("onbottomclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnbottomclick(String _onbottomclick){
this._onbottomclick = _onbottomclick;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncopyallclick(){
	if (this._oncopyallclick != null) {
		return this._oncopyallclick;
	}
	ValueExpression ve = getValueExpression("oncopyallclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncopyallclick(String _oncopyallclick){
this._oncopyallclick = _oncopyallclick;
}

public String getOncopyclick(){
	if (this._oncopyclick != null) {
		return this._oncopyclick;
	}
	ValueExpression ve = getValueExpression("oncopyclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOncopyclick(String _oncopyclick){
this._oncopyclick = _oncopyclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOndownclick(){
	if (this._ondownclick != null) {
		return this._ondownclick;
	}
	ValueExpression ve = getValueExpression("ondownclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOndownclick(String _ondownclick){
this._ondownclick = _ondownclick;
}

public String getOnlistchanged(){
	if (this._onlistchanged != null) {
		return this._onlistchanged;
	}
	ValueExpression ve = getValueExpression("onlistchanged");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlistchanged(String _onlistchanged){
this._onlistchanged = _onlistchanged;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnorderchanged(){
	if (this._onorderchanged != null) {
		return this._onorderchanged;
	}
	ValueExpression ve = getValueExpression("onorderchanged");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnorderchanged(String _onorderchanged){
this._onorderchanged = _onorderchanged;
}

public String getOnremoveallclick(){
	if (this._onremoveallclick != null) {
		return this._onremoveallclick;
	}
	ValueExpression ve = getValueExpression("onremoveallclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnremoveallclick(String _onremoveallclick){
this._onremoveallclick = _onremoveallclick;
}

public String getOnremoveclick(){
	if (this._onremoveclick != null) {
		return this._onremoveclick;
	}
	ValueExpression ve = getValueExpression("onremoveclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnremoveclick(String _onremoveclick){
this._onremoveclick = _onremoveclick;
}

public String getOntopclick(){
	if (this._ontopclick != null) {
		return this._ontopclick;
	}
	ValueExpression ve = getValueExpression("ontopclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOntopclick(String _ontopclick){
this._ontopclick = _ontopclick;
}

public String getOnupclick(){
	if (this._onupclick != null) {
		return this._onupclick;
	}
	ValueExpression ve = getValueExpression("onupclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOnupclick(String _onupclick){
this._onupclick = _onupclick;
}

public String getOrderControlsVerticalAlign(){
	if (this._orderControlsVerticalAlign != null) {
		return this._orderControlsVerticalAlign;
	}
	ValueExpression ve = getValueExpression("orderControlsVerticalAlign");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "middle";
	

}

public void setOrderControlsVerticalAlign(String _orderControlsVerticalAlign){
this._orderControlsVerticalAlign = _orderControlsVerticalAlign;
}

public boolean isOrderControlsVisible(){
	if (this._orderControlsVisibleSet) {
	    return (this._orderControlsVisible);
	}
	ValueExpression ve = getValueExpression("orderControlsVisible");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._orderControlsVisible);
	    }
	    
	    return value;
	} else {
	    return (this._orderControlsVisible);
	}

}

public void setOrderControlsVisible(boolean _orderControlsVisible){
this._orderControlsVisible = _orderControlsVisible;
this._orderControlsVisibleSet = true;
}

public String getRemoveAllControlClass(){
	if (this._removeAllControlClass != null) {
		return this._removeAllControlClass;
	}
	ValueExpression ve = getValueExpression("removeAllControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRemoveAllControlClass(String _removeAllControlClass){
this._removeAllControlClass = _removeAllControlClass;
}

public String getRemoveAllControlLabel(){
	if (this._removeAllControlLabel != null) {
		return this._removeAllControlLabel;
	}
	ValueExpression ve = getValueExpression("removeAllControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRemoveAllControlLabel(String _removeAllControlLabel){
this._removeAllControlLabel = _removeAllControlLabel;
}

public String getRemoveControlClass(){
	if (this._removeControlClass != null) {
		return this._removeControlClass;
	}
	ValueExpression ve = getValueExpression("removeControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRemoveControlClass(String _removeControlClass){
this._removeControlClass = _removeControlClass;
}

public String getRemoveControlLabel(){
	if (this._removeControlLabel != null) {
		return this._removeControlLabel;
	}
	ValueExpression ve = getValueExpression("removeControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRemoveControlLabel(String _removeControlLabel){
this._removeControlLabel = _removeControlLabel;
}

public boolean isRequired(){
	if (this._requiredSet) {
	    return (this._required);
	}
	ValueExpression ve = getValueExpression("required");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._required);
	    }
	    
	    return value;
	} else {
	    return (this._required);
	}

}

public void setRequired(boolean _required){
this._required = _required;
this._requiredSet = true;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public boolean isShowButtonLabels(){
	if (this._showButtonLabelsSet) {
	    return (this._showButtonLabels);
	}
	ValueExpression ve = getValueExpression("showButtonLabels");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._showButtonLabels);
	    }
	    
	    return value;
	} else {
	    return (this._showButtonLabels);
	}

}

public void setShowButtonLabels(boolean _showButtonLabels){
this._showButtonLabels = _showButtonLabels;
this._showButtonLabelsSet = true;
}

public String getSourceCaptionLabel(){
	if (this._sourceCaptionLabel != null) {
		return this._sourceCaptionLabel;
	}
	ValueExpression ve = getValueExpression("sourceCaptionLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSourceCaptionLabel(String _sourceCaptionLabel){
this._sourceCaptionLabel = _sourceCaptionLabel;
}

public String getSourceListWidth(){
	if (this._sourceListWidth != null) {
		return this._sourceListWidth;
	}
	ValueExpression ve = getValueExpression("sourceListWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setSourceListWidth(String _sourceListWidth){
this._sourceListWidth = _sourceListWidth;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public boolean isSwitchByClick(){
	if (this._switchByClickSet) {
	    return (this._switchByClick);
	}
	ValueExpression ve = getValueExpression("switchByClick");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._switchByClick);
	    }
	    
	    return value;
	} else {
	    return (this._switchByClick);
	}

}

public void setSwitchByClick(boolean _switchByClick){
this._switchByClick = _switchByClick;
this._switchByClickSet = true;
}

public String getTargetCaptionLabel(){
	if (this._targetCaptionLabel != null) {
		return this._targetCaptionLabel;
	}
	ValueExpression ve = getValueExpression("targetCaptionLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTargetCaptionLabel(String _targetCaptionLabel){
this._targetCaptionLabel = _targetCaptionLabel;
}

public String getTargetListWidth(){
	if (this._targetListWidth != null) {
		return this._targetListWidth;
	}
	ValueExpression ve = getValueExpression("targetListWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "140";
	

}

public void setTargetListWidth(String _targetListWidth){
this._targetListWidth = _targetListWidth;
}

public String getTopControlClass(){
	if (this._topControlClass != null) {
		return this._topControlClass;
	}
	ValueExpression ve = getValueExpression("topControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setTopControlClass(String _topControlClass){
this._topControlClass = _topControlClass;
}

public String getTopControlLabel(){
	if (this._topControlLabel != null) {
		return this._topControlLabel;
	}
	ValueExpression ve = getValueExpression("topControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTopControlLabel(String _topControlLabel){
this._topControlLabel = _topControlLabel;
}

public String getUpControlClass(){
	if (this._upControlClass != null) {
		return this._upControlClass;
	}
	ValueExpression ve = getValueExpression("upControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setUpControlClass(String _upControlClass){
this._upControlClass = _upControlClass;
}

public String getUpControlLabel(){
	if (this._upControlLabel != null) {
		return this._upControlLabel;
	}
	ValueExpression ve = getValueExpression("upControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUpControlLabel(String _upControlLabel){
this._upControlLabel = _upControlLabel;
}

public boolean isValid(){
return _valid;
}

public void setValid(boolean _valid){
this._valid = _valid;
this._validSet = true;
}

public MethodBinding getValueChangeListener(){
return _valueChangeListener;
}

public void setValueChangeListener(MethodBinding _valueChangeListener){
this._valueChangeListener = _valueChangeListener;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[66];
state[0] = super.saveState(context);
state[1] = _bottomControlClass;
state[2] = _bottomControlLabel;
state[3] = _columnClasses;
state[4] = _controlsType;
state[5] = saveAttachedState(context, _converter);
state[6] = _copyAllControlClass;
state[7] = _copyAllControlLabel;
state[8] = _copyControlClass;
state[9] = _copyControlLabel;
state[10] = _disabledControlClass;
state[11] = _downControlClass;
state[12] = _downControlLabel;
state[13] = Boolean.valueOf(_fastMoveControlsVisible);
state[14] = Boolean.valueOf(_fastMoveControlsVisibleSet);
state[15] = Boolean.valueOf(_fastOrderControlsVisible);
state[16] = Boolean.valueOf(_fastOrderControlsVisibleSet);
state[17] = Boolean.valueOf(_immediate);
state[18] = Boolean.valueOf(_immediateSet);
state[19] = _listClass;
state[20] = _listsHeight;
state[21] = _moveControlsVerticalAlign;
state[22] = Boolean.valueOf(_moveControlsVisible);
state[23] = Boolean.valueOf(_moveControlsVisibleSet);
state[24] = _onbottomclick;
state[25] = _onclick;
state[26] = _oncopyallclick;
state[27] = _oncopyclick;
state[28] = _ondblclick;
state[29] = _ondownclick;
state[30] = _onlistchanged;
state[31] = _onmousemove;
state[32] = _onmouseout;
state[33] = _onmouseover;
state[34] = _onorderchanged;
state[35] = _onremoveallclick;
state[36] = _onremoveclick;
state[37] = _ontopclick;
state[38] = _onupclick;
state[39] = _orderControlsVerticalAlign;
state[40] = Boolean.valueOf(_orderControlsVisible);
state[41] = Boolean.valueOf(_orderControlsVisibleSet);
state[42] = _removeAllControlClass;
state[43] = _removeAllControlLabel;
state[44] = _removeControlClass;
state[45] = _removeControlLabel;
state[46] = Boolean.valueOf(_required);
state[47] = Boolean.valueOf(_requiredSet);
state[48] = _rowClasses;
state[49] = Boolean.valueOf(_showButtonLabels);
state[50] = Boolean.valueOf(_showButtonLabelsSet);
state[51] = _sourceCaptionLabel;
state[52] = _sourceListWidth;
state[53] = _style;
state[54] = _styleClass;
state[55] = Boolean.valueOf(_switchByClick);
state[56] = Boolean.valueOf(_switchByClickSet);
state[57] = _targetCaptionLabel;
state[58] = _targetListWidth;
state[59] = _topControlClass;
state[60] = _topControlLabel;
state[61] = _upControlClass;
state[62] = _upControlLabel;
state[63] = Boolean.valueOf(_valid);
state[64] = Boolean.valueOf(_validSet);
state[65] = saveAttachedState(context, _valueChangeListener);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_bottomControlClass = (String)states[1];;
		_bottomControlLabel = (String)states[2];;
		_columnClasses = (String)states[3];;
		_controlsType = (String)states[4];;
		_converter = (Converter)restoreAttachedState(context, states[5]);
		_copyAllControlClass = (String)states[6];;
		_copyAllControlLabel = (String)states[7];;
		_copyControlClass = (String)states[8];;
		_copyControlLabel = (String)states[9];;
		_disabledControlClass = (String)states[10];;
		_downControlClass = (String)states[11];;
		_downControlLabel = (String)states[12];;
		_fastMoveControlsVisible = ((Boolean)states[13]).booleanValue();
		_fastMoveControlsVisibleSet = ((Boolean)states[14]).booleanValue();
		_fastOrderControlsVisible = ((Boolean)states[15]).booleanValue();
		_fastOrderControlsVisibleSet = ((Boolean)states[16]).booleanValue();
		_immediate = ((Boolean)states[17]).booleanValue();
		_immediateSet = ((Boolean)states[18]).booleanValue();
		_listClass = (String)states[19];;
		_listsHeight = (String)states[20];;
		_moveControlsVerticalAlign = (String)states[21];;
		_moveControlsVisible = ((Boolean)states[22]).booleanValue();
		_moveControlsVisibleSet = ((Boolean)states[23]).booleanValue();
		_onbottomclick = (String)states[24];;
		_onclick = (String)states[25];;
		_oncopyallclick = (String)states[26];;
		_oncopyclick = (String)states[27];;
		_ondblclick = (String)states[28];;
		_ondownclick = (String)states[29];;
		_onlistchanged = (String)states[30];;
		_onmousemove = (String)states[31];;
		_onmouseout = (String)states[32];;
		_onmouseover = (String)states[33];;
		_onorderchanged = (String)states[34];;
		_onremoveallclick = (String)states[35];;
		_onremoveclick = (String)states[36];;
		_ontopclick = (String)states[37];;
		_onupclick = (String)states[38];;
		_orderControlsVerticalAlign = (String)states[39];;
		_orderControlsVisible = ((Boolean)states[40]).booleanValue();
		_orderControlsVisibleSet = ((Boolean)states[41]).booleanValue();
		_removeAllControlClass = (String)states[42];;
		_removeAllControlLabel = (String)states[43];;
		_removeControlClass = (String)states[44];;
		_removeControlLabel = (String)states[45];;
		_required = ((Boolean)states[46]).booleanValue();
		_requiredSet = ((Boolean)states[47]).booleanValue();
		_rowClasses = (String)states[48];;
		_showButtonLabels = ((Boolean)states[49]).booleanValue();
		_showButtonLabelsSet = ((Boolean)states[50]).booleanValue();
		_sourceCaptionLabel = (String)states[51];;
		_sourceListWidth = (String)states[52];;
		_style = (String)states[53];;
		_styleClass = (String)states[54];;
		_switchByClick = ((Boolean)states[55]).booleanValue();
		_switchByClickSet = ((Boolean)states[56]).booleanValue();
		_targetCaptionLabel = (String)states[57];;
		_targetListWidth = (String)states[58];;
		_topControlClass = (String)states[59];;
		_topControlLabel = (String)states[60];;
		_upControlClass = (String)states[61];;
		_upControlLabel = (String)states[62];;
		_valid = ((Boolean)states[63]).booleanValue();
		_validSet = ((Boolean)states[64]).booleanValue();
		_valueChangeListener = (MethodBinding)restoreAttachedState(context, states[65]);
	
}

}
