package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UITab;

public class HtmlTab extends UITab{

final public static  String COMPONENT_FAMILY = "org.richfaces.Tab";

final public static  String COMPONENT_TYPE = "org.richfaces.Tab";

/*
* if "true", submits ONLY one field/link, instead of all form controls
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* Disables a tab in a tab panel
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* Text for the actual "tab" in a tab section
*/
private  String _label = null;

/*
* Length for the actual "tab" in a tab section defined in pixels. If it is not defined, the
	    	length is calculated basing on a tab label text length
*/
private  String _labelWidth = null;

/*
* If "true", updates on client side ONLY elements from this 'reRender' property. If "false" (default) updates all rendered by ajax region components
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* Attribute defines tab name
*/
private  Object _name = null;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* A JavaScript event handler; a label of the tab is clicked
*/
private  String _onlabelclick = null;

/*
* A JavaScript event handler; a pointer within label is double-clicked
*/
private  String _onlabeldblclick = null;

/*
* A JavaScript event handler; a key within label is pressed down
*/
private  String _onlabelkeydown = null;

/*
* A JavaScript event handler; a key within label is pressed and released
*/
private  String _onlabelkeypress = null;

/*
* A JavaScript event handler; a key within label is released
*/
private  String _onlabelkeyup = null;

/*
* A JavaScript event handler; a pointer within label is pressed down
*/
private  String _onlabelmousedown = null;

/*
* A JavaScript event handler; a pointer is moved within label
*/
private  String _onlabelmousemove = null;

/*
* A JavaScript event handler; a pointer within label is released
*/
private  String _onlabelmouseup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* Event must occurs on the tab which has been entered
*/
private  String _ontabenter = null;

/*
* Event must occurs on the tab which has been left
*/
private  String _ontableave = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Tab switch algorithm: "client", "server", "ajax", "page"
*/
private  String _switchType = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* HTML: An advisory title for this element. Often displayed as a tooltip
*/
private  String _title = null;

/*
* value
*/
private  Object _value = null;


public HtmlTab(){
setRendererType("org.richfaces.TabRenderer");
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public String getLabel(){
	if (this._label != null) {
		return this._label;
	}
	ValueExpression ve = getValueExpression("label");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabel(String _label){
this._label = _label;
}

public String getLabelWidth(){
	if (this._labelWidth != null) {
		return this._labelWidth;
	}
	ValueExpression ve = getValueExpression("labelWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLabelWidth(String _labelWidth){
this._labelWidth = _labelWidth;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public Object getName(){
	if (this._name != null) {
		return this._name;
	}
	ValueExpression ve = getValueExpression("name");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return getId();
	

}

public void setName(Object _name){
this._name = _name;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnlabelclick(){
	if (this._onlabelclick != null) {
		return this._onlabelclick;
	}
	ValueExpression ve = getValueExpression("onlabelclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelclick(String _onlabelclick){
this._onlabelclick = _onlabelclick;
}

public String getOnlabeldblclick(){
	if (this._onlabeldblclick != null) {
		return this._onlabeldblclick;
	}
	ValueExpression ve = getValueExpression("onlabeldblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabeldblclick(String _onlabeldblclick){
this._onlabeldblclick = _onlabeldblclick;
}

public String getOnlabelkeydown(){
	if (this._onlabelkeydown != null) {
		return this._onlabelkeydown;
	}
	ValueExpression ve = getValueExpression("onlabelkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelkeydown(String _onlabelkeydown){
this._onlabelkeydown = _onlabelkeydown;
}

public String getOnlabelkeypress(){
	if (this._onlabelkeypress != null) {
		return this._onlabelkeypress;
	}
	ValueExpression ve = getValueExpression("onlabelkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelkeypress(String _onlabelkeypress){
this._onlabelkeypress = _onlabelkeypress;
}

public String getOnlabelkeyup(){
	if (this._onlabelkeyup != null) {
		return this._onlabelkeyup;
	}
	ValueExpression ve = getValueExpression("onlabelkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelkeyup(String _onlabelkeyup){
this._onlabelkeyup = _onlabelkeyup;
}

public String getOnlabelmousedown(){
	if (this._onlabelmousedown != null) {
		return this._onlabelmousedown;
	}
	ValueExpression ve = getValueExpression("onlabelmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelmousedown(String _onlabelmousedown){
this._onlabelmousedown = _onlabelmousedown;
}

public String getOnlabelmousemove(){
	if (this._onlabelmousemove != null) {
		return this._onlabelmousemove;
	}
	ValueExpression ve = getValueExpression("onlabelmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelmousemove(String _onlabelmousemove){
this._onlabelmousemove = _onlabelmousemove;
}

public String getOnlabelmouseup(){
	if (this._onlabelmouseup != null) {
		return this._onlabelmouseup;
	}
	ValueExpression ve = getValueExpression("onlabelmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnlabelmouseup(String _onlabelmouseup){
this._onlabelmouseup = _onlabelmouseup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOntabenter(){
	if (this._ontabenter != null) {
		return this._ontabenter;
	}
	ValueExpression ve = getValueExpression("ontabenter");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOntabenter(String _ontabenter){
this._ontabenter = _ontabenter;
}

public String getOntableave(){
	if (this._ontableave != null) {
		return this._ontableave;
	}
	ValueExpression ve = getValueExpression("ontableave");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setOntableave(String _ontableave){
this._ontableave = _ontableave;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getSwitchType(){
	if (this._switchType != null) {
		return this._switchType;
	}
	ValueExpression ve = getValueExpression("switchType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSwitchType(String _switchType){
this._switchType = _switchType;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public Object getValue(){
	if (this._value != null) {
		return this._value;
	}
	ValueExpression ve = getValueExpression("value");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setValue(Object _value){
this._value = _value;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[50];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxSingle);
state[2] = Boolean.valueOf(_ajaxSingleSet);
state[3] = Boolean.valueOf(_bypassUpdates);
state[4] = Boolean.valueOf(_bypassUpdatesSet);
state[5] = saveAttachedState(context, _data);
state[6] = Boolean.valueOf(_disabled);
state[7] = Boolean.valueOf(_disabledSet);
state[8] = _eventsQueue;
state[9] = _focus;
state[10] = Boolean.valueOf(_ignoreDupResponses);
state[11] = Boolean.valueOf(_ignoreDupResponsesSet);
state[12] = _label;
state[13] = _labelWidth;
state[14] = Boolean.valueOf(_limitToList);
state[15] = Boolean.valueOf(_limitToListSet);
state[16] = saveAttachedState(context, _name);
state[17] = _onbeforedomupdate;
state[18] = _onclick;
state[19] = _oncomplete;
state[20] = _ondblclick;
state[21] = _onkeydown;
state[22] = _onkeypress;
state[23] = _onkeyup;
state[24] = _onlabelclick;
state[25] = _onlabeldblclick;
state[26] = _onlabelkeydown;
state[27] = _onlabelkeypress;
state[28] = _onlabelkeyup;
state[29] = _onlabelmousedown;
state[30] = _onlabelmousemove;
state[31] = _onlabelmouseup;
state[32] = _onmousedown;
state[33] = _onmousemove;
state[34] = _onmouseout;
state[35] = _onmouseover;
state[36] = _onmouseup;
state[37] = _ontabenter;
state[38] = _ontableave;
state[39] = saveAttachedState(context, _reRender);
state[40] = Integer.valueOf(_requestDelay);
state[41] = Boolean.valueOf(_requestDelaySet);
state[42] = _status;
state[43] = _style;
state[44] = _styleClass;
state[45] = _switchType;
state[46] = Integer.valueOf(_timeout);
state[47] = Boolean.valueOf(_timeoutSet);
state[48] = _title;
state[49] = saveAttachedState(context, _value);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxSingle = ((Boolean)states[1]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[2]).booleanValue();
		_bypassUpdates = ((Boolean)states[3]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[4]).booleanValue();
		_data = (Object)restoreAttachedState(context, states[5]);
		_disabled = ((Boolean)states[6]).booleanValue();
		_disabledSet = ((Boolean)states[7]).booleanValue();
		_eventsQueue = (String)states[8];;
		_focus = (String)states[9];;
		_ignoreDupResponses = ((Boolean)states[10]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[11]).booleanValue();
		_label = (String)states[12];;
		_labelWidth = (String)states[13];;
		_limitToList = ((Boolean)states[14]).booleanValue();
		_limitToListSet = ((Boolean)states[15]).booleanValue();
		_name = (Object)restoreAttachedState(context, states[16]);
		_onbeforedomupdate = (String)states[17];;
		_onclick = (String)states[18];;
		_oncomplete = (String)states[19];;
		_ondblclick = (String)states[20];;
		_onkeydown = (String)states[21];;
		_onkeypress = (String)states[22];;
		_onkeyup = (String)states[23];;
		_onlabelclick = (String)states[24];;
		_onlabeldblclick = (String)states[25];;
		_onlabelkeydown = (String)states[26];;
		_onlabelkeypress = (String)states[27];;
		_onlabelkeyup = (String)states[28];;
		_onlabelmousedown = (String)states[29];;
		_onlabelmousemove = (String)states[30];;
		_onlabelmouseup = (String)states[31];;
		_onmousedown = (String)states[32];;
		_onmousemove = (String)states[33];;
		_onmouseout = (String)states[34];;
		_onmouseover = (String)states[35];;
		_onmouseup = (String)states[36];;
		_ontabenter = (String)states[37];;
		_ontableave = (String)states[38];;
		_reRender = (Object)restoreAttachedState(context, states[39]);
		_requestDelay = ((Integer)states[40]).intValue();
		_requestDelaySet = ((Boolean)states[41]).booleanValue();
		_status = (String)states[42];;
		_style = (String)states[43];;
		_styleClass = (String)states[44];;
		_switchType = (String)states[45];;
		_timeout = ((Integer)states[46]).intValue();
		_timeoutSet = ((Boolean)states[47]).booleanValue();
		_title = (String)states[48];;
		_value = (Object)restoreAttachedState(context, states[49]);
	
}

}
