/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.renderkit.AjaxComponentRendererBase;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AjaxCommandRendererBase
extends AjaxComponentRendererBase {
    private static final Log _log = LogFactory.getLog(AjaxCommandRendererBase.class);

    protected void doDecode(FacesContext facesContext, UIComponent uiComponent) {
        if (this.isSubmitted(facesContext, uiComponent)) {
            ActionEvent event = new ActionEvent(uiComponent);
            uiComponent.queueEvent((FacesEvent)event);
            uiComponent.queueEvent((FacesEvent)new AjaxEvent(uiComponent));
        }
    }

    public String getOnClick(FacesContext context, UIComponent component) {
        StringBuffer onClick;
        if (!this.getUtils().isBooleanAttribute(component, "disabled")) {
            onClick = AjaxRendererUtils.buildOnClick((UIComponent)component, (FacesContext)context);
            if (!"reset".equals(component.getAttributes().get("type"))) {
                onClick.append(";return false;");
            }
        } else {
            onClick = new StringBuffer("return false;");
        }
        return onClick.toString();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.renderChildren(context, component);
    }

    public Object getValue(UIComponent uiComponent) {
        if (uiComponent instanceof ValueHolder) {
            return ((ValueHolder)uiComponent).getValue();
        }
        return uiComponent.getAttributes().get("value");
    }

    public String getType(UIComponent uiComponent) {
        String type = uiComponent instanceof HtmlCommandButton ? ((HtmlCommandButton)uiComponent).getType() : (String)uiComponent.getAttributes().get("type");
        if (type == null) {
            type = "button";
        }
        return type;
    }

    protected boolean isSubmitted(FacesContext facesContext, UIComponent uiComponent) {
        boolean submitted;
        if (!AjaxContext.getCurrentInstance((FacesContext)facesContext).isAjaxRequest()) {
            return false;
        }
        if (this.getUtils().isBooleanAttribute(uiComponent, "disabled")) {
            return false;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        Object value = paramMap.get(clientId);
        boolean bl = submitted = null != value;
        if (submitted && _log.isDebugEnabled()) {
            _log.debug((Object)("Decode submit of the Ajax component " + clientId));
        }
        return submitted;
    }
}

