/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.richfaces.component.UIDatascroller;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.renderkit.html.ControlsState;

public class DataScrollerRenderer
extends HeaderResourcesRendererBase {
    protected Class getComponentClass() {
        return UIDatascroller.class;
    }

    public void doDecode(FacesContext context, UIComponent component) {
        UIData data;
        UIDatascroller scroller;
        int pageCount;
        String clientId;
        Map paramMap = this.getParamMap(context);
        String param = (String)paramMap.get(clientId = component.getClientId(context));
        if (param != null && (pageCount = (scroller = (UIDatascroller)component).getPageCount(data = scroller.getDataTable())) > 1) {
            int pageIndex = scroller.getPageIndex(data, pageCount);
            int newPage = scroller.getPageForFacet(param, pageIndex, pageCount);
            int page = scroller.getPage();
            if (newPage > 0 && newPage != page) {
                DataScrollerEvent event = new DataScrollerEvent((UIComponent)scroller, String.valueOf(page), param, newPage);
                if (scroller.isImmediate()) {
                    event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
                } else {
                    event.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                component.queueEvent((FacesEvent)event);
            }
        }
    }

    public ControlsState getControlsState(FacesContext context, UIDatascroller datascroller, int pageIndex, int pageCount) {
        int minPageIdx = 1;
        int maxPageIdx = pageCount;
        int fastStep = datascroller.getFastStep();
        if (fastStep <= 1) {
            fastStep = 1;
        }
        boolean useFirst = true;
        boolean useLast = true;
        boolean useBackFast = true;
        boolean useForwFast = true;
        ControlsState controlsState = new ControlsState();
        if (pageIndex <= minPageIdx) {
            useFirst = false;
        }
        if (pageIndex >= maxPageIdx) {
            useLast = false;
        }
        if (pageIndex - fastStep < minPageIdx) {
            useBackFast = false;
        }
        if (pageIndex + fastStep > maxPageIdx) {
            useForwFast = false;
        }
        String boundaryControls = datascroller.getBoundaryControls();
        String stepControls = datascroller.getStepControls();
        String fastControls = datascroller.getFastControls();
        boolean isAuto = "auto".equals(boundaryControls);
        if (isAuto || "show".equals(boundaryControls)) {
            if (isAuto) {
                controlsState.setFirstRendered(useFirst);
                controlsState.setLastRendered(useLast);
            }
            controlsState.setFirstEnabled(useFirst);
            controlsState.setLastEnabled(useLast);
        } else {
            controlsState.setFirstRendered(false);
            controlsState.setLastRendered(false);
        }
        isAuto = "auto".equals(stepControls);
        if (isAuto || "show".equals(stepControls)) {
            if (isAuto) {
                controlsState.setPreviousRendered(useFirst);
                controlsState.setNextRendered(useLast);
            }
            controlsState.setPreviousEnabled(useFirst);
            controlsState.setNextEnabled(useLast);
        } else {
            controlsState.setPreviousRendered(false);
            controlsState.setNextRendered(false);
        }
        isAuto = "auto".equals(fastControls);
        if (isAuto || "show".equals(fastControls)) {
            if (isAuto) {
                controlsState.setFastForwardRendered(useForwFast);
                controlsState.setFastRewindRendered(useBackFast);
            }
            controlsState.setFastForwardEnabled(useForwFast);
            controlsState.setFastRewindEnabled(useBackFast);
        } else {
            controlsState.setFastForwardRendered(false);
            controlsState.setFastRewindRendered(false);
        }
        UIComponent controlsSeparatorFacet = datascroller.getFacet("controlsSeparator");
        if (controlsSeparatorFacet != null && controlsSeparatorFacet.isRendered()) {
            controlsState.setControlsSeparatorRendered(true);
        }
        return controlsState;
    }

    public void renderPager(FacesContext context, UIComponent component, int pageIndex, int count) throws IOException {
        int start;
        int pages;
        int pageCount;
        ResponseWriter out = context.getResponseWriter();
        UIDatascroller scroller = (UIDatascroller)component;
        int currentPage = pageIndex;
        int maxPages = scroller.getMaxPages();
        if (maxPages <= 1) {
            maxPages = 1;
        }
        if ((pageCount = count) <= 1) {
            return;
        }
        int delta = maxPages / 2;
        if (pageCount > maxPages && currentPage > delta) {
            pages = maxPages;
            start = currentPage - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            String style;
            String styleClass;
            boolean isCurrentPage;
            boolean bl = isCurrentPage = i + 1 == currentPage;
            if (isCurrentPage) {
                styleClass = scroller.getSelectedStyleClass();
                style = scroller.getSelectedStyle();
            } else {
                styleClass = scroller.getInactiveStyleClass();
                style = scroller.getInactiveStyle();
            }
            if (styleClass == null) {
                styleClass = "";
            }
            out.startElement("td", component);
            if (isCurrentPage) {
                out.writeAttribute("class", (Object)("dr-dscr-act rich-datascr-act " + styleClass), null);
            } else {
                out.writeAttribute("class", (Object)("dr-dscr-inact rich-datascr-inact " + styleClass), null);
                out.writeAttribute("onclick", this.getOnClick(Integer.toString(i + 1)), null);
            }
            if (null != style) {
                out.writeAttribute("style", (Object)style, null);
            }
            out.writeText((Object)Integer.toString(i + 1), null);
            out.endElement("td");
        }
    }

    public Object getOnClick(String string) {
        return "RichFaces.Datascroller.switchToPage(this, event, '" + string + "');";
    }

    public void renderPages(FacesContext context, UIComponent component, int pageIndex, int count) throws IOException {
        String varName;
        UIDatascroller scroller = (UIDatascroller)component;
        int currentPage = pageIndex;
        int pageCount = count;
        if (pageCount <= 1) {
            pageCount = 1;
        }
        if ((varName = (String)scroller.getAttributes().get("pageIndexVar")) != null && varName.length() > 0) {
            context.getExternalContext().getRequestMap().put(varName, new Integer(currentPage));
        }
        if ((varName = (String)scroller.getAttributes().get("pagesVar")) != null && varName.length() > 0) {
            context.getExternalContext().getRequestMap().put(varName, new Integer(pageCount));
        }
    }

    private Map getParamMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap();
    }

    protected Map getParameters(FacesContext context, UIComponent component) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (component instanceof UIDatascroller) {
            UIDatascroller datascroller = (UIDatascroller)component;
            List children = datascroller.getChildren();
            for (UIComponent child : children) {
                UIParameter param;
                String name;
                if (!(child instanceof UIParameter) || (name = (param = (UIParameter)child).getName()) == null) continue;
                parameters.put(name, param.getValue());
            }
        }
        return parameters;
    }

    public String getSubmitFunction(FacesContext context, UIComponent component) {
        JSFunctionDefinition definition = new JSFunctionDefinition(new Object[]{"event"});
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        UIDatascroller scroller = (UIDatascroller)component;
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        Map parameters = (Map)eventOptions.get("parameters");
        Map params = this.getParameters(context, component);
        if (!params.isEmpty()) {
            parameters.putAll(params);
        }
        function.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        buffer.append("; return false;");
        definition.addToBody((Object)buffer.toString());
        return definition.toScript();
    }

    public boolean getRendersChildren() {
        return true;
    }
}

