package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIFileUpload;

public class HtmlFileUpload extends UIFileUpload{

final public static  String COMPONENT_FAMILY = "org.richfaces.component.FileUpload";

final public static  String COMPONENT_TYPE = "org.richfaces.component.FileUpload";

/*
* Files types allowed to upload
*/
private  String _acceptedTypes = null;

/*
* This attribute assigns an access key to an element. An access key is a single character from the document character set. Note: Authors should consider the input method of the expected reader when specifying an accesskey
*/
private  String _accesskey = null;

/*
* CSS style for add button
*/
private  String _addButtonClass = null;

/*
* CSS style for add button disabled
*/
private  String _addButtonClassDisabled = null;

/*
* Defines a label for an add control
*/
private  String _addControlLabel = null;

/*
* left|center|right|justify [CI]
            Deprecated. This attribute specifies the horizontal alignment of its element with respect to the surrounding context. Possible values:
            
            * left: text lines are rendered flush left.
            * center: text lines are centered.
            * right: text lines are rendered flush right.
            * justify: text lines are justified to both margins.
            
            The default depends on the base text direction. For left to right text, the default is align=left, while for right to left text, the default is align=right
*/
private  String _align = null;

/*
* For a user agents that cannot display images, forms, or applets, this attribute specifies alternate text. The language of the alternate text is specified by the lang attribute
*/
private  String _alt = null;

/*
* If this attribute is true files will be immediatelly removed from list after upload completed
*/
private  boolean _autoclear = false;

private  boolean _autoclearSet = false;

/*
* CSS style for cancel button
*/
private  String _cancelButtonClass = null;

/*
* CSS style for cancel button disabled
*/
private  String _cancelButtonClassDisabled = null;

/*
* Defines a label for a cancel control
*/
private  String _cancelEntryControlLabel = null;

/*
* CSS style for clean button
*/
private  String _cleanButtonClass = null;

/*
* CSS style for clean button disabled
*/
private  String _cleanButtonClassDisabled = null;

/*
* Defines a label for a clearAll control
*/
private  String _clearAllControlLabel = null;

/*
* Defines a label for a clear control
*/
private  String _clearControlLabel = null;

/*
* null
*/
private  Object _contentType = null;

/*
* Attribute 'disabled' provides possibility to make the whole component disabled if its value equals to "true".
*/
private  boolean _disabled = false;

private  boolean _disabledSet = false;

/*
* CSS style upload file entry
*/
private  String _fileEntryClass = null;

/*
* CSS style upload file entry disabled
*/
private  String _fileEntryClassDisabled = null;

/*
* CSS style for upload enrty control
*/
private  String _fileEntryControlClass = null;

/*
* CSS style for upload enrty control disabled
*/
private  String _fileEntryControlClassDisabled = null;

/*
* null
*/
private  Object _fileName = null;

/*
* null
*/
private  Object _fileSize = null;

/*
* MethodExpression representing an action listener method
				that will be notified after file uploaded.
*/
private  MethodExpression _fileUploadListener = null;

/*
* If this attribute is true files will be immediatelly uploaded after they have been added in list
*/
private  boolean _immediateUpload = false;

private  boolean _immediateUploadSet = false;

/*
* Defines height of file list
*/
private  String _listHeight = null;

/*
* Defines width of file list
*/
private  String _listWidth = null;

/*
* Used for locale definition
*/
private  Object _locale = null;

/*
* Defines max files count allowed for upload (optional).
*/
private  Integer _maxFilesQuantity = null;

/*
* null
*/
private  Object _maxLength = null;

/*
* When the type attribute has the value "text" or "password", this attribute specifies the maximum number of characters you may enter. This number may exceed the specified size, in which case the user agent should offer a scrolling mechanism. The default value for this attribute is an unlimited number
*/
private  int _maxlength = Integer.MIN_VALUE;

private  boolean _maxlengthSet = false;

/*
* HTML: script expression; the element lost the focus
*/
private  String _onblur = null;

/*
* HTML: script expression; the element value was changed
*/
private  String _onchange = null;

/*
* HTML: a script expression; a pointer button is clicked
*/
private  String _onclick = null;

/*
* HTML: a script expression; a pointer button is double-clicked
*/
private  String _ondblclick = null;

/*
* A JavaScript event handler called when the file upload was interrupted according to any errors
*/
private  String _onerror = null;

/*
* HTML: script expression; the element got the focus
*/
private  String _onfocus = null;

/*
* HTML: a script expression; a key is pressed down
*/
private  String _onkeydown = null;

/*
* HTML: a script expression; a key is pressed and released
*/
private  String _onkeypress = null;

/*
* HTML: a script expression; a key is released
*/
private  String _onkeyup = null;

/*
* HTML: script expression; a pointer button is pressed down
*/
private  String _onmousedown = null;

/*
* HTML: a script expression; a pointer is moved within
*/
private  String _onmousemove = null;

/*
* HTML: a script expression; a pointer is moved away
*/
private  String _onmouseout = null;

/*
* HTML: a script expression; a pointer is moved onto
*/
private  String _onmouseover = null;

/*
* HTML: script expression; a pointer button is released
*/
private  String _onmouseup = null;

/*
* HTML: script expression; The onselect event occurs when you select some text in a text field. This attribute may be used with the INPUT and TEXTAREA elements
*/
private  String _onselect = null;

/*
* A JavaScript event handler called on an upload operation
*/
private  String _onupload = null;

/*
* A JavaScript event handler called when upload is cancelled
*/
private  String _onuploadcanceled = null;

/*
* A JavaScript event handler called when upload is completed
*/
private  String _onuploadcomplete = null;

/*
* null
*/
private  Object _progressInfo = null;

/*
* null
*/
private  Object _size = null;

/*
* Defines a label for a stop control
*/
private  String _stopControlLabel = null;

/*
* Defines a label for a stop control
*/
private  String _stopEntryControlLabel = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* This attribute specifies the position of the current element in the tabbing order for the current document. This value must be a number between 0 and 32767. User agents should ignore leading zeros
*/
private  String _tabindex = null;

/*
* CSS style for upload button
*/
private  String _uploadButtonClass = null;

/*
* CSS style for upload button disabled
*/
private  String _uploadButtonClassDisabled = null;

/*
* Defines a label for an upload control
*/
private  String _uploadControlLabel = null;

/*
* Collection of files uploaded
*/
private  Object _uploadData = null;

/*
* CSS style for upload list
*/
private  String _uploadListClass = null;

/*
* CSS style for upload list disabled
*/
private  String _uploadListClassDisabled = null;


public HtmlFileUpload(){
setRendererType("org.richfaces.renderkit.html.FileUploadRenderer");
}

public String getAcceptedTypes(){
	if (this._acceptedTypes != null) {
		return this._acceptedTypes;
	}
	ValueExpression ve = getValueExpression("acceptedTypes");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAcceptedTypes(String _acceptedTypes){
this._acceptedTypes = _acceptedTypes;
}

public String getAccesskey(){
	if (this._accesskey != null) {
		return this._accesskey;
	}
	ValueExpression ve = getValueExpression("accesskey");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAccesskey(String _accesskey){
this._accesskey = _accesskey;
}

public String getAddButtonClass(){
	if (this._addButtonClass != null) {
		return this._addButtonClass;
	}
	ValueExpression ve = getValueExpression("addButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddButtonClass(String _addButtonClass){
this._addButtonClass = _addButtonClass;
}

public String getAddButtonClassDisabled(){
	if (this._addButtonClassDisabled != null) {
		return this._addButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("addButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddButtonClassDisabled(String _addButtonClassDisabled){
this._addButtonClassDisabled = _addButtonClassDisabled;
}

public String getAddControlLabel(){
	if (this._addControlLabel != null) {
		return this._addControlLabel;
	}
	ValueExpression ve = getValueExpression("addControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAddControlLabel(String _addControlLabel){
this._addControlLabel = _addControlLabel;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getAlt(){
	if (this._alt != null) {
		return this._alt;
	}
	ValueExpression ve = getValueExpression("alt");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlt(String _alt){
this._alt = _alt;
}

public boolean isAutoclear(){
	if (this._autoclearSet) {
	    return (this._autoclear);
	}
	ValueExpression ve = getValueExpression("autoclear");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._autoclear);
	    }
	    
	    return value;
	} else {
	    return (this._autoclear);
	}

}

public void setAutoclear(boolean _autoclear){
this._autoclear = _autoclear;
this._autoclearSet = true;
}

public String getCancelButtonClass(){
	if (this._cancelButtonClass != null) {
		return this._cancelButtonClass;
	}
	ValueExpression ve = getValueExpression("cancelButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelButtonClass(String _cancelButtonClass){
this._cancelButtonClass = _cancelButtonClass;
}

public String getCancelButtonClassDisabled(){
	if (this._cancelButtonClassDisabled != null) {
		return this._cancelButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("cancelButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelButtonClassDisabled(String _cancelButtonClassDisabled){
this._cancelButtonClassDisabled = _cancelButtonClassDisabled;
}

public String getCancelEntryControlLabel(){
	if (this._cancelEntryControlLabel != null) {
		return this._cancelEntryControlLabel;
	}
	ValueExpression ve = getValueExpression("cancelEntryControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCancelEntryControlLabel(String _cancelEntryControlLabel){
this._cancelEntryControlLabel = _cancelEntryControlLabel;
}

public String getCleanButtonClass(){
	if (this._cleanButtonClass != null) {
		return this._cleanButtonClass;
	}
	ValueExpression ve = getValueExpression("cleanButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCleanButtonClass(String _cleanButtonClass){
this._cleanButtonClass = _cleanButtonClass;
}

public String getCleanButtonClassDisabled(){
	if (this._cleanButtonClassDisabled != null) {
		return this._cleanButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("cleanButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCleanButtonClassDisabled(String _cleanButtonClassDisabled){
this._cleanButtonClassDisabled = _cleanButtonClassDisabled;
}

public String getClearAllControlLabel(){
	if (this._clearAllControlLabel != null) {
		return this._clearAllControlLabel;
	}
	ValueExpression ve = getValueExpression("clearAllControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClearAllControlLabel(String _clearAllControlLabel){
this._clearAllControlLabel = _clearAllControlLabel;
}

public String getClearControlLabel(){
	if (this._clearControlLabel != null) {
		return this._clearControlLabel;
	}
	ValueExpression ve = getValueExpression("clearControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setClearControlLabel(String _clearControlLabel){
this._clearControlLabel = _clearControlLabel;
}

public Object getContentType(){
	if (this._contentType != null) {
		return this._contentType;
	}
	ValueExpression ve = getValueExpression("contentType");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentType(Object _contentType){
this._contentType = _contentType;
}

public boolean isDisabled(){
	if (this._disabledSet) {
	    return (this._disabled);
	}
	ValueExpression ve = getValueExpression("disabled");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._disabled);
	    }
	    
	    return value;
	} else {
	    return (this._disabled);
	}

}

public void setDisabled(boolean _disabled){
this._disabled = _disabled;
this._disabledSet = true;
}

public String getFileEntryClass(){
	if (this._fileEntryClass != null) {
		return this._fileEntryClass;
	}
	ValueExpression ve = getValueExpression("fileEntryClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryClass(String _fileEntryClass){
this._fileEntryClass = _fileEntryClass;
}

public String getFileEntryClassDisabled(){
	if (this._fileEntryClassDisabled != null) {
		return this._fileEntryClassDisabled;
	}
	ValueExpression ve = getValueExpression("fileEntryClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryClassDisabled(String _fileEntryClassDisabled){
this._fileEntryClassDisabled = _fileEntryClassDisabled;
}

public String getFileEntryControlClass(){
	if (this._fileEntryControlClass != null) {
		return this._fileEntryControlClass;
	}
	ValueExpression ve = getValueExpression("fileEntryControlClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryControlClass(String _fileEntryControlClass){
this._fileEntryControlClass = _fileEntryControlClass;
}

public String getFileEntryControlClassDisabled(){
	if (this._fileEntryControlClassDisabled != null) {
		return this._fileEntryControlClassDisabled;
	}
	ValueExpression ve = getValueExpression("fileEntryControlClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileEntryControlClassDisabled(String _fileEntryControlClassDisabled){
this._fileEntryControlClassDisabled = _fileEntryControlClassDisabled;
}

public Object getFileName(){
	if (this._fileName != null) {
		return this._fileName;
	}
	ValueExpression ve = getValueExpression("fileName");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileName(Object _fileName){
this._fileName = _fileName;
}

public Object getFileSize(){
	if (this._fileSize != null) {
		return this._fileSize;
	}
	ValueExpression ve = getValueExpression("fileSize");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFileSize(Object _fileSize){
this._fileSize = _fileSize;
}

public MethodExpression getFileUploadListener(){
return _fileUploadListener;
}

public void setFileUploadListener(MethodExpression _fileUploadListener){
this._fileUploadListener = _fileUploadListener;
}

public boolean isImmediateUpload(){
	if (this._immediateUploadSet) {
	    return (this._immediateUpload);
	}
	ValueExpression ve = getValueExpression("immediateUpload");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediateUpload);
	    }
	    
	    return value;
	} else {
	    return (this._immediateUpload);
	}

}

public void setImmediateUpload(boolean _immediateUpload){
this._immediateUpload = _immediateUpload;
this._immediateUploadSet = true;
}

public String getListHeight(){
	if (this._listHeight != null) {
		return this._listHeight;
	}
	ValueExpression ve = getValueExpression("listHeight");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "210px";
	

}

public void setListHeight(String _listHeight){
this._listHeight = _listHeight;
}

public String getListWidth(){
	if (this._listWidth != null) {
		return this._listWidth;
	}
	ValueExpression ve = getValueExpression("listWidth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "400px";
	

}

public void setListWidth(String _listWidth){
this._listWidth = _listWidth;
}

public Object getLocale(){
	if (this._locale != null) {
		return this._locale;
	}
	ValueExpression ve = getValueExpression("locale");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLocale(Object _locale){
this._locale = _locale;
}

public Integer getMaxFilesQuantity(){
	if (this._maxFilesQuantity != null) {
		return this._maxFilesQuantity;
	}
	ValueExpression ve = getValueExpression("maxFilesQuantity");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return 1;
	

}

public void setMaxFilesQuantity(Integer _maxFilesQuantity){
this._maxFilesQuantity = _maxFilesQuantity;
}

public Object getMaxLength(){
	if (this._maxLength != null) {
		return this._maxLength;
	}
	ValueExpression ve = getValueExpression("maxLength");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMaxLength(Object _maxLength){
this._maxLength = _maxLength;
}

public int getMaxlength(){
	if (this._maxlengthSet) {
	    return (this._maxlength);
	}
	ValueExpression ve = getValueExpression("maxlength");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._maxlength);
	    }
	    
	    return value;
	} else {
	    return (this._maxlength);
	}

}

public void setMaxlength(int _maxlength){
this._maxlength = _maxlength;
this._maxlengthSet = true;
}

public String getOnblur(){
	if (this._onblur != null) {
		return this._onblur;
	}
	ValueExpression ve = getValueExpression("onblur");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnblur(String _onblur){
this._onblur = _onblur;
}

public String getOnchange(){
	if (this._onchange != null) {
		return this._onchange;
	}
	ValueExpression ve = getValueExpression("onchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnchange(String _onchange){
this._onchange = _onchange;
}

public String getOnclick(){
	if (this._onclick != null) {
		return this._onclick;
	}
	ValueExpression ve = getValueExpression("onclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnclick(String _onclick){
this._onclick = _onclick;
}

public String getOndblclick(){
	if (this._ondblclick != null) {
		return this._ondblclick;
	}
	ValueExpression ve = getValueExpression("ondblclick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndblclick(String _ondblclick){
this._ondblclick = _ondblclick;
}

public String getOnerror(){
	if (this._onerror != null) {
		return this._onerror;
	}
	ValueExpression ve = getValueExpression("onerror");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnerror(String _onerror){
this._onerror = _onerror;
}

public String getOnfocus(){
	if (this._onfocus != null) {
		return this._onfocus;
	}
	ValueExpression ve = getValueExpression("onfocus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnfocus(String _onfocus){
this._onfocus = _onfocus;
}

public String getOnkeydown(){
	if (this._onkeydown != null) {
		return this._onkeydown;
	}
	ValueExpression ve = getValueExpression("onkeydown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeydown(String _onkeydown){
this._onkeydown = _onkeydown;
}

public String getOnkeypress(){
	if (this._onkeypress != null) {
		return this._onkeypress;
	}
	ValueExpression ve = getValueExpression("onkeypress");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeypress(String _onkeypress){
this._onkeypress = _onkeypress;
}

public String getOnkeyup(){
	if (this._onkeyup != null) {
		return this._onkeyup;
	}
	ValueExpression ve = getValueExpression("onkeyup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnkeyup(String _onkeyup){
this._onkeyup = _onkeyup;
}

public String getOnmousedown(){
	if (this._onmousedown != null) {
		return this._onmousedown;
	}
	ValueExpression ve = getValueExpression("onmousedown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousedown(String _onmousedown){
this._onmousedown = _onmousedown;
}

public String getOnmousemove(){
	if (this._onmousemove != null) {
		return this._onmousemove;
	}
	ValueExpression ve = getValueExpression("onmousemove");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmousemove(String _onmousemove){
this._onmousemove = _onmousemove;
}

public String getOnmouseout(){
	if (this._onmouseout != null) {
		return this._onmouseout;
	}
	ValueExpression ve = getValueExpression("onmouseout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseout(String _onmouseout){
this._onmouseout = _onmouseout;
}

public String getOnmouseover(){
	if (this._onmouseover != null) {
		return this._onmouseover;
	}
	ValueExpression ve = getValueExpression("onmouseover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseover(String _onmouseover){
this._onmouseover = _onmouseover;
}

public String getOnmouseup(){
	if (this._onmouseup != null) {
		return this._onmouseup;
	}
	ValueExpression ve = getValueExpression("onmouseup");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnmouseup(String _onmouseup){
this._onmouseup = _onmouseup;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnupload(){
	if (this._onupload != null) {
		return this._onupload;
	}
	ValueExpression ve = getValueExpression("onupload");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnupload(String _onupload){
this._onupload = _onupload;
}

public String getOnuploadcanceled(){
	if (this._onuploadcanceled != null) {
		return this._onuploadcanceled;
	}
	ValueExpression ve = getValueExpression("onuploadcanceled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnuploadcanceled(String _onuploadcanceled){
this._onuploadcanceled = _onuploadcanceled;
}

public String getOnuploadcomplete(){
	if (this._onuploadcomplete != null) {
		return this._onuploadcomplete;
	}
	ValueExpression ve = getValueExpression("onuploadcomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnuploadcomplete(String _onuploadcomplete){
this._onuploadcomplete = _onuploadcomplete;
}

public Object getProgressInfo(){
	if (this._progressInfo != null) {
		return this._progressInfo;
	}
	ValueExpression ve = getValueExpression("progressInfo");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProgressInfo(Object _progressInfo){
this._progressInfo = _progressInfo;
}

public Object getSize(){
	if (this._size != null) {
		return this._size;
	}
	ValueExpression ve = getValueExpression("size");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSize(Object _size){
this._size = _size;
}

public String getStopControlLabel(){
	if (this._stopControlLabel != null) {
		return this._stopControlLabel;
	}
	ValueExpression ve = getValueExpression("stopControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStopControlLabel(String _stopControlLabel){
this._stopControlLabel = _stopControlLabel;
}

public String getStopEntryControlLabel(){
	if (this._stopEntryControlLabel != null) {
		return this._stopEntryControlLabel;
	}
	ValueExpression ve = getValueExpression("stopEntryControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStopEntryControlLabel(String _stopEntryControlLabel){
this._stopEntryControlLabel = _stopEntryControlLabel;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTabindex(){
	if (this._tabindex != null) {
		return this._tabindex;
	}
	ValueExpression ve = getValueExpression("tabindex");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTabindex(String _tabindex){
this._tabindex = _tabindex;
}

public String getUploadButtonClass(){
	if (this._uploadButtonClass != null) {
		return this._uploadButtonClass;
	}
	ValueExpression ve = getValueExpression("uploadButtonClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadButtonClass(String _uploadButtonClass){
this._uploadButtonClass = _uploadButtonClass;
}

public String getUploadButtonClassDisabled(){
	if (this._uploadButtonClassDisabled != null) {
		return this._uploadButtonClassDisabled;
	}
	ValueExpression ve = getValueExpression("uploadButtonClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadButtonClassDisabled(String _uploadButtonClassDisabled){
this._uploadButtonClassDisabled = _uploadButtonClassDisabled;
}

public String getUploadControlLabel(){
	if (this._uploadControlLabel != null) {
		return this._uploadControlLabel;
	}
	ValueExpression ve = getValueExpression("uploadControlLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadControlLabel(String _uploadControlLabel){
this._uploadControlLabel = _uploadControlLabel;
}

public Object getUploadData(){
	if (this._uploadData != null) {
		return this._uploadData;
	}
	ValueExpression ve = getValueExpression("uploadData");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadData(Object _uploadData){
this._uploadData = _uploadData;
}

public String getUploadListClass(){
	if (this._uploadListClass != null) {
		return this._uploadListClass;
	}
	ValueExpression ve = getValueExpression("uploadListClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadListClass(String _uploadListClass){
this._uploadListClass = _uploadListClass;
}

public String getUploadListClassDisabled(){
	if (this._uploadListClassDisabled != null) {
		return this._uploadListClassDisabled;
	}
	ValueExpression ve = getValueExpression("uploadListClassDisabled");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setUploadListClassDisabled(String _uploadListClassDisabled){
this._uploadListClassDisabled = _uploadListClassDisabled;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[67];
state[0] = super.saveState(context);
state[1] = _acceptedTypes;
state[2] = _accesskey;
state[3] = _addButtonClass;
state[4] = _addButtonClassDisabled;
state[5] = _addControlLabel;
state[6] = _align;
state[7] = _alt;
state[8] = Boolean.valueOf(_autoclear);
state[9] = Boolean.valueOf(_autoclearSet);
state[10] = _cancelButtonClass;
state[11] = _cancelButtonClassDisabled;
state[12] = _cancelEntryControlLabel;
state[13] = _cleanButtonClass;
state[14] = _cleanButtonClassDisabled;
state[15] = _clearAllControlLabel;
state[16] = _clearControlLabel;
state[17] = saveAttachedState(context, _contentType);
state[18] = Boolean.valueOf(_disabled);
state[19] = Boolean.valueOf(_disabledSet);
state[20] = _fileEntryClass;
state[21] = _fileEntryClassDisabled;
state[22] = _fileEntryControlClass;
state[23] = _fileEntryControlClassDisabled;
state[24] = saveAttachedState(context, _fileName);
state[25] = saveAttachedState(context, _fileSize);
state[26] = saveAttachedState(context, _fileUploadListener);
state[27] = Boolean.valueOf(_immediateUpload);
state[28] = Boolean.valueOf(_immediateUploadSet);
state[29] = _listHeight;
state[30] = _listWidth;
state[31] = saveAttachedState(context, _locale);
state[32] = _maxFilesQuantity;
state[33] = saveAttachedState(context, _maxLength);
state[34] = Integer.valueOf(_maxlength);
state[35] = Boolean.valueOf(_maxlengthSet);
state[36] = _onblur;
state[37] = _onchange;
state[38] = _onclick;
state[39] = _ondblclick;
state[40] = _onerror;
state[41] = _onfocus;
state[42] = _onkeydown;
state[43] = _onkeypress;
state[44] = _onkeyup;
state[45] = _onmousedown;
state[46] = _onmousemove;
state[47] = _onmouseout;
state[48] = _onmouseover;
state[49] = _onmouseup;
state[50] = _onselect;
state[51] = _onupload;
state[52] = _onuploadcanceled;
state[53] = _onuploadcomplete;
state[54] = saveAttachedState(context, _progressInfo);
state[55] = saveAttachedState(context, _size);
state[56] = _stopControlLabel;
state[57] = _stopEntryControlLabel;
state[58] = _style;
state[59] = _styleClass;
state[60] = _tabindex;
state[61] = _uploadButtonClass;
state[62] = _uploadButtonClassDisabled;
state[63] = _uploadControlLabel;
state[64] = saveAttachedState(context, _uploadData);
state[65] = _uploadListClass;
state[66] = _uploadListClassDisabled;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_acceptedTypes = (String)states[1];;
		_accesskey = (String)states[2];;
		_addButtonClass = (String)states[3];;
		_addButtonClassDisabled = (String)states[4];;
		_addControlLabel = (String)states[5];;
		_align = (String)states[6];;
		_alt = (String)states[7];;
		_autoclear = ((Boolean)states[8]).booleanValue();
		_autoclearSet = ((Boolean)states[9]).booleanValue();
		_cancelButtonClass = (String)states[10];;
		_cancelButtonClassDisabled = (String)states[11];;
		_cancelEntryControlLabel = (String)states[12];;
		_cleanButtonClass = (String)states[13];;
		_cleanButtonClassDisabled = (String)states[14];;
		_clearAllControlLabel = (String)states[15];;
		_clearControlLabel = (String)states[16];;
		_contentType = (Object)restoreAttachedState(context, states[17]);
		_disabled = ((Boolean)states[18]).booleanValue();
		_disabledSet = ((Boolean)states[19]).booleanValue();
		_fileEntryClass = (String)states[20];;
		_fileEntryClassDisabled = (String)states[21];;
		_fileEntryControlClass = (String)states[22];;
		_fileEntryControlClassDisabled = (String)states[23];;
		_fileName = (Object)restoreAttachedState(context, states[24]);
		_fileSize = (Object)restoreAttachedState(context, states[25]);
		_fileUploadListener = (MethodExpression)restoreAttachedState(context, states[26]);
		_immediateUpload = ((Boolean)states[27]).booleanValue();
		_immediateUploadSet = ((Boolean)states[28]).booleanValue();
		_listHeight = (String)states[29];;
		_listWidth = (String)states[30];;
		_locale = (Object)restoreAttachedState(context, states[31]);
		_maxFilesQuantity = (Integer)states[32];;
		_maxLength = (Object)restoreAttachedState(context, states[33]);
		_maxlength = ((Integer)states[34]).intValue();
		_maxlengthSet = ((Boolean)states[35]).booleanValue();
		_onblur = (String)states[36];;
		_onchange = (String)states[37];;
		_onclick = (String)states[38];;
		_ondblclick = (String)states[39];;
		_onerror = (String)states[40];;
		_onfocus = (String)states[41];;
		_onkeydown = (String)states[42];;
		_onkeypress = (String)states[43];;
		_onkeyup = (String)states[44];;
		_onmousedown = (String)states[45];;
		_onmousemove = (String)states[46];;
		_onmouseout = (String)states[47];;
		_onmouseover = (String)states[48];;
		_onmouseup = (String)states[49];;
		_onselect = (String)states[50];;
		_onupload = (String)states[51];;
		_onuploadcanceled = (String)states[52];;
		_onuploadcomplete = (String)states[53];;
		_progressInfo = (Object)restoreAttachedState(context, states[54]);
		_size = (Object)restoreAttachedState(context, states[55]);
		_stopControlLabel = (String)states[56];;
		_stopEntryControlLabel = (String)states[57];;
		_style = (String)states[58];;
		_styleClass = (String)states[59];;
		_tabindex = (String)states[60];;
		_uploadButtonClass = (String)states[61];;
		_uploadButtonClassDisabled = (String)states[62];;
		_uploadControlLabel = (String)states[63];;
		_uploadData = (Object)restoreAttachedState(context, states[64]);
		_uploadListClass = (String)states[65];;
		_uploadListClassDisabled = (String)states[66];;
	
}

}
